import { Meteor } from 'meteor/meteor';

import { Mailer } from '../lib/Mailer';
import { hasRole } from '../../../authorization';

Meteor.methods({
	'Mailer.sendMail'(from, subject, body, dryrun, query) {
		const userId = Meteor.userId();
		if (!userId) {
			throw new Meteor.Error('error-invalid-user', 'Invalid user', {
				method: 'Mailer.sendMail',
			});
		}
		if (hasRole(userId, 'admin') !== true) {
			throw new Meteor.Error('error-not-allowed', 'Not allowed', {
				method: 'Mailer.sendMail',
			});
		}
		return Mailer.sendMail(from, subject, body, dryrun, query);
	},
});


// Limit setting username once per minute
// DDPRateLimiter.addRule
//	type: 'method'
//	name: 'Mailer.sendMail'
//	connectionId: -> return true
//	, 1, 60000
