import React from 'react';

import { usePermission } from '../../contexts/AuthorizationContext';
import NotAuthorizedPage from '../NotAuthorizedPage';
import OAuthAppsPage from './OAuthAppsPage';

export default function MailerRoute() {
	const canAccessOAuthApps = usePermission('manage-oauth-apps');

	if (!canAccessOAuthApps) {
		return <NotAuthorizedPage/>;
	}

	return <OAuthAppsPage />;
}
