import { Box } from '@rocket.chat/fuselage';
import React, { useState } from 'react';

function Logo({ src = 'images/logo/logo.svg', ...props }) {
	const [isLoaded, setLoaded] = useState(false);

	const handleLoad = () => {
		setLoaded(true);
	};

	const handleError = () => {
		setLoaded(false);
	};

	return <>
		{!isLoaded && <Box is='svg' viewBox='0 0 1000 182' xmlns='http://www.w3.org/2000/svg' {...props}>
			<g fill='none' fillRule='evenodd'>
				<g fill='#9ea2a8' fillRule='nonzero' transform='translate(245.154709 29.581775)'>
					<path d='m62.5717573 58.8485839c0 10.1578288-3.791296 16.8288535-11.0711519 20.01071l10.4656798 39.7212001c.4541041 1.822594-.454104 2.727981-2.1238826 2.727981h-15.7753863c-1.5160454 0-2.2728855-.756459-2.5779867-2.122813l-10.1629438-38.5061381h-10.4656799v38.2059181c0 1.517646-.9082081 2.423033-2.4266186 2.423033h-15.77538636c-1.51604538 0-2.42661865-.910115-2.42661865-2.423033v-116.43561996c0-1.51528236.91057327-2.42539734 2.42661865-2.42539734h38.07142346c14.2569758 0 21.8419329 7.58113963 21.8419329 21.83094zm-26.6951702 1.817866c3.942664 0 6.0665466-2.1228136 6.0665466-6.0634933v-28.5019646c0-3.9406797-2.1238826-6.0611294-6.0665466-6.0611294h-15.0161812v40.6289513z'/>
					<path d='m74.6977552 21.8553647c0-14.24980037 7.582592-21.83094 21.841933-21.83094h16.9886958c14.256976 0 21.841933 7.58113963 21.841933 21.83094v77.6221705c0 14.2474368-7.584957 21.8285758-21.841933 21.8285758h-16.9886958c-14.259341 0-21.841933-7.581139-21.841933-21.8285758zm35.0369678 79.8939123c3.942664 0 6.066546-1.9715221 6.066546-6.0634936v-70.0386669c0-3.9406797-2.123882-6.0634934-6.066546-6.0634934h-8.795902c-3.9426636 0-6.0665462 2.1228137-6.0665462 6.0634934v70.0410309c0 4.0896075 2.1238826 6.0611296 6.0665462 6.0611296z'/>
					<path d='m211.352335 38.2279787c0 1.5176462-.910573 2.4253973-2.424253 2.4253973h-15.167549c-1.669779 0-2.426619-.9077511-2.426619-2.4253973v-12.1269867c0-3.9406797-2.121518-6.0611294-6.064182-6.0611294h-7.887693c-4.094032 0-6.066546 2.1204497-6.066546 6.0611294v69.1356438c0 4.0919715 2.121517 6.0587652 6.066546 6.0587652h7.887693c3.942664 0 6.064182-1.9691576 6.064182-6.0587652v-12.1317146c0-1.5176463.75684-2.4253973 2.426619-2.4253973h15.167549c1.520775 0 2.424253.907751 2.424253 2.4253973v16.3749779c0 14.2474369-7.736325 21.8285759-21.839568 21.8285759h-16.988695c-14.256976 0-21.993301-7.581139-21.993301-21.8285759v-77.6245344c0-14.24980037 7.736325-21.83094 21.993301-21.83094h16.988695c14.105608 0 21.839568 7.58113963 21.839568 21.83094z'/>
					<path d='m275.352628 121.308475c-1.823511 0-2.880723-.756459-3.490925-2.271741l-19.107848-45.0282348-5.614808 10.7653601v33.5016877c0 1.971521-1.059576 3.032928-3.03209 3.032928h-14.562077c-1.972515 0-3.034456-1.061407-3.034456-3.032928v-115.21819366c0-1.96915788 1.061941-3.03292864 3.034456-3.03292864h14.562077c1.970149 0 3.03209 1.06140683 3.03209 3.03292864v46.99739226l23.357979-47.75621541c.759205-1.51528235 1.823511-2.27410549 3.490925-2.27410549h15.924389c2.275251 0 3.185824 1.51764629 2.121518 3.638096l-25.782232 52.9095938 27.449645 61.2495565c1.061941 1.971522.151368 3.486804-2.272885 3.486804z'/>
					<path d='m365.293617 17.6121013c0 1.5152823-.607838 2.5766892-2.426619 2.5766892h-37.920055v30.3198306h28.97042c1.520776 0 2.426619.910115 2.426619 2.5766892v15.0086235c0 1.6689381-.910573 2.5790531-2.426619 2.5790531h-28.97042v30.6224141h37.920055c1.823512 0 2.426619.758823 2.426619 2.425398v15.162279c0 1.515282-.607838 2.420669-2.426619 2.420669h-55.816959c-1.367043 0-2.277616-.910115-2.277616-2.420669v-116.43325596c0-1.51528236.910573-2.42539734 2.277616-2.42539734h55.816959c1.823512 0 2.426619.91011498 2.426619 2.42539734z'/>
					<path d='m435.665557.0244247c1.667414 0 2.426619.91011498 2.426619 2.42539734v15.16227926c0 1.5152823-.759205 2.4253973-2.426619 2.4253973h-17.594167v98.8455794c0 1.666574-.75684 2.420669-2.424254 2.420669h-15.775386c-1.520776 0-2.426619-.754095-2.426619-2.420669v-98.8455794h-17.591803c-1.520775 0-2.426618-.910115-2.426618-2.4253973v-15.16227926c0-1.51528236.910573-2.42539734 2.426618-2.42539734z'/>
					<path d='m436.586195 104.356644c0-1.971522 1.061941-3.030564 3.034456-3.030564h13.802872c1.972514 0 3.032091 1.059042 3.032091 3.030564v13.944853c0 1.973886-1.059577 3.032929-3.032091 3.032929h-13.802872c-1.972515 0-3.034456-1.059043-3.034456-3.032929z'/>
					<path d='m532.422837 38.2279787c0 1.5176462-.912938 2.4253973-2.426618 2.4253973h-15.16755c-1.667413 0-2.424253-.9077511-2.424253-2.4253973v-12.1269867c0-3.9406797-2.121518-6.0611294-6.064182-6.0611294h-7.887693c-4.096397 0-6.066546 2.1204497-6.066546 6.0611294v69.1356438c0 4.0919715 2.121517 6.0587652 6.066546 6.0587652h7.887693c3.942664 0 6.064182-1.9691576 6.064182-6.0587652v-12.1317146c0-1.5176463.75684-2.4253973 2.424253-2.4253973h15.16755c1.520775 0 2.426618.907751 2.426618 2.4253973v16.3749779c0 14.2474369-7.736325 21.8285759-21.841933 21.8285759h-16.988695c-14.256976 0-21.993301-7.581139-21.993301-21.8285759v-77.6245344c0-14.24980037 7.736325-21.83094 21.993301-21.83094h16.988695c14.107973 0 21.841933 7.58113963 21.841933 21.83094z'/>
					<path d='m587.627229 2.44982204c0-1.51528236.908208-2.42539734 2.424253-2.42539734h15.621654c1.821146 0 2.575621.91011498 2.575621 2.42539734v116.43325596c0 1.515282-.75684 2.420669-2.575621 2.420669h-15.621654c-1.520775 0-2.424253-.910115-2.424253-2.420669v-48.2100911h-19.415314v48.2124551c0 1.517646-.910574 2.423033-2.426619 2.423033h-15.619288c-1.823512 0-2.580352-.910115-2.580352-2.423033v-116.43561996c0-1.51528236.75684-2.42539734 2.580352-2.42539734h15.619288c1.520776 0 2.426619.91011498 2.426619 2.42539734v48.21009096h19.415314z'/>
					<path d='m677.416849 121.308475c-1.364677 0-2.121517-.756459-2.426618-2.122813l-4.2454-22.1311602h-27.000272l-4.091667 22.1311602c-.305101 1.366354-1.061941 2.122813-2.426619 2.122813h-16.227125c-1.667413 0-2.426618-.910115-1.97488-2.576689l25.179125-116.58454765c.305102-1.51528235 1.21331-2.12281365 2.577987-2.12281365h21.085093c1.364677 0 2.275251.6075313 2.577987 2.12281365l25.179125 116.58454765c.305101 1.666574-.302737 2.576689-2.121518 2.576689zm-20.174519-94.7536075-9.706475 52.9095938h19.415314z'/>
					<path d='m752.339291.0244247c1.667414 0 2.426619.91011498 2.426619 2.42539734v15.16227926c0 1.5152823-.759205 2.4253973-2.426619 2.4253973h-17.591802v98.8455794c0 1.666574-.759206 2.420669-2.426619 2.420669h-15.775386c-1.516046 0-2.424254-.754095-2.424254-2.420669v-98.8455794h-17.591802c-1.518411 0-2.424254-.910115-2.424254-2.4253973v-15.16227926c0-1.51528236.910573-2.42539734 2.424254-2.42539734z'/>
				</g>
				<path d='m180.330283 70.2108641.003609.0056432c-.000601-.0009405-.001203-.0018809-.001805-.0028213-.000601-.0009406-.001203-.0018813-.001804-.0028219zm-118.376131-62.56650083c6.3387401 3.52053473 12.3304614 7.97478583 17.4474489 12.92560413 8.2483703-1.493946 16.7534113-2.2472853 25.3816541-2.2472853 25.829288 0 50.317728 6.7758093 68.949969 19.0753991 9.648766 6.3726136 17.318087 13.9335933 22.79236 22.4749752 6.096443 9.5175397 9.186759 19.7523434 9.186759 30.7192654 0 10.6719522-3.090316 20.9110002-9.186759 30.4264182-5.474273 8.545626-13.143594 16.104484-22.79236 22.477097-18.632241 12.29959-43.118627 19.071155-68.949969 19.071155-8.6282428 0-17.1312305-.753339-25.3816541-2.245163-5.1190409 4.948696-11.1087088 9.405069-17.4474489 12.925604-33.868215 16.961805-61.954152.398952-61.954152.398952s26.1126525-22.169396 21.8662921-41.603427c-11.6836513-11.974911-18.01417792-26.417804-18.01417792-41.7413615 0-15.0349541 6.33258002-29.4778472 18.01417792-41.4548805 4.2456572-19.4286913-21.85764516-41.59396243-21.86628995-41.60130241.00835221-.00492837 28.09097195-16.5624544 61.95414985.39894968z' fill='#db2323' fillRule='nonzero'/>
				<path d='m41.6969487 124.026456c-11.6079642-9.147807-18.5755614-20.853906-18.5755614-33.6127751 0-29.2774081 36.6879889-53.0114368 81.9449167-53.0114368 45.256928 0 81.944917 23.7340287 81.944917 53.0114368s-36.687989 53.0114371-81.944917 53.0114371c-11.153988 0-21.7874802-1.441656-31.4795213-4.052646l-7.0858271 6.833734c-3.8501553 3.713177-8.3628437 7.073426-13.0666687 9.72133-6.2348704 3.061887-12.3916858 4.732411-18.4830125 5.242134.3436223-.624722.6600359-1.257578.9997137-1.883283 7.099975-13.078552 9.0152952-24.831862 5.7459606-35.259931z' fill='#fff'/>
				<path d='m65.7703624 103.026182c-6.6534511 0-12.047139-5.4803639-12.047139-12.2407349 0-6.7603709 5.3936879-12.2407344 12.047139-12.2407344 6.6534512 0 12.047139 5.4803635 12.047139 12.2407344 0 6.760371-5.3936878 12.2407349-12.047139 12.2407349zm38.7859106 0c-6.6534508 0-12.0471386-5.4803639-12.0471386-12.2407349 0-6.7603709 5.3936878-12.2407344 12.0471386-12.2407344 6.653452 0 12.047139 5.4803635 12.047139 12.2407344 0 6.760371-5.393687 12.2407349-12.047139 12.2407349zm38.785911 0c-6.653451 0-12.047139-5.4803639-12.047139-12.2407349 0-6.7603709 5.393688-12.2407344 12.047139-12.2407344 6.653452 0 12.047139 5.4803635 12.047139 12.2407344 0 6.760371-5.393687 12.2407349-12.047139 12.2407349z' fill='#db2323' fillRule='nonzero'/>
			</g>
		</Box>}
		<Box is='img' src={src} hidden={!isLoaded} onLoad={handleLoad} onError={handleError} {...props} />
	</>;
}

export default Logo;
