# Change Log

## [6.15.0](https://github.com/eclipse/che/tree/6.15.0) (2018-12-05)
[Full Changelog](https://github.com/eclipse/che/compare/6.14.2...6.15.0)

**Merged pull requests:**

- use latest tag of che-ls-jdt [\#12113](https://github.com/eclipse/che/pull/12113) ([riuvshin](https://github.com/riuvshin))
- Different small changes for Che with SSL enabled [\#12112](https://github.com/eclipse/che/pull/12112) ([sleshchenko](https://github.com/sleshchenko))
- Fixed go-agents dependencies [\#12111](https://github.com/eclipse/che/pull/12111) ([sleshchenko](https://github.com/sleshchenko))
- Add prometheus and grafana to the Helm chart [\#12088](https://github.com/eclipse/che/pull/12088) ([metlos](https://github.com/metlos))
- Temporary disable refactoring rename operation in go extension [\#12087](https://github.com/eclipse/che/pull/12087) ([vzhukovskii](https://github.com/vzhukovskii))
- Selenium: remove info about known \#11779 and \#11697 issues [\#12086](https://github.com/eclipse/che/pull/12086) ([SkorikSergey](https://github.com/SkorikSergey))
- Copy yarn.lock before yarn install [\#12081](https://github.com/eclipse/che/pull/12081) ([evidolob](https://github.com/evidolob))
- Regenerate dashboard/yarn.lock [\#12078](https://github.com/eclipse/che/pull/12078) ([monaka](https://github.com/monaka))
- CHE-11697: Remove redundant synchronize call [\#12073](https://github.com/eclipse/che/pull/12073) ([vinokurig](https://github.com/vinokurig))
- Fix MetricsServer deployment [\#12072](https://github.com/eclipse/che/pull/12072) ([skabashnyuk](https://github.com/skabashnyuk))
- \[dockerfile\] \[theia\] Simplify the build [\#12070](https://github.com/eclipse/che/pull/12070) ([benoitf](https://github.com/benoitf))
- Selenium: fix unstable selenium tests, add info about known issues [\#12068](https://github.com/eclipse/che/pull/12068) ([SkorikSergey](https://github.com/SkorikSergey))
- Made Workspace Loader listen to installer output and print it [\#12064](https://github.com/eclipse/che/pull/12064) ([sleshchenko](https://github.com/sleshchenko))
- Fields are declared at the top of the class [\#12060](https://github.com/eclipse/che/pull/12060) ([sachinaraballi](https://github.com/sachinaraballi))
- \[docker\] \[theia\] Update factory plug-in [\#12056](https://github.com/eclipse/che/pull/12056) ([benoitf](https://github.com/benoitf))
- fix a default stack [\#12051](https://github.com/eclipse/che/pull/12051) ([olexii4](https://github.com/olexii4))
- Remove forked jdt projects [\#12050](https://github.com/eclipse/che/pull/12050) ([tsmaeder](https://github.com/tsmaeder))
- Introducing Jaeger tracing support to the Che Helm chart. [\#12049](https://github.com/eclipse/che/pull/12049) ([metlos](https://github.com/metlos))
- Add ability to change CORS configuration on Che Server through env vars [\#12046](https://github.com/eclipse/che/pull/12046) ([mkuznyetsov](https://github.com/mkuznyetsov))
- RELEASE: Update CHANGELOG [\#12037](https://github.com/eclipse/che/pull/12037) ([riuvshin](https://github.com/riuvshin))
- rh-che \#1075: Adding 'ImpersonatorInterceptor' during creation of KubernetesClient [\#12029](https://github.com/eclipse/che/pull/12029) ([ibuziuk](https://github.com/ibuziuk))
- Properly handle no-environment in workspace config from UD [\#12028](https://github.com/eclipse/che/pull/12028) ([ashumilova](https://github.com/ashumilova))
- Remove redundant \<version\> elements. [\#12023](https://github.com/eclipse/che/pull/12023) ([monaka](https://github.com/monaka))
- Fix typo. [\#12022](https://github.com/eclipse/che/pull/12022) ([monaka](https://github.com/monaka))
- Added commands to Runtime [\#12016](https://github.com/eclipse/che/pull/12016) ([sleshchenko](https://github.com/sleshchenko))
- Use 'versions.sh' from proper place [\#12010](https://github.com/eclipse/che/pull/12010) ([evidolob](https://github.com/evidolob))
- Selenium: cover workspace sharing feature by selenium test [\#12008](https://github.com/eclipse/che/pull/12008) ([SkorikSergey](https://github.com/SkorikSergey))
- \[ Selenium \] Do minor fixing changes for stabilizing of "TheiaBuildPluginTest", "CreateNewJavaFilesTest", "DeletePackageTest" selenium tests [\#12007](https://github.com/eclipse/che/pull/12007) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- build.sh become working on Ubuntu / Linux Mint [\#12004](https://github.com/eclipse/che/pull/12004) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- \[ Selenium \] Fix of unexpected fail of "TheiaBuildPluginTest" and "RenameProjectTest" selenium tests [\#12001](https://github.com/eclipse/che/pull/12001) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Fix style bugs for UI [\#11999](https://github.com/eclipse/che/pull/11999) ([olexii4](https://github.com/olexii4))
- \[ Selenium \] Fix of unexpected fail of "CheckErrorsWarningsTabTest" selenium test [\#11995](https://github.com/eclipse/che/pull/11995) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Metrics POC [\#11990](https://github.com/eclipse/che/pull/11990) ([skabashnyuk](https://github.com/skabashnyuk))
- Change Centos Nodejs stack Run Command [\#11989](https://github.com/eclipse/che/pull/11989) ([jarifibrahim](https://github.com/jarifibrahim))
- Add property to control ping interval in ServersChecker [\#11984](https://github.com/eclipse/che/pull/11984) ([amisevsk](https://github.com/amisevsk))
- \[ Selenium \] Fix of unexpected fail of "CheckOnValidAndInvalidClassNameTest" and "RenamedAlreadyCreatedNotJavaFileTest" selenium tests [\#11979](https://github.com/eclipse/che/pull/11979) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Upgrade java8 version for workspace master [\#11977](https://github.com/eclipse/che/pull/11977) ([skabashnyuk](https://github.com/skabashnyuk))
- Selenium: Delete try-catch from the 'GitCompareTest' related to resolve issue \#11791 [\#11974](https://github.com/eclipse/che/pull/11974) ([artaleks9](https://github.com/artaleks9))
- RELEASE: Update CHANGELOG 6.14.1 [\#11971](https://github.com/eclipse/che/pull/11971) ([riuvshin](https://github.com/riuvshin))
- Update CentOS Java image [\#11966](https://github.com/eclipse/che/pull/11966) ([l0rd](https://github.com/l0rd))
- Fix 'Go to line' for 'Git Compare' widget [\#11962](https://github.com/eclipse/che/pull/11962) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Delegate toString to wrapped class [\#11959](https://github.com/eclipse/che/pull/11959) ([skabashnyuk](https://github.com/skabashnyuk))
- Clangd fixes [\#11958](https://github.com/eclipse/che/pull/11958) ([eivantsov](https://github.com/eivantsov))
- Fix failed test due to the wrong mock reset [\#11957](https://github.com/eclipse/che/pull/11957) ([skabashnyuk](https://github.com/skabashnyuk))
- RELEASE: Update CHANGELOG [\#11950](https://github.com/eclipse/che/pull/11950) ([riuvshin](https://github.com/riuvshin))
- \[ Selenium \] Add an ability to manage timeouts in the 'AssistantFindPanel\#waitNode' method [\#11942](https://github.com/eclipse/che/pull/11942) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Remove duplicate keys [\#11941](https://github.com/eclipse/che/pull/11941) ([tsmaeder](https://github.com/tsmaeder))
- Remove unneeded listening of PluginBrokers Pod events [\#11940](https://github.com/eclipse/che/pull/11940) ([sleshchenko](https://github.com/sleshchenko))
- \[ Selenium \] Rework methods for getting nodes count in the 'AssistantFindPanel' page object [\#11939](https://github.com/eclipse/che/pull/11939) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Add che.openshift.project parameter for oc usage. [\#11933](https://github.com/eclipse/che/pull/11933) ([Katka92](https://github.com/Katka92))
- \[ Selenium \] Quick fix of the 'TheiaBuildPluginTest' selenium test [\#11931](https://github.com/eclipse/che/pull/11931) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- RELEASE: Set next development version [\#11930](https://github.com/eclipse/che/pull/11930) ([riuvshin](https://github.com/riuvshin))
- Workspace tracing [\#11924](https://github.com/eclipse/che/pull/11924) ([metlos](https://github.com/metlos))
- Made PVC Strategies wait until PVCs are bound during preparing [\#11920](https://github.com/eclipse/che/pull/11920) ([sleshchenko](https://github.com/sleshchenko))
- Use absolute folder path to open it as working dir in terminal [\#11914](https://github.com/eclipse/che/pull/11914) ([vzhukovskii](https://github.com/vzhukovskii))
- \[ Selenium \] Get rid of redundant methods in the "SeleniumWebDriverHelper" class [\#11913](https://github.com/eclipse/che/pull/11913) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Ignore Java files in `node\_modules/` on the build phase. [\#11823](https://github.com/eclipse/che/pull/11823) ([monaka](https://github.com/monaka))
- Added 'centos-php' tag to web-php-simple sample. [\#11170](https://github.com/eclipse/che/pull/11170) ([rhopp](https://github.com/rhopp))
- Use proxy forwarding [\#11137](https://github.com/eclipse/che/pull/11137) ([eivantsov](https://github.com/eivantsov))


## [6.14.2](https://github.com/eclipse/che/tree/6.14.2) (2018-11-23)
[Full Changelog](https://github.com/eclipse/che/compare/6.14.1...6.14.2)

**Merged pull requests:**

- rh-che \#1075: Adding 'ImpersonatorInterceptor' during creation of KubernetesClient [\#12029](https://github.com/eclipse/che/pull/12029) ([ibuziuk](https://github.com/ibuziuk))
- Add property to control ping interval in ServersChecker [\#11984](https://github.com/eclipse/che/pull/11984) ([amisevsk](https://github.com/amisevsk))

## [6.14.1](https://github.com/eclipse/che/tree/6.14.1) (2018-11-16)
[Full Changelog](https://github.com/eclipse/che/compare/6.14.0...6.14.1)

**Merged pull requests:**

- Update CentOS Java image [\#11966](https://github.com/eclipse/che/pull/11966) ([l0rd](https://github.com/l0rd))
- Clangd fixes [\#11958](https://github.com/eclipse/che/pull/11958) ([eivantsov](https://github.com/eivantsov))
- RELEASE: Update CHANGELOG [\#11950](https://github.com/eclipse/che/pull/11950) ([riuvshin](https://github.com/riuvshin))
- Add che.openshift.project parameter for oc usage. [\#11933](https://github.com/eclipse/che/pull/11933) ([Katka92](https://github.com/Katka92))
- Made PVC Strategies wait until PVCs are bound during preparing [\#11920](https://github.com/eclipse/che/pull/11920) ([sleshchenko](https://github.com/sleshchenko))


## [6.14.0](https://github.com/eclipse/che/tree/6.14.0) (2018-11-14)
[Full Changelog](https://github.com/eclipse/che/compare/6.13.1...6.14.0)

**Merged pull requests:**

- \[ Selenium \] Rework methods for getting nodes count in the 'AssistantFindPanel' page object [\#11939](https://github.com/eclipse/che/pull/11939) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- \[ Selenium \] Quick fix of the 'TheiaBuildPluginTest' selenium test [\#11931](https://github.com/eclipse/che/pull/11931) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- RELEASE: Set next development version [\#11930](https://github.com/eclipse/che/pull/11930) ([riuvshin](https://github.com/riuvshin))
- Selenium: stabilize unstable selenium tests [\#11925](https://github.com/eclipse/che/pull/11925) ([SkorikSergey](https://github.com/SkorikSergey))
- Revert "Revert "CHE-10480: Fix NullPointerException \(\#11857\)" \(\#11908\)" [\#11919](https://github.com/eclipse/che/pull/11919) ([vinokurig](https://github.com/vinokurig))
- che-theia: Upgrade theia factory plugin to include fixes \#11838 and \#11837 [\#11918](https://github.com/eclipse/che/pull/11918) ([sunix](https://github.com/sunix))
- Do not show warning about low timeout value, if it is set to less than 0 [\#11915](https://github.com/eclipse/che/pull/11915) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Selenium: stabilize selenium tests, remove info about resolved known issues [\#11909](https://github.com/eclipse/che/pull/11909) ([SkorikSergey](https://github.com/SkorikSergey))
- Revert "CHE-10480: Fix NullPointerException \(\#11857\)" [\#11908](https://github.com/eclipse/che/pull/11908) ([vinokurig](https://github.com/vinokurig))
- Jdbc tracing support [\#11905](https://github.com/eclipse/che/pull/11905) ([skabashnyuk](https://github.com/skabashnyuk))
- \[docker image\] Fix hosted mode within Theia [\#11901](https://github.com/eclipse/che/pull/11901) ([benoitf](https://github.com/benoitf))
- \[ Selenium \] Fix unexpected fail of "TheiaBuildPluginTest" selenium test [\#11899](https://github.com/eclipse/che/pull/11899) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Shows icons specific to visibility in "file structure" window. [\#11898](https://github.com/eclipse/che/pull/11898) ([tsmaeder](https://github.com/tsmaeder))
- Remove pure kubectl deployment [\#11894](https://github.com/eclipse/che/pull/11894) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Update python content to valid Python 3.x syntax \(\#11891\) [\#11892](https://github.com/eclipse/che/pull/11892) ([timfreund](https://github.com/timfreund))
- \[ Selenium \] Get rid of legacy code in the "Consoles" selenium page object [\#11889](https://github.com/eclipse/che/pull/11889) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Add ability to cancel rename operation [\#11886](https://github.com/eclipse/che/pull/11886) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Add log warning for using less than minimal workspace idle timeout [\#11878](https://github.com/eclipse/che/pull/11878) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Changelog 6.13.1 [\#11875](https://github.com/eclipse/che/pull/11875) ([riuvshin](https://github.com/riuvshin))
- \[ Selenium \] Get rid of boilerplate code in the "Menu" selenium page object [\#11874](https://github.com/eclipse/che/pull/11874) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: check Apache Camel language server initialization before project import [\#11873](https://github.com/eclipse/che/pull/11873) ([SkorikSergey](https://github.com/SkorikSergey))
- Wait on test workspace removal before running next test [\#11870](https://github.com/eclipse/che/pull/11870) ([dmytro-ndp](https://github.com/dmytro-ndp))
- \[dockerfile\] Update theia image [\#11868](https://github.com/eclipse/che/pull/11868) ([benoitf](https://github.com/benoitf))
- Selenium: update info about known issues [\#11861](https://github.com/eclipse/che/pull/11861) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-10480: Fix NullPointerException [\#11857](https://github.com/eclipse/che/pull/11857) ([vinokurig](https://github.com/vinokurig))
- Get suite xml file from 'target/test-classes/suite' directory [\#11847](https://github.com/eclipse/che/pull/11847) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Selenium: update info about known issue, fix expected stacks list on Dashboard [\#11845](https://github.com/eclipse/che/pull/11845) ([SkorikSergey](https://github.com/SkorikSergey))
- Basic tracing support for OpenShift [\#11844](https://github.com/eclipse/che/pull/11844) ([skabashnyuk](https://github.com/skabashnyuk))
- The PVC cleaning on workspace deletion is done in the wrong condition [\#11840](https://github.com/eclipse/che/pull/11840) ([davidfestal](https://github.com/davidfestal))
- Selenium: update info about known issue, update tests for Apache Camel stack [\#11839](https://github.com/eclipse/che/pull/11839) ([SkorikSergey](https://github.com/SkorikSergey))
- Check file vcs status before reopen folder node [\#11836](https://github.com/eclipse/che/pull/11836) ([vzhukovskii](https://github.com/vzhukovskii))
- Allow POSTGRESQL\_LOG\_DEBUG variable to be unset in PostgreSQL image [\#11835](https://github.com/eclipse/che/pull/11835) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Made Kubernetes Infrastructure create workspace service account [\#11834](https://github.com/eclipse/che/pull/11834) ([sleshchenko](https://github.com/sleshchenko))
- Added dirigible server to liveness probes list [\#11829](https://github.com/eclipse/che/pull/11829) ([skabashnyuk](https://github.com/skabashnyuk))
- Do not inform language server about file rename for not registered file type [\#11825](https://github.com/eclipse/che/pull/11825) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Formatting fix [\#11816](https://github.com/eclipse/che/pull/11816) ([mshaposhnik](https://github.com/mshaposhnik))
- Exclude E2E tests which failed permanently from default test execution [\#11815](https://github.com/eclipse/che/pull/11815) ([dmytro-ndp](https://github.com/dmytro-ndp))
- \[Selenium\] Fix unexpected fail of "TheiaBuildPluginTest" and "Che7PreviewStackStartTest" selenium tests [\#11813](https://github.com/eclipse/che/pull/11813) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Add Che 7 stack: Java + MySQL [\#11809](https://github.com/eclipse/che/pull/11809) ([mmorhun](https://github.com/mmorhun))
- Selenium: update expected stacks lists in 'NewWorkspacesPageTest' test  [\#11805](https://github.com/eclipse/che/pull/11805) ([SkorikSergey](https://github.com/SkorikSergey))
- \[Selenium\] Create selenium test for checking of the "Che 7 Preview" stack creation [\#11800](https://github.com/eclipse/che/pull/11800) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: fix exception type in selenium tests from refactor.types package  [\#11799](https://github.com/eclipse/che/pull/11799) ([SkorikSergey](https://github.com/SkorikSergey))
- drop codenvy nexus repository [\#11795](https://github.com/eclipse/che/pull/11795) ([riuvshin](https://github.com/riuvshin))
- Reuse the Dashboard Keycloak instance in IDE frames when possible [\#11794](https://github.com/eclipse/che/pull/11794) ([davidfestal](https://github.com/davidfestal))
- Modified the injection framework to use String for the workspace temp… [\#11792](https://github.com/eclipse/che/pull/11792) ([ScrewTSW](https://github.com/ScrewTSW))
- Add debug output for workspace startup [\#11787](https://github.com/eclipse/che/pull/11787) ([mshaposhnik](https://github.com/mshaposhnik))
- Ensure plugin broker works with ephemeral workspaces [\#11786](https://github.com/eclipse/che/pull/11786) ([amisevsk](https://github.com/amisevsk))
- Change access modifiers of debug config classes for reusing code [\#11785](https://github.com/eclipse/che/pull/11785) ([musienko-maxim](https://github.com/musienko-maxim))
- CHE-11457: switch github-extension to tag [\#11784](https://github.com/eclipse/che/pull/11784) ([vinokurig](https://github.com/vinokurig))
- \[Selenium\] Create Selenium test covered "start Theia in hosted mode and test the plugin" [\#11783](https://github.com/eclipse/che/pull/11783) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: fix selenium tests, add known issues [\#11782](https://github.com/eclipse/che/pull/11782) ([SkorikSergey](https://github.com/SkorikSergey))
- Add ability to handle case when active tab is closed [\#11778](https://github.com/eclipse/che/pull/11778) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Selenium: update info about known issues [\#11776](https://github.com/eclipse/che/pull/11776) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix 'add a new machine' flow [\#11771](https://github.com/eclipse/che/pull/11771) ([olexii4](https://github.com/olexii4))
- Selenium: Add the 'try-catch' to the 'GitCompareTest' according to the known issue \#11769 [\#11770](https://github.com/eclipse/che/pull/11770) ([artaleks9](https://github.com/artaleks9))
- Upgrade fabric8-kubernetes-client version to v.4.1.0 [\#11768](https://github.com/eclipse/che/pull/11768) ([skabashnyuk](https://github.com/skabashnyuk))
- Selenium: add info about known \#11735 issue to JavaDocPopupTest test [\#11767](https://github.com/eclipse/che/pull/11767) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Add changes to the 'RenameParametersTest' to incease reliability [\#11766](https://github.com/eclipse/che/pull/11766) ([artaleks9](https://github.com/artaleks9))
- \[dockerfile\] Update to latest tag of Theia + cleanup 1GiB in image [\#11765](https://github.com/eclipse/che/pull/11765) ([benoitf](https://github.com/benoitf))
- \[Selenium\] Remove try/catch block with known \#11660 issue from "TransitiveDependencyTest" selenium test [\#11762](https://github.com/eclipse/che/pull/11762) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: Delete the 'try-catch' from the 'ImportAndValidateEclipseCheProjectTest' [\#11758](https://github.com/eclipse/che/pull/11758) ([artaleks9](https://github.com/artaleks9))
- Add item menu for Che Public Chat and Issue Tracker [\#11756](https://github.com/eclipse/che/pull/11756) ([vparfonov](https://github.com/vparfonov))
- Selenium: Add the 'try-catch' to the 'RenamePackageTest' according to the known issue \#11754 [\#11755](https://github.com/eclipse/che/pull/11755) ([artaleks9](https://github.com/artaleks9))
- \[dockerfile\] \[cli\] Fix title in cli backup command to not see codenvy [\#11753](https://github.com/eclipse/che/pull/11753) ([benoitf](https://github.com/benoitf))
- Send URI instead of path to ls on didChangeWatchedFiles [\#11752](https://github.com/eclipse/che/pull/11752) ([tsmaeder](https://github.com/tsmaeder))
- \[Selenium\] Fix of unexpected fails of "AutocompleteProposalJavaDocTest", "ShowHintsCommandTest", "DownloadProjectTest", "CheckRestoringSplitEditorTest" selenium tests [\#11751](https://github.com/eclipse/che/pull/11751) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- \[docker\] \[theia\] Factory Extension has been removed in image, fix the test [\#11748](https://github.com/eclipse/che/pull/11748) ([benoitf](https://github.com/benoitf))
- Prevent duplication of command in context menu after update meta information [\#11745](https://github.com/eclipse/che/pull/11745) ([vzhukovskii](https://github.com/vzhukovskii))
- Selenium: not check known issues in selenium page objects [\#11742](https://github.com/eclipse/che/pull/11742) ([SkorikSergey](https://github.com/SkorikSergey))
- Update Che 7 stack to support kube as well [\#11739](https://github.com/eclipse/che/pull/11739) ([l0rd](https://github.com/l0rd))
- Use styled dialog instead of browser pop-up for goto line in compare widget [\#11738](https://github.com/eclipse/che/pull/11738) ([vparfonov](https://github.com/vparfonov))
- Selenium: Change the 'waitNode\(\)' method in the 'AssistantFindPanel' [\#11737](https://github.com/eclipse/che/pull/11737) ([artaleks9](https://github.com/artaleks9))
- \[Selenium\] Fix unexpected fails of "TheiaBuildPluginTest", "JavaDocPopupTest", "CheckAutocompleteFeaturesInTheTestFolderTest", "ContextMenuEditorTest" selenium tests  [\#11736](https://github.com/eclipse/che/pull/11736) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: remove info about known 10177 and 10699 issues [\#11734](https://github.com/eclipse/che/pull/11734) ([SkorikSergey](https://github.com/SkorikSergey))
- Added 1-second delay between installer commands in the test  [\#11727](https://github.com/eclipse/che/pull/11727) ([skabashnyuk](https://github.com/skabashnyuk))
- RELEASE: Update CHANGELOG [\#11726](https://github.com/eclipse/che/pull/11726) ([riuvshin](https://github.com/riuvshin))
- fix dependencies versions [\#11725](https://github.com/eclipse/che/pull/11725) ([riuvshin](https://github.com/riuvshin))
- Selenium: quick fix for CheckStoppingWsByTimeoutTest test [\#11724](https://github.com/eclipse/che/pull/11724) ([SkorikSergey](https://github.com/SkorikSergey))
- \[Selenium\] Fix unexpected fails of "CheckBasicFunctionalityInCommandsExplorerTest", "CheckOnValidAndInvalidPackageNameTest" and "CheckShowHideHiddenFilesTest" selenium tests [\#11723](https://github.com/eclipse/che/pull/11723) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Factory plugin [\#11718](https://github.com/eclipse/che/pull/11718) ([sunix](https://github.com/sunix))
- Selenium: add annotation to selenium page object [\#11712](https://github.com/eclipse/che/pull/11712) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: cover creation stacks from recipe by selenium test  [\#11711](https://github.com/eclipse/che/pull/11711) ([SkorikSergey](https://github.com/SkorikSergey))
- RELEASE: Set next development version [\#11710](https://github.com/eclipse/che/pull/11710) ([riuvshin](https://github.com/riuvshin))
- Removing offline tokens support \(OSIO specific\). [\#11704](https://github.com/eclipse/che/pull/11704) ([rhopp](https://github.com/rhopp))
- Display notification with error instead of dialog window [\#11698](https://github.com/eclipse/che/pull/11698) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Fix of signature help feature when typing '\(' symbol [\#11696](https://github.com/eclipse/che/pull/11696) ([dkuleshov](https://github.com/dkuleshov))
- Switch update project to Json-rpc [\#11691](https://github.com/eclipse/che/pull/11691) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Do not execute selenium tests under repair by default [\#11689](https://github.com/eclipse/che/pull/11689) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Share volumes between containers for ephemeral workspaces [\#11657](https://github.com/eclipse/che/pull/11657) ([amisevsk](https://github.com/amisevsk))
- CHE-9720: Checkout ssh-extension to tag with extension [\#11405](https://github.com/eclipse/che/pull/11405) ([vinokurig](https://github.com/vinokurig))


## [6.13.1](https://github.com/eclipse/che/tree/6.13.1) (2018-11-08)
[Full Changelog](https://github.com/eclipse/che/compare/6.13.0...6.13.1)

**Merged pull requests:**

- The PVC cleaning on workspace deletion is done in the wrong condition [\#11840](https://github.com/eclipse/che/pull/11840) ([davidfestal](https://github.com/davidfestal))
- Reuse the Dashboard Keycloak instance in IDE frames when possible [\#11794](https://github.com/eclipse/che/pull/11794) ([davidfestal](https://github.com/davidfestal))


## [6.13.0](https://github.com/eclipse/che/tree/6.13.0) (2018-10-24)
[Full Changelog](https://github.com/eclipse/che/compare/6.12.2...6.13.0)

**Merged pull requests:**

- Selenium: quick fix for CheckStoppingWsByTimeoutTest test [\#11724](https://github.com/eclipse/che/pull/11724) ([SkorikSergey](https://github.com/SkorikSergey))
- RELEASE: Set next development version [\#11710](https://github.com/eclipse/che/pull/11710) ([riuvshin](https://github.com/riuvshin))
- Update the theia yeoman generator to the latest version [\#11695](https://github.com/eclipse/che/pull/11695) ([benoitf](https://github.com/benoitf))
- Fix improperly editor behavior when in debug mode [\#11672](https://github.com/eclipse/che/pull/11672) ([azatsarynnyy](https://github.com/azatsarynnyy))
- Add Theia stack for Kubernetes [\#11661](https://github.com/eclipse/che/pull/11661) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Selenium: Adapt selenium tests after merging JDT.LS branch in master [\#11715](https://github.com/eclipse/che/pull/11715) ([artaleks9](https://github.com/artaleks9))
- Selenium: quick fix for selenium tests [\#11708](https://github.com/eclipse/che/pull/11708) ([SkorikSergey](https://github.com/SkorikSergey))
- Use keyclock token in case MultiUser assembly for SSH Key Uploading [\#11702](https://github.com/eclipse/che/pull/11702) ([vparfonov](https://github.com/vparfonov))
- \[Selenium\] Fix unexpected fail of "TheiaBuildPluginTest", "AutocompleteFeaturesInEditorTest", "DeletePackageWithOpenedFilesTabTest", "ContextMenuEditorTest", "JavaDocPopupTest"  selenium tests [\#11700](https://github.com/eclipse/che/pull/11700) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Che-theia: Temporary using extension branch for che-theia-factory-ext… [\#11687](https://github.com/eclipse/che/pull/11687) ([sunix](https://github.com/sunix))
- Fix Theia image build [\#11685](https://github.com/eclipse/che/pull/11685) ([evidolob](https://github.com/evidolob))
- Fix exception handling in permissions DAO [\#11684](https://github.com/eclipse/che/pull/11684) ([mkuznyetsov](https://github.com/mkuznyetsov))
- More information for ServerSideRequestProcessor.RejectedExecutionHandler [\#11681](https://github.com/eclipse/che/pull/11681) ([skabashnyuk](https://github.com/skabashnyuk))
- Selenium: remove info about known \#10698 issue [\#11680](https://github.com/eclipse/che/pull/11680) ([SkorikSergey](https://github.com/SkorikSergey))
- adds pluginrepo for snapshots, sort poms [\#11678](https://github.com/eclipse/che/pull/11678) ([riuvshin](https://github.com/riuvshin))
- Selenium: adapt selenium tests after merging JDT.LS branch in master [\#11674](https://github.com/eclipse/che/pull/11674) ([SkorikSergey](https://github.com/SkorikSergey))
- \[Selenium\] Rework selenium tests in the "preferences", "autocomplete", "projectexplorer", "dependencies", "editor" packages for adopting to branch changes [\#11673](https://github.com/eclipse/che/pull/11673) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- \[dockerfile\] \[theia\] Fix git [\#11671](https://github.com/eclipse/che/pull/11671) ([benoitf](https://github.com/benoitf))
- Selenium: Delete the 'try-catch' from the test method in the 'GolangFileEditingTest' [\#11669](https://github.com/eclipse/che/pull/11669) ([artaleks9](https://github.com/artaleks9))
- Prevent exception in case Preview URL not set [\#11658](https://github.com/eclipse/che/pull/11658) ([vparfonov](https://github.com/vparfonov))
- Change Theia broker image to one hosted in wsskeleton repo [\#11656](https://github.com/eclipse/che/pull/11656) ([garagatyi](https://github.com/garagatyi))
- Selenium: Add the 'try-catch' to the 'GitPullTest' [\#11652](https://github.com/eclipse/che/pull/11652) ([artaleks9](https://github.com/artaleks9))
- Add missing java support in Camel stack [\#11651](https://github.com/eclipse/che/pull/11651) ([apupier](https://github.com/apupier))
- Correct initialize orion hover provider [\#11647](https://github.com/eclipse/che/pull/11647) ([vzhukovskii](https://github.com/vzhukovskii))
- \[Selenium\] Update launch command in 'TheiaBuildPluginTest' according to changes in \#11633 [\#11646](https://github.com/eclipse/che/pull/11646) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- \[dockerfile\] Update che theia image [\#11641](https://github.com/eclipse/che/pull/11641) ([benoitf](https://github.com/benoitf))
- \[docker\] Update che theia image [\#11633](https://github.com/eclipse/che/pull/11633) ([benoitf](https://github.com/benoitf))
- Fix exception message during factory update with duplicate name [\#11630](https://github.com/eclipse/che/pull/11630) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Fix view rolebinding for Kubernetes. [\#11629](https://github.com/eclipse/che/pull/11629) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- \[Selenium\] Add catching of the known bug \(\#11624\) to the "TheiaBuildPluginTest" selenium test  [\#11628](https://github.com/eclipse/che/pull/11628) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenuim: execute selenium tests from 'dashboard' package on openshift prod-preview [\#11626](https://github.com/eclipse/che/pull/11626) ([SkorikSergey](https://github.com/SkorikSergey))
- Add workspace name and namespace as environment variable [\#11623](https://github.com/eclipse/che/pull/11623) ([skabashnyuk](https://github.com/skabashnyuk))
- Fix build \(invalid stubbing\) [\#11619](https://github.com/eclipse/che/pull/11619) ([benoitf](https://github.com/benoitf))
- Add an ability to disable discover-ability of a plugin endpoint [\#11617](https://github.com/eclipse/che/pull/11617) ([skabashnyuk](https://github.com/skabashnyuk))
- Cleanup code after removing test LangServer [\#11613](https://github.com/eclipse/che/pull/11613) ([vparfonov](https://github.com/vparfonov))
- Selenium: wait that IDE is ready to use before open project [\#11612](https://github.com/eclipse/che/pull/11612) ([SkorikSergey](https://github.com/SkorikSergey))
- Create a parent /node\_modules folder and add setting for yarn to use that parent folder [\#11611](https://github.com/eclipse/che/pull/11611) ([benoitf](https://github.com/benoitf))
- Selenium: fix unstable selenium tests [\#11610](https://github.com/eclipse/che/pull/11610) ([SkorikSergey](https://github.com/SkorikSergey))
- Add an index in thread names [\#11608](https://github.com/eclipse/che/pull/11608) ([skabashnyuk](https://github.com/skabashnyuk))
- \[Selenium\] Adapt the "TheiaBuildPluginTest" selenium test to the new terminal tab titles [\#11607](https://github.com/eclipse/che/pull/11607) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Don't put new line in the editor when going to a line by number [\#11603](https://github.com/eclipse/che/pull/11603) ([azatsarynnyy](https://github.com/azatsarynnyy))
- Add cause information in LoggedRunnable error [\#11602](https://github.com/eclipse/che/pull/11602) ([skabashnyuk](https://github.com/skabashnyuk))
- Selenium: Correct the method 'waitAndSelectItemByName\(\)' in the 'ProjectExplorer' [\#11599](https://github.com/eclipse/che/pull/11599) ([artaleks9](https://github.com/artaleks9))
- Selenium: quick fix for selenium tests  [\#11597](https://github.com/eclipse/che/pull/11597) ([SkorikSergey](https://github.com/SkorikSergey))
- Add workspaceEnv to plugin, populate it on sidecar resolving [\#11596](https://github.com/eclipse/che/pull/11596) ([garagatyi](https://github.com/garagatyi))
- \[Selenium\] Adapt the "TheiaBuildPluginTest" selenium test to changes in the top menu [\#11595](https://github.com/eclipse/che/pull/11595) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Fixed case when Find References feature displays incorrect line positions [\#11594](https://github.com/eclipse/che/pull/11594) ([dkuleshov](https://github.com/dkuleshov))
- \[stack\] Use of the new theia image [\#11593](https://github.com/eclipse/che/pull/11593) ([benoitf](https://github.com/benoitf))
- Moved recovering of runtimes out of PostConstruct phase [\#11592](https://github.com/eclipse/che/pull/11592) ([sleshchenko](https://github.com/sleshchenko))
- Selenium: Change the 'GitStatusBar' to avoid unexpected 'stale element exception' [\#11590](https://github.com/eclipse/che/pull/11590) ([artaleks9](https://github.com/artaleks9))
- Add an ability to use a custom registry for WS.NEXT plugins [\#11588](https://github.com/eclipse/che/pull/11588) ([mshaposhnik](https://github.com/mshaposhnik))
- Add abstraction for TestWorkspaceInjector. [\#11586](https://github.com/eclipse/che/pull/11586) ([Katka92](https://github.com/Katka92))
- Improve and clean up factory validation exception messages [\#11585](https://github.com/eclipse/che/pull/11585) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Added exec plugin to Che 7 stack [\#11580](https://github.com/eclipse/che/pull/11580) ([l0rd](https://github.com/l0rd))
- Fix importing a project from Git VCS with a branch that contains slash symbol [\#11579](https://github.com/eclipse/che/pull/11579) ([azatsarynnyy](https://github.com/azatsarynnyy))
- Selenium: update expected stacks lists in 'NewWorkspacesPageTest' test  [\#11577](https://github.com/eclipse/che/pull/11577) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-10945: Fix terminal font for some systems. [\#11576](https://github.com/eclipse/che/pull/11576) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Split editors and plugins, and disable installers, when any plugin is selected [\#11575](https://github.com/eclipse/che/pull/11575) ([ashumilova](https://github.com/ashumilova))
- \[dockerfile\] Update che-theia image [\#11573](https://github.com/eclipse/che/pull/11573) ([benoitf](https://github.com/benoitf))
- Add tracking of STARTING/STOPPING recovered k8s/OS runtimes [\#11570](https://github.com/eclipse/che/pull/11570) ([sleshchenko](https://github.com/sleshchenko))
- Fix small bugs for dashboard [\#11569](https://github.com/eclipse/che/pull/11569) ([olexii4](https://github.com/olexii4))
- Remove obsolete 'Welcome' page from preferences [\#11567](https://github.com/eclipse/che/pull/11567) ([azatsarynnyy](https://github.com/azatsarynnyy))
- Fix duplicating the processes in the Commands toolbar [\#11566](https://github.com/eclipse/che/pull/11566) ([azatsarynnyy](https://github.com/azatsarynnyy))
- \[Selenium\] Fix unexpected fail of "AutocompleteFeaturesInEditorTest" selenium test [\#11565](https://github.com/eclipse/che/pull/11565) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: quick fix for selenium tests [\#11561](https://github.com/eclipse/che/pull/11561) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix memory request jwt [\#11556](https://github.com/eclipse/che/pull/11556) ([garagatyi](https://github.com/garagatyi))
- Replaced ws.next sample stack with a Che7 preview stack [\#11543](https://github.com/eclipse/che/pull/11543) ([l0rd](https://github.com/l0rd))
- Store logs of test workspaces created by E2E tests from Dashboard [\#11542](https://github.com/eclipse/che/pull/11542) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Define image pulling strategy for sidecars via configuration  [\#11536](https://github.com/eclipse/che/pull/11536) ([mshaposhnik](https://github.com/mshaposhnik))
- Validate a command's name before saving [\#11535](https://github.com/eclipse/che/pull/11535) ([azatsarynnyy](https://github.com/azatsarynnyy))
- RELEASE: Update CHANGELOG for 6.12.1 [\#11533](https://github.com/eclipse/che/pull/11533) ([riuvshin](https://github.com/riuvshin))
- \[dockerfile\] add 'debug-nodejs' extension to che-theia image [\#11531](https://github.com/eclipse/che/pull/11531) ([evidolob](https://github.com/evidolob))
- Returns 'add-source' execution into pom.xml for UD [\#11528](https://github.com/eclipse/che/pull/11528) ([olexii4](https://github.com/olexii4))
- Display notification with proposition to restart ws agent [\#11524](https://github.com/eclipse/che/pull/11524) ([RomanNikitenko](https://github.com/RomanNikitenko))
- \[Selenium\] Fix unexpected fail of "TheiaBuildPluginTest" selenium test [\#11523](https://github.com/eclipse/che/pull/11523) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- RELEASE: Update CHANGELOG [\#11522](https://github.com/eclipse/che/pull/11522) ([riuvshin](https://github.com/riuvshin))
- \[dockerfile\] Multi staged build of Theia image [\#11519](https://github.com/eclipse/che/pull/11519) ([benoitf](https://github.com/benoitf))
- \[Selenium\] Get rid of "StaleElementReferenceException" in the "TheiaEditor\#getEditorText\(\)" method [\#11518](https://github.com/eclipse/che/pull/11518) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Reworked LanguageServerFileWatcher [\#11515](https://github.com/eclipse/che/pull/11515) ([dkuleshov](https://github.com/dkuleshov))
- Fix of FileWatcherByPathMatcher to properly watch existing files. [\#11510](https://github.com/eclipse/che/pull/11510) ([dkuleshov](https://github.com/dkuleshov))
- Merge mysql sql schema into common bundle; [\#11501](https://github.com/eclipse/che/pull/11501) ([mshaposhnik](https://github.com/mshaposhnik))
- \[Selenium\] Fix unexpected fail of "MacrosCommandsEditorTest" selenium test [\#11498](https://github.com/eclipse/che/pull/11498) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- fix dashboard version [\#11494](https://github.com/eclipse/che/pull/11494) ([riuvshin](https://github.com/riuvshin))
- Remove outdated actions [\#11489](https://github.com/eclipse/che/pull/11489) ([vparfonov](https://github.com/vparfonov))
- Enhanced error logging in WsAgentURLProvider [\#11485](https://github.com/eclipse/che/pull/11485) ([dkuleshov](https://github.com/dkuleshov))
- Fix for rename file operation when using Camel LS [\#11483](https://github.com/eclipse/che/pull/11483) ([dkuleshov](https://github.com/dkuleshov))
- Disable debug mode for wsagent by default [\#11475](https://github.com/eclipse/che/pull/11475) ([sleshchenko](https://github.com/sleshchenko))
- Sidecar container naming using plugin\_name + che\_container\_name [\#11465](https://github.com/eclipse/che/pull/11465) ([mshaposhnik](https://github.com/mshaposhnik))
- Limit pool size used to process Json/rpc requests [\#11456](https://github.com/eclipse/che/pull/11456) ([skabashnyuk](https://github.com/skabashnyuk))
- RELEASE: Set next development version [\#11434](https://github.com/eclipse/che/pull/11434) ([riuvshin](https://github.com/riuvshin))
- Update to latest theia image including new remote plugins [\#11426](https://github.com/eclipse/che/pull/11426) ([benoitf](https://github.com/benoitf))
- Added publishing of plugin broker logs as runtime logs [\#11423](https://github.com/eclipse/che/pull/11423) ([sleshchenko](https://github.com/sleshchenko))
- Provide better compatibility with alternate OIDC providers [\#11090](https://github.com/eclipse/che/pull/11090) ([davidfestal](https://github.com/davidfestal))
- Rework dependency management in go agents [\#11038](https://github.com/eclipse/che/pull/11038) ([skabashnyuk](https://github.com/skabashnyuk))
- \[WIP\]Fix timeunit: set to seconds. Add checking after add to index [\#11022](https://github.com/eclipse/che/pull/11022) ([vparfonov](https://github.com/vparfonov))
- Introduce java language server [\#10863](https://github.com/eclipse/che/pull/10863) ([tolusha](https://github.com/tolusha))
- Upgrade to new dependency mockito-testng [\#10647](https://github.com/eclipse/che/pull/10647) ([skabashnyuk](https://github.com/skabashnyuk))


## [6.12.1](https://github.com/eclipse/che/tree/6.12.1) (2018-10-08)
[Full Changelog](https://github.com/eclipse/che/compare/6.12.0...6.12.1)

**Merged pull requests:**

- Returns 'add-source' execution into pom.xml for UD [\#11528](https://github.com/eclipse/che/pull/11528) ([olexii4](https://github.com/olexii4))
- \[Selenium\] Fix unexpected fail of "TheiaBuildPluginTest" selenium test [\#11523](https://github.com/eclipse/che/pull/11523) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- RELEASE: Update CHANGELOG [\#11522](https://github.com/eclipse/che/pull/11522) ([riuvshin](https://github.com/riuvshin))
- \[Selenium\] Get rid of "StaleElementReferenceException" in the "TheiaEditor\#getEditorText\(\)" method [\#11518](https://github.com/eclipse/che/pull/11518) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Sidecar container naming using plugin\_name + che\_container\_name [\#11465](https://github.com/eclipse/che/pull/11465) ([mshaposhnik](https://github.com/mshaposhnik))
- Limit pool size used to process Json/rpc requests [\#11456](https://github.com/eclipse/che/pull/11456) ([skabashnyuk](https://github.com/skabashnyuk))


## [6.12.0](https://github.com/eclipse/che/tree/6.12.0) (2018-10-05)
[Full Changelog](https://github.com/eclipse/che/compare/6.11.1...6.12.0)

**Merged pull requests:**

- Merge mysql sql schema into common bundle; [\#11501](https://github.com/eclipse/che/pull/11501) ([mshaposhnik](https://github.com/mshaposhnik))
- \[Selenium\] Fix unexpected fail of "MacrosCommandsEditorTest" selenium test [\#11498](https://github.com/eclipse/che/pull/11498) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- fix dashboard version [\#11494](https://github.com/eclipse/che/pull/11494) ([riuvshin](https://github.com/riuvshin))
- Remove outdated actions [\#11489](https://github.com/eclipse/che/pull/11489) ([vparfonov](https://github.com/vparfonov))
- Disable debug mode for wsagent by default [\#11475](https://github.com/eclipse/che/pull/11475) ([sleshchenko](https://github.com/sleshchenko))
- Adapt jdt.ls as a lsp editor when opening locations [\#11449](https://github.com/eclipse/che/pull/11449) ([tsmaeder](https://github.com/tsmaeder))
- Adapt "open declaration" tests to behaviour of LSP editors [\#11448](https://github.com/eclipse/che/pull/11448) ([tsmaeder](https://github.com/tsmaeder))
- Fix open location to select range [\#11436](https://github.com/eclipse/che/pull/11436) ([tsmaeder](https://github.com/tsmaeder))
- RELEASE: Set next development version [\#11434](https://github.com/eclipse/che/pull/11434) ([riuvshin](https://github.com/riuvshin))
- Added publishing of plugin broker logs as runtime logs [\#11423](https://github.com/eclipse/che/pull/11423) ([sleshchenko](https://github.com/sleshchenko))
- Fix java debugger integration tests [\#11395](https://github.com/eclipse/che/pull/11395) ([tolusha](https://github.com/tolusha))
- Switch log message we wait for in LS tests [\#11394](https://github.com/eclipse/che/pull/11394) ([tsmaeder](https://github.com/tsmaeder))
- Implementers is Broken for Class Files \#10337 [\#11378](https://github.com/eclipse/che/pull/11378) ([vrubezhny](https://github.com/vrubezhny))
- \#11192 - added multiuser tck tests for MySQL [\#11371](https://github.com/eclipse/che/pull/11371) ([BarryDrez](https://github.com/BarryDrez))
- Login to oc right after init [\#11366](https://github.com/eclipse/che/pull/11366) ([Katka92](https://github.com/Katka92))
- Wait for jdt.ls before debugging [\#11362](https://github.com/eclipse/che/pull/11362) ([tsmaeder](https://github.com/tsmaeder))
- Suspend handling of file changed notifications when applying ws edit [\#11360](https://github.com/eclipse/che/pull/11360) ([tsmaeder](https://github.com/tsmaeder))
- Restore some loader.waitOnClosed\(\) calls [\#11348](https://github.com/eclipse/che/pull/11348) ([tsmaeder](https://github.com/tsmaeder))
- Don't fail when jdt.ls messages are not found [\#11334](https://github.com/eclipse/che/pull/11334) ([tsmaeder](https://github.com/tsmaeder))
- Selenium: rework "FindUsages" selenium page object by "SeleniumWebDriverHelper" class  [\#11329](https://github.com/eclipse/che/pull/11329) ([SkorikSergey](https://github.com/SkorikSergey))
- \#11192 - Tck tests and initial support for MySQL [\#11315](https://github.com/eclipse/che/pull/11315) ([BarryDrez](https://github.com/BarryDrez))
- Don't use eclipse.text classes to convert text edits [\#11314](https://github.com/eclipse/che/pull/11314) ([tsmaeder](https://github.com/tsmaeder))
- Add org.eclipse.che.ls.java installer into E2E test workspace templates [\#11310](https://github.com/eclipse/che/pull/11310) ([dmytro-ndp](https://github.com/dmytro-ndp))
- New folders do not register in the jdt.ls workspace \#10115 [\#11084](https://github.com/eclipse/che/pull/11084) ([vrubezhny](https://github.com/vrubezhny))
- Upgrade the version of jQuery to 3.3.1 [\#11492](https://github.com/eclipse/che/pull/11492) ([olexii4](https://github.com/olexii4))
- fix pg version in rc [\#11480](https://github.com/eclipse/che/pull/11480) ([riuvshin](https://github.com/riuvshin))
- introduce RC version for pre-release testing [\#11477](https://github.com/eclipse/che/pull/11477) ([riuvshin](https://github.com/riuvshin))
- Selenium: not check that CHE\_MACHINE\_NAME variable exists in 'Environment variables' tab [\#11464](https://github.com/eclipse/che/pull/11464) ([SkorikSergey](https://github.com/SkorikSergey))
- Added liveness probe for jupyter server [\#11454](https://github.com/eclipse/che/pull/11454) ([sleshchenko](https://github.com/sleshchenko))
- Don't stop workspace recovery when error is encountered [\#11446](https://github.com/eclipse/che/pull/11446) ([amisevsk](https://github.com/amisevsk))
- Selenium: Change the timeout in the 'openItemByPath\(\)' from the 'ProjectExplorer' [\#11441](https://github.com/eclipse/che/pull/11441) ([artaleks9](https://github.com/artaleks9))
- Fix regex in PullRequestPluginTest [\#11439](https://github.com/eclipse/che/pull/11439) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Fixed `exec`, `terminal` sidecars [\#11432](https://github.com/eclipse/che/pull/11432) ([sleshchenko](https://github.com/sleshchenko))
- Add custom timeout for AbstractTestWorkspaceServiceClient\#waitStatus. [\#11430](https://github.com/eclipse/che/pull/11430) ([Katka92](https://github.com/Katka92))
- Rework ConvertToProjectWithPomFileTest test for checking conversion folders to maven multimodule project [\#11427](https://github.com/eclipse/che/pull/11427) ([musienko-maxim](https://github.com/musienko-maxim))
- Selenium: Correct the method 'checkFindProjectSymbolFeature\(\)' in the 'GolangFileEditingTest' [\#11425](https://github.com/eclipse/che/pull/11425) ([artaleks9](https://github.com/artaleks9))
- Make Che Server depending on plugin broker image tag instead of latest [\#11422](https://github.com/eclipse/che/pull/11422) ([sleshchenko](https://github.com/sleshchenko))
- Selenium: rework "FileStructure" selenium page object by "SeleniumWebDriverHelper" class [\#11421](https://github.com/eclipse/che/pull/11421) ([SkorikSergey](https://github.com/SkorikSergey))
- \[Selenium\] Fix unexpected fail of "TheiaBuildPluginTest" selenium test [\#11418](https://github.com/eclipse/che/pull/11418) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Fail workspace start if registry not configured and ws.next plugins requested [\#11414](https://github.com/eclipse/che/pull/11414) ([amisevsk](https://github.com/amisevsk))
- Set k8s memory request wherever we set limit [\#11413](https://github.com/eclipse/che/pull/11413) ([garagatyi](https://github.com/garagatyi))
- Make Theia sidecar/stack secure, add an ability to use new JWT auth on a per-workspace basis [\#11410](https://github.com/eclipse/che/pull/11410) ([garagatyi](https://github.com/garagatyi))
- CHE-11408: Disable probes of Che master when debug is enabled [\#11409](https://github.com/eclipse/che/pull/11409) ([garagatyi](https://github.com/garagatyi))
- Selenium: Correct the 'openItemByPath\(\)' to avoid the 'NoSuchElementException' [\#11407](https://github.com/eclipse/che/pull/11407) ([artaleks9](https://github.com/artaleks9))
- Include activity tracker extension into default Theia image [\#11404](https://github.com/eclipse/che/pull/11404) ([mmorhun](https://github.com/mmorhun))
- Make methods accessible with machine token configurable [\#11402](https://github.com/eclipse/che/pull/11402) ([mshaposhnik](https://github.com/mshaposhnik))
- \[Selenium\] Fix of unexpected fail of "UploadIntoProjectTest" selenium test [\#11399](https://github.com/eclipse/che/pull/11399) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Fail workspace validation if config contains both ws.next plugins and installers [\#11392](https://github.com/eclipse/che/pull/11392) ([amisevsk](https://github.com/amisevsk))
- Correct the 'GitPullTest' related to unexpected stale element reference [\#11389](https://github.com/eclipse/che/pull/11389) ([artaleks9](https://github.com/artaleks9))
- \[Selenium\] Create Selenium test covered Theia stack [\#11388](https://github.com/eclipse/che/pull/11388) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Quick fix for TypeScriptEditingTest [\#11386](https://github.com/eclipse/che/pull/11386) ([musienko-maxim](https://github.com/musienko-maxim))
- Close 'Project Configuration' form when configure Che in Che [\#11375](https://github.com/eclipse/che/pull/11375) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Selenium: Rework the 'waitGitDeletionMarkerInPosition\(\)' to avoid unexpected 'stale element exception' [\#11369](https://github.com/eclipse/che/pull/11369) ([artaleks9](https://github.com/artaleks9))
- Add possibility to configure timeout for plugin broker [\#11368](https://github.com/eclipse/che/pull/11368) ([mshaposhnik](https://github.com/mshaposhnik))
- Add different small improvements [\#11367](https://github.com/eclipse/che/pull/11367) ([sleshchenko](https://github.com/sleshchenko))
- Selenium: stabilize FindUsagesBaseOperationTest selenium test [\#11365](https://github.com/eclipse/che/pull/11365) ([SkorikSergey](https://github.com/SkorikSergey))
- Change default sidecar memory limit to 128MB [\#11358](https://github.com/eclipse/che/pull/11358) ([garagatyi](https://github.com/garagatyi))
- Remove multiuser module from single-user integration tests [\#11355](https://github.com/eclipse/che/pull/11355) ([mshaposhnik](https://github.com/mshaposhnik))
- Setup default value for CHE\_WORKSPACE\_PLUGIN\_\_REGISTRY\_\_URL [\#11354](https://github.com/eclipse/che/pull/11354) ([skabashnyuk](https://github.com/skabashnyuk))
- Use latest che-theia-terminal extension and che-theia-task-plugin for Theia image [\#11351](https://github.com/eclipse/che/pull/11351) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Selenium: Update the 'ApacheCamelFileEditingTest' according to the test plan [\#11347](https://github.com/eclipse/che/pull/11347) ([artaleks9](https://github.com/artaleks9))
- Added propagation of plugin broker failing error [\#11344](https://github.com/eclipse/che/pull/11344) ([sleshchenko](https://github.com/sleshchenko))
- Adding support of the ephemeral workspaces \(using `emptyDir` volume instead of PVC\) via 'persistVolumes' attribute [\#11343](https://github.com/eclipse/che/pull/11343) ([ibuziuk](https://github.com/ibuziuk))
- Provide support for MySQL [\#11337](https://github.com/eclipse/che/pull/11337) ([mshaposhnik](https://github.com/mshaposhnik))
- Selenium: update "YamlFileEditingTest" selenium test according to language servers test plan [\#11336](https://github.com/eclipse/che/pull/11336) ([SkorikSergey](https://github.com/SkorikSergey))
- Add to TypeScriptEditing test all supported language capabilities [\#11333](https://github.com/eclipse/che/pull/11333) ([musienko-maxim](https://github.com/musienko-maxim))
- \[dockerfile\] Add textmate and minibrowser extensions [\#11332](https://github.com/eclipse/che/pull/11332) ([benoitf](https://github.com/benoitf))
- Add memory limit to the Openshift Theia stack. [\#11331](https://github.com/eclipse/che/pull/11331) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- \[Selenium\] Fix unexpected fail of "InheritClassTest" selenium test [\#11325](https://github.com/eclipse/che/pull/11325) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
-  CHE-11097: Allow setting sidecar memory limit in ws attributes [\#11323](https://github.com/eclipse/che/pull/11323) ([garagatyi](https://github.com/garagatyi))
- \[Selenium\] Fix unexpected fail of "CheckRestoringSplitEditorTest" selenium test [\#11322](https://github.com/eclipse/che/pull/11322) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Add an ability to configure Pull policy for broker [\#11321](https://github.com/eclipse/che/pull/11321) ([garagatyi](https://github.com/garagatyi))
- \[root pom\] support overriding the version of dashboard [\#11313](https://github.com/eclipse/che/pull/11313) ([nickboldt](https://github.com/nickboldt))
- Selenium: Update the 'GolangFileEditingTest' according to the test plan [\#11312](https://github.com/eclipse/che/pull/11312) ([artaleks9](https://github.com/artaleks9))
- Selenium: update expected stacks lists in 'NewWorkspacesPageTest' test [\#11309](https://github.com/eclipse/che/pull/11309) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: update "JsonFileEditingTest" selenium test according to language servers test plan [\#11307](https://github.com/eclipse/che/pull/11307) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-10883 migrate from bower to yarn [\#11301](https://github.com/eclipse/che/pull/11301) ([olexii4](https://github.com/olexii4))
- Added exec plugin to ws-next stacks [\#11298](https://github.com/eclipse/che/pull/11298) ([l0rd](https://github.com/l0rd))
- Add Apache Camel icon for the Stack \(\#11236\) [\#11296](https://github.com/eclipse/che/pull/11296) ([apupier](https://github.com/apupier))
- \[ Selenium \] Cover the "Python" language server functionality by selenium test  [\#11293](https://github.com/eclipse/che/pull/11293) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Add plugins widget on workspace creation [\#11291](https://github.com/eclipse/che/pull/11291) ([ashumilova](https://github.com/ashumilova))
- \[docker\] Fix unison build [\#11289](https://github.com/eclipse/che/pull/11289) ([benoitf](https://github.com/benoitf))
- Change default sidecar memory limit to 512MB to let Theia work OOTB [\#11288](https://github.com/eclipse/che/pull/11288) ([garagatyi](https://github.com/garagatyi))
- \[ Selenium \] Update usecases in "PhpAssistantFeaturesTest" for catching known bugs \#10117 \#10698 [\#11283](https://github.com/eclipse/che/pull/11283) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: update "ClangFileEditingTest" selenium test according to language servers test plan [\#11280](https://github.com/eclipse/che/pull/11280) ([SkorikSergey](https://github.com/SkorikSergey))
- \[ Selenium \] Fix unexpected fail of "CheckWorkingWithTabsByUsingContextMenuTest" selenium test [\#11277](https://github.com/eclipse/che/pull/11277) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- RELEASE: Update CHANGELOG [\#11272](https://github.com/eclipse/che/pull/11272) ([riuvshin](https://github.com/riuvshin))
- Fix NPE for plugin volumes. [\#11268](https://github.com/eclipse/che/pull/11268) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Do not recognize file in workspace root as project [\#11264](https://github.com/eclipse/che/pull/11264) ([vzhukovskii](https://github.com/vzhukovskii))
- \[ Selenium \] Cover the "PHP" language server functionality by selenium test [\#11263](https://github.com/eclipse/che/pull/11263) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: update expected stacks lists on 'New Workspaces' page [\#11262](https://github.com/eclipse/che/pull/11262) ([SkorikSergey](https://github.com/SkorikSergey))
- Add selenium tests for covering advanced operations for C\# LS [\#11261](https://github.com/eclipse/che/pull/11261) ([musienko-maxim](https://github.com/musienko-maxim))
- CHE-11097: add mem limit field to sidecar model [\#11254](https://github.com/eclipse/che/pull/11254) ([garagatyi](https://github.com/garagatyi))
- Fix k8s/OS workspace deployment cleanup when pod failed to start [\#11253](https://github.com/eclipse/che/pull/11253) ([amisevsk](https://github.com/amisevsk))
- Selenium: correct the 'doRenamingByLanguageServerField\(\)' method in t… [\#11251](https://github.com/eclipse/che/pull/11251) ([artaleks9](https://github.com/artaleks9))
- CHE-11097: Add per-sidecar memory limit in WS.NEXT [\#11248](https://github.com/eclipse/che/pull/11248) ([garagatyi](https://github.com/garagatyi))
- Imrove code readability by following sonar lint guidance [\#11247](https://github.com/eclipse/che/pull/11247) ([apupier](https://github.com/apupier))
- \[Selenium\] Create method for performing specified functionality with ignoring provided exception [\#11246](https://github.com/eclipse/che/pull/11246) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Provide basic Apache Camel stack [\#11245](https://github.com/eclipse/che/pull/11245) ([apupier](https://github.com/apupier))
- Fix typo in Contributing.md [\#11239](https://github.com/eclipse/che/pull/11239) ([apupier](https://github.com/apupier))
- Rename project attributes column name to avoid reserved keyword [\#11237](https://github.com/eclipse/che/pull/11237) ([mshaposhnik](https://github.com/mshaposhnik))
- Stores logs of test workspaces which do not have RUNNING status [\#11233](https://github.com/eclipse/che/pull/11233) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Do not skip selenium test which should run always [\#11232](https://github.com/eclipse/che/pull/11232) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Use verbaccio config. [\#11230](https://github.com/eclipse/che/pull/11230) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Add 'che-theia-terminal-extension' and 'che-theia-task-plugin' to the Theia image [\#11228](https://github.com/eclipse/che/pull/11228) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- \[Selenium\] Create "FindPreferencesConsoleTab" selenium page object [\#11225](https://github.com/eclipse/che/pull/11225) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- CHE-10909: Set Git committer name and email from profile on IDE start [\#11224](https://github.com/eclipse/che/pull/11224) ([vinokurig](https://github.com/vinokurig))
- \[Selenium\] Create page object for "QuickOpenView" form [\#11216](https://github.com/eclipse/che/pull/11216) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Limit scope of the machine token signed requests [\#11215](https://github.com/eclipse/che/pull/11215) ([mshaposhnik](https://github.com/mshaposhnik))
- Add support of dockerimage and kubernetes recipes in some cases [\#11213](https://github.com/eclipse/che/pull/11213) ([garagatyi](https://github.com/garagatyi))
- Add a property for default sidecar mem limit [\#11212](https://github.com/eclipse/che/pull/11212) ([garagatyi](https://github.com/garagatyi))
- Close browser window after factory-related E2E tests finished [\#11207](https://github.com/eclipse/che/pull/11207) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Fix the plugins registry location [\#11205](https://github.com/eclipse/che/pull/11205) ([ashumilova](https://github.com/ashumilova))
- Fix docs [\#11203](https://github.com/eclipse/che/pull/11203) ([eivantsov](https://github.com/eivantsov))
- Make OpenShift infrastructure create a special service account for workspaces [\#11199](https://github.com/eclipse/che/pull/11199) ([sleshchenko](https://github.com/sleshchenko))
- Selenium: Add the 'try/catch' to tests in the 'refactor.parameters' package [\#11191](https://github.com/eclipse/che/pull/11191) ([artaleks9](https://github.com/artaleks9))
- Add the 'try/catch' to the 'ImportAndValidateEclipseCheProjectTest' [\#11190](https://github.com/eclipse/che/pull/11190) ([artaleks9](https://github.com/artaleks9))
- Selenium: add selenium tests that cover workspace creation from Theia and Node stacks to CheSuite test suite [\#11183](https://github.com/eclipse/che/pull/11183) ([SkorikSergey](https://github.com/SkorikSergey))
- Added an ability to specify service account to be bound to workspaces pods [\#11178](https://github.com/eclipse/che/pull/11178) ([sleshchenko](https://github.com/sleshchenko))
- Use edit role for Che SA [\#11177](https://github.com/eclipse/che/pull/11177) ([eivantsov](https://github.com/eivantsov))
- CHE-11173: Fix Unsupported operation exception [\#11176](https://github.com/eclipse/che/pull/11176) ([vinokurig](https://github.com/vinokurig))
- RELEASE: Set next development version [\#11169](https://github.com/eclipse/che/pull/11169) ([riuvshin](https://github.com/riuvshin))
- Manage the list of plugins from Che plugins registry [\#11143](https://github.com/eclipse/che/pull/11143) ([ashumilova](https://github.com/ashumilova))
- Selenium: Add new test method to the 'PullRequestPluginTest' [\#11128](https://github.com/eclipse/che/pull/11128) ([artaleks9](https://github.com/artaleks9))
- Add extra workspace existence check before creating keypair  [\#10902](https://github.com/eclipse/che/pull/10902) ([mshaposhnik](https://github.com/mshaposhnik))

## [6.11.1](https://github.com/eclipse/che/tree/6.11.1) (2018-09-20)
[Full Changelog](https://github.com/eclipse/che/compare/6.11.0...6.11.1)

**Merged pull requests:**

- Wait for loader to close after jdt.ls workspace updated message. [\#11294](https://github.com/eclipse/che/pull/11294) ([tsmaeder](https://github.com/tsmaeder))
- 6.11.1 [\#11292](https://github.com/eclipse/che/pull/11292) ([amisevsk](https://github.com/amisevsk))
- Increase Refactoring Request Timeout [\#11278](https://github.com/eclipse/che/pull/11278) ([tsmaeder](https://github.com/tsmaeder))
- Wait for jdt.ls to have started [\#11274](https://github.com/eclipse/che/pull/11274) ([tsmaeder](https://github.com/tsmaeder))
- Wait for loader to close after projectexplorer refresh [\#11243](https://github.com/eclipse/che/pull/11243) ([tsmaeder](https://github.com/tsmaeder))
- Readd java stuff [\#11210](https://github.com/eclipse/che/pull/11210) ([tsmaeder](https://github.com/tsmaeder))
- Fix for RunPlainJavaProjectTest test [\#11133](https://github.com/eclipse/che/pull/11133) ([svor](https://github.com/svor))
- Don't throw an exception if none LS was found [\#11094](https://github.com/eclipse/che/pull/11094) ([svor](https://github.com/svor))


## [6.11.0](https://github.com/eclipse/che/tree/6.11.0) (2018-09-12)
[Full Changelog](https://github.com/eclipse/che/compare/6.10.0...6.11.0)

**Merged pull requests:**

- CHE-11173: Fix Unsupported operation exception [\#11176](https://github.com/eclipse/che/pull/11176) ([vinokurig](https://github.com/vinokurig))
- RELEASE: Set next development version [\#11169](https://github.com/eclipse/che/pull/11169) ([riuvshin](https://github.com/riuvshin))
- Add actual values of web element in SeleniumWebDriver error message [\#11153](https://github.com/eclipse/che/pull/11153) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Update LSP4J to 0.5.0.M1 [\#11152](https://github.com/eclipse/che/pull/11152) ([tsmaeder](https://github.com/tsmaeder))
- Manage the list of plugins from Che plugins registry [\#11143](https://github.com/eclipse/che/pull/11143) ([ashumilova](https://github.com/ashumilova))
- Add heap options env variable to jdt.ls start script [\#11116](https://github.com/eclipse/che/pull/11116) ([tsmaeder](https://github.com/tsmaeder))
- Fix for PlainJavaProjectConfigureClasspathTest [\#11109](https://github.com/eclipse/che/pull/11109) ([svor](https://github.com/svor))
- Fix selenium tests [\#11100](https://github.com/eclipse/che/pull/11100) ([tolusha](https://github.com/tolusha))
- Fix selenium tests [\#11074](https://github.com/eclipse/che/pull/11074) ([tolusha](https://github.com/tolusha))
- Fix selenium tests [\#11063](https://github.com/eclipse/che/pull/11063) ([tolusha](https://github.com/tolusha))
- Fix selenium tests [\#11062](https://github.com/eclipse/che/pull/11062) ([tolusha](https://github.com/tolusha))
- Fix tests from languageserver package [\#11059](https://github.com/eclipse/che/pull/11059) ([svor](https://github.com/svor))
- Use notifications instead of client commands [\#11057](https://github.com/eclipse/che/pull/11057) ([tsmaeder](https://github.com/tsmaeder))
- Fix waiting message in NavigateToFileTest [\#11052](https://github.com/eclipse/che/pull/11052) ([svor](https://github.com/svor))
- Fix selenium tests [\#11041](https://github.com/eclipse/che/pull/11041) ([tolusha](https://github.com/tolusha))
- Fix selenium tests [\#11036](https://github.com/eclipse/che/pull/11036) ([tolusha](https://github.com/tolusha))
- Fix NavigateToFileTest selenium test [\#11034](https://github.com/eclipse/che/pull/11034) ([svor](https://github.com/svor))
- Waiting for editor activation in FindUsagesBaseOperationTest [\#11014](https://github.com/eclipse/che/pull/11014) ([svor](https://github.com/svor))
- Fix selenium tests in languageserver package [\#11005](https://github.com/eclipse/che/pull/11005) ([tolusha](https://github.com/tolusha))
- Source folders of Plain Java project are not properly shown in Projec… [\#11003](https://github.com/eclipse/che/pull/11003) ([vrubezhny](https://github.com/vrubezhny))
- Make tests stable in projectexplorer package [\#10990](https://github.com/eclipse/che/pull/10990) ([tolusha](https://github.com/tolusha))
- Restore test resources [\#10985](https://github.com/eclipse/che/pull/10985) ([tsmaeder](https://github.com/tsmaeder))
- Simplify jdtls pr [\#10984](https://github.com/eclipse/che/pull/10984) ([tsmaeder](https://github.com/tsmaeder))
- Fix tests in org.eclipse.che.selenium.editor.autocomplete [\#10975](https://github.com/eclipse/che/pull/10975) ([svor](https://github.com/svor))
- Fix dependencies [\#10972](https://github.com/eclipse/che/pull/10972) ([vparfonov](https://github.com/vparfonov))
- Jdt.ls: fix selenium fix stack ordering [\#10969](https://github.com/eclipse/che/pull/10969) ([vparfonov](https://github.com/vparfonov))
- Jdt.ls: fix few Selenium tests for Refactoring feature  [\#10965](https://github.com/eclipse/che/pull/10965) ([vparfonov](https://github.com/vparfonov))
- Use equinox launcher independently of its version [\#10963](https://github.com/eclipse/che/pull/10963) ([tolusha](https://github.com/tolusha))
- Fix selenium tests in debug package [\#10951](https://github.com/eclipse/che/pull/10951) ([tolusha](https://github.com/tolusha))
- Fix find usage and method name [\#10949](https://github.com/eclipse/che/pull/10949) ([vparfonov](https://github.com/vparfonov))
- Fix launcher version [\#10946](https://github.com/eclipse/che/pull/10946) ([tolusha](https://github.com/tolusha))
- Jdt.ls: fix selenium test PullRequestPluginWithForkTest and PullRequestPluginTest [\#10938](https://github.com/eclipse/che/pull/10938) ([vparfonov](https://github.com/vparfonov))
- Cleanup maven client side [\#10933](https://github.com/eclipse/che/pull/10933) ([tolusha](https://github.com/tolusha))
- Fix config initialization [\#10930](https://github.com/eclipse/che/pull/10930) ([tolusha](https://github.com/tolusha))
- Fix selenium tests in factory package [\#10921](https://github.com/eclipse/che/pull/10921) ([tolusha](https://github.com/tolusha))
- Removed Eclipse Dependencies [\#10907](https://github.com/eclipse/che/pull/10907) ([tsmaeder](https://github.com/tsmaeder))
- Fix tests in org.eclipse.che.selenium.editor [\#10899](https://github.com/eclipse/che/pull/10899) ([svor](https://github.com/svor))
- New folders do not register in the jdt.ls workspace \#10115 [\#10893](https://github.com/eclipse/che/pull/10893) ([vrubezhny](https://github.com/vrubezhny))
- JDT.LS: fix selenium tests in org.eclipse.che.selenium.miscellaneous [\#10886](https://github.com/eclipse/che/pull/10886) ([vparfonov](https://github.com/vparfonov))
- Jdt.ls: fix selenium test in org.eclipse.che.selenium.dashboard.workspaces.details  [\#10882](https://github.com/eclipse/che/pull/10882) ([vparfonov](https://github.com/vparfonov))
- JDT.LS: fix selenium tests in org.eclipse.che.selenium.miscellaneous [\#10876](https://github.com/eclipse/che/pull/10876) ([vparfonov](https://github.com/vparfonov))
- Stabilize selenium test UploadIntoProjectTest [\#10871](https://github.com/eclipse/che/pull/10871) ([dmytro-ndp](https://github.com/dmytro-ndp))
- CHE-10360: Hide the 'From Archetype' field  if parent folder with pom.xml is selected [\#10718](https://github.com/eclipse/che/pull/10718) ([vinokurig](https://github.com/vinokurig))
- \[Selenium\] Update the "MachinesAsynchronousStartTest" selenium test according to the new expected behavior [\#11167](https://github.com/eclipse/che/pull/11167) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
-  Set stable version of selenium chrome-node 3.14.0-curium [\#11165](https://github.com/eclipse/che/pull/11165) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Use correct constant [\#11159](https://github.com/eclipse/che/pull/11159) ([vzhukovskii](https://github.com/vzhukovskii))
- Added authorization checks for all factory service's methods [\#11156](https://github.com/eclipse/che/pull/11156) ([sleshchenko](https://github.com/sleshchenko))
- Selenium: update NewWorkspacePageTest selenium test according to the addition of new stacks [\#11150](https://github.com/eclipse/che/pull/11150) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix 'onOpen' websocket handlers [\#11136](https://github.com/eclipse/che/pull/11136) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Apply WaitUtils.waitSuccessCondition\(\) method to HotUpdateUtil [\#11127](https://github.com/eclipse/che/pull/11127) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Remove instructions to fork test repos [\#11126](https://github.com/eclipse/che/pull/11126) ([dmytro-ndp](https://github.com/dmytro-ndp))
-  Fix selenium tests in 'git' package to increase reliability [\#11125](https://github.com/eclipse/che/pull/11125) ([artaleks9](https://github.com/artaleks9))
- \[factories\] Add support for github PR urls [\#11123](https://github.com/eclipse/che/pull/11123) ([benoitf](https://github.com/benoitf))
- Selenium: increase timeout for checking that Wizard form is closed [\#11122](https://github.com/eclipse/che/pull/11122) ([SkorikSergey](https://github.com/SkorikSergey))
- Rework plugin brokering to reuse PVC strategies code [\#11119](https://github.com/eclipse/che/pull/11119) ([garagatyi](https://github.com/garagatyi))
- Fix an ability to use locally built images of Che on minishift [\#11118](https://github.com/eclipse/che/pull/11118) ([garagatyi](https://github.com/garagatyi))
- Set JWT proxy pulling strategy to Always [\#11117](https://github.com/eclipse/che/pull/11117) ([garagatyi](https://github.com/garagatyi))
- Fix links to kubernetes deployment docs [\#11115](https://github.com/eclipse/che/pull/11115) ([garagatyi](https://github.com/garagatyi))
- Fix NPE and NumberFormatException in some cases [\#11114](https://github.com/eclipse/che/pull/11114) ([garagatyi](https://github.com/garagatyi))
- Add migration to fix signature keys inconsistency [\#11113](https://github.com/eclipse/che/pull/11113) ([mshaposhnik](https://github.com/mshaposhnik))
- Tune a list of owners for  multi-user modules [\#11108](https://github.com/eclipse/che/pull/11108) ([skabashnyuk](https://github.com/skabashnyuk))
- Add functional test for checking factory with skipFirstLevel parameter [\#11104](https://github.com/eclipse/che/pull/11104) ([musienko-maxim](https://github.com/musienko-maxim))
- \[dockerfiles\] \[theia\] \[e2e\] Cleanup videos folder on each new run [\#11103](https://github.com/eclipse/che/pull/11103) ([benoitf](https://github.com/benoitf))
- \[Selenium\] Fix unexpected fail of "WorkspaceDetailsMachineActionsTest" selenium test on docker infrastructure [\#11102](https://github.com/eclipse/che/pull/11102) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Update create new project related selenium test [\#11101](https://github.com/eclipse/che/pull/11101) ([vzhukovskii](https://github.com/vzhukovskii))
- \[ Selenium \] Fix unexpected fail of "CheckErrorsWarningsTabTest" selenium test [\#11099](https://github.com/eclipse/che/pull/11099) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Added injecting of auth related env vars into Plugin Broker Pod [\#11098](https://github.com/eclipse/che/pull/11098) ([sleshchenko](https://github.com/sleshchenko))
- Added authorization checks for BrokerService's JSON RPC methods [\#11092](https://github.com/eclipse/che/pull/11092) ([sleshchenko](https://github.com/sleshchenko))
- \[walking skeleton\] Introduce ws.next stacks [\#11088](https://github.com/eclipse/che/pull/11088) ([benoitf](https://github.com/benoitf))
- \[stack\] Use of new Theia 0.3.14 [\#11085](https://github.com/eclipse/che/pull/11085) ([benoitf](https://github.com/benoitf))
- Selenium: check workspace creation from Java Theia stacks [\#11079](https://github.com/eclipse/che/pull/11079) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-10756: Use regular user instead of root in theia image [\#11076](https://github.com/eclipse/che/pull/11076) ([mmorhun](https://github.com/mmorhun))
- \[docker images\] Switch to Theia 0.3.14 [\#11073](https://github.com/eclipse/che/pull/11073) ([benoitf](https://github.com/benoitf))
- Remove duplicated properties [\#11066](https://github.com/eclipse/che/pull/11066) ([skabashnyuk](https://github.com/skabashnyuk))
- Moved plugin broker to runtime start phase instead of context preparing [\#11061](https://github.com/eclipse/che/pull/11061) ([sleshchenko](https://github.com/sleshchenko))
- Make property with plugin registry url more javascript-friendly [\#11060](https://github.com/eclipse/che/pull/11060) ([skabashnyuk](https://github.com/skabashnyuk))
- Fixed helm deployment with default value of loggerConfig [\#11056](https://github.com/eclipse/che/pull/11056) ([skabashnyuk](https://github.com/skabashnyuk))
- Replace outdated images in configuration [\#11051](https://github.com/eclipse/che/pull/11051) ([musienko-maxim](https://github.com/musienko-maxim))
- Various changes of Eclipse Che selenium tests result handling [\#11049](https://github.com/eclipse/che/pull/11049) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Selenium: add info about known issues, fix unstable selenium tests  [\#11046](https://github.com/eclipse/che/pull/11046) ([SkorikSergey](https://github.com/SkorikSergey))
- Add icons to project explorer tree for files with ".ts", ".jsx" and ".es6" extensions [\#11043](https://github.com/eclipse/che/pull/11043) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- CHE-10808: Use master branch of Che-Theia-hosted-plugin-manager-extension [\#11039](https://github.com/eclipse/che/pull/11039) ([mmorhun](https://github.com/mmorhun))
- Prevent XSS attacks [\#11037](https://github.com/eclipse/che/pull/11037) ([vzhukovskii](https://github.com/vzhukovskii))
- Multiple changes to deploy scripts [\#11025](https://github.com/eclipse/che/pull/11025) ([eivantsov](https://github.com/eivantsov))
- Save all webdriver network logs with request URL starting from 'ws://' [\#11024](https://github.com/eclipse/che/pull/11024) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Correct the tests in the 'factory' package related to get rid from test repositories on GitHub [\#11019](https://github.com/eclipse/che/pull/11019) ([artaleks9](https://github.com/artaleks9))
- Add che.workspace.plugin\_registry\_url information to workspace/settings Rest method [\#11015](https://github.com/eclipse/che/pull/11015) ([skabashnyuk](https://github.com/skabashnyuk))
- Ocp sh improvements [\#11011](https://github.com/eclipse/che/pull/11011) ([eivantsov](https://github.com/eivantsov))
- Fix path to OCP oauth certificate [\#11010](https://github.com/eclipse/che/pull/11010) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Create new test for covering Refactoring -\>Rename feature for DotNet LS [\#11006](https://github.com/eclipse/che/pull/11006) ([musienko-maxim](https://github.com/musienko-maxim))
- Fix override and skip root behaviors [\#11002](https://github.com/eclipse/che/pull/11002) ([vparfonov](https://github.com/vparfonov))
- Log at the DEBUG level when xml document parsing is quiet [\#10997](https://github.com/eclipse/che/pull/10997) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Fixed putting Che Subject into ServerEndpointConfig if http session is null [\#10993](https://github.com/eclipse/che/pull/10993) ([sleshchenko](https://github.com/sleshchenko))
- Add  Open on GitHub feature with E2E test [\#10971](https://github.com/eclipse/che/pull/10971) ([musienko-maxim](https://github.com/musienko-maxim))
- Prevent XSS attack during render popup menu items [\#10970](https://github.com/eclipse/che/pull/10970) ([vzhukovskii](https://github.com/vzhukovskii))
- Do not set incorrect presentable text marker for pom file [\#10968](https://github.com/eclipse/che/pull/10968) ([RomanNikitenko](https://github.com/RomanNikitenko))
- \[Selenium\] Fix of unexpected fail of " RollingUpdateStrategyWithWorkspacesStartStopTest" selenium test [\#10967](https://github.com/eclipse/che/pull/10967) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Fix clone and yo in Theia image [\#10960](https://github.com/eclipse/che/pull/10960) ([eivantsov](https://github.com/eivantsov))
- Fix css styles for Firefox [\#10959](https://github.com/eclipse/che/pull/10959) ([vzhukovskii](https://github.com/vzhukovskii))
- Added ability to deploy che plugin registry with ocp.sh [\#10954](https://github.com/eclipse/che/pull/10954) ([skabashnyuk](https://github.com/skabashnyuk))
- CHE-10730: Change log level from Error to Debug when failed to parse xml file [\#10953](https://github.com/eclipse/che/pull/10953) ([vinokurig](https://github.com/vinokurig))
- Revert update to 3.10 [\#10947](https://github.com/eclipse/che/pull/10947) ([eivantsov](https://github.com/eivantsov))
- CHE-10798 Add theia-dashboard-extension into Theia Docker image [\#10942](https://github.com/eclipse/che/pull/10942) ([olexii4](https://github.com/olexii4))
- Make E2E tests screenshots available in report on CI [\#10939](https://github.com/eclipse/che/pull/10939) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Added authorization for JsonRpc methods [\#10934](https://github.com/eclipse/che/pull/10934) ([sleshchenko](https://github.com/sleshchenko))
- Selenium: fix locator for tooltips on New Workspace page, add info about \#10728 known issue [\#10925](https://github.com/eclipse/che/pull/10925) ([SkorikSergey](https://github.com/SkorikSergey))
- Added subject propagation during WebSocket methods calls [\#10922](https://github.com/eclipse/che/pull/10922) ([sleshchenko](https://github.com/sleshchenko))
- Make Che logging variables configurable via helm [\#10912](https://github.com/eclipse/che/pull/10912) ([Ido-Itz](https://github.com/Ido-Itz))
- Revert removal of CHE\_MULTIUSER variable from che-server-template.yaml [\#10911](https://github.com/eclipse/che/pull/10911) ([skabashnyuk](https://github.com/skabashnyuk))
- Selenium: Change the timeout to resolve dependencies in the 'ImportAndValidateEclipseCheProjectTest' [\#10901](https://github.com/eclipse/che/pull/10901) ([artaleks9](https://github.com/artaleks9))
- Change the method to expand the project tree in the 'SplitEditorFeatureTest' [\#10900](https://github.com/eclipse/che/pull/10900) ([artaleks9](https://github.com/artaleks9))
- Don't skip maven site plugin in selenium tests [\#10896](https://github.com/eclipse/che/pull/10896) ([dmytro-ndp](https://github.com/dmytro-ndp))
- CHE-10850: Add notification about stop workspace by idle timeout [\#10892](https://github.com/eclipse/che/pull/10892) ([vinokurig](https://github.com/vinokurig))
- Selenium: remove info about \#10809 known issue in CheckIntelligenceCommandToolbarTest test [\#10891](https://github.com/eclipse/che/pull/10891) ([SkorikSergey](https://github.com/SkorikSergey))
- Show meaningful message when we cannot authenticate user \(due to absend email or other error\) [\#10889](https://github.com/eclipse/che/pull/10889) ([mshaposhnik](https://github.com/mshaposhnik))
- Do not exit when okd dir removal fails [\#10888](https://github.com/eclipse/che/pull/10888) ([eivantsov](https://github.com/eivantsov))
- Check if okd dir exists before removing content [\#10885](https://github.com/eclipse/che/pull/10885) ([eivantsov](https://github.com/eivantsov))
- Create OKD local dir [\#10884](https://github.com/eclipse/che/pull/10884) ([eivantsov](https://github.com/eivantsov))
- Selenium: add info about known issues, fix unstable selenium tests [\#10877](https://github.com/eclipse/che/pull/10877) ([SkorikSergey](https://github.com/SkorikSergey))
- RELEASE: Update CHANGELOG [\#10873](https://github.com/eclipse/che/pull/10873) ([riuvshin](https://github.com/riuvshin))
- Update selenium chrome-node to 3.14.0 [\#10869](https://github.com/eclipse/che/pull/10869) ([dmytro-ndp](https://github.com/dmytro-ndp))
- RELEASE: Set next development version [\#10867](https://github.com/eclipse/che/pull/10867) ([riuvshin](https://github.com/riuvshin))
- Remove unnecessary Services class from all dependent tests for increasing stability [\#10858](https://github.com/eclipse/che/pull/10858) ([musienko-maxim](https://github.com/musienko-maxim))
- CHE-9709: fix ability to create a factory from a Git URL [\#10843](https://github.com/eclipse/che/pull/10843) ([akurinnoy](https://github.com/akurinnoy))
- Fixed skipFirstLevel project parameter for factories [\#10837](https://github.com/eclipse/che/pull/10837) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Fix Che server protocol deserialization in k8s/OS infras [\#10831](https://github.com/eclipse/che/pull/10831) ([garagatyi](https://github.com/garagatyi))
- Fix the link to docs. [\#10830](https://github.com/eclipse/che/pull/10830) ([monaka](https://github.com/monaka))
- Selenium: fix locator for hover popup [\#10826](https://github.com/eclipse/che/pull/10826) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-10775 Upgrade lodash to version 4.17.10 [\#10783](https://github.com/eclipse/che/pull/10783) ([olexii4](https://github.com/olexii4))
- Multiple changes to deploy scripts [\#10766](https://github.com/eclipse/che/pull/10766) ([eivantsov](https://github.com/eivantsov))
- Move WS.NEXT flow to k8s infra implementation, rework it to use plugin broker [\#10740](https://github.com/eclipse/che/pull/10740) ([garagatyi](https://github.com/garagatyi))
- Selenium: Cover "Dashboard / Workspace Details / Machines" part of test plan by selenium test [\#10739](https://github.com/eclipse/che/pull/10739) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- \[dockerfiles\] \[theia\] Add e2e tests for the che/theia image [\#10714](https://github.com/eclipse/che/pull/10714) ([benoitf](https://github.com/benoitf))
- Rework GitStatusProvider to use cached status storage [\#10690](https://github.com/eclipse/che/pull/10690) ([vinokurig](https://github.com/vinokurig))
- Make Resource memory request configurable for k8s and OpenShift [\#10673](https://github.com/eclipse/che/pull/10673) ([i300543](https://github.com/i300543))
- Selenium: Add method to the "WaitUtils" class for waiting specified condition happens without using of "WebDriverWait" [\#10576](https://github.com/eclipse/che/pull/10576) ([Ohrimenko1988](https://github.com/Ohrimenko1988))


## [6.10.0](https://github.com/eclipse/che/tree/6.10.0) (2018-08-21)
[Full Changelog](https://github.com/eclipse/che/compare/6.9.0...6.10.0)

**Merged pull requests:**

- Fix PreviewRefactoringTest test [\#10847](https://github.com/eclipse/che/pull/10847) ([svor](https://github.com/svor))
- Get rid of redundant dependency [\#10835](https://github.com/eclipse/che/pull/10835) ([tolusha](https://github.com/tolusha))
- Adapt tests to correct observed behaviour [\#10824](https://github.com/eclipse/che/pull/10824) ([tsmaeder](https://github.com/tsmaeder))
- Fix resource leak in ZipUtils [\#10815](https://github.com/eclipse/che/pull/10815) ([tsmaeder](https://github.com/tsmaeder))
- Fix parent path handling when importing test projects [\#10785](https://github.com/eclipse/che/pull/10785) ([tsmaeder](https://github.com/tsmaeder))
- Update copyright in test to epl 2.0 [\#10773](https://github.com/eclipse/che/pull/10773) ([tsmaeder](https://github.com/tsmaeder))
- Don't write files to test codebase [\#10765](https://github.com/eclipse/che/pull/10765) ([tsmaeder](https://github.com/tsmaeder))
- Update values.yaml [\#10706](https://github.com/eclipse/che/pull/10706) ([riuvshin](https://github.com/riuvshin))
- Update maven module if parent was changed [\#10689](https://github.com/eclipse/che/pull/10689) ([svor](https://github.com/svor))
- Update project config when event is fired [\#10677](https://github.com/eclipse/che/pull/10677) ([tolusha](https://github.com/tolusha))
- New folders do not register in the jdt.ls workspace \#10115 [\#10665](https://github.com/eclipse/che/pull/10665) ([vrubezhny](https://github.com/vrubezhny))
- Fixup for 10499 handle markdown [\#10655](https://github.com/eclipse/che/pull/10655) ([tsmaeder](https://github.com/tsmaeder))
- Handle markdown in LSP doc popups [\#10645](https://github.com/eclipse/che/pull/10645) ([tsmaeder](https://github.com/tsmaeder))
- Update resource of the generated effective pom [\#10635](https://github.com/eclipse/che/pull/10635) ([svor](https://github.com/svor))
- CHE-LIB-57: Update xterm.js to the version 3.3.0 [\#10037](https://github.com/eclipse/che/pull/10037) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Stabilize selenium test UploadIntoProjectTest [\#10871](https://github.com/eclipse/che/pull/10871) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Adapt NewWorkspacePageTest to run against Eclipse Che on K8S [\#10859](https://github.com/eclipse/che/pull/10859) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Fix license headers of loader.css and loader.js [\#10856](https://github.com/eclipse/che/pull/10856) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Selenium: remove info about known issues, fix unstable tests [\#10851](https://github.com/eclipse/che/pull/10851) ([SkorikSergey](https://github.com/SkorikSergey))
- Make WorkingWithTerminalTest not to depend on command prompt in terminal [\#10846](https://github.com/eclipse/che/pull/10846) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Filter test configuration methods which belong to improper groups [\#10845](https://github.com/eclipse/che/pull/10845) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Use che-plugin-registry instead of marketplace placeholder for Walking skeleton flow [\#10832](https://github.com/eclipse/che/pull/10832) ([garagatyi](https://github.com/garagatyi))
- CHE-10827 Add patch to the target centos image [\#10828](https://github.com/eclipse/che/pull/10828) ([olexii4](https://github.com/olexii4))
- CHE-10769: improve loader.html page [\#10820](https://github.com/eclipse/che/pull/10820) ([akurinnoy](https://github.com/akurinnoy))
- Make clickable the whole workspace item row in workspaces list of an organization [\#10814](https://github.com/eclipse/che/pull/10814) ([akurinnoy](https://github.com/akurinnoy))
- Selenium: add info about known issue \#10809 to CheckIntelligenceCommandFromToolbarTest selenium test [\#10811](https://github.com/eclipse/che/pull/10811) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: add info about known issue \#9100 to CheckFactoryWithPerClickCreatePolicyTest and CheckFactoryWithMultiModuleTest tests [\#10804](https://github.com/eclipse/che/pull/10804) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix redirect URIs and webOrigins [\#10802](https://github.com/eclipse/che/pull/10802) ([eivantsov](https://github.com/eivantsov))
- CHE\_INFRASTRUCTURE and CHE\_MULTIUSER vars can be now passed as system [\#10801](https://github.com/eclipse/che/pull/10801) ([rhopp](https://github.com/rhopp))
- Add 500 error to the rest framework for go agents [\#10799](https://github.com/eclipse/che/pull/10799) ([garagatyi](https://github.com/garagatyi))
- Fix formatting of CSharpFileEditingTest [\#10797](https://github.com/eclipse/che/pull/10797) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Fix selenium test groups management [\#10791](https://github.com/eclipse/che/pull/10791) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Add info about known issue \#10789 to CSharpFileEditingTest [\#10790](https://github.com/eclipse/che/pull/10790) ([musienko-maxim](https://github.com/musienko-maxim))
- Remove test language server [\#10788](https://github.com/eclipse/che/pull/10788) ([vparfonov](https://github.com/vparfonov))
- Fix name of 'Java Theia\(openshift\)' stack [\#10787](https://github.com/eclipse/che/pull/10787) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: fix unstable selenium tests from dashboard and miscellaneous packages [\#10786](https://github.com/eclipse/che/pull/10786) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-10121: fix behavior of the factory's "Create" button [\#10778](https://github.com/eclipse/che/pull/10778) ([akurinnoy](https://github.com/akurinnoy))
- \[Selenium\] Fix expected number of process counter in CheckIntelligenceCommandFromToolbarTest selenium test [\#10777](https://github.com/eclipse/che/pull/10777) ([SkorikSergey](https://github.com/SkorikSergey))
- Change steps in the CSharpFileEditingTest according to new behavior for init the LS [\#10771](https://github.com/eclipse/che/pull/10771) ([musienko-maxim](https://github.com/musienko-maxim))
- Added an ability to configure whether machine server authentication via cookies is enabled [\#10763](https://github.com/eclipse/che/pull/10763) ([sleshchenko](https://github.com/sleshchenko))
- Make machine token signing key per-workspace  [\#10761](https://github.com/eclipse/che/pull/10761) ([mshaposhnik](https://github.com/mshaposhnik))
- CHE-5650: set fixed sorting order for prioritized stacks [\#10760](https://github.com/eclipse/che/pull/10760) ([akurinnoy](https://github.com/akurinnoy))
-  Add utility method to remove test github repos with certain prefix [\#10752](https://github.com/eclipse/che/pull/10752) ([dmytro-ndp](https://github.com/dmytro-ndp))
- CHE-9148: fix workspace item in organization's workspaces list [\#10750](https://github.com/eclipse/che/pull/10750) ([akurinnoy](https://github.com/akurinnoy))
- fix k8s deployment fail [\#10747](https://github.com/eclipse/che/pull/10747) ([musienko-maxim](https://github.com/musienko-maxim))
- Fix remaining files with licenses [\#10746](https://github.com/eclipse/che/pull/10746) ([mkuznyetsov](https://github.com/mkuznyetsov))
-  Remove test github repo created by PullRequestPluginWithForkTest [\#10741](https://github.com/eclipse/che/pull/10741) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Added an ability to configure JwtProxy container and memory limit for it [\#10737](https://github.com/eclipse/che/pull/10737) ([sleshchenko](https://github.com/sleshchenko))
- Change steps for increasing stability tests [\#10736](https://github.com/eclipse/che/pull/10736) ([musienko-maxim](https://github.com/musienko-maxim))
- CHE-10687: fix log message, add check for runtime in running workspace [\#10734](https://github.com/eclipse/che/pull/10734) ([akurinnoy](https://github.com/akurinnoy))
- Selenium: Fix of unexpected fail of "OpenExternalLibraryFileAfterRefreshTest" selenium test [\#10727](https://github.com/eclipse/che/pull/10727) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: Add catching of known \#10713 issue to 'CheckIntelligenceCommandFromToolbarTest' selenium test [\#10722](https://github.com/eclipse/che/pull/10722) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Added attributes field to workspace config object [\#10721](https://github.com/eclipse/che/pull/10721) ([sleshchenko](https://github.com/sleshchenko))
- Render context menu correctly in different screen resolutions [\#10719](https://github.com/eclipse/che/pull/10719) ([vzhukovskii](https://github.com/vzhukovskii))
- CHE-10360: Hide the 'From Archetype' field  if parent folder with pom.xml is selected [\#10718](https://github.com/eclipse/che/pull/10718) ([vinokurig](https://github.com/vinokurig))
- Selenium: fix unstable selenium tests from dashboard and miscellaneous packages [\#10717](https://github.com/eclipse/che/pull/10717) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-10544: prevent Dashboard to become broken after deleting a workspace [\#10716](https://github.com/eclipse/che/pull/10716) ([akurinnoy](https://github.com/akurinnoy))
- Fix unrecoverable events functionality after move to deployments [\#10709](https://github.com/eclipse/che/pull/10709) ([amisevsk](https://github.com/amisevsk))
- Move organization management selenium tests into the CheOneThreadTest.xml [\#10707](https://github.com/eclipse/che/pull/10707) ([dmytro-ndp](https://github.com/dmytro-ndp))
- allow to set che ws agent inacive timeout in helm [\#10705](https://github.com/eclipse/che/pull/10705) ([riuvshin](https://github.com/riuvshin))
- \[docker file\] \[theia\] Use of centos instead of Alpine as base image [\#10697](https://github.com/eclipse/che/pull/10697) ([benoitf](https://github.com/benoitf))
- Fix build after applying new formatter [\#10695](https://github.com/eclipse/che/pull/10695) ([tolusha](https://github.com/tolusha))
- CHE-10656: persist 'yarn.lock' with fixed dependency versions [\#10694](https://github.com/eclipse/che/pull/10694) ([akurinnoy](https://github.com/akurinnoy))
- Selenium: Cover "Dashboard / Workspace Details / Projects" part of test plan by selenium test [\#10691](https://github.com/eclipse/che/pull/10691) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- CHE-10540: stop progress on websocket error [\#10688](https://github.com/eclipse/che/pull/10688) ([akurinnoy](https://github.com/akurinnoy))
- Selenium: Increase stability of the "AddOrImportProjectFormTest" selenium test  [\#10686](https://github.com/eclipse/che/pull/10686) ([SkorikSergey](https://github.com/SkorikSergey))
- Make possible to configure some jwtproxy values via properties [\#10685](https://github.com/eclipse/che/pull/10685) ([mshaposhnik](https://github.com/mshaposhnik))
- Do not expose workspace runtime for user if he does not have `use` permission [\#10684](https://github.com/eclipse/che/pull/10684) ([sleshchenko](https://github.com/sleshchenko))
- Selenium: Increase stability of the "WorkspacesListTest" selenium test [\#10681](https://github.com/eclipse/che/pull/10681) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Added an ability to remove user when third-party user management service is configured [\#10676](https://github.com/eclipse/che/pull/10676) ([sleshchenko](https://github.com/sleshchenko))
- remove codenvy snapshots repo from che [\#10675](https://github.com/eclipse/che/pull/10675) ([riuvshin](https://github.com/riuvshin))
- New test case for rolling update [\#10670](https://github.com/eclipse/che/pull/10670) ([Katka92](https://github.com/Katka92))
- Update fmt plugin to latest to enable skipping check \#10554 [\#10667](https://github.com/eclipse/che/pull/10667) ([vrubezhny](https://github.com/vrubezhny))
- Selenium: Cover "Dashboard / Workspace Details / Overview" part of test plan by selenium test [\#10661](https://github.com/eclipse/che/pull/10661) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: adapt template project file after updating licenses headers [\#10658](https://github.com/eclipse/che/pull/10658) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-10538: improves workspace loader [\#10642](https://github.com/eclipse/che/pull/10642) ([akurinnoy](https://github.com/akurinnoy))
- Add ability to get File Type by provider and avoid File Type collision [\#10640](https://github.com/eclipse/che/pull/10640) ([RomanNikitenko](https://github.com/RomanNikitenko))
- move to central [\#10639](https://github.com/eclipse/che/pull/10639) ([riuvshin](https://github.com/riuvshin))
- Rewrite JWTProxyConfigBuilder to use model objects to create config YAML [\#10633](https://github.com/eclipse/che/pull/10633) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Fixing of letters cut-off in left menu. [\#10632](https://github.com/eclipse/che/pull/10632) ([Katka92](https://github.com/Katka92))
- Selenium: cover Golang language server functionality by selenium test  [\#10625](https://github.com/eclipse/che/pull/10625) ([SkorikSergey](https://github.com/SkorikSergey))
- Loader fix [\#10619](https://github.com/eclipse/che/pull/10619) ([mshaposhnik](https://github.com/mshaposhnik))
- CHE-9937 Fix Composer project type [\#10606](https://github.com/eclipse/che/pull/10606) ([vinokurig](https://github.com/vinokurig))
- RELEASE: Set next development version [\#10603](https://github.com/eclipse/che/pull/10603) ([riuvshin](https://github.com/riuvshin))
- Fix sequential start of workspace machines [\#10545](https://github.com/eclipse/che/pull/10545) ([amisevsk](https://github.com/amisevsk))
- Simplify OpenShift/Kubernetes admin configuration [\#10529](https://github.com/eclipse/che/pull/10529) ([amisevsk](https://github.com/amisevsk))
- Make host calculation more short and concise for che master [\#10509](https://github.com/eclipse/che/pull/10509) ([i300543](https://github.com/i300543))

## [6.9.0](https://github.com/eclipse/che/tree/6.9.0) (2018-08-02)
[Full Changelog](https://github.com/eclipse/che/compare/6.8.0...6.9.0)

**Merged pull requests:**

- Fix for checking Java Compiler settings in selenium test [\#10623](https://github.com/eclipse/che/pull/10623) ([svor](https://github.com/svor))
- Fix build errors after rebase [\#10608](https://github.com/eclipse/che/pull/10608) ([vrubezhny](https://github.com/vrubezhny))
- Removed jdt [\#10587](https://github.com/eclipse/che/pull/10587) ([tsmaeder](https://github.com/tsmaeder))
- Fix workspace-loader application build [\#10578](https://github.com/eclipse/che/pull/10578) ([tolusha](https://github.com/tolusha))
- Added page which set up authentication cookie via jwtproxy [\#10482](https://github.com/eclipse/che/pull/10482) ([akurinnoy](https://github.com/akurinnoy))
- Add Bearer token prefix for project service requests [\#10477](https://github.com/eclipse/che/pull/10477) ([mshaposhnik](https://github.com/mshaposhnik))
- Check events after applying refactoring's changes [\#10472](https://github.com/eclipse/che/pull/10472) ([svor](https://github.com/svor))
- Fix selenium tests in editor package [\#10471](https://github.com/eclipse/che/pull/10471) ([tolusha](https://github.com/tolusha))
- Fixup for testing Java Compiler settings [\#10458](https://github.com/eclipse/che/pull/10458) ([svor](https://github.com/svor))
- Fix selenium tests in projectexplorer package [\#10452](https://github.com/eclipse/che/pull/10452) ([tolusha](https://github.com/tolusha))
- Fixup for testing Organize imports operation [\#10446](https://github.com/eclipse/che/pull/10446) ([svor](https://github.com/svor))
- Consume markup and snippets in completion doc [\#10436](https://github.com/eclipse/che/pull/10436) ([tsmaeder](https://github.com/tsmaeder))
- Small fixups for git package [\#10432](https://github.com/eclipse/che/pull/10432) ([tolusha](https://github.com/tolusha))
- Check result of code assist after move operation [\#10428](https://github.com/eclipse/che/pull/10428) ([svor](https://github.com/svor))
- Update set of existing key-bindings [\#10426](https://github.com/eclipse/che/pull/10426) ([svor](https://github.com/svor))
- Fix selenium tests [\#10418](https://github.com/eclipse/che/pull/10418) ([tolusha](https://github.com/tolusha))
- 10413 address lsp doc popup [\#10414](https://github.com/eclipse/che/pull/10414) ([tsmaeder](https://github.com/tsmaeder))
- Announce code assist snippet support [\#10411](https://github.com/eclipse/che/pull/10411) ([tsmaeder](https://github.com/tsmaeder))
- Check when ws-edit changes were applied [\#10397](https://github.com/eclipse/che/pull/10397) ([svor](https://github.com/svor))
- Make sure dot-files don't exist before creating them. [\#10389](https://github.com/eclipse/che/pull/10389) ([tsmaeder](https://github.com/tsmaeder))
- Send and handle ProjectCreatedEvent [\#10363](https://github.com/eclipse/che/pull/10363) ([tsmaeder](https://github.com/tsmaeder))
- Fix Simple Java Project Creation [\#10339](https://github.com/eclipse/che/pull/10339) ([tsmaeder](https://github.com/tsmaeder))
- Removal of rename and move refactorings [\#10323](https://github.com/eclipse/che/pull/10323) ([JPinkney](https://github.com/JPinkney))
- Fix license header text [\#10629](https://github.com/eclipse/che/pull/10629) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Selenium: Fix selenium tests after updating licenses headers [\#10627](https://github.com/eclipse/che/pull/10627) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Set Che QE team members as owners of selenium tests sub-project [\#10622](https://github.com/eclipse/che/pull/10622) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Fix java debugger integration tests [\#10616](https://github.com/eclipse/che/pull/10616) ([tolusha](https://github.com/tolusha))
- \[stack\] Update theia image to latest one [\#10614](https://github.com/eclipse/che/pull/10614) ([benoitf](https://github.com/benoitf))
- Fix remaining notes about old EPL 1.0 license [\#10607](https://github.com/eclipse/che/pull/10607) ([mkuznyetsov](https://github.com/mkuznyetsov))
- fix format [\#10605](https://github.com/eclipse/che/pull/10605) ([riuvshin](https://github.com/riuvshin))
- fix license headers [\#10604](https://github.com/eclipse/che/pull/10604) ([riuvshin](https://github.com/riuvshin))
- Selenium: Update license header in 'MachinesAsynchronousStartTest' selenium test [\#10598](https://github.com/eclipse/che/pull/10598) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: fix logical mistake in the "MachinesAsynchronousStartTest" and add known issue \#10295 catching [\#10596](https://github.com/eclipse/che/pull/10596) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Change debug level from info to debug [\#10580](https://github.com/eclipse/che/pull/10580) ([vzhukovskii](https://github.com/vzhukovskii))
- Added page which set up authentication cookie via jwtproxy [\#10575](https://github.com/eclipse/che/pull/10575) ([akurinnoy](https://github.com/akurinnoy))
- Fix workspace-loader application build [\#10572](https://github.com/eclipse/che/pull/10572) ([akurinnoy](https://github.com/akurinnoy))
- Don't register application id on ws agent [\#10570](https://github.com/eclipse/che/pull/10570) ([vzhukovskii](https://github.com/vzhukovskii))
- Selenium: Create "SeleniumWebDriverHelper\#waitCondition\(ExpectedCondition\<Boolean\> expectedCondition\)" method for selenium tests [\#10564](https://github.com/eclipse/che/pull/10564) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: Create test 'ImportAndValidateEclipseCheProjectTest' [\#10558](https://github.com/eclipse/che/pull/10558) ([artaleks9](https://github.com/artaleks9))
- Selenium: Fix logical mistakes in the "SeleniumWebDriverHelper" class methods [\#10556](https://github.com/eclipse/che/pull/10556) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- \[ Theia Docker image\] Updates [\#10552](https://github.com/eclipse/che/pull/10552) ([benoitf](https://github.com/benoitf))
- che \#10444: Fixing NumberFormatException occurences during the 'watchEvents' calls on k8s infrastructure [\#10546](https://github.com/eclipse/che/pull/10546) ([ibuziuk](https://github.com/ibuziuk))
- Selenium: Cover use cases of "Kubernetes/OpenShift machines are started sequentially" issue by selenium tests  [\#10541](https://github.com/eclipse/che/pull/10541) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Set vcs status marker only for resource related editor tabs [\#10534](https://github.com/eclipse/che/pull/10534) ([RomanNikitenko](https://github.com/RomanNikitenko))
- CHE-10365: Add websocket reconnection feature to workspace loader app [\#10533](https://github.com/eclipse/che/pull/10533) ([akurinnoy](https://github.com/akurinnoy))
- Update license to EPL 2.0 [\#10531](https://github.com/eclipse/che/pull/10531) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Add service discovery of ChePluginEndpoint of sidecar tooling container on k8s/OS infras [\#10528](https://github.com/eclipse/che/pull/10528) ([garagatyi](https://github.com/garagatyi))
- Fix exceptions at opening an editor that does not correspond to an existing resource [\#10527](https://github.com/eclipse/che/pull/10527) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Add the re-selection of the project in the test 'AmendCommitTest' [\#10526](https://github.com/eclipse/che/pull/10526) ([artaleks9](https://github.com/artaleks9))
- Selenium: cover Yaml language server functionality by selenium test [\#10525](https://github.com/eclipse/che/pull/10525) ([SkorikSergey](https://github.com/SkorikSergey))
- Add a missing file required to correctly bootstrap Ceylon user projects [\#10517](https://github.com/eclipse/che/pull/10517) ([davidfestal](https://github.com/davidfestal))
- Fix start of a workspace with Theia on k8s infra [\#10513](https://github.com/eclipse/che/pull/10513) ([garagatyi](https://github.com/garagatyi))
- Parse THEIA\_PORT environment variable [\#10511](https://github.com/eclipse/che/pull/10511) ([garagatyi](https://github.com/garagatyi))
- Add debug Id for content assistant widgets [\#10506](https://github.com/eclipse/che/pull/10506) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Add notifier about low disk space [\#10503](https://github.com/eclipse/che/pull/10503) ([vzhukovskii](https://github.com/vzhukovskii))
- Selenium: adapt selenium tests that work with Theia stack [\#10498](https://github.com/eclipse/che/pull/10498) ([SkorikSergey](https://github.com/SkorikSergey))
- Improve java debug performance to fetch list of threads/frames/variables [\#10492](https://github.com/eclipse/che/pull/10492) ([tolusha](https://github.com/tolusha))
- Selenium: check workspace action buttons on Workspaces list page [\#10485](https://github.com/eclipse/che/pull/10485) ([SkorikSergey](https://github.com/SkorikSergey))
- \[docker\] \[theia\] Enable the theia plug-in generator in theia image [\#10483](https://github.com/eclipse/che/pull/10483) ([benoitf](https://github.com/benoitf))
- allow to not define GITHUB\_TOKEN to build.sh if api rate limit on github is enough [\#10478](https://github.com/eclipse/che/pull/10478) ([benoitf](https://github.com/benoitf))
- Selenium:  Finish creating the test methods in the 'UploadIntoProjectTest' [\#10475](https://github.com/eclipse/che/pull/10475) ([artaleks9](https://github.com/artaleks9))
- Selenium: adapt selenium tests according to changes in the flow for adding a new stack [\#10468](https://github.com/eclipse/che/pull/10468) ([SkorikSergey](https://github.com/SkorikSergey))
- Simplify the theia stack from 2 machines to 1 with Theia only [\#10467](https://github.com/eclipse/che/pull/10467) ([ashumilova](https://github.com/ashumilova))
- Add exclusions mechanism into jwtproxy config builder & exlude liveness probes from auth [\#10463](https://github.com/eclipse/che/pull/10463) ([mshaposhnik](https://github.com/mshaposhnik))
- Add CheEditor object to the Workspace Next model [\#10457](https://github.com/eclipse/che/pull/10457) ([garagatyi](https://github.com/garagatyi))
- Selenium: Increase stability of the "CheckIntelligenceCommandFromToolbarTest" selenium test [\#10453](https://github.com/eclipse/che/pull/10453) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: remove selenium tests from OSIO test group [\#10450](https://github.com/eclipse/che/pull/10450) ([SkorikSergey](https://github.com/SkorikSergey))
- Added more information in error output [\#10443](https://github.com/eclipse/che/pull/10443) ([skabashnyuk](https://github.com/skabashnyuk))
- CHE-10286: Switch import rest methods to Json-rpc [\#10440](https://github.com/eclipse/che/pull/10440) ([vinokurig](https://github.com/vinokurig))
- Selenium: Fix unexpected fail of "che-multiuser-master-ocp-oauth-test" and "che-multiuser-master-ocp-recreate-strategy-test" jobs  [\#10438](https://github.com/eclipse/che/pull/10438) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: cover JSON language server functionality by selenium test [\#10434](https://github.com/eclipse/che/pull/10434) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: fix 'run' command in 'CentOS WildFly Swarm' predefined stack [\#10433](https://github.com/eclipse/che/pull/10433) ([SkorikSergey](https://github.com/SkorikSergey))
- Open folder in terminal [\#10422](https://github.com/eclipse/che/pull/10422) ([vparfonov](https://github.com/vparfonov))
- Update regex for initializing C\# language server [\#10421](https://github.com/eclipse/che/pull/10421) ([azatsarynnyy](https://github.com/azatsarynnyy))
- Fixed binding of jwt proxy secure servers for Che on K8s/OS [\#10407](https://github.com/eclipse/che/pull/10407) ([sleshchenko](https://github.com/sleshchenko))
- Restore the dependencies on creating a C\# project [\#10405](https://github.com/eclipse/che/pull/10405) ([azatsarynnyy](https://github.com/azatsarynnyy))
- Selenium: Update priorities of the test methods in the 'ImportWizardFormTest' [\#10401](https://github.com/eclipse/che/pull/10401) ([artaleks9](https://github.com/artaleks9))
- Selenium: Fix unexpected fail of "MacrosCommandsEditorTest" selenium test [\#10394](https://github.com/eclipse/che/pull/10394) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- CHE-10335: update the flow for adding a new stack [\#10393](https://github.com/eclipse/che/pull/10393) ([akurinnoy](https://github.com/akurinnoy))
- clean up k8s config map [\#10391](https://github.com/eclipse/che/pull/10391) ([riuvshin](https://github.com/riuvshin))
- Add Proxy env variables for workspace containers in Openshift and Kub… [\#10387](https://github.com/eclipse/che/pull/10387) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Validate infrastructure related configuration only on start workspace [\#10385](https://github.com/eclipse/che/pull/10385) ([gazarenkov](https://github.com/gazarenkov))
- Add K8S infrastructure for selenium tests  [\#10384](https://github.com/eclipse/che/pull/10384) ([musienko-maxim](https://github.com/musienko-maxim))
- Delete the 'try/catch' from the 'ContributeTabTest' according to resolving issues \#9959  \#10019 [\#10383](https://github.com/eclipse/che/pull/10383) ([artaleks9](https://github.com/artaleks9))
- Selenum: fix 'start apache' command in CreateWorkspaceFromPHPStackTest selenium test [\#10382](https://github.com/eclipse/che/pull/10382) ([SkorikSergey](https://github.com/SkorikSergey))
- Update regex for c-based file extensions [\#10379](https://github.com/eclipse/che/pull/10379) ([vzhukovskii](https://github.com/vzhukovskii))
- Fix sequence of selenium test package execution [\#10377](https://github.com/eclipse/che/pull/10377) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Selenium: cover Apache Camel language server functionality by selenium test [\#10376](https://github.com/eclipse/che/pull/10376) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-10097, CHE-10098, CHE-256: fix bugs related to installers on Stack Details page [\#10367](https://github.com/eclipse/che/pull/10367) ([akurinnoy](https://github.com/akurinnoy))
- set default k8s namespace to che [\#10366](https://github.com/eclipse/che/pull/10366) ([riuvshin](https://github.com/riuvshin))
- Selenium: Create selenium test for covering issue \#9620 "In case ws-agent stopped unexpectedly all editors should become in readonly mode or close them" [\#10354](https://github.com/eclipse/che/pull/10354) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: Update the 'CreateFactoryTest' according to the test plan [\#10353](https://github.com/eclipse/che/pull/10353) ([artaleks9](https://github.com/artaleks9))
- RELEASE: Set next development version [\#10345](https://github.com/eclipse/che/pull/10345) ([riuvshin](https://github.com/riuvshin))
- Added go test and go build [\#10328](https://github.com/eclipse/che/pull/10328) ([InnovativeInventor](https://github.com/InnovativeInventor))
- "Minor typographical improvements to localization file" by zv-io   [\#10317](https://github.com/eclipse/che/pull/10317) ([vparfonov](https://github.com/vparfonov))
- Selenium: cover workspace creation from Ubuntu stacks by selenium tests [\#10271](https://github.com/eclipse/che/pull/10271) ([SkorikSergey](https://github.com/SkorikSergey))
- Different Quickfix Behaviour Java vs. LSP \#10112 [\#10268](https://github.com/eclipse/che/pull/10268) ([vrubezhny](https://github.com/vrubezhny))
- Added an ability to authenticate requests to servers with jwtproxy [\#10252](https://github.com/eclipse/che/pull/10252) ([sleshchenko](https://github.com/sleshchenko))
- Generate yarn cache with THEIA\_VERSION. Generate resolutions to use strict Theia dependencies [\#10164](https://github.com/eclipse/che/pull/10164) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))

## [6.8.0](https://github.com/eclipse/che/tree/6.8.0) (2018-07-10)
[Full Changelog](https://github.com/eclipse/che/compare/6.7.1...6.8.0)

**Merged pull requests:**

- Fix multimodule pom, test. [\#10364](https://github.com/eclipse/che/pull/10364) ([tsmaeder](https://github.com/tsmaeder))
- Clean cached classpath on error [\#10362](https://github.com/eclipse/che/pull/10362) ([tsmaeder](https://github.com/tsmaeder))
- Fix version of jdtls runner [\#10235](https://github.com/eclipse/che/pull/10235) ([vrubezhny](https://github.com/vrubezhny))
- Removal of jdt.ui [\#10234](https://github.com/eclipse/che/pull/10234) ([JPinkney](https://github.com/JPinkney))
- Consume Progress and Status DTO's from  [\#10224](https://github.com/eclipse/che/pull/10224) ([tsmaeder](https://github.com/tsmaeder))
- Adapt selenium tests relaited to java refactoring [\#10221](https://github.com/eclipse/che/pull/10221) ([svor](https://github.com/svor))
- Update Keycloak to 3.4.3.Final version [\#10165](https://github.com/eclipse/che/pull/10165) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Custom socket provider and java language server in sidecar [\#9616](https://github.com/eclipse/che/pull/9616) ([JPinkney](https://github.com/JPinkney))
- Selenium: fix testing code assistant feature in PhpFileEditingTest selenium test [\#10344](https://github.com/eclipse/che/pull/10344) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: increase timeout for IDE availability in ImportProjectFromGitHubTest selenium test [\#10336](https://github.com/eclipse/che/pull/10336) ([SkorikSergey](https://github.com/SkorikSergey))
- Add selenium tests to cover the 'Upload Folder/File' feature with default options [\#10332](https://github.com/eclipse/che/pull/10332) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Selenium: Implement usecase which covers opening a file from libraries after refreshing [\#10320](https://github.com/eclipse/che/pull/10320) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Fixed error logging for Go LS when going to definition [\#10315](https://github.com/eclipse/che/pull/10315) ([dkuleshov](https://github.com/dkuleshov))
- Tune a list of owners for infrastructure and multi-user modules [\#10310](https://github.com/eclipse/che/pull/10310) ([skabashnyuk](https://github.com/skabashnyuk))
- Selenium: Remove catching of known issue \#8122 [\#10304](https://github.com/eclipse/che/pull/10304) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Added an ability to specify custom ocp tools dir  [\#10302](https://github.com/eclipse/che/pull/10302) ([sleshchenko](https://github.com/sleshchenko))
- Refine code ownership  [\#10301](https://github.com/eclipse/che/pull/10301) ([gazarenkov](https://github.com/gazarenkov))
- Selenium: Fix unexpected fail of "NewWorkspacePageTest" selenium test  [\#10297](https://github.com/eclipse/che/pull/10297) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Make initial pvc claim configurable [\#10294](https://github.com/eclipse/che/pull/10294) ([eivantsov](https://github.com/eivantsov))
- Fixed offset and range calculation for full text and range formatting. [\#10293](https://github.com/eclipse/che/pull/10293) ([dkuleshov](https://github.com/dkuleshov))
- Selenium: fix locators for Keycloak Federated Identities page [\#10289](https://github.com/eclipse/che/pull/10289) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix failing test & check formatting [\#10279](https://github.com/eclipse/che/pull/10279) ([mshaposhnik](https://github.com/mshaposhnik))
- Selenium: Fix reason of failing the "RollingUpdateStrategyWithEditorTest" selenium test [\#10269](https://github.com/eclipse/che/pull/10269) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Fix namespace for deployment under OCP user account [\#10267](https://github.com/eclipse/che/pull/10267) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Refactored external servers exposition in K8s/OS infrastructures [\#10266](https://github.com/eclipse/che/pull/10266) ([sleshchenko](https://github.com/sleshchenko))
- Change the loading flow by always wait the runtime before open IDE [\#10263](https://github.com/eclipse/che/pull/10263) ([ashumilova](https://github.com/ashumilova))
- Selenium: cover workspace creation from CentOS stacks by selenium tests [\#10255](https://github.com/eclipse/che/pull/10255) ([SkorikSergey](https://github.com/SkorikSergey))
- Fixed maven build without test sources compiling [\#10254](https://github.com/eclipse/che/pull/10254) ([sleshchenko](https://github.com/sleshchenko))
- Disables format action in menu when formatting is not supported [\#10253](https://github.com/eclipse/che/pull/10253) ([dkuleshov](https://github.com/dkuleshov))
- Fix machine auth by using own user token instead of workspace owner token. [\#10249](https://github.com/eclipse/che/pull/10249) ([mshaposhnik](https://github.com/mshaposhnik))
- Adjust Workspace.Next model classes to latest updates in the Workspace.Next vision [\#10246](https://github.com/eclipse/che/pull/10246) ([garagatyi](https://github.com/garagatyi))
- Added doc for CHE\_LOGGER\_CONFIG in che.env file [\#10245](https://github.com/eclipse/che/pull/10245) ([sleshchenko](https://github.com/sleshchenko))
- Added cascade removing of Kubernetes runtime state when a workspace is removed [\#10244](https://github.com/eclipse/che/pull/10244) ([sleshchenko](https://github.com/sleshchenko))
- Fix logic error in CSharpFileEditingTest [\#10239](https://github.com/eclipse/che/pull/10239) ([musienko-maxim](https://github.com/musienko-maxim))
- CHE-10215 fix factory templates [\#10238](https://github.com/eclipse/che/pull/10238) ([olexii4](https://github.com/olexii4))
- Make it possible for Go agents to use auth tokens from HTTP header [\#10237](https://github.com/eclipse/che/pull/10237) ([mshaposhnik](https://github.com/mshaposhnik))
- Optimizing che-theia-factory loading sequence by adding it to the def… [\#10233](https://github.com/eclipse/che/pull/10233) ([sunix](https://github.com/sunix))
- \#10229 Publish all workspace pod events to the machine logs [\#10228](https://github.com/eclipse/che/pull/10228) ([ibuziuk](https://github.com/ibuziuk))
- Selenium: Change the wait timeout in the 'Menu' to increase stability selenium tests [\#10220](https://github.com/eclipse/che/pull/10220) ([artaleks9](https://github.com/artaleks9))
- CHE-9052: Fix bug when file was deleted after move [\#10218](https://github.com/eclipse/che/pull/10218) ([vinokurig](https://github.com/vinokurig))
- Selenium: cover workspace creation from Java stack by selenium test  [\#10214](https://github.com/eclipse/che/pull/10214) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Fix of unexpected fail of "RollingUpdateStrategyWithWorkspacesStartStopTest" selenium test [\#10212](https://github.com/eclipse/che/pull/10212) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Add Html Sanitization for workspace name for preventing XSS [\#10198](https://github.com/eclipse/che/pull/10198) ([vparfonov](https://github.com/vparfonov))
- Make Authorization header value more uniform and use 'Bearer' prefix [\#10197](https://github.com/eclipse/che/pull/10197) ([mshaposhnik](https://github.com/mshaposhnik))
- Fixed absence of internal servers in WorkspaceProjectSynchronizer [\#10196](https://github.com/eclipse/che/pull/10196) ([dkuleshov](https://github.com/dkuleshov))
- Creating selenium framework tests \(abstraction for rh-che\) [\#10191](https://github.com/eclipse/che/pull/10191) ([ScrewTSW](https://github.com/ScrewTSW))
- Correct revert unsaved preference changes [\#10179](https://github.com/eclipse/che/pull/10179) ([vzhukovskii](https://github.com/vzhukovskii))
- Fix a bug in the Che GWT maven plugin that prevents RhChe to build with upstream `master` [\#10177](https://github.com/eclipse/che/pull/10177) ([davidfestal](https://github.com/davidfestal))
- Selenium: Create E2E test for checking Hot update feature for wsmaster [\#10176](https://github.com/eclipse/che/pull/10176) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- CHE-9154: Fix authorization message [\#10173](https://github.com/eclipse/che/pull/10173) ([vinokurig](https://github.com/vinokurig))
- CHE-9418: Fix Git status message if the repository is checkouted to tag or commit. [\#10172](https://github.com/eclipse/che/pull/10172) ([vinokurig](https://github.com/vinokurig))
- Adapt the CSharpFileEditingTest after latest changes in Csharp language server [\#10166](https://github.com/eclipse/che/pull/10166) ([musienko-maxim](https://github.com/musienko-maxim))
- Update font style for progress loader [\#10159](https://github.com/eclipse/che/pull/10159) ([vzhukovskii](https://github.com/vzhukovskii))
- Add selenium test of login with OpenShift account [\#10158](https://github.com/eclipse/che/pull/10158) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Selenium: set the GitHub username to lowercase when compared to the value 'Federated Identity' [\#10157](https://github.com/eclipse/che/pull/10157) ([artaleks9](https://github.com/artaleks9))
- che \#9946: Better handling of unrecoverable events for k8s & openshift infra \(processing both 'container' and 'pod' events\) [\#10155](https://github.com/eclipse/che/pull/10155) ([ibuziuk](https://github.com/ibuziuk))
- Fix Routing Strategy Docs [\#10152](https://github.com/eclipse/che/pull/10152) ([guydaichs](https://github.com/guydaichs))
- Selenium: cover Python language server format feature by selenium test [\#10149](https://github.com/eclipse/che/pull/10149) ([SkorikSergey](https://github.com/SkorikSergey))
- Merge wiptheia dockerfile with Che Theia IDE dockerfile [\#10148](https://github.com/eclipse/che/pull/10148) ([mmorhun](https://github.com/mmorhun))
- Selenium: move WorkingWithJavaMySqlStackTest and WorkingWithNodeWsTest selenium tests to stack package [\#10147](https://github.com/eclipse/che/pull/10147) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix start of workspaces of Eclipse Che Singleuser on OCP [\#10146](https://github.com/eclipse/che/pull/10146) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Selenium: cover workspace creation from Blank stack by selenium test [\#10145](https://github.com/eclipse/che/pull/10145) ([SkorikSergey](https://github.com/SkorikSergey))
- Update style for the save mark in editor tab for FireFox [\#10134](https://github.com/eclipse/che/pull/10134) ([vzhukovskii](https://github.com/vzhukovskii))
- Added secrets into K8s/OS environments [\#10129](https://github.com/eclipse/che/pull/10129) ([sleshchenko](https://github.com/sleshchenko))
- fix script on ci [\#10126](https://github.com/eclipse/che/pull/10126) ([riuvshin](https://github.com/riuvshin))
- Selenium: Fix of unexpected fail of "AddOrImportProjectFormTest" selenium test [\#10118](https://github.com/eclipse/che/pull/10118) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Make theia Docker image be able to use yarn cache on Openshift [\#10116](https://github.com/eclipse/che/pull/10116) ([mmorhun](https://github.com/mmorhun))
- Setup OCP to create objects under the certain user account [\#10114](https://github.com/eclipse/che/pull/10114) ([dmytro-ndp](https://github.com/dmytro-ndp))
- RELEASE: Set next development version [\#10110](https://github.com/eclipse/che/pull/10110) ([riuvshin](https://github.com/riuvshin))
- Lang servers [\#10102](https://github.com/eclipse/che/pull/10102) ([eivantsov](https://github.com/eivantsov))
- Basic support of the Eclipse Ceylon language [\#10096](https://github.com/eclipse/che/pull/10096) ([davidfestal](https://github.com/davidfestal))
- Show build details in dedicate window [\#10093](https://github.com/eclipse/che/pull/10093) ([vzhukovskii](https://github.com/vzhukovskii))
- NPEs on workspace start-up \#10083 [\#10088](https://github.com/eclipse/che/pull/10088) ([vrubezhny](https://github.com/vrubezhny))
- Fix for formatting for python language servers [\#10060](https://github.com/eclipse/che/pull/10060) ([dkuleshov](https://github.com/dkuleshov))
- Use Deployments instead of Pods in Kubernetes/OpenShift infra [\#10021](https://github.com/eclipse/che/pull/10021) ([amisevsk](https://github.com/amisevsk))
- Selenium: Revise and update "Dashboard" selenium tests in "Workspaces" section \("Workspace List" and "New Workspace" pages\). [\#9997](https://github.com/eclipse/che/pull/9997) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Track workspace Pods starting for failures [\#9976](https://github.com/eclipse/che/pull/9976) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Update readme with Che repositories section [\#9617](https://github.com/eclipse/che/pull/9617) ([ashumilova](https://github.com/ashumilova))

## [6.7.1](https://github.com/eclipse/che/tree/6.7.1) (2018-06-27)
[Full Changelog](https://github.com/eclipse/che/compare/6.7.0...6.7.1)

**Merged pull requests:**

- Use location instead of Eclipse workspace path for classpath [\#10153](https://github.com/eclipse/che/pull/10153) ([tsmaeder](https://github.com/tsmaeder))
- fix running script on ci [\#10125](https://github.com/eclipse/che/pull/10125) ([riuvshin](https://github.com/riuvshin))
- Show warning dialog after refactoring operation if something isn't valid [\#10080](https://github.com/eclipse/che/pull/10080) ([svor](https://github.com/svor))
- Simple Java project is not recognized \#9526 [\#10028](https://github.com/eclipse/che/pull/10028) ([vrubezhny](https://github.com/vrubezhny))
- Handle project updated notifications from jdt.ls [\#9983](https://github.com/eclipse/che/pull/9983) ([svor](https://github.com/svor))

## [6.7.0](https://github.com/eclipse/che/tree/6.7.0) (2018-06-20)
[Full Changelog](https://github.com/eclipse/che/compare/6.6.2...6.7.0)

**Merged pull requests:**

- Add one condition check to 'AfterMethod' in the 'ContributeTabTest' [\#10108](https://github.com/eclipse/che/pull/10108) ([artaleks9](https://github.com/artaleks9))
- Support Move refactoring [\#9953](https://github.com/eclipse/che/pull/9953) ([svor](https://github.com/svor))
- Selenium: fix StacksListTest selenium test according to stacks list changes [\#10104](https://github.com/eclipse/che/pull/10104) ([SkorikSergey](https://github.com/SkorikSergey))
- Implement test for covering rollout update CHE with Recreate strategy [\#10091](https://github.com/eclipse/che/pull/10091) ([musienko-maxim](https://github.com/musienko-maxim))
- Fix image-che-flag [\#10073](https://github.com/eclipse/che/pull/10073) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Correct the closing 'Preferences' form in the 'AfterMethod' of 'ContributeTabTest' [\#10069](https://github.com/eclipse/che/pull/10069) ([artaleks9](https://github.com/artaleks9))
- Selenium: cover workspace creation from Python stack by selenium test [\#10057](https://github.com/eclipse/che/pull/10057) ([SkorikSergey](https://github.com/SkorikSergey))
- \[cli\] Use fixed version of dependency [\#10054](https://github.com/eclipse/che/pull/10054) ([benoitf](https://github.com/benoitf))
- Selenium: fix workspace template for C++ stack  [\#10042](https://github.com/eclipse/che/pull/10042) ([SkorikSergey](https://github.com/SkorikSergey))
- Extract OpenShiftCliCommandExecutor in selenium tests [\#10033](https://github.com/eclipse/che/pull/10033) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Make ws agent-master interaction more consistent [\#10031](https://github.com/eclipse/che/pull/10031) ([gazarenkov](https://github.com/gazarenkov))
- CHE-8164: Fix error when creating project from archetype [\#10029](https://github.com/eclipse/che/pull/10029) ([vinokurig](https://github.com/vinokurig))
- Selenium: Add the 'Assert.fail\(\)' to the 'ContributeTabTest' according to known issue \(\#10019\) [\#10026](https://github.com/eclipse/che/pull/10026) ([artaleks9](https://github.com/artaleks9))
- add cli bugfix versions [\#10025](https://github.com/eclipse/che/pull/10025) ([riuvshin](https://github.com/riuvshin))
- Fix ocp.sh [\#10024](https://github.com/eclipse/che/pull/10024) ([eivantsov](https://github.com/eivantsov))
- Fix comment to comply build requirements [\#10023](https://github.com/eclipse/che/pull/10023) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Add option not to start test workspaces after creation [\#10022](https://github.com/eclipse/che/pull/10022) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Selenium: wait until 'Workspace is Created' dialog is fully rendered before creating workspace [\#10017](https://github.com/eclipse/che/pull/10017) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Add the 'Assert.fail\(\)' in the 'ImportWizardFormTest according to the known issue \#10012 [\#10016](https://github.com/eclipse/che/pull/10016) ([artaleks9](https://github.com/artaleks9))
- Don't trim stack trace and capture skipped selenium test results [\#10015](https://github.com/eclipse/che/pull/10015) ([dmytro-ndp](https://github.com/dmytro-ndp))
- rh-che \#703: Adding support of 'Impersonate-\*' headers processing in OpenShift infrastructure [\#10010](https://github.com/eclipse/che/pull/10010) ([ibuziuk](https://github.com/ibuziuk))
- Selenium: cover \#8674 issue in selenium test [\#10006](https://github.com/eclipse/che/pull/10006) ([SkorikSergey](https://github.com/SkorikSergey))
- Delete only child projects from project config registry at removing project [\#10005](https://github.com/eclipse/che/pull/10005) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Increase remove node-loader handler timeout [\#10003](https://github.com/eclipse/che/pull/10003) ([vinokurig](https://github.com/vinokurig))
- Set face name for 'Refresh Contribution Branch Name' button to avoid NPE [\#9996](https://github.com/eclipse/che/pull/9996) ([RomanNikitenko](https://github.com/RomanNikitenko))
- CHE-6840 Fix bug when closing editor by mouse middle key [\#9994](https://github.com/eclipse/che/pull/9994) ([vinokurig](https://github.com/vinokurig))
- Do not initialize Contribution Workflow when process of initialization has started [\#9993](https://github.com/eclipse/che/pull/9993) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Add ability to see and copy commit id value from git history dialog [\#9988](https://github.com/eclipse/che/pull/9988) ([vzhukovskii](https://github.com/vzhukovskii))
- Clean up opening files list [\#9985](https://github.com/eclipse/che/pull/9985) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Create selenium test user in Eclipse Che on OCP remotely [\#9982](https://github.com/eclipse/che/pull/9982) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Add support of Workspace Next to Openshift  infrastructure  [\#9981](https://github.com/eclipse/che/pull/9981) ([garagatyi](https://github.com/garagatyi))
- Selenium: Create the 'ContributeTabTest' [\#9974](https://github.com/eclipse/che/pull/9974) ([artaleks9](https://github.com/artaleks9))
- Implement selenium test for covering LS server for TypeScript language [\#9969](https://github.com/eclipse/che/pull/9969) ([musienko-maxim](https://github.com/musienko-maxim))
- Private registries support [\#9962](https://github.com/eclipse/che/pull/9962) ([davidfestal](https://github.com/davidfestal))
- Optimize the list of stacks [\#9960](https://github.com/eclipse/che/pull/9960) ([eivantsov](https://github.com/eivantsov))
- Fire ProjectCreatedEvent on importProject [\#9954](https://github.com/eclipse/che/pull/9954) ([vparfonov](https://github.com/vparfonov))
- Fix start of Che assembly on non-k8s infras [\#9947](https://github.com/eclipse/che/pull/9947) ([garagatyi](https://github.com/garagatyi))
- Added back and reworked LS related tests removed by a mistake [\#9933](https://github.com/eclipse/che/pull/9933) ([dkuleshov](https://github.com/dkuleshov))
- Watch connection manager never closed when trying to delete a non-existing POD [\#9932](https://github.com/eclipse/che/pull/9932) ([davidfestal](https://github.com/davidfestal))
- Do not track hidden items in the root by 'GitCheckoutDetector' [\#9931](https://github.com/eclipse/che/pull/9931) ([RomanNikitenko](https://github.com/RomanNikitenko))
- updated URL for the Camel LSP binary [\#9928](https://github.com/eclipse/che/pull/9928) ([lhein](https://github.com/lhein))
- Removed extra dependency [\#9926](https://github.com/eclipse/che/pull/9926) ([dkuleshov](https://github.com/dkuleshov))
- CHE-9563 fix switcher bug for UD [\#9915](https://github.com/eclipse/che/pull/9915) ([olexii4](https://github.com/olexii4))
- Switch editors in read only mode when ws agent has stopped [\#9912](https://github.com/eclipse/che/pull/9912) ([RomanNikitenko](https://github.com/RomanNikitenko))
- CHE-7371: Add support for custom identity providers in Che keycloak theme [\#9911](https://github.com/eclipse/che/pull/9911) ([mmorhun](https://github.com/mmorhun))
- Path provider should return absolute path [\#9910](https://github.com/eclipse/che/pull/9910) ([vparfonov](https://github.com/vparfonov))
- Fix displaying tabs for read only editors [\#9897](https://github.com/eclipse/che/pull/9897) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Selenium: delete the 'try/catch' from the 'PullRequestPluginTest' according to close issue \#9484 [\#9896](https://github.com/eclipse/che/pull/9896) ([artaleks9](https://github.com/artaleks9))
- Fix version for eclipse/che-theia image [\#9893](https://github.com/eclipse/che/pull/9893) ([ashumilova](https://github.com/ashumilova))
- Selenium: delete the 'try/catch' from the 'TestWorkspaceImpl' according to close issue \#9556 [\#9892](https://github.com/eclipse/che/pull/9892) ([artaleks9](https://github.com/artaleks9))
- Selenium: cover creation of workspaces from organization details page [\#9888](https://github.com/eclipse/che/pull/9888) ([SkorikSergey](https://github.com/SkorikSergey))
-  Does not claim recovery is supported on docker infra [\#9887](https://github.com/eclipse/che/pull/9887) ([mshaposhnik](https://github.com/mshaposhnik))
- RELEASE: Update CHANGELOG [\#9884](https://github.com/eclipse/che/pull/9884) ([riuvshin](https://github.com/riuvshin))
- Selenium: cover Clangd LS functionality by selenium test [\#9875](https://github.com/eclipse/che/pull/9875) ([SkorikSergey](https://github.com/SkorikSergey))
- Fixed golang language server hover bug [\#9874](https://github.com/eclipse/che/pull/9874) ([dkuleshov](https://github.com/dkuleshov))
- Selenium: Fix unexpected fails of "CreateWorkspaceTest", "AddWorkspaceToOrganizationTest", "ShareWorkspaceTest" selenium tests [\#9873](https://github.com/eclipse/che/pull/9873) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Automate adding self signed cert to Java trust store in Che server pod [\#9869](https://github.com/eclipse/che/pull/9869) ([eivantsov](https://github.com/eivantsov))
- RELEASE: Set next development version [\#9862](https://github.com/eclipse/che/pull/9862) ([riuvshin](https://github.com/riuvshin))
- Make it possible to have distributed ProjectRegistry [\#9848](https://github.com/eclipse/che/pull/9848) ([gazarenkov](https://github.com/gazarenkov))
- CHE-9547 fix RAM changes for editing the machine dialog for UD [\#9834](https://github.com/eclipse/che/pull/9834) ([olexii4](https://github.com/olexii4))
- Improve wsmaster OpenIdConnect configurability, and helm deployment s… [\#9826](https://github.com/eclipse/che/pull/9826) ([i300543](https://github.com/i300543))
- Added an ability to interrupt the start of a Kubernetes/OpenShift runtime [\#9816](https://github.com/eclipse/che/pull/9816) ([sleshchenko](https://github.com/sleshchenko))
- WIP: Add Golang Support in Che [\#9803](https://github.com/eclipse/che/pull/9803) ([eivantsov](https://github.com/eivantsov))
- \[\#8040\]: Fix Git credentials by creating ~/.ssh in case it is missing [\#9800](https://github.com/eclipse/che/pull/9800) ([ctron](https://github.com/ctron))
- Update cached children when external file event is coming [\#9793](https://github.com/eclipse/che/pull/9793) ([vzhukovskii](https://github.com/vzhukovskii))
- Fix initialization of servers statuses by DockerInfrastructure [\#9777](https://github.com/eclipse/che/pull/9777) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Add an ability to try Workspace.Next features [\#9774](https://github.com/eclipse/che/pull/9774) ([garagatyi](https://github.com/garagatyi))
- Fix for YAML language server not displaying hover [\#9670](https://github.com/eclipse/che/pull/9670) ([JPinkney](https://github.com/JPinkney))
- Remove unnecessary pageobjects. Rename MachineTerminal page object to CheTerminal [\#9665](https://github.com/eclipse/che/pull/9665) ([musienko-maxim](https://github.com/musienko-maxim))

## [6.6.2](https://github.com/eclipse/che/tree/6.6.2) (2018-06-14)
[Full Changelog](https://github.com/eclipse/che/compare/6.6.1...6.6.2)

**Merged pull requests:**

- Prepare for 6.6.2 bug-fix release [\#10053](https://github.com/eclipse/che/pull/10053) ([davidfestal](https://github.com/davidfestal))

## [6.6.1](https://github.com/eclipse/che/tree/6.6.1) (2018-06-13)
[Full Changelog](https://github.com/eclipse/che/compare/6.5.3...6.6.1)

**Merged pull requests:**

- Issue 8721 - Update Libraries, etc. based on JDT notifications \#8721 [\#9650](https://github.com/eclipse/che/pull/9650) ([vrubezhny](https://github.com/vrubezhny))

## [6.5.3](https://github.com/eclipse/che/tree/6.5.3) (2018-06-06)
[Full Changelog](https://github.com/eclipse/che/compare/6.5.2...6.5.3)

**Merged pull requests:**

- Support Rename refactoring [\#9636](https://github.com/eclipse/che/pull/9636) ([svor](https://github.com/svor))

## [6.5.2](https://github.com/eclipse/che/tree/6.5.2) (2018-05-31)
[Full Changelog](https://github.com/eclipse/che/compare/6.6.0...6.5.2)


## [6.6.0](https://github.com/eclipse/che/tree/6.6.0) (2018-05-30)
[Full Changelog](https://github.com/eclipse/che/compare/6.5.1...6.6.0)

**Merged pull requests:**

- RELEASE: Set next development version [\#9862](https://github.com/eclipse/che/pull/9862) ([riuvshin](https://github.com/riuvshin))
- fix build.sh for theia image [\#9850](https://github.com/eclipse/che/pull/9850) ([riuvshin](https://github.com/riuvshin))
- Selenium: Rework "NewWorkspace" selenium page object by "SeleniumWebDriverHelper" class [\#9812](https://github.com/eclipse/che/pull/9812) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Fix contribute part displaying at project selection [\#9806](https://github.com/eclipse/che/pull/9806) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Implement selenium test for covering LS server for PHP language [\#9805](https://github.com/eclipse/che/pull/9805) ([musienko-maxim](https://github.com/musienko-maxim))
- add bugfix versions to cli [\#9799](https://github.com/eclipse/che/pull/9799) ([riuvshin](https://github.com/riuvshin))
- Removed Codenvy analytics components [\#9795](https://github.com/eclipse/che/pull/9795) ([sleshchenko](https://github.com/sleshchenko))
- Wait until Che is available when deploying it on OCP [\#9783](https://github.com/eclipse/che/pull/9783) ([dmytro-ndp](https://github.com/dmytro-ndp))
- fix formating [\#9782](https://github.com/eclipse/che/pull/9782) ([vparfonov](https://github.com/vparfonov))
- There are possible places of failure due to not closing InputStreams [\#9780](https://github.com/eclipse/che/pull/9780) ([dkuleshov](https://github.com/dkuleshov))
- Fix injection if any implementation of LanguageDescription found [\#9779](https://github.com/eclipse/che/pull/9779) ([vparfonov](https://github.com/vparfonov))
- Send initialized event, after initialization [\#9776](https://github.com/eclipse/che/pull/9776) ([vparfonov](https://github.com/vparfonov))
- Rework the 'ImportProjectFromZipTest' to add test repo on Github using the 'kohsuke GitHub' library [\#9773](https://github.com/eclipse/che/pull/9773) ([artaleks9](https://github.com/artaleks9))
- che \#9542 Processing only the events that happened after `watchContainers` initialization [\#9772](https://github.com/eclipse/che/pull/9772) ([ibuziuk](https://github.com/ibuziuk))
- CHE-8931: fix blank screen on project details page [\#9771](https://github.com/eclipse/che/pull/9771) ([akurinnoy](https://github.com/akurinnoy))
- Rework the 'ImportMavenProjectFromGitTest' to add test repo on Github using the 'kohsuke Github' library [\#9763](https://github.com/eclipse/che/pull/9763) ([artaleks9](https://github.com/artaleks9))
- Selenium: Rework the 'ImportProjectFromGitHubTest' to add test repo on Github using the 'kohsuke Github' library [\#9762](https://github.com/eclipse/che/pull/9762) ([artaleks9](https://github.com/artaleks9))
- Selenium: cover Python LS functionality by selenium test  [\#9759](https://github.com/eclipse/che/pull/9759) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix installers version confusing by displaying only the latest version [\#9758](https://github.com/eclipse/che/pull/9758) ([ashumilova](https://github.com/ashumilova))
- Fix wsagent clientId passing, fix diagnostics recipe to work both on ocp and docker [\#9757](https://github.com/eclipse/che/pull/9757) ([ashumilova](https://github.com/ashumilova))
- Delete child projects only from project config registry at removing project [\#9754](https://github.com/eclipse/che/pull/9754) ([RomanNikitenko](https://github.com/RomanNikitenko))
- CHE-9716: Use the fixed version of Theia in eclipse/che-theia image [\#9751](https://github.com/eclipse/che/pull/9751) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- If node is already visible in project tree, then select it instead of reload [\#9747](https://github.com/eclipse/che/pull/9747) ([vzhukovskii](https://github.com/vzhukovskii))
- Selenium: Change the name of the test library in the resources [\#9746](https://github.com/eclipse/che/pull/9746) ([artaleks9](https://github.com/artaleks9))
- Fix AskDialog page object of selenium tests [\#9745](https://github.com/eclipse/che/pull/9745) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Provide machine name as a machine's environment variable [\#9743](https://github.com/eclipse/che/pull/9743) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Selenium: Rework the 'ImportWizardFormTest' to add test repo on Github using the 'kohsuke GitHub' library [\#9742](https://github.com/eclipse/che/pull/9742) ([artaleks9](https://github.com/artaleks9))
- Make client id and secret configurable from command line [\#9738](https://github.com/eclipse/che/pull/9738) ([eivantsov](https://github.com/eivantsov))
- Move building of postgresql-tck module to integration build profile [\#9737](https://github.com/eclipse/che/pull/9737) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Added an error when keycloak container is not found [\#9736](https://github.com/eclipse/che/pull/9736) ([sleshchenko](https://github.com/sleshchenko))
- End-To-End tests of download project/directory/file feature [\#9724](https://github.com/eclipse/che/pull/9724) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Send request with activity on ws-agent in a separate thread [\#9708](https://github.com/eclipse/che/pull/9708) ([mkuznyetsov](https://github.com/mkuznyetsov))
- che-9234: fix diagnostics by reworking websocket usage to jsonrpc [\#9704](https://github.com/eclipse/che/pull/9704) ([ashumilova](https://github.com/ashumilova))
- \#9542 Proper handling of unrecoverable events. Processing only events which are related to current workspace pods [\#9703](https://github.com/eclipse/che/pull/9703) ([ibuziuk](https://github.com/ibuziuk))
- Added JGroups based status cache and lock service [\#9701](https://github.com/eclipse/che/pull/9701) ([sleshchenko](https://github.com/sleshchenko))
- Fixed wrong logger output [\#9696](https://github.com/eclipse/che/pull/9696) ([skabashnyuk](https://github.com/skabashnyuk))
- Selenium: increase timeout for checking the project details page [\#9695](https://github.com/eclipse/che/pull/9695) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-9523 fix flow to creating a new OpenShift/K8S stack  [\#9693](https://github.com/eclipse/che/pull/9693) ([olexii4](https://github.com/olexii4))
- Fix of P1 bugs in dashboard [\#9690](https://github.com/eclipse/che/pull/9690) ([ashumilova](https://github.com/ashumilova))
- Notify consumers about file is opened at restoring IDE state [\#9689](https://github.com/eclipse/che/pull/9689) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Selenium: Add the 'try/catch' to the 'PullRequestPluginTest' according to the known issue \#9484 [\#9688](https://github.com/eclipse/che/pull/9688) ([artaleks9](https://github.com/artaleks9))
- Fixed removing of temporary workspaces on server startup and shutdown [\#9687](https://github.com/eclipse/che/pull/9687) ([sleshchenko](https://github.com/sleshchenko))
- Selenium: Restore order of the test methods launch in the "ContextMenuEditorTest" selenium test [\#9686](https://github.com/eclipse/che/pull/9686) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Added an ability to schedule servers checkers for STARTING K8s/OS runtime [\#9685](https://github.com/eclipse/che/pull/9685) ([sleshchenko](https://github.com/sleshchenko))
-  Add DB termination component on application shutdown [\#9683](https://github.com/eclipse/che/pull/9683) ([mshaposhnik](https://github.com/mshaposhnik))
- RELEASE: Update CHANGELOG [\#9678](https://github.com/eclipse/che/pull/9678) ([riuvshin](https://github.com/riuvshin))
- Selenium: Replace the known issue \#8856 on the \#9556 in the try/catch block in the TestWorkspaceImpl [\#9672](https://github.com/eclipse/che/pull/9672) ([artaleks9](https://github.com/artaleks9))
- CHE-6109: Enable Update project configuration from any project level [\#9671](https://github.com/eclipse/che/pull/9671) ([vinokurig](https://github.com/vinokurig))
- RELEASE: Set next development version [\#9669](https://github.com/eclipse/che/pull/9669) ([riuvshin](https://github.com/riuvshin))
- Adding error from machine startup and installers to slf4j log [\#9659](https://github.com/eclipse/che/pull/9659) ([skabashnyuk](https://github.com/skabashnyuk))
- Add missing service terminations [\#9658](https://github.com/eclipse/che/pull/9658) ([sleshchenko](https://github.com/sleshchenko))
-  Add ability to configure OAuth type in Multi User Che [\#9640](https://github.com/eclipse/che/pull/9640) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Adding `-Dvertx.disableDnsResolver=true` to vert.x run / debug commands [\#9611](https://github.com/eclipse/che/pull/9611) ([ibuziuk](https://github.com/ibuziuk))
- To white label dashboard, make it possible to override dashboard fonts [\#9604](https://github.com/eclipse/che/pull/9604) ([panditrashmi](https://github.com/panditrashmi))
- Correct process situation when project has been renamed [\#9582](https://github.com/eclipse/che/pull/9582) ([vzhukovskii](https://github.com/vzhukovskii))
- Allow creating OpenShift objects under the current user account on OCP [\#9577](https://github.com/eclipse/che/pull/9577) ([davidfestal](https://github.com/davidfestal))
- \[WIP\] Several improvements to the way remote language servers may be configured through workspace configuration [\#9387](https://github.com/eclipse/che/pull/9387) ([dkuleshov](https://github.com/dkuleshov))

## [6.5.1](https://github.com/eclipse/che/tree/6.5.1) (2018-05-24)
[Full Changelog](https://github.com/eclipse/che/compare/6.5.0...6.5.1)

**Merged pull requests:**

- Selenium: change url of known issue to \#9523 instead of \#9648 in StacksListTest test  [\#9667](https://github.com/eclipse/che/pull/9667) ([SkorikSergey](https://github.com/SkorikSergey))


## [6.5.0](https://github.com/eclipse/che/tree/6.5.0) (2018-05-10)
[Full Changelog](https://github.com/eclipse/che/compare/6.4.1...6.5.0)

**Merged pull requests:**

- Skip selenium tests which depends on failed tests [\#9622](https://github.com/eclipse/che/pull/9622) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Add info about bug \#9548 into the PullRequestPluginWithForkTest [\#9558](https://github.com/eclipse/che/pull/9558) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Selenium: change url of known issue to \#9523 instead of \#9648 in StacksListTest test  [\#9667](https://github.com/eclipse/che/pull/9667) ([SkorikSergey](https://github.com/SkorikSergey))
- Change issue reference [\#9662](https://github.com/eclipse/che/pull/9662) ([musienko-maxim](https://github.com/musienko-maxim))
- CHE-9542: Disable unrecoverable k8s events handling [\#9661](https://github.com/eclipse/che/pull/9661) ([garagatyi](https://github.com/garagatyi))
- Rework PlainJava project type and Deprecate SettableValueProvider [\#9634](https://github.com/eclipse/che/pull/9634) ([gazarenkov](https://github.com/gazarenkov))
- Selenium: wait for Project Explorer after starting IDE in tests from refactor.types package [\#9629](https://github.com/eclipse/che/pull/9629) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix Eclipse Che deployment on OCP [\#9627](https://github.com/eclipse/che/pull/9627) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Add logging of Kubernetes/OpenShift unrecoverable events [\#9619](https://github.com/eclipse/che/pull/9619) ([sleshchenko](https://github.com/sleshchenko))
- CHE-8931: fix projects management in multi-user mode [\#9615](https://github.com/eclipse/che/pull/9615) ([akurinnoy](https://github.com/akurinnoy))
- CHE-9449: Adapt Node Js debugger to node version 8 [\#9612](https://github.com/eclipse/che/pull/9612) ([vinokurig](https://github.com/vinokurig))
- Allow adding Theia extension on image build from within container [\#9608](https://github.com/eclipse/che/pull/9608) ([mmorhun](https://github.com/mmorhun))
- Selenium: Rework the 'RunPlainJavaProjectTest' to use the 'kohsuke Github' library [\#9602](https://github.com/eclipse/che/pull/9602) ([artaleks9](https://github.com/artaleks9))
- Selenium: cover the Stacks list by selenium test  [\#9601](https://github.com/eclipse/che/pull/9601) ([SkorikSergey](https://github.com/SkorikSergey))
- Include workspace activity times into cascade removals; [\#9600](https://github.com/eclipse/che/pull/9600) ([mshaposhnik](https://github.com/mshaposhnik))
- Build any Theia extensions which are downloaded from a git provider [\#9598](https://github.com/eclipse/che/pull/9598) ([mmorhun](https://github.com/mmorhun))
- Fix check for a directory [\#9594](https://github.com/eclipse/che/pull/9594) ([eivantsov](https://github.com/eivantsov))
- CHE-8931: fix black screen on project details page [\#9586](https://github.com/eclipse/che/pull/9586) ([akurinnoy](https://github.com/akurinnoy))
-  Selenium: change url of known issue to \#8465 instead of \#8293 in NavigateToFileTest test  [\#9585](https://github.com/eclipse/che/pull/9585) ([SkorikSergey](https://github.com/SkorikSergey))
- Add supervisor into Theia image to reap zombie processes [\#9583](https://github.com/eclipse/che/pull/9583) ([mmorhun](https://github.com/mmorhun))
- README: Reference to roadmap and meetings [\#9575](https://github.com/eclipse/che/pull/9575) ([bmicklea](https://github.com/bmicklea))
- Skip downloading binaries if node\_modules exist [\#9571](https://github.com/eclipse/che/pull/9571) ([eivantsov](https://github.com/eivantsov))
- Do not download LS binaries if LS dir is found in a container [\#9570](https://github.com/eclipse/che/pull/9570) ([eivantsov](https://github.com/eivantsov))
- Add new Python Language server [\#9569](https://github.com/eclipse/che/pull/9569) ([eivantsov](https://github.com/eivantsov))
- Add missing maven-server binaries for Che-in-Che deployment [\#9561](https://github.com/eclipse/che/pull/9561) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Fixed removal of remote subscriptions in manager [\#9560](https://github.com/eclipse/che/pull/9560) ([mshaposhnik](https://github.com/mshaposhnik))
- Add processing of runtime exceptions during JWT tokens validation [\#9557](https://github.com/eclipse/che/pull/9557) ([sleshchenko](https://github.com/sleshchenko))
- Remove cleaning up of CHE\_DATA/lib folder in entrypoint.sh [\#9553](https://github.com/eclipse/che/pull/9553) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Remove Keycloak job, use the right entrypoint, add envs the script re… [\#9533](https://github.com/eclipse/che/pull/9533) ([eivantsov](https://github.com/eivantsov))
- CHE-9442: Fix Git exception when editing untracked or new file. [\#9529](https://github.com/eclipse/che/pull/9529) ([vinokurig](https://github.com/vinokurig))
- Added an ability to update Che Server without stopping of running workspaces [\#9527](https://github.com/eclipse/che/pull/9527) ([sleshchenko](https://github.com/sleshchenko))
- Selenium: Rework the 'GitCompareTest' by use the 'kohsuke Github' library [\#9524](https://github.com/eclipse/che/pull/9524) ([artaleks9](https://github.com/artaleks9))
- Do not display hidden items in root of project tree [\#9522](https://github.com/eclipse/che/pull/9522) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Upgrade php ls [\#9521](https://github.com/eclipse/che/pull/9521) ([eivantsov](https://github.com/eivantsov))
- Remove duplicated declaration of artifact [\#9515](https://github.com/eclipse/che/pull/9515) ([skabashnyuk](https://github.com/skabashnyuk))
- Update deploy\_che script [\#9513](https://github.com/eclipse/che/pull/9513) ([eivantsov](https://github.com/eivantsov))
- Update OpenShift Origin version to 3.9 [\#9509](https://github.com/eclipse/che/pull/9509) ([eivantsov](https://github.com/eivantsov))
- Skip authentication for the `OIDCKeycloak.js` file \(Fix regression\) [\#9505](https://github.com/eclipse/che/pull/9505) ([davidfestal](https://github.com/davidfestal))
- Fix bootstrapping fast failed when URL is invalid [\#9504](https://github.com/eclipse/che/pull/9504) ([akorneta](https://github.com/akorneta))
- Selenium: Covers more steps of the "RenameProjectTest" selenium test by catching issue \#9393 [\#9503](https://github.com/eclipse/che/pull/9503) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Fix injection of default user in selenium tests of SingleUser Che [\#9499](https://github.com/eclipse/che/pull/9499) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Use -gt as comparison operator [\#9497](https://github.com/eclipse/che/pull/9497) ([eivantsov](https://github.com/eivantsov))
- Fix Github oAuth in dashboard [\#9495](https://github.com/eclipse/che/pull/9495) ([ashumilova](https://github.com/ashumilova))
- Fixes to ocp script [\#9493](https://github.com/eclipse/che/pull/9493) ([eivantsov](https://github.com/eivantsov))
- Added starting servers checkers after recovering only for RUNNING workspaces [\#9492](https://github.com/eclipse/che/pull/9492) ([sleshchenko](https://github.com/sleshchenko))
- Make Keycloak Admin configurable [\#9490](https://github.com/eclipse/che/pull/9490) ([eivantsov](https://github.com/eivantsov))
- RELEASE: Update CHANGELOG [\#9478](https://github.com/eclipse/che/pull/9478) ([riuvshin](https://github.com/riuvshin))
- Add internal and external API URL environment variables for workspaces [\#9475](https://github.com/eclipse/che/pull/9475) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Fix error of selenium tests when admin credentials is incorrect [\#9474](https://github.com/eclipse/che/pull/9474) ([dmytro-ndp](https://github.com/dmytro-ndp))
- RELEASE: Set next development version [\#9473](https://github.com/eclipse/che/pull/9473) ([riuvshin](https://github.com/riuvshin))
- Add GitResetTest for covering git soft/mixed/hard reset feature [\#9471](https://github.com/eclipse/che/pull/9471) ([musienko-maxim](https://github.com/musienko-maxim))
- Wait for children nodes to be loaded on refresh project explorer after adding new resource [\#9470](https://github.com/eclipse/che/pull/9470) ([vinokurig](https://github.com/vinokurig))
- Selenium: adapt dashboard selenium tests for OSIO [\#9448](https://github.com/eclipse/che/pull/9448) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-9428: fix kubernetes infra after a merge of not checked PR [\#9446](https://github.com/eclipse/che/pull/9446) ([garagatyi](https://github.com/garagatyi))
- rh-che \#557: Adding property and handler for stopping k8s / openshift workspace if unrecoverable event occurs during workspace startup [\#9426](https://github.com/eclipse/che/pull/9426) ([ibuziuk](https://github.com/ibuziuk))
- Changed absolute paths to relative paths for zipped content [\#9400](https://github.com/eclipse/che/pull/9400) ([dkuleshov](https://github.com/dkuleshov))

## [6.4.1](https://github.com/eclipse/che/tree/6.4.1) (2018-04-26)
[Full Changelog](https://github.com/eclipse/che/compare/6.4.0...6.4.1)

**Merged pull requests:**

- Move factory-related selenium tests to the CheSuite.xml [\#9543](https://github.com/eclipse/che/pull/9543) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Rework organization-related tests to be executed in multi-thread mode [\#9532](https://github.com/eclipse/che/pull/9532) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Fix handling of outdated local Chrome version when create webdriver [\#9514](https://github.com/eclipse/che/pull/9514) ([dmytro-ndp](https://github.com/dmytro-ndp))


## [6.4.0](https://github.com/eclipse/che/tree/6.4.0) (2018-04-18)
[Full Changelog](https://github.com/eclipse/che/compare/6.3.0...6.4.0)

**Merged pull requests:**

- RELEASE: Set next development version [\#9473](https://github.com/eclipse/che/pull/9473) ([riuvshin](https://github.com/riuvshin))
- Move test user creating from selenium tests launcher to framework [\#9357](https://github.com/eclipse/che/pull/9357) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Fixed command for launching minikube with RBAC in helm chart readme [\#9468](https://github.com/eclipse/che/pull/9468) ([sleshchenko](https://github.com/sleshchenko))
- Selenium: Remove workaround in "MacrosCommandsEditorTest" selenium test [\#9460](https://github.com/eclipse/che/pull/9460) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: Add catching issue \#9456 [\#9457](https://github.com/eclipse/che/pull/9457) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: remove info about \#9100 issue from ProjectExplorer page object [\#9443](https://github.com/eclipse/che/pull/9443) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix calculation Projects Root so it wont cause NPE if there are no 'project' volume defined  [\#9440](https://github.com/eclipse/che/pull/9440) ([gazarenkov](https://github.com/gazarenkov))
- Fixed removing of PVCs when OpenShift project name is predefined [\#9437](https://github.com/eclipse/che/pull/9437) ([sleshchenko](https://github.com/sleshchenko))
- Make IDE use projects folder configured in a workspace instead of hardcoded /projects [\#9422](https://github.com/eclipse/che/pull/9422) ([gazarenkov](https://github.com/gazarenkov))
- Selenium: Resolve unexpected fail of UpdateListOfLibraryTest selenium test [\#9420](https://github.com/eclipse/che/pull/9420) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: Remove catching issue \#7551 in the selenium tests [\#9407](https://github.com/eclipse/che/pull/9407) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Notify other browsers when project is created in one session [\#9405](https://github.com/eclipse/che/pull/9405) ([vzhukovskii](https://github.com/vzhukovskii))
- Add catching of known bug \#9393 [\#9396](https://github.com/eclipse/che/pull/9396) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Use workspace limit idle timeout value in WorkspaceActivityManager [\#9395](https://github.com/eclipse/che/pull/9395) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Added initialization for FileTreeWalker [\#9392](https://github.com/eclipse/che/pull/9392) ([dkuleshov](https://github.com/dkuleshov))
- Selenium: wait that Restart button in ToastLoader is clickable [\#9389](https://github.com/eclipse/che/pull/9389) ([SkorikSergey](https://github.com/SkorikSergey))
- che \#9376 Setting default postgres image for 'deploy\_postgres\_only.sh' instead of failing if 'IMAGE\_POSTGRES' env var is not set [\#9382](https://github.com/eclipse/che/pull/9382) ([ibuziuk](https://github.com/ibuziuk))
- Fix move sign key binding to auth module [\#9380](https://github.com/eclipse/che/pull/9380) ([akorneta](https://github.com/akorneta))
- Revert "Use workspace limit idle timeout value in WorkspaceActivityManager \(\#9342\)" [\#9377](https://github.com/eclipse/che/pull/9377) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Selenium: move SeleniumWebDriverHelper class to org.eclipse.che.selenium.core package [\#9375](https://github.com/eclipse/che/pull/9375) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Create one test from "ImportRecursiveSubmoduleTest", "ImportProjectIntoSpecifiedBranchTest", and "KeepDirectoryGitImportTest" selenium tests [\#9372](https://github.com/eclipse/che/pull/9372) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Make exec agent not to use setsid for other than Linux OSes [\#9371](https://github.com/eclipse/che/pull/9371) ([gazarenkov](https://github.com/gazarenkov))
- Fix workspace loader which should pass its query strings to the underlying alternate IDE [\#9370](https://github.com/eclipse/che/pull/9370) ([sunix](https://github.com/sunix))
- Correct handle of input events in navigate to file dialogue [\#9369](https://github.com/eclipse/che/pull/9369) ([vzhukovskii](https://github.com/vzhukovskii))
- Selenium: Rework the 'CheckoutReferenceTest' to run in the multi-thread mode [\#9368](https://github.com/eclipse/che/pull/9368) ([artaleks9](https://github.com/artaleks9))
- Fix Openshift infrastructure [\#9366](https://github.com/eclipse/che/pull/9366) ([garagatyi](https://github.com/garagatyi))
- Selenium: change url of known issue to \#8293 instead of \#8465 in NavigateToFileTest selenium test [\#9364](https://github.com/eclipse/che/pull/9364) ([SkorikSergey](https://github.com/SkorikSergey))
- Update content from the resource for CheckGeneratingMavenArchetypeTest file to actual state [\#9363](https://github.com/eclipse/che/pull/9363) ([musienko-maxim](https://github.com/musienko-maxim))
- Selenium: not check Workspace API installer changeability in WorkspaceDetailsSingleMachineTest test [\#9350](https://github.com/eclipse/che/pull/9350) ([SkorikSergey](https://github.com/SkorikSergey))
- Improve abstract InternalRuntime to be more flexible for recovery functionality [\#9345](https://github.com/eclipse/che/pull/9345) ([sleshchenko](https://github.com/sleshchenko))
- Use workspace limit idle timeout value in WorkspaceActivityManager [\#9342](https://github.com/eclipse/che/pull/9342) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Fix go stack version. [\#9341](https://github.com/eclipse/che/pull/9341) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Selenium: fix project names generation in selenium tests from refactor package [\#9340](https://github.com/eclipse/che/pull/9340) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix GitHub optional properties binding to selenium tests [\#9337](https://github.com/eclipse/che/pull/9337) ([dmytro-ndp](https://github.com/dmytro-ndp))
- k8s-infra: routing, TLS \(rebased\) [\#9329](https://github.com/eclipse/che/pull/9329) ([guydaichs](https://github.com/guydaichs))
- Improve and rework the  PushingChangesTest using kohsuke library [\#9328](https://github.com/eclipse/che/pull/9328) ([musienko-maxim](https://github.com/musienko-maxim))
- Selenium: fix github user name in PullRequestPluginWithForkTest test [\#9327](https://github.com/eclipse/che/pull/9327) ([SkorikSergey](https://github.com/SkorikSergey))
- \[533196\] Fix Camel LSP artefact to download [\#9324](https://github.com/eclipse/che/pull/9324) ([apupier](https://github.com/apupier))
- CHE-9299 remove the dev machine validation for UD [\#9322](https://github.com/eclipse/che/pull/9322) ([olexii4](https://github.com/olexii4))
- Fix failing tests in docker infrastructure [\#9320](https://github.com/eclipse/che/pull/9320) ([garagatyi](https://github.com/garagatyi))
- Port org.slf4j.helpers.Util.java to the slf4j GWT logger [\#9319](https://github.com/eclipse/che/pull/9319) ([vparfonov](https://github.com/vparfonov))
- Selenium: improve and rework the 'PullRequestPluginWithForkTest' test [\#9312](https://github.com/eclipse/che/pull/9312) ([SkorikSergey](https://github.com/SkorikSergey))
- Add replicated storage for remote websocket subscriptions [\#9311](https://github.com/eclipse/che/pull/9311) ([mshaposhnik](https://github.com/mshaposhnik))
- Selenium: Rework the 'CheckoutToRemoteBranchWhichAlreadyHasLinkedLocalBranchTest to run in the multi-threaded mode [\#9309](https://github.com/eclipse/che/pull/9309) ([artaleks9](https://github.com/artaleks9))
-  Add auxiliary test github user repository [\#9308](https://github.com/eclipse/che/pull/9308) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Add exec with error output processing [\#9307](https://github.com/eclipse/che/pull/9307) ([akorneta](https://github.com/akorneta))
- Change the name of test project for better readability [\#9303](https://github.com/eclipse/che/pull/9303) ([musienko-maxim](https://github.com/musienko-maxim))
- CHE-9066: Fix wrong author name of revert commit [\#9302](https://github.com/eclipse/che/pull/9302) ([vinokurig](https://github.com/vinokurig))
- Implemented recovery functionality for Kubernetes/OpenShift infrastructures [\#9301](https://github.com/eclipse/che/pull/9301) ([sleshchenko](https://github.com/sleshchenko))
- Add ability to manage the list of Theia plugins in UD [\#9300](https://github.com/eclipse/che/pull/9300) ([ashumilova](https://github.com/ashumilova))
- Selenium: improve and rework the 'PullRequestPluginTest' test [\#9297](https://github.com/eclipse/che/pull/9297) ([SkorikSergey](https://github.com/SkorikSergey))
- Add setting of an environment variable to configure master logs encoding [\#9296](https://github.com/eclipse/che/pull/9296) ([garagatyi](https://github.com/garagatyi))
- Selenium: Improve and rework the 'KeepDirectoryGitImportTest' for ability to launching in multi-threaded mode [\#9293](https://github.com/eclipse/che/pull/9293) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- fix format file [\#9289](https://github.com/eclipse/che/pull/9289) ([musienko-maxim](https://github.com/musienko-maxim))
- Fix recreation of user in Che DB, when it has been recreated on Keycloak [\#9280](https://github.com/eclipse/che/pull/9280) ([mkuznyetsov](https://github.com/mkuznyetsov))
- RELEASE: Update CHANGELOG [\#9278](https://github.com/eclipse/che/pull/9278) ([riuvshin](https://github.com/riuvshin))
- Use the owner Id only in the workspace `RuntimeIdentity` \(\#8859\) [\#9274](https://github.com/eclipse/che/pull/9274) ([davidfestal](https://github.com/davidfestal))
- RELEASE: Set next development version [\#9268](https://github.com/eclipse/che/pull/9268) ([riuvshin](https://github.com/riuvshin))
- Add ability to configure Theia port [\#9264](https://github.com/eclipse/che/pull/9264) ([mmorhun](https://github.com/mmorhun))
- Handle issue \#9251 in selenium tests related to debugger [\#9263](https://github.com/eclipse/che/pull/9263) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Selenium: add method for switching from Dashboard to IDE frame in SeleniumWebDriverHelper class [\#9262](https://github.com/eclipse/che/pull/9262) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Unexpected fail of TransitiveDependencyTest in the selenium tests [\#9261](https://github.com/eclipse/che/pull/9261) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Provide configuration property to be able to set docker image build timeout [\#9259](https://github.com/eclipse/che/pull/9259) ([akorneta](https://github.com/akorneta))
-  Set correct response for non-working services in Multi User Che [\#9237](https://github.com/eclipse/che/pull/9237) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Disable PVC creation for che-multiuser master [\#9236](https://github.com/eclipse/che/pull/9236) ([akorneta](https://github.com/akorneta))
- Selenium: Rework the 'CheckoutToRemoteBranchTest' to run in multi-threaded mode [\#9228](https://github.com/eclipse/che/pull/9228) ([artaleks9](https://github.com/artaleks9))
- Change way of storing IDE state data [\#9196](https://github.com/eclipse/che/pull/9196) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Use templates only to deploy Che to OpenShift [\#9190](https://github.com/eclipse/che/pull/9190) ([eivantsov](https://github.com/eivantsov))
- Add the test for checking inactive  workspace [\#9171](https://github.com/eclipse/che/pull/9171) ([musienko-maxim](https://github.com/musienko-maxim))
- Make workspace expiration data persistent & shareable. [\#9142](https://github.com/eclipse/che/pull/9142) ([mshaposhnik](https://github.com/mshaposhnik))
- Use JWT instead of machine token to be able recover workspaces [\#9016](https://github.com/eclipse/che/pull/9016) ([akorneta](https://github.com/akorneta))
- Enable single-level DNS domains \(\*.domain.tld\) in SINGLE\_PORT mode to simplify HTTPS setup [\#8983](https://github.com/eclipse/che/pull/8983) ([hkolvenbach](https://github.com/hkolvenbach))
- Configure JPA L2 cache coordination between instances on Openshift®  / Kubernetes [\#8982](https://github.com/eclipse/che/pull/8982) ([mshaposhnik](https://github.com/mshaposhnik))


## [6.3.0](https://github.com/eclipse/che/tree/6.3.0) (2018-03-28)
[Full Changelog](https://github.com/eclipse/che/compare/6.2.0...6.3.0)

**Merged pull requests:**

- RELEASE: Set next development version [\#9268](https://github.com/eclipse/che/pull/9268) ([riuvshin](https://github.com/riuvshin))
- Disable PVC creation for che-multiuser master [\#9236](https://github.com/eclipse/che/pull/9236) ([akorneta](https://github.com/akorneta))
- Improve interaction between selenium tests and GitHub [\#9219](https://github.com/eclipse/che/pull/9219) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Make workspace expiration data persistent & shareable. [\#9142](https://github.com/eclipse/che/pull/9142) ([mshaposhnik](https://github.com/mshaposhnik))
- Selenium: Rework static classes "CommandsEditorType" and "CommandsMacrosLinkType" to enumerations [\#9256](https://github.com/eclipse/che/pull/9256) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- CHE-9095: Fix Theia start in case of first run of default assembly [\#9250](https://github.com/eclipse/che/pull/9250) ([mmorhun](https://github.com/mmorhun))
- Selenium: Add new methods to the "SeleniumWebDriverHelper" class [\#9249](https://github.com/eclipse/che/pull/9249) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: Update javadocs to actual state in the "CommandsEditor" class [\#9242](https://github.com/eclipse/che/pull/9242) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Allow overriding CHE props defined in che-config file [\#9240](https://github.com/eclipse/che/pull/9240) ([riuvshin](https://github.com/riuvshin))
- Selenium: fix switching to IDE frame from Dashboard [\#9239](https://github.com/eclipse/che/pull/9239) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix K8s Helm Chart [\#9230](https://github.com/eclipse/che/pull/9230) ([perspectivus1](https://github.com/perspectivus1))
- Add handler to clean up project config registry [\#9229](https://github.com/eclipse/che/pull/9229) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Fix File Watcher exclude feature [\#9227](https://github.com/eclipse/che/pull/9227) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Fix deployment che-multi on docker [\#9222](https://github.com/eclipse/che/pull/9222) ([riuvshin](https://github.com/riuvshin))
- Selenium: Delete not actual "known issue" from "editor" and "projectexplorer" test packages [\#9217](https://github.com/eclipse/che/pull/9217) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Add and use script for adding git hosted plugins into Theia image [\#9216](https://github.com/eclipse/che/pull/9216) ([mmorhun](https://github.com/mmorhun))
- ocp.sh clean up [\#9207](https://github.com/eclipse/che/pull/9207) ([riuvshin](https://github.com/riuvshin))
- Selenium: fix unstable selenium tests [\#9205](https://github.com/eclipse/che/pull/9205) ([SkorikSergey](https://github.com/SkorikSergey))
- Do not throw Exception when not project item is found in root [\#9193](https://github.com/eclipse/che/pull/9193) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Selenium: test SSH and Volumes tab on workspace details page [\#9189](https://github.com/eclipse/che/pull/9189) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: remove info about known issues from dashboard and miscellaneous packages [\#9188](https://github.com/eclipse/che/pull/9188) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix handling messages from Maven server after workspace restart [\#9187](https://github.com/eclipse/che/pull/9187) ([RomanNikitenko](https://github.com/RomanNikitenko))
- fix wait CHE pod in deploy script [\#9185](https://github.com/eclipse/che/pull/9185) ([riuvshin](https://github.com/riuvshin))
- hide "Users" menu item in left navbar when keycloack is used [\#9182](https://github.com/eclipse/che/pull/9182) ([akurinnoy](https://github.com/akurinnoy))
- make KC configuration before CHE start in case of deploy to OS [\#9181](https://github.com/eclipse/che/pull/9181) ([riuvshin](https://github.com/riuvshin))
- ocp.sh clean-up [\#9177](https://github.com/eclipse/che/pull/9177) ([riuvshin](https://github.com/riuvshin))
- Selenium: Inspect methods logic in the "CommandsEditor" pageobject [\#9174](https://github.com/eclipse/che/pull/9174) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Cleanup view before showing new results [\#9173](https://github.com/eclipse/che/pull/9173) ([vparfonov](https://github.com/vparfonov))
- Fix formatting rules [\#9172](https://github.com/eclipse/che/pull/9172) ([benoitf](https://github.com/benoitf))
- CHE-8675: fix reconnection to a WebSocket entrypoint [\#9170](https://github.com/eclipse/che/pull/9170) ([akurinnoy](https://github.com/akurinnoy))
- Do not redirect to UD requests intended to be for the API [\#9168](https://github.com/eclipse/che/pull/9168) ([garagatyi](https://github.com/garagatyi))
- Selenium: cover sharing workspaces in organization by selenium test [\#9167](https://github.com/eclipse/che/pull/9167) ([SkorikSergey](https://github.com/SkorikSergey))
- fix deploy\_che.sh ability to be launched from any place [\#9165](https://github.com/eclipse/che/pull/9165) ([riuvshin](https://github.com/riuvshin))
- CHE-9095: Improve Theia build stability on plugin list changes [\#9163](https://github.com/eclipse/che/pull/9163) ([mmorhun](https://github.com/mmorhun))
- Introduce logger REST API to manage log level at runtime [\#9161](https://github.com/eclipse/che/pull/9161) ([benoitf](https://github.com/benoitf))
- apply codeowners for deploy module [\#9160](https://github.com/eclipse/che/pull/9160) ([riuvshin](https://github.com/riuvshin))
- fix ocp.sh ability to be launched from any place [\#9159](https://github.com/eclipse/che/pull/9159) ([riuvshin](https://github.com/riuvshin))
- Fix TestGitHubRepository formatting [\#9153](https://github.com/eclipse/che/pull/9153) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Add indexes for reference side of foreign keys [\#9146](https://github.com/eclipse/che/pull/9146) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Selenium: Remove inheriting between "CodenvyEditor" and "CommandsEditor" [\#9144](https://github.com/eclipse/che/pull/9144) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Move deployment files out of dockerfiles folder [\#9143](https://github.com/eclipse/che/pull/9143) ([garagatyi](https://github.com/garagatyi))
- Encapsulate kohsuke-related code and ensure test repo creation [\#9141](https://github.com/eclipse/che/pull/9141) ([dmytro-ndp](https://github.com/dmytro-ndp))
- docker-compose: stop exposing postgres to external [\#9138](https://github.com/eclipse/che/pull/9138) ([ishitatsuyuki](https://github.com/ishitatsuyuki))
- Increase timeouts for debugger-related selenium tests to make them stable [\#9132](https://github.com/eclipse/che/pull/9132) ([dmytro-ndp](https://github.com/dmytro-ndp))
- che \#9062: Adding property for setting workspace pod termination grace period for Kubernetes / OpenShift infrastructures [\#9118](https://github.com/eclipse/che/pull/9118) ([ibuziuk](https://github.com/ibuziuk))
- Selenium: check that the IDE is loaded before switching to IDE application frame [\#9117](https://github.com/eclipse/che/pull/9117) ([SkorikSergey](https://github.com/SkorikSergey))
- RELEASE: Update CHANGELOG [\#9116](https://github.com/eclipse/che/pull/9116) ([riuvshin](https://github.com/riuvshin))
- Selenium: Update javadocs to actual state in the "CodenvyEditor" class [\#9115](https://github.com/eclipse/che/pull/9115) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Allow using --build-arg in build.sh scripts [\#9111](https://github.com/eclipse/che/pull/9111) ([riuvshin](https://github.com/riuvshin))
- Selenium: add info about known issue \#9100 to ProjectExplorer selenium page object [\#9102](https://github.com/eclipse/che/pull/9102) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: change method for expanding test project in CreateWorkspaceOnDashboardTest test [\#9101](https://github.com/eclipse/che/pull/9101) ([SkorikSergey](https://github.com/SkorikSergey))
- Cache node modules before rebuild Theia with selected plugins.  [\#9096](https://github.com/eclipse/che/pull/9096) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Do not duplicate Error/Warnings items in Preferences [\#9093](https://github.com/eclipse/che/pull/9093) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Don't publish ProjectCreatedEvent on importing arbitrary zipped resources [\#9092](https://github.com/eclipse/che/pull/9092) ([azatsarynnyy](https://github.com/azatsarynnyy))
- remove outdated s2i from init image [\#9089](https://github.com/eclipse/che/pull/9089) ([riuvshin](https://github.com/riuvshin))
- CHE-9067: Fix bug with git colors in editor tabs [\#9088](https://github.com/eclipse/che/pull/9088) ([vinokurig](https://github.com/vinokurig))
- Selenium: add checking that a workspace name is valid in RenameWorkspaceTest [\#9087](https://github.com/eclipse/che/pull/9087) ([SkorikSergey](https://github.com/SkorikSergey))
- Add catching known issue to the 'GitColorsTest' [\#9075](https://github.com/eclipse/che/pull/9075) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Unable to open Theia IDE [\#9073](https://github.com/eclipse/che/pull/9073) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- CHE-8752: Fix error when creating project inside existing folder [\#9072](https://github.com/eclipse/che/pull/9072) ([vinokurig](https://github.com/vinokurig))
- Support set-up Theia extension version. [\#9070](https://github.com/eclipse/che/pull/9070) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Add ability to exclude github-specific selenium tests from test execution [\#9069](https://github.com/eclipse/che/pull/9069) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Add new common methods in the 'SeleniumWebDriverHelper' class [\#9065](https://github.com/eclipse/che/pull/9065) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: Delete the 'try/catch' from selenium tests in the 'opendeclaration' package [\#9059](https://github.com/eclipse/che/pull/9059) ([artaleks9](https://github.com/artaleks9))
- Allow to use NULL in JDBC env vars [\#9047](https://github.com/eclipse/che/pull/9047) ([garagatyi](https://github.com/garagatyi))
- Make k8s internal runtime return k8s machines [\#9046](https://github.com/eclipse/che/pull/9046) ([garagatyi](https://github.com/garagatyi))
- Add authentication filters for websocket connections [\#9043](https://github.com/eclipse/che/pull/9043) ([mkuznyetsov](https://github.com/mkuznyetsov))
- RELEASE: Set next development version [\#9038](https://github.com/eclipse/che/pull/9038) ([riuvshin](https://github.com/riuvshin))
- Selenium: Inspect methods logic in the "CodenvyEditor" pageobject and rework it where it necessary [\#9031](https://github.com/eclipse/che/pull/9031) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Improve and rework the 'RevertCommitTest' to use the 'kohsuke Github library' [\#9030](https://github.com/eclipse/che/pull/9030) ([artaleks9](https://github.com/artaleks9))
- Allow to configure logback logger with env variables [\#8998](https://github.com/eclipse/che/pull/8998) ([skabashnyuk](https://github.com/skabashnyuk))
- K8s multiuser helm [\#8973](https://github.com/eclipse/che/pull/8973) ([guydaichs](https://github.com/guydaichs))
- Fix orion document changing event getting text from native orion event instead of guessing it [\#8942](https://github.com/eclipse/che/pull/8942) ([sunix](https://github.com/sunix))
- CHE-8557: No Dto available for FormattingOptions [\#8784](https://github.com/eclipse/che/pull/8784) ([jonahkichwacoders](https://github.com/jonahkichwacoders))
- Support alternate OIDC providers, to prepare for the switch from Keycloak to `fabric8\_auth`  [\#8650](https://github.com/eclipse/che/pull/8650) ([davidfestal](https://github.com/davidfestal))


## [6.2.0](https://github.com/eclipse/che/tree/6.2.0) (2018-03-07)
[Full Changelog](https://github.com/eclipse/che/compare/6.1.1...6.2.0)

**Merged pull requests:**

- RELEASE: Set next development version [\#9038](https://github.com/eclipse/che/pull/9038) ([riuvshin](https://github.com/riuvshin))
- CHE-9024: fix ability to start a workspace from Dashboard [\#9034](https://github.com/eclipse/che/pull/9034) ([akurinnoy](https://github.com/akurinnoy))
- Fix workspace details errors for UD [\#9027](https://github.com/eclipse/che/pull/9027) ([olexii4](https://github.com/olexii4))
-  Fix removal of inactive containers [\#9017](https://github.com/eclipse/che/pull/9017) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Add missed binding for MANAGE\_USERS system action [\#9011](https://github.com/eclipse/che/pull/9011) ([sleshchenko](https://github.com/sleshchenko))
- Upgrade php language server [\#9007](https://github.com/eclipse/che/pull/9007) ([vparfonov](https://github.com/vparfonov))
- Selenium: Improve and rework the 'FetchUpdatesAndMergeRemoteBranchIntoLocalTest' [\#9005](https://github.com/eclipse/che/pull/9005) ([artaleks9](https://github.com/artaleks9))
- Selenium: Update javadocs to actual state in the "SeleniumWebDriverHelper" class [\#9004](https://github.com/eclipse/che/pull/9004) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: open the New Workspace page before each test method in CreateWorkspaceTest test [\#9003](https://github.com/eclipse/che/pull/9003) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-8571 add UD permissive to unknown recipe types which are supported by the server side. [\#9002](https://github.com/eclipse/che/pull/9002) ([olexii4](https://github.com/olexii4))
- Restore Che5 factory behavior. [\#9000](https://github.com/eclipse/che/pull/9000) ([skabashnyuk](https://github.com/skabashnyuk))
- Selenium: Add new methods to the "SeleniumWebDriverHelper" class [\#8995](https://github.com/eclipse/che/pull/8995) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: remove info about known issue from NavigateToFileTest test [\#8994](https://github.com/eclipse/che/pull/8994) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Rework methods from "CodenvyEditor" page object with using "SeleniumWebDriverHelper" and "WebDriverWaitFactory" classes [\#8980](https://github.com/eclipse/che/pull/8980) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: Transform locators from "CodenvyEditor" page object to enumerations and rework related methods [\#8961](https://github.com/eclipse/che/pull/8961) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: fix expected values list in NavigateToFileTest test [\#8949](https://github.com/eclipse/che/pull/8949) ([SkorikSergey](https://github.com/SkorikSergey))
- Rename docker connector configuration properties [\#8948](https://github.com/eclipse/che/pull/8948) ([mkuznyetsov](https://github.com/mkuznyetsov))
- fix an error when adding a new workspace [\#8938](https://github.com/eclipse/che/pull/8938) ([olexii4](https://github.com/olexii4))
- Fix unexpected removal/stop of test workspace in factory-related selenium tests [\#8934](https://github.com/eclipse/che/pull/8934) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Selenium: add info about known issue \#8931 in WorkspaceProjects page object [\#8932](https://github.com/eclipse/che/pull/8932) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: remove project state checking after workspace restarting from ProjectStateAfterRefreshTest test [\#8930](https://github.com/eclipse/che/pull/8930) ([SkorikSergey](https://github.com/SkorikSergey))
- Do not add hidden items to project registry [\#8928](https://github.com/eclipse/che/pull/8928) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Avoid not needed encoding [\#8927](https://github.com/eclipse/che/pull/8927) ([vparfonov](https://github.com/vparfonov))
- Add ability storing of webdriver console and network logs after failing tests [\#8926](https://github.com/eclipse/che/pull/8926) ([musienko-maxim](https://github.com/musienko-maxim))
- Fix context propagation for bootstrap and server checks [\#8924](https://github.com/eclipse/che/pull/8924) ([akorneta](https://github.com/akorneta))
- CHE-8909 fix bug with adding a new machine with the needed name [\#8919](https://github.com/eclipse/che/pull/8919) ([olexii4](https://github.com/olexii4))
- Selenium: test Navigate To File feature using '\*' and '?' characters in search bar [\#8918](https://github.com/eclipse/che/pull/8918) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: cover working with factories on the Dashboard by selenium tests  [\#8917](https://github.com/eclipse/che/pull/8917) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-8544 fix user's workspaces visibility [\#8916](https://github.com/eclipse/che/pull/8916) ([olexii4](https://github.com/olexii4))
- Fix che.workspace.auto\_start property not returning from workspace service [\#8913](https://github.com/eclipse/che/pull/8913) ([mkuznyetsov](https://github.com/mkuznyetsov))
- replace duplicate env var with check if it's defined [\#8912](https://github.com/eclipse/che/pull/8912) ([riuvshin](https://github.com/riuvshin))
- Remove outdated plugin [\#8911](https://github.com/eclipse/che/pull/8911) ([mshaposhnik](https://github.com/mshaposhnik))
- Remove unsupported ls on Mac [\#8908](https://github.com/eclipse/che/pull/8908) ([eivantsov](https://github.com/eivantsov))
- Fix displaying Pull Request Panel [\#8905](https://github.com/eclipse/che/pull/8905) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Fix key press handling in some cases [\#8901](https://github.com/eclipse/che/pull/8901) ([vparfonov](https://github.com/vparfonov))
- Add fmt:format and sortpom:sort [\#8899](https://github.com/eclipse/che/pull/8899) ([gausa](https://github.com/gausa))
- eliminate kc-util image [\#8896](https://github.com/eclipse/che/pull/8896) ([riuvshin](https://github.com/riuvshin))
- Fix switching parts layout [\#8895](https://github.com/eclipse/che/pull/8895) ([azatsarynnyy](https://github.com/azatsarynnyy))
- Remove redundant import from the TestWorkspaceLogsReaderTest [\#8894](https://github.com/eclipse/che/pull/8894) ([dmytro-ndp](https://github.com/dmytro-ndp))
- fix new images build outside it's directory [\#8893](https://github.com/eclipse/che/pull/8893) ([riuvshin](https://github.com/riuvshin))
- Allow configuring the dispatcher and connection pool of the `KubernetesClient` shared underlying http client. [\#8892](https://github.com/eclipse/che/pull/8892) ([davidfestal](https://github.com/davidfestal))
- set correct version for image traefik in 6.1.0 [\#8890](https://github.com/eclipse/che/pull/8890) ([riuvshin](https://github.com/riuvshin))
- Buffer input file change events and disable file tracking during git reset [\#8889](https://github.com/eclipse/che/pull/8889) ([vzhukovskii](https://github.com/vzhukovskii))
- set correct version for image traefik in 6.2.0 [\#8887](https://github.com/eclipse/che/pull/8887) ([riuvshin](https://github.com/riuvshin))
- Print selenium test statistics in log during execution [\#8883](https://github.com/eclipse/che/pull/8883) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Selenium: Rework the 'WorkingWithPullConflictsTest' related to \#8832 [\#8882](https://github.com/eclipse/che/pull/8882) ([artaleks9](https://github.com/artaleks9))
- Reset showInheritedMembers flag on each action calls [\#8879](https://github.com/eclipse/che/pull/8879) ([vparfonov](https://github.com/vparfonov))
- Fix creation of test users for selenium testing [\#8878](https://github.com/eclipse/che/pull/8878) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Improve functionality of identity provider token retrieval [\#8873](https://github.com/eclipse/che/pull/8873) ([mshaposhnik](https://github.com/mshaposhnik))
- Remove declaration of unused properties & environment variables [\#8872](https://github.com/eclipse/che/pull/8872) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Selenium: add AddWorkspaceToOrganizationTest selenium test to MULTIUSER tests group [\#8869](https://github.com/eclipse/che/pull/8869) ([SkorikSergey](https://github.com/SkorikSergey))
- Fixed missing header file extensions for C and C++ languages [\#8866](https://github.com/eclipse/che/pull/8866) ([dkuleshov](https://github.com/dkuleshov))
- Selenium: Rework "ProjectExplorer" page object with "SeleniumWebDriverHelper" and "WebDriverWaitFactory" [\#8865](https://github.com/eclipse/che/pull/8865) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: add info about known issue to WorkingWithTerminalTest test [\#8862](https://github.com/eclipse/che/pull/8862) ([SkorikSergey](https://github.com/SkorikSergey))
- Adding Eclipse Che to SonarCloud.io for getting reports [\#8861](https://github.com/eclipse/che/pull/8861) ([riuvshin](https://github.com/riuvshin))
- Selenium: Change the \#8031 on the \#8856 in the 'try/catch' block [\#8860](https://github.com/eclipse/che/pull/8860) ([artaleks9](https://github.com/artaleks9))
- Selenium: add AddWorkspaceToOrganizationTest selenium test to tests suite [\#8855](https://github.com/eclipse/che/pull/8855) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix code formatting [\#8853](https://github.com/eclipse/che/pull/8853) ([mshaposhnik](https://github.com/mshaposhnik))
- Selenium: change method for expanding test projects in ResolveDependencyAfterRecreateProjectTest test [\#8851](https://github.com/eclipse/che/pull/8851) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Change "quickExpandWithJavaScript" to "expandPathInProjectExplorer" method in the "CreateNewPackagesWithHelpCreationJavaClassTest" selenium test for increasing stability [\#8845](https://github.com/eclipse/che/pull/8845) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Perform liveness checks of wsagent by dedicated URL [\#8844](https://github.com/eclipse/che/pull/8844) ([mshaposhnik](https://github.com/mshaposhnik))
- Catch  \#8616 issue to the DirectUrlFactoryWithSpecificBranch test [\#8843](https://github.com/eclipse/che/pull/8843) ([musienko-maxim](https://github.com/musienko-maxim))
- Selenium: add selenium test to cover creating of workspaces for organizations  [\#8842](https://github.com/eclipse/che/pull/8842) ([SkorikSergey](https://github.com/SkorikSergey))
- Workspace loader [\#8838](https://github.com/eclipse/che/pull/8838) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- Support Compose memory limit byte units [\#8837](https://github.com/eclipse/che/pull/8837) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Make start of OpenShift machines parallel [\#8836](https://github.com/eclipse/che/pull/8836) ([akorneta](https://github.com/akorneta))
- Selenium: Rework "ProjectExplorer\#openItemByPath\(\)" method for working with already expanded project explorer tree and fix related selenium tests [\#8835](https://github.com/eclipse/che/pull/8835) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- CHE CLI: Space in NO\_PROXY leads to failed startup [\#8834](https://github.com/eclipse/che/pull/8834) ([riuvshin](https://github.com/riuvshin))
- Selenium: change method to get a number of root organizations [\#8833](https://github.com/eclipse/che/pull/8833) ([SkorikSergey](https://github.com/SkorikSergey))
- Use runAsync instead of supplyAsync in downloader [\#8830](https://github.com/eclipse/che/pull/8830) ([mshaposhnik](https://github.com/mshaposhnik))
- Revert "Fix orion document changing event getting text from native orion event instead of guessing it" [\#8823](https://github.com/eclipse/che/pull/8823) ([vparfonov](https://github.com/vparfonov))
- Store logs and test workspace state in CheckFactoryWithPerUserCreatePolicyTest [\#8820](https://github.com/eclipse/che/pull/8820) ([musienko-maxim](https://github.com/musienko-maxim))
- Replace s2i based deployment approach with pure deployments [\#8819](https://github.com/eclipse/che/pull/8819) ([eivantsov](https://github.com/eivantsov))
- fix CLI ENV vars setting / overriding [\#8818](https://github.com/eclipse/che/pull/8818) ([riuvshin](https://github.com/riuvshin))
- \[dashboard\] Avoid the usage of ng-annotate which slow down the build [\#8813](https://github.com/eclipse/che/pull/8813) ([benoitf](https://github.com/benoitf))
- set correct version in newly contributed plugin [\#8807](https://github.com/eclipse/che/pull/8807) ([riuvshin](https://github.com/riuvshin))
- Make CHE 6 multi-tenant compatible for OSIO [\#8805](https://github.com/eclipse/che/pull/8805) ([davidfestal](https://github.com/davidfestal))
- Fix displaying the editor annotations for the corresponding diagnostics notifications [\#8804](https://github.com/eclipse/che/pull/8804) ([azatsarynnyy](https://github.com/azatsarynnyy))
- Save meaningful logs of failed tests workspaces in the target directory [\#8803](https://github.com/eclipse/che/pull/8803) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Add ability found artifacts in repositories described in pom.xml [\#8801](https://github.com/eclipse/che/pull/8801) ([vparfonov](https://github.com/vparfonov))
- Selenium: Apply expand project tree by native clicks in the selenium tests related with bug "\#7161" for increase stability [\#8797](https://github.com/eclipse/che/pull/8797) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: remove unnecessary steps from CreateWorkspaceOnDashboardTest selenium test [\#8796](https://github.com/eclipse/che/pull/8796) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix incorrect usage of k8s property in openshift infra [\#8795](https://github.com/eclipse/che/pull/8795) ([garagatyi](https://github.com/garagatyi))
- Selenium: add info about known issue [\#8794](https://github.com/eclipse/che/pull/8794) ([SkorikSergey](https://github.com/SkorikSergey))
- RELEASE: Update CHANGELOG [\#8790](https://github.com/eclipse/che/pull/8790) ([riuvshin](https://github.com/riuvshin))
- Added a meaningful error message when OAuth token has expired or credentials are incorrect [\#8787](https://github.com/eclipse/che/pull/8787) ([sleshchenko](https://github.com/sleshchenko))
- Preserve active part while switching parts layout [\#8783](https://github.com/eclipse/che/pull/8783) ([azatsarynnyy](https://github.com/azatsarynnyy))
- Fix Command Editor initialization after saving a command [\#8781](https://github.com/eclipse/che/pull/8781) ([azatsarynnyy](https://github.com/azatsarynnyy))
- Selenium: Add catch browser logs in the selenium tests from 'opendeclaration' package for investigating "\#8122" bug [\#8780](https://github.com/eclipse/che/pull/8780) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- RELEASE: Set next development version [\#8773](https://github.com/eclipse/che/pull/8773) ([riuvshin](https://github.com/riuvshin))
- Selenium: Catch issue \#7161 in 'ShowHintsCommandTest' selenium test [\#8772](https://github.com/eclipse/che/pull/8772) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Thread-unsafe collections used for subscription contexts [\#8767](https://github.com/eclipse/che/pull/8767) ([dkuleshov](https://github.com/dkuleshov))
- CHE-8575: Do not show .che folder in project explorer [\#8758](https://github.com/eclipse/che/pull/8758) ([vinokurig](https://github.com/vinokurig))
- Fix orion document changing event getting text from native orion event instead of guessing it [\#8753](https://github.com/eclipse/che/pull/8753) ([sunix](https://github.com/sunix))
- Enabe parallel pull of images in docker infra [\#8748](https://github.com/eclipse/che/pull/8748) ([mshaposhnik](https://github.com/mshaposhnik))
- Theia docker file with launcher script  [\#8732](https://github.com/eclipse/che/pull/8732) ([evidolob](https://github.com/evidolob))
- Remove exec/terminal agents from dependencies of ws-agent [\#8717](https://github.com/eclipse/che/pull/8717) ([skabashnyuk](https://github.com/skabashnyuk))
- Initial support for deploying Che to Kubernetes using Helm charts [\#8715](https://github.com/eclipse/che/pull/8715) ([perspectivus1](https://github.com/perspectivus1))
- Fix machine token generation on workspace start [\#8710](https://github.com/eclipse/che/pull/8710) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Implement matching of a machine to OpenShift container by pod annotations [\#8560](https://github.com/eclipse/che/pull/8560) ([olexii4](https://github.com/olexii4))

## [6.1.1](https://github.com/eclipse/che/tree/6.1.1) (2018-02-26)
[Full Changelog](https://github.com/eclipse/che/compare/5.22.2...6.1.1)

**Merged pull requests:**

- Uploading zip file corrupts file [\#8800](https://github.com/eclipse/che/pull/8800) ([dkuleshov](https://github.com/dkuleshov))

## [5.22.2](https://github.com/eclipse/che/tree/5.22.2) (2018-02-22)
[Full Changelog](https://github.com/eclipse/che/compare/6.1.0...5.22.2)

**Merged pull requests:**

- Set up default file encoding to utf8 in workspace agent configuration [\#8814](https://github.com/eclipse/che/pull/8814) ([vzhukovskii](https://github.com/vzhukovskii))


## [6.1.0](https://github.com/eclipse/che/tree/6.1.0) (2018-02-14)
[Full Changelog](https://github.com/eclipse/che/compare/6.0.0...6.1.0)

**Merged pull requests:**

- RELEASE: Set next development version [\#8773](https://github.com/eclipse/che/pull/8773) ([riuvshin](https://github.com/riuvshin))
- Selenium: Catch issue \#7161 in 'ShowHintsCommandTest' selenium test [\#8772](https://github.com/eclipse/che/pull/8772) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Fix orion document changing event getting text from native orion event instead of guessing it [\#8753](https://github.com/eclipse/che/pull/8753) ([sunix](https://github.com/sunix))
- Selenium: Add extra steps in the 'prepare\(\)' to increase stability [\#8550](https://github.com/eclipse/che/pull/8550) ([artaleks9](https://github.com/artaleks9))
- Add back primary style for start workspace button [\#8764](https://github.com/eclipse/che/pull/8764) ([vzhukovskii](https://github.com/vzhukovskii))
- Fix displaying pull request panel [\#8760](https://github.com/eclipse/che/pull/8760) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Add different style for focusable element [\#8757](https://github.com/eclipse/che/pull/8757) ([vzhukovskii](https://github.com/vzhukovskii))
- Selenium: increase timeout to check that a menu item is enabled [\#8755](https://github.com/eclipse/che/pull/8755) ([SkorikSergey](https://github.com/SkorikSergey))
- Support enter press in refactoring rename form [\#8754](https://github.com/eclipse/che/pull/8754) ([vzhukovskii](https://github.com/vzhukovskii))
- Selenium: Add most common methods to the "SeleniumWebDriverHelper" [\#8746](https://github.com/eclipse/che/pull/8746) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: change a way for selecting an element from suggestions list [\#8736](https://github.com/eclipse/che/pull/8736) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix formatting issue [\#8730](https://github.com/eclipse/che/pull/8730) ([vzhukovskii](https://github.com/vzhukovskii))
- Disable pre-creating of PVC subpaths on minikube [\#8726](https://github.com/eclipse/che/pull/8726) ([sleshchenko](https://github.com/sleshchenko))
- Selenium: wait opened workspace is ready to use [\#8725](https://github.com/eclipse/che/pull/8725) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Update CheckErrorMessageWhenCreationDuplicateFolderOrFileTest for increasing stability [\#8722](https://github.com/eclipse/che/pull/8722) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Increase postgres claim for OpenShift to be 1gb [\#8709](https://github.com/eclipse/che/pull/8709) ([gshipley](https://github.com/gshipley))
- Selenium: Delete the 'Assert.fail\(\)' from the selenium tests after resolve related issues [\#8706](https://github.com/eclipse/che/pull/8706) ([artaleks9](https://github.com/artaleks9))
- Selenium: Store list of external libraries, project type and project language for investigate \#7161 bug [\#8696](https://github.com/eclipse/che/pull/8696) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: Fix unexpected fail of CheckBasicFunctionalityInCommandsExplorerTest selenium test [\#8692](https://github.com/eclipse/che/pull/8692) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: Add wait of visibility git markers web-elements in the page object 'CodenvyEditor' [\#8691](https://github.com/eclipse/che/pull/8691) ([artaleks9](https://github.com/artaleks9))
- \[WIP\] CHE-8365: Fix opening empty files when soft wrap options is activated in editor [\#8686](https://github.com/eclipse/che/pull/8686) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Selenium: Create new class 'WebDriverWaitFactory' [\#8685](https://github.com/eclipse/che/pull/8685) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Catch issues \#8671, \#8667 in selenium tests of org.eclipse.che.selenium.factory package [\#8684](https://github.com/eclipse/che/pull/8684) ([musienko-maxim](https://github.com/musienko-maxim))
- Selenium: check that suggestions list of Navigate To File widget is visible [\#8683](https://github.com/eclipse/che/pull/8683) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: increase timeout for checking workspace statuses on Workspaces list [\#8681](https://github.com/eclipse/che/pull/8681) ([SkorikSergey](https://github.com/SkorikSergey))
- Catch issue \#8468 in the ProjectExplorer page-object [\#8680](https://github.com/eclipse/che/pull/8680) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: wait that all notifications are closed before deleting project in CreateAndDeleteProjectsTest test [\#8676](https://github.com/eclipse/che/pull/8676) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: add info about known issue to RenameOrganizationTest [\#8670](https://github.com/eclipse/che/pull/8670) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix perspective initialization in case switching perspective [\#8664](https://github.com/eclipse/che/pull/8664) ([vparfonov](https://github.com/vparfonov))
- Selenium: Catch issue \#7161 in the AutocompleteProposalJavaDocTest selenium test [\#8663](https://github.com/eclipse/che/pull/8663) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: Remove extra steps from SplitEditorFeatureTest selenium test [\#8662](https://github.com/eclipse/che/pull/8662) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: Change locator for editor tab with unsaved status [\#8660](https://github.com/eclipse/che/pull/8660) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Fix failed build [\#8658](https://github.com/eclipse/che/pull/8658) ([vparfonov](https://github.com/vparfonov))
- che-7246: fix fetch available RAM on workspace creation [\#8657](https://github.com/eclipse/che/pull/8657) ([ashumilova](https://github.com/ashumilova))
- Fix webapp startup  if no docker IP's set. [\#8655](https://github.com/eclipse/che/pull/8655) ([mshaposhnik](https://github.com/mshaposhnik))
- Selenium: wait that a found files list in the Navigate To File widget is changed [\#8654](https://github.com/eclipse/che/pull/8654) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-8031: Add waiting watcher for default service account [\#8653](https://github.com/eclipse/che/pull/8653) ([akorneta](https://github.com/akorneta))
- Cleaning MDC at the end of the request [\#8649](https://github.com/eclipse/che/pull/8649) ([sunix](https://github.com/sunix))
- Introduce Apache Camel LSP support [\#8648](https://github.com/eclipse/che/pull/8648) ([benoitf](https://github.com/benoitf))
- Selenium: Add logs with catched libraries, project type and language for investigate bug [\#8642](https://github.com/eclipse/che/pull/8642) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: fix unstable CheckStopStartWsTest selenium test [\#8640](https://github.com/eclipse/che/pull/8640) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: remove info about known issue from organization selenium tests [\#8639](https://github.com/eclipse/che/pull/8639) ([SkorikSergey](https://github.com/SkorikSergey))
- Property rename: old value to new support [\#8636](https://github.com/eclipse/che/pull/8636) ([skabashnyuk](https://github.com/skabashnyuk))
- Selenium: Add steps for switch focus to another element in the CheckRestoringSplitEditorTest selenium test [\#8635](https://github.com/eclipse/che/pull/8635) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: Refactor methods in the TestProjectServiceClient page objects [\#8633](https://github.com/eclipse/che/pull/8633) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Add permissions for default admin to manage his profile [\#8630](https://github.com/eclipse/che/pull/8630) ([mshaposhnik](https://github.com/mshaposhnik))
- Fixes machine row when there are no installers [\#8627](https://github.com/eclipse/che/pull/8627) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- Reorganize Project-\>New menu [\#8621](https://github.com/eclipse/che/pull/8621) ([vzhukovskii](https://github.com/vzhukovskii))
- Dashboard: fix list of workspaces on Workspaces page [\#8620](https://github.com/eclipse/che/pull/8620) ([akurinnoy](https://github.com/akurinnoy))
- Selenium: Add the 'WaitUtils.sleepQuietly' to the page object 'Preferences' [\#8619](https://github.com/eclipse/che/pull/8619) ([artaleks9](https://github.com/artaleks9))
- Add selecting and waiting PR widget for avoiding unstable the tests for factory package [\#8618](https://github.com/eclipse/che/pull/8618) ([musienko-maxim](https://github.com/musienko-maxim))
- Fix singleport mode in multiuser [\#8615](https://github.com/eclipse/che/pull/8615) ([mshaposhnik](https://github.com/mshaposhnik))
- Add informative messages to the loaders it will helpful for error det… [\#8613](https://github.com/eclipse/che/pull/8613) ([vparfonov](https://github.com/vparfonov))
- CHE-7278 Properly handle restarting the workspace [\#8612](https://github.com/eclipse/che/pull/8612) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- Directory created from terminal doesn't appear in project explorer root  [\#8610](https://github.com/eclipse/che/pull/8610) ([dkuleshov](https://github.com/dkuleshov))
- Selenium: change info about know issue in selenium tests [\#8608](https://github.com/eclipse/che/pull/8608) ([SkorikSergey](https://github.com/SkorikSergey))
- Allow calling system state method for anonymous user [\#8607](https://github.com/eclipse/che/pull/8607) ([skabashnyuk](https://github.com/skabashnyuk))
- Increase CHE boot timeout in deploy\_che.sh [\#8605](https://github.com/eclipse/che/pull/8605) ([riuvshin](https://github.com/riuvshin))
- Dashboard: fix editor styles in "Build stack from recipe" widget  [\#8602](https://github.com/eclipse/che/pull/8602) ([akurinnoy](https://github.com/akurinnoy))
- Dashboard: fix closing the popup window on Create Workspace page [\#8601](https://github.com/eclipse/che/pull/8601) ([akurinnoy](https://github.com/akurinnoy))
- Theia stacks from Florent's theia  prototype  [\#8600](https://github.com/eclipse/che/pull/8600) ([skabashnyuk](https://github.com/skabashnyuk))
- Fixes for styles and error handling [\#8599](https://github.com/eclipse/che/pull/8599) ([ashumilova](https://github.com/ashumilova))
- Fix formatting [\#8592](https://github.com/eclipse/che/pull/8592) ([vparfonov](https://github.com/vparfonov))
- Selenium: Fix unexpected fail of CheckErrorsWarningsTabTest in the selenium tests [\#8591](https://github.com/eclipse/che/pull/8591) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: change scroll testing in the Terminal [\#8588](https://github.com/eclipse/che/pull/8588) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Add checking the visibility of the web-element in the 'ProjectSourcePage' [\#8587](https://github.com/eclipse/che/pull/8587) ([artaleks9](https://github.com/artaleks9))
- Selenium: Remove logging of preferences from "CheckRestoringSplitEditorTest" selenium test [\#8586](https://github.com/eclipse/che/pull/8586) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Copy MDC context in workspace runtime \(start stop\) related async tasks [\#8585](https://github.com/eclipse/che/pull/8585) ([sunix](https://github.com/sunix))
- Selenium: check that a menu item is enabled [\#8584](https://github.com/eclipse/che/pull/8584) ([SkorikSergey](https://github.com/SkorikSergey))
- Handling project removing event and refresh command list [\#8582](https://github.com/eclipse/che/pull/8582) ([vparfonov](https://github.com/vparfonov))
- Command Explorer UI improvements [\#8581](https://github.com/eclipse/che/pull/8581) ([vzhukovskii](https://github.com/vzhukovskii))
- Dashboard: update list of namespaces after list of organizations is updated [\#8579](https://github.com/eclipse/che/pull/8579) ([akurinnoy](https://github.com/akurinnoy))
- Selenium: Add ability to check project type and language, and get list of external libraries [\#8577](https://github.com/eclipse/che/pull/8577) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: Delete the 'loader.waitOnClosed\(\)' from the page object 'Preferences'  [\#8576](https://github.com/eclipse/che/pull/8576) ([artaleks9](https://github.com/artaleks9))
- Selenium: change locator for Edit button in the Account page [\#8570](https://github.com/eclipse/che/pull/8570) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: adapt selenium test for testing workspace after workspace agent is shut down [\#8567](https://github.com/eclipse/che/pull/8567) ([SkorikSergey](https://github.com/SkorikSergey))
- Prompt to generate ssh key at import private repo from github [\#8564](https://github.com/eclipse/che/pull/8564) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Protect installer service modifying methods with permissions [\#8563](https://github.com/eclipse/che/pull/8563) ([mshaposhnik](https://github.com/mshaposhnik))
- Selenium: Delete the 'loader.waitOnClosed\(\)' from the page object 'Preferences' [\#8562](https://github.com/eclipse/che/pull/8562) ([artaleks9](https://github.com/artaleks9))
- Selenium: adapt selenium tests according to changes with workspace config updating [\#8561](https://github.com/eclipse/che/pull/8561) ([SkorikSergey](https://github.com/SkorikSergey))
- Added kubernetes infrastructure [\#8559](https://github.com/eclipse/che/pull/8559) ([sleshchenko](https://github.com/sleshchenko))
- Remove obsolete script [\#8558](https://github.com/eclipse/che/pull/8558) ([riuvshin](https://github.com/riuvshin))
- rh-che \#500:  Adding 'che.workspace.server.ping\_success\_threshold' property for server checker and liveness probe configuration. [\#8551](https://github.com/eclipse/che/pull/8551) ([ibuziuk](https://github.com/ibuziuk))
- Errors in the browser console when importing the eclipse-che project [\#8549](https://github.com/eclipse/che/pull/8549) ([dkuleshov](https://github.com/dkuleshov))
- Fix docs link. Dash instead underscore [\#8548](https://github.com/eclipse/che/pull/8548) ([eivantsov](https://github.com/eivantsov))
- Add blocks in typical places for investigation problem from the \[CHE-8105\] issue [\#8546](https://github.com/eclipse/che/pull/8546) ([musienko-maxim](https://github.com/musienko-maxim))
- Fix displaying of list of organizations for GitHub account [\#8540](https://github.com/eclipse/che/pull/8540) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Prevents displaying installers with empty names and descriptions [\#8536](https://github.com/eclipse/che/pull/8536) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- Provide machine logs volume and configuration of logs root path [\#8535](https://github.com/eclipse/che/pull/8535) ([akorneta](https://github.com/akorneta))
- Dashboard: fix list of organizations for system administrator [\#8533](https://github.com/eclipse/che/pull/8533) ([akurinnoy](https://github.com/akurinnoy))
- \#8509 handle keybinding inside FileStructure Window [\#8528](https://github.com/eclipse/che/pull/8528) ([evidolob](https://github.com/evidolob))
- Dashboard: allow to update workspace config without workpace restarting [\#8505](https://github.com/eclipse/che/pull/8505) ([akurinnoy](https://github.com/akurinnoy))
- RELEASE: Set next development version [\#8496](https://github.com/eclipse/che/pull/8496) ([riuvshin](https://github.com/riuvshin))
- Bug with closing tabs in processes panel [\#8491](https://github.com/eclipse/che/pull/8491) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- Refactored Window class [\#8374](https://github.com/eclipse/che/pull/8374) ([vzhukovskii](https://github.com/vzhukovskii))
- LuceneSearcher redesign and fix memory leak [\#8112](https://github.com/eclipse/che/pull/8112) ([skabashnyuk](https://github.com/skabashnyuk))
- Fix internal policy of event.Bus events publishing [\#8110](https://github.com/eclipse/che/pull/8110) ([voievodin](https://github.com/voievodin))
- Refine underline style when tab marked with error or warning [\#7862](https://github.com/eclipse/che/pull/7862) ([vzhukovskii](https://github.com/vzhukovskii))

## [6.0.0](https://github.com/eclipse/che/tree/6.0.0) (2018-01-31)
[Full Changelog](https://github.com/eclipse/che/compare/5.22.1...6.0.0)

**Merged pull requests:**

- Renew URLs of CI servers to compare local selenium testing results [\#8541](https://github.com/eclipse/che/pull/8541) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Factories links [\#8530](https://github.com/eclipse/che/pull/8530) ([eivantsov](https://github.com/eivantsov))
- Improves debug panel, fixes UI of configure breakpoints popup [\#8520](https://github.com/eclipse/che/pull/8520) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- CHE-7555 fix resolve factory flow [\#8519](https://github.com/eclipse/che/pull/8519) ([olexii4](https://github.com/olexii4))
- Selenium: Fix unexpected fail of AutocompleteWithInheritTest selenium test  [\#8518](https://github.com/eclipse/che/pull/8518) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: add info about known issue to FileStructureBaseOperationTest selenium test  [\#8513](https://github.com/eclipse/che/pull/8513) ([SkorikSergey](https://github.com/SkorikSergey))
- Add a comment about using $entry function [\#8511](https://github.com/eclipse/che/pull/8511) ([vzhukovskii](https://github.com/vzhukovskii))
- Remove redundant check if webdriver session can be created [\#8506](https://github.com/eclipse/che/pull/8506) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Selenium: Change timeout in the page object 'ProjectSourcePage' [\#8503](https://github.com/eclipse/che/pull/8503) ([artaleks9](https://github.com/artaleks9))
- Selenium: Add ability to catch Chrome browser`s console logs [\#8502](https://github.com/eclipse/che/pull/8502) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Fix of steps sequence for the DebuggerWatchExpressionTest [\#8500](https://github.com/eclipse/che/pull/8500) ([musienko-maxim](https://github.com/musienko-maxim))
- Selenium: add info about known issue to NavigationBar selenium page object [\#8499](https://github.com/eclipse/che/pull/8499) ([SkorikSergey](https://github.com/SkorikSergey))
- add CLI version 6.0.0 [\#8494](https://github.com/eclipse/che/pull/8494) ([riuvshin](https://github.com/riuvshin))
- Selenium: Change expected number of process and remove try/catch block with known issue [\#8493](https://github.com/eclipse/che/pull/8493) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: change test scenario in CreateWorkspaceOnDashboardTest test [\#8485](https://github.com/eclipse/che/pull/8485) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Add changes in the methods of checking git-marker in the page object 'CodenvyEditor' [\#8484](https://github.com/eclipse/che/pull/8484) ([artaleks9](https://github.com/artaleks9))
- Selenium: change info about known issue in NavigateToFileTest test [\#8483](https://github.com/eclipse/che/pull/8483) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix error handlers for load factory flow [\#8482](https://github.com/eclipse/che/pull/8482) ([olexii4](https://github.com/olexii4))
- Avoid removal of non-test workspaces at the cleanup environment stage of selenium testing [\#8481](https://github.com/eclipse/che/pull/8481) ([dmytro-ndp](https://github.com/dmytro-ndp))
- CHE-6923: Provide more space for committer fields in Preferences dialog. [\#8480](https://github.com/eclipse/che/pull/8480) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Improved context menus [\#8477](https://github.com/eclipse/che/pull/8477) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- init and cli images should not use tag from CHE [\#8474](https://github.com/eclipse/che/pull/8474) ([riuvshin](https://github.com/riuvshin))
- \#6331 disable key binding handle when any 'Window' opened [\#8473](https://github.com/eclipse/che/pull/8473) ([evidolob](https://github.com/evidolob))
- Restore support of single-port Che mode \(on docker infra\) [\#8471](https://github.com/eclipse/che/pull/8471) ([mshaposhnik](https://github.com/mshaposhnik))
- Apply formating for CreateNewPackagesWithHelpCreationJavaClassTest [\#8464](https://github.com/eclipse/che/pull/8464) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Remove read 'preferences' from try/catch block in CreateNewPackagesWithHelpCreationJavaClassTest selenium test [\#8463](https://github.com/eclipse/che/pull/8463) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- CHE-8240: Switch to project explorer tab for reavel resources action. [\#8460](https://github.com/eclipse/che/pull/8460) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Selenium: Fix unexpected fail of CheckAutocompleteFeaturesInTheTestFolderTest selenium test [\#8457](https://github.com/eclipse/che/pull/8457) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: Add try/catch block for displaying "Known issue" with \#8300 bug [\#8454](https://github.com/eclipse/che/pull/8454) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Change PVC name provisioning to prefix + generating 8 chars [\#8453](https://github.com/eclipse/che/pull/8453) ([akorneta](https://github.com/akorneta))
- Selenium: add info about known issue to FileStructureNodesTest selenium test [\#8452](https://github.com/eclipse/che/pull/8452) ([SkorikSergey](https://github.com/SkorikSergey))
- openshift.io \#2022: Missing goals for wildfly build / run commands [\#8450](https://github.com/eclipse/che/pull/8450) ([ibuziuk](https://github.com/ibuziuk))
- Fix formatting [\#8447](https://github.com/eclipse/che/pull/8447) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- Fix style [\#8446](https://github.com/eclipse/che/pull/8446) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- Fix formatting [\#8445](https://github.com/eclipse/che/pull/8445) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- Selenium: change locator for documentation link on the Dashboard [\#8443](https://github.com/eclipse/che/pull/8443) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Fix unexpected fail of MacrosCommandsEditorTest selenium test [\#8441](https://github.com/eclipse/che/pull/8441) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Fix typo [\#8437](https://github.com/eclipse/che/pull/8437) ([vzhukovskii](https://github.com/vzhukovskii))
- Selenium: increase timeout for checking that a workspace name is not visible in the Workspaces list after deleting [\#8432](https://github.com/eclipse/che/pull/8432) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: remove info about known issue from OrganizationMembersTest selenium test  [\#8431](https://github.com/eclipse/che/pull/8431) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: add info about known issue into ProjectStateAfterRefreshTest selenium test  [\#8430](https://github.com/eclipse/che/pull/8430) ([SkorikSergey](https://github.com/SkorikSergey))
- Remove stopping test workspace [\#8427](https://github.com/eclipse/che/pull/8427) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Move GitCompareTest to one thread tests suite [\#8426](https://github.com/eclipse/che/pull/8426) ([dmytro-ndp](https://github.com/dmytro-ndp))
- CHE-7581 Improved keycloak initialization [\#8425](https://github.com/eclipse/che/pull/8425) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- Update docs links [\#8424](https://github.com/eclipse/che/pull/8424) ([eivantsov](https://github.com/eivantsov))
- Rework default memory limit setting [\#8422](https://github.com/eclipse/che/pull/8422) ([garagatyi](https://github.com/garagatyi))
- CHE-4927 fix light theme colors [\#8418](https://github.com/eclipse/che/pull/8418) ([olexii4](https://github.com/olexii4))
- Rework organization events tracking to use JSON RPC [\#8417](https://github.com/eclipse/che/pull/8417) ([ashumilova](https://github.com/ashumilova))
- Move license to resource details [\#8415](https://github.com/eclipse/che/pull/8415) ([akorneta](https://github.com/akorneta))
- CHE-7263: Add filtering to File Structure dialog [\#8411](https://github.com/eclipse/che/pull/8411) ([vinokurig](https://github.com/vinokurig))
- Selenium: change projects names in ResolveDependencyAfterRecreateProjectTest selenium test [\#8410](https://github.com/eclipse/che/pull/8410) ([SkorikSergey](https://github.com/SkorikSergey))
- Add workspace status to the Assert.fail\(\) log [\#8409](https://github.com/eclipse/che/pull/8409) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Remove "source" field from stack object [\#8407](https://github.com/eclipse/che/pull/8407) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Updated policy of installers update [\#8406](https://github.com/eclipse/che/pull/8406) ([sleshchenko](https://github.com/sleshchenko))
- Selenium: Add preferences response to the log for investigating bug \#8122 [\#8405](https://github.com/eclipse/che/pull/8405) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: change timeout in the CreateWorkspaceOnDashboardTest selenium test [\#8403](https://github.com/eclipse/che/pull/8403) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Fix unexpected fail of DeleteProjectsTest selenium test [\#8402](https://github.com/eclipse/che/pull/8402) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Fix servers probes on https powered deployment [\#8401](https://github.com/eclipse/che/pull/8401) ([garagatyi](https://github.com/garagatyi))
- Selenium: Fix unexpected fail of ShowHintsCommandTest selenium test [\#8398](https://github.com/eclipse/che/pull/8398) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Adapt selenium tests to work with openshift.io REST API [\#8396](https://github.com/eclipse/che/pull/8396) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Selenium: Create selenium tests to cover the authorization on GitHub [\#8395](https://github.com/eclipse/che/pull/8395) ([artaleks9](https://github.com/artaleks9))
- CHE-8083 fix update custom stack flow [\#8394](https://github.com/eclipse/che/pull/8394) ([olexii4](https://github.com/olexii4))
- Selenium: add info about known issue into WorkingWithTerminalTest selenium test [\#8393](https://github.com/eclipse/che/pull/8393) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: cover the Workspaces page by selenium test  [\#8392](https://github.com/eclipse/che/pull/8392) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-7897 fix delete bulk operation for organization members [\#8389](https://github.com/eclipse/che/pull/8389) ([olexii4](https://github.com/olexii4))
- Refactor remaining everrest websocket endpoints to use Json RPC [\#8388](https://github.com/eclipse/che/pull/8388) ([mshaposhnik](https://github.com/mshaposhnik))
- Added popup notification when it is detected that workspace agent is shut down [\#8376](https://github.com/eclipse/che/pull/8376) ([dkuleshov](https://github.com/dkuleshov))
- Selenium: adapt selenium tests according to changes in the Process panel [\#8375](https://github.com/eclipse/che/pull/8375) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix CHE\_DATABASE env. var to point at proper database path [\#8367](https://github.com/eclipse/che/pull/8367) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Fix kc deploy on openshift [\#8366](https://github.com/eclipse/che/pull/8366) ([riuvshin](https://github.com/riuvshin))
- Selenium: Create "AccountTest" and related pageobjects [\#8364](https://github.com/eclipse/che/pull/8364) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- fix ocp.sh deploy with custom CLI image [\#8363](https://github.com/eclipse/che/pull/8363) ([riuvshin](https://github.com/riuvshin))
- \[WIP\] Placeholders for light theme [\#8362](https://github.com/eclipse/che/pull/8362) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- Fix placement of workspace files storage on container host [\#8361](https://github.com/eclipse/che/pull/8361) ([garagatyi](https://github.com/garagatyi))
- Fix remove project. [\#8358](https://github.com/eclipse/che/pull/8358) ([JamesDrummond](https://github.com/JamesDrummond))
- Cleanup and Roll Update not working. [\#8357](https://github.com/eclipse/che/pull/8357) ([JamesDrummond](https://github.com/JamesDrummond))
- CHE-7139: Fix redraw selection on horizontal scroll. [\#8355](https://github.com/eclipse/che/pull/8355) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Fixed an ability to update an installer [\#8354](https://github.com/eclipse/che/pull/8354) ([sleshchenko](https://github.com/sleshchenko))
- Add try/catch to the "TestWorkspaceServiceClient" for catching bug with "whitescreen" [\#8353](https://github.com/eclipse/che/pull/8353) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: adapt selenium tests according to changes in a workspace creation flow  [\#8349](https://github.com/eclipse/che/pull/8349) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: remove unnecessary steps from WorkspaceDetailsSingleMachineTest selenium test [\#8343](https://github.com/eclipse/che/pull/8343) ([SkorikSergey](https://github.com/SkorikSergey))
- Add ability to add several tests users to selenium tests [\#8342](https://github.com/eclipse/che/pull/8342) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Selenium: change locator for the Add Member to organization button [\#8341](https://github.com/eclipse/che/pull/8341) ([SkorikSergey](https://github.com/SkorikSergey))
- Dashboard: improve a workspace creation flow [\#8338](https://github.com/eclipse/che/pull/8338) ([akurinnoy](https://github.com/akurinnoy))
- Fix format. [\#8337](https://github.com/eclipse/che/pull/8337) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Add check preferences to the try/catch block in the "CheckRestoringSplitEditorTest" [\#8336](https://github.com/eclipse/che/pull/8336) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Dashboard: code clean-up [\#8333](https://github.com/eclipse/che/pull/8333) ([akurinnoy](https://github.com/akurinnoy))
- add test for DNS providers in ocp.sh and use backup if default doesn't work [\#8332](https://github.com/eclipse/che/pull/8332) ([riuvshin](https://github.com/riuvshin))
- Selenium: Fix unexpected fail of CheckIntelligenceCommandFromToolbarTest selenium test \(not expected text in the page body\) [\#8331](https://github.com/eclipse/che/pull/8331) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- CHE-7577 CHE6 UI refinements [\#8329](https://github.com/eclipse/che/pull/8329) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- Sync JAVA\_OPTS of workspace master between docker and openshift config [\#8321](https://github.com/eclipse/che/pull/8321) ([skabashnyuk](https://github.com/skabashnyuk))
- Add info about known issue [\#8319](https://github.com/eclipse/che/pull/8319) ([musienko-maxim](https://github.com/musienko-maxim))
- CHE-8304: Support DTO generating for new LSP4J constructs [\#8318](https://github.com/eclipse/che/pull/8318) ([jonahkichwacoders](https://github.com/jonahkichwacoders))
- Selenium: add checking that a project is visible in projects list before selecting it in the Add or Import Project form [\#8317](https://github.com/eclipse/che/pull/8317) ([SkorikSergey](https://github.com/SkorikSergey))
- Added resolving of conflicts between installers servers for OpenShift infra [\#8316](https://github.com/eclipse/che/pull/8316) ([sleshchenko](https://github.com/sleshchenko))
- Selenium: change timeouts in unstable selenium tests [\#8314](https://github.com/eclipse/che/pull/8314) ([SkorikSergey](https://github.com/SkorikSergey))
- Cleanup unused properties [\#8309](https://github.com/eclipse/che/pull/8309) ([garagatyi](https://github.com/garagatyi))
- Fix moving database to new path [\#8307](https://github.com/eclipse/che/pull/8307) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Change shm size in a container for fixing problem with unexpected crashing of browser tabs [\#8303](https://github.com/eclipse/che/pull/8303) ([musienko-maxim](https://github.com/musienko-maxim))
- Selenium: add info about known issue into unstable FileStructureNodesTest selenium test [\#8301](https://github.com/eclipse/che/pull/8301) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Add the 'Assert.fail\(\)' to the tests from the 'opendeclaration' package  [\#8299](https://github.com/eclipse/che/pull/8299) ([artaleks9](https://github.com/artaleks9))
- Selenium: add checking that a machine name is clickable in the Consoles page object [\#8295](https://github.com/eclipse/che/pull/8295) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: add info about known issue into NavigateToFileTest selenium test [\#8294](https://github.com/eclipse/che/pull/8294) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Delete the 'Assert.fail\(\) from the 'CommitFilesTest' [\#8287](https://github.com/eclipse/che/pull/8287) ([artaleks9](https://github.com/artaleks9))
- Add changes to tests for fixing problem after adding license headers [\#8283](https://github.com/eclipse/che/pull/8283) ([musienko-maxim](https://github.com/musienko-maxim))
- Selenium: unexpected fail of CreateWorkspaceOnDashboardTest and ServerRuntimeInfoTest tests  [\#8281](https://github.com/eclipse/che/pull/8281) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: unexpected fail of ConvertToProjectWithPomFileTest selenium test [\#8280](https://github.com/eclipse/che/pull/8280) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Fix unexpected fails in the "FormatterTest", "CheckRestoringSplitEditorTest", "CheckIntelligenceCommandFromToolbarTest" selenium tests [\#8278](https://github.com/eclipse/che/pull/8278) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- che-8250: fix github redirect url, when no port is defined [\#8275](https://github.com/eclipse/che/pull/8275) ([ashumilova](https://github.com/ashumilova))
- Correct  the 'move-file-out ' in the resources after change of header [\#8274](https://github.com/eclipse/che/pull/8274) ([artaleks9](https://github.com/artaleks9))
- Selenium: Change timeout in the 'waitNoGitChangeMarkers\(\)' 'waitGitInsertionMarkerInPosition\(\)' methods [\#8273](https://github.com/eclipse/che/pull/8273) ([artaleks9](https://github.com/artaleks9))
- Sort pom [\#8269](https://github.com/eclipse/che/pull/8269) ([mshaposhnik](https://github.com/mshaposhnik))
- Openshift ocp fails due to livenessProbe. [\#8263](https://github.com/eclipse/che/pull/8263) ([JamesDrummond](https://github.com/JamesDrummond))
- Enable multiusering in core che version [\#8262](https://github.com/eclipse/che/pull/8262) ([mshaposhnik](https://github.com/mshaposhnik))
- Selenium: unexpected fail of ImportProjectFromGitHubTest selenium test [\#8261](https://github.com/eclipse/che/pull/8261) ([SkorikSergey](https://github.com/SkorikSergey))
- Dashboard: prevent to start and open in IDE a workspace with unsupported recipe type [\#8260](https://github.com/eclipse/che/pull/8260) ([akurinnoy](https://github.com/akurinnoy))
- Selenium: fix unexpected fail of the CheckStopStartWsTest selenium test [\#8258](https://github.com/eclipse/che/pull/8258) ([SkorikSergey](https://github.com/SkorikSergey))
- Add default language descriptions set [\#8256](https://github.com/eclipse/che/pull/8256) ([dkuleshov](https://github.com/dkuleshov))
- Allow to override cli-image in ocp.sh [\#8255](https://github.com/eclipse/che/pull/8255) ([riuvshin](https://github.com/riuvshin))
- Fix parsing of test runner's output messages [\#8254](https://github.com/eclipse/che/pull/8254) ([svor](https://github.com/svor))
- Selenium: Fix unexpected fail of OpenDeclarationTest selenium test  [\#8253](https://github.com/eclipse/che/pull/8253) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Set new year in license headers [\#8244](https://github.com/eclipse/che/pull/8244) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Set default value of export CHE\_INFRA\_OPENSHIFT\_MASTER\_\_URL in ocp.sh [\#8236](https://github.com/eclipse/che/pull/8236) ([JamesDrummond](https://github.com/JamesDrummond))
- CHE-7098: Add an option to ask user before browser tab closing [\#8234](https://github.com/eclipse/che/pull/8234) ([mmorhun](https://github.com/mmorhun))
- Implementation of required resource API features for che6 [\#8228](https://github.com/eclipse/che/pull/8228) ([akorneta](https://github.com/akorneta))
- CHE-7624: Hide 'connect via SSH' and 'New terminal' buttons on stop workspace. [\#8224](https://github.com/eclipse/che/pull/8224) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Allow Openshift deploy\_che.sh script to detect if project deletion is completed and new project successfully created. [\#8159](https://github.com/eclipse/che/pull/8159) ([JamesDrummond](https://github.com/JamesDrummond))
- Allow removal of existing Openshift projects using ocp.sh script. [\#8158](https://github.com/eclipse/che/pull/8158) ([JamesDrummond](https://github.com/JamesDrummond))
- Allow user to use local scripts and configuration files in lieu of generated when using openshift ocp.sh script. [\#8156](https://github.com/eclipse/che/pull/8156) ([JamesDrummond](https://github.com/JamesDrummond))
- User can specify project name using openshift ocp.sh. [\#8154](https://github.com/eclipse/che/pull/8154) ([JamesDrummond](https://github.com/JamesDrummond))
- Fix Che using different database path in different versions [\#8073](https://github.com/eclipse/che/pull/8073) ([mkuznyetsov](https://github.com/mkuznyetsov))

## [5.22.1](https://github.com/eclipse/che/tree/5.22.1) (2018-01-11)
[Full Changelog](https://github.com/eclipse/che/compare/6.0.0-M4...5.22.1)

**Merged pull requests:**

- Remove unused parameter from IDE link [\#8248](https://github.com/eclipse/che/pull/8248) ([ashumilova](https://github.com/ashumilova))
- Selenium: Fix unexpected fail of CheckAutocompleteFeaturesInTheTestFolderTest selenium test [\#8247](https://github.com/eclipse/che/pull/8247) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Update networking comments in che.env [\#8246](https://github.com/eclipse/che/pull/8246) ([garagatyi](https://github.com/garagatyi))
- Fix formatting issue [\#8245](https://github.com/eclipse/che/pull/8245) ([vzhukovskii](https://github.com/vzhukovskii))
- Changed back recreate update in che deployment config [\#8239](https://github.com/eclipse/che/pull/8239) ([sleshchenko](https://github.com/sleshchenko))
- Update Docker API version to latest supported by current Docker version [\#8238](https://github.com/eclipse/che/pull/8238) ([mshaposhnik](https://github.com/mshaposhnik))
- Use native profile to build Che in Che workspace [\#8237](https://github.com/eclipse/che/pull/8237) ([eivantsov](https://github.com/eivantsov))
- Dashboard: switch to the opened workspace without reloading the IDE [\#8231](https://github.com/eclipse/che/pull/8231) ([akurinnoy](https://github.com/akurinnoy))
- Selenium: move ServerRuntimeInfoTest selenium test to miscellaneous package [\#8230](https://github.com/eclipse/che/pull/8230) ([SkorikSergey](https://github.com/SkorikSergey))
- Dashboard: fix importing of GitHub project without description [\#8229](https://github.com/eclipse/che/pull/8229) ([akurinnoy](https://github.com/akurinnoy))
- Dashboard: handle the supported types of environments [\#8227](https://github.com/eclipse/che/pull/8227) ([akurinnoy](https://github.com/akurinnoy))
- Add info about known issue in the unstable part of the test [\#8225](https://github.com/eclipse/che/pull/8225) ([musienko-maxim](https://github.com/musienko-maxim))
- Selenium: Fix unexpected fail of TransitiveDependencyTest selenium test [\#8216](https://github.com/eclipse/che/pull/8216) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: unexpected fail of WorkingWithJavaMySqlStackTest and RenameWorkspaceTest selenium tests [\#8215](https://github.com/eclipse/che/pull/8215) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix unexpected fail of CheckIntelligenceCommandFromToolbarTest selenium test \(Preview link\) [\#8212](https://github.com/eclipse/che/pull/8212) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Make machine present in workspace runtime when starting event is sent [\#8210](https://github.com/eclipse/che/pull/8210) ([garagatyi](https://github.com/garagatyi))
- Added sending of error message if boostrapping failed [\#8208](https://github.com/eclipse/che/pull/8208) ([sleshchenko](https://github.com/sleshchenko))
- Fixed cleaning up the OpenShift project [\#8207](https://github.com/eclipse/che/pull/8207) ([sleshchenko](https://github.com/sleshchenko))
- Selenium: fix unexpected fail of the NavigateToFileTest selenium test [\#8206](https://github.com/eclipse/che/pull/8206) ([SkorikSergey](https://github.com/SkorikSergey))
- Make user home dir writable for OpenShift arbitrary user [\#8205](https://github.com/eclipse/che/pull/8205) ([eivantsov](https://github.com/eivantsov))
- Prevent ConcurrentModificationException [\#8200](https://github.com/eclipse/che/pull/8200) ([vparfonov](https://github.com/vparfonov))
- Added small delay before update presentation state this is need for correct UI initialization [\#8199](https://github.com/eclipse/che/pull/8199) ([vparfonov](https://github.com/vparfonov))
- Add info into selenium report about known issue. Modify method for TestRunner plugin for more stability. [\#8197](https://github.com/eclipse/che/pull/8197) ([musienko-maxim](https://github.com/musienko-maxim))
- Selenium: Fix unexpected fail of CheckIntelligenceCommandFromToolbarTest selenium test \(Preview button\) [\#8195](https://github.com/eclipse/che/pull/8195) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Fix port retrieving for probes on OpenShift [\#8194](https://github.com/eclipse/che/pull/8194) ([garagatyi](https://github.com/garagatyi))
- Fixed provision and cleaning up of PVCs in Unique PVC strategy [\#8193](https://github.com/eclipse/che/pull/8193) ([sleshchenko](https://github.com/sleshchenko))
- Restore functionality of uploading SSH keys to machine on startup. [\#8192](https://github.com/eclipse/che/pull/8192) ([mshaposhnik](https://github.com/mshaposhnik))
- remove calling oc client in HELP in ocp.sh [\#8188](https://github.com/eclipse/che/pull/8188) ([riuvshin](https://github.com/riuvshin))
- Fix 'Print Key Binding' feature [\#8183](https://github.com/eclipse/che/pull/8183) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Fixed resolving of servers of an OpenShift multi-container workspace [\#8182](https://github.com/eclipse/che/pull/8182) ([sleshchenko](https://github.com/sleshchenko))
- CHE-7040: Add 400 ms. delay in Navigate to file dialog [\#8177](https://github.com/eclipse/che/pull/8177) ([vinokurig](https://github.com/vinokurig))
- Do not add server into workspace runtime if there is no matching server config in workspace configuration [\#8176](https://github.com/eclipse/che/pull/8176) ([garagatyi](https://github.com/garagatyi))
- Selenium: Fix unexpected fail CheckIntelligenceCommandFromToolbarTest selenium test [\#8175](https://github.com/eclipse/che/pull/8175) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Cleanup deleted resource from resource manager's cache [\#8174](https://github.com/eclipse/che/pull/8174) ([vzhukovskii](https://github.com/vzhukovskii))
- Inform Undo object about compound changes at updating file content [\#8172](https://github.com/eclipse/che/pull/8172) ([RomanNikitenko](https://github.com/RomanNikitenko))
-  CHE-7872: Fix errors in browser console when closing Git Branches dialog [\#8169](https://github.com/eclipse/che/pull/8169) ([vinokurig](https://github.com/vinokurig))
- improve the editor widget for UD [\#8165](https://github.com/eclipse/che/pull/8165) ([olexii4](https://github.com/olexii4))
- Fixed recipe in the che-in-che stack [\#8163](https://github.com/eclipse/che/pull/8163) ([sleshchenko](https://github.com/sleshchenko))
- Added additional common environment variables that may need to be set to CLI help menu. [\#8155](https://github.com/eclipse/che/pull/8155) ([JamesDrummond](https://github.com/JamesDrummond))
- Selenium: change an image name from 'location' to 'content' in default.json recipe [\#8150](https://github.com/eclipse/che/pull/8150) ([SkorikSergey](https://github.com/SkorikSergey))
- RELEASE: Update CHANGELOG [\#8149](https://github.com/eclipse/che/pull/8149) ([riuvshin](https://github.com/riuvshin))
- Update icon for yaml file type [\#8148](https://github.com/eclipse/che/pull/8148) ([vzhukovskii](https://github.com/vzhukovskii))
- Selenium: Fix unexpected fail of CreateNewJavaFilesTest selenium test [\#8146](https://github.com/eclipse/che/pull/8146) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- CHE-7524: Separate text color from background in search widgets [\#8144](https://github.com/eclipse/che/pull/8144) ([vinokurig](https://github.com/vinokurig))
- Selenium: add checking that the Authorize button exists in the ImportProjectFromGitHubTest test [\#8142](https://github.com/eclipse/che/pull/8142) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Fix unexpected tests fails in the "refactor" package [\#8141](https://github.com/eclipse/che/pull/8141) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: add waiting that the Loader is closed in WorkspaceDetailsSingleMachineTest selenium test [\#8132](https://github.com/eclipse/che/pull/8132) ([SkorikSergey](https://github.com/SkorikSergey))
- Add an ability to set INFRA\_OPENSHIFT\_\[USERNAME|PASSWORD|TOKEN\] to empty [\#8129](https://github.com/eclipse/che/pull/8129) ([sleshchenko](https://github.com/sleshchenko))
- Handle existed node in tree in case if explorer receives create event [\#8120](https://github.com/eclipse/che/pull/8120) ([vzhukovskii](https://github.com/vzhukovskii))
- CHE-6968: Add filtering by project in Git Colorizers [\#8102](https://github.com/eclipse/che/pull/8102) ([vinokurig](https://github.com/vinokurig))
- allow fast search by pressing enter on search field [\#8101](https://github.com/eclipse/che/pull/8101) ([hkolvenbach](https://github.com/hkolvenbach))
- Add continuous servers liveness checks [\#8088](https://github.com/eclipse/che/pull/8088) ([garagatyi](https://github.com/garagatyi))


## [6.0.0-M4](https://github.com/eclipse/che/tree/6.0.0-M4) (2018-01-03)
[Full Changelog](https://github.com/eclipse/che/compare/6.0.0-M3...6.0.0-M4)

**Merged pull requests:**

- RELEASE: Set next development version [\#8135](https://github.com/eclipse/che/pull/8135) ([riuvshin](https://github.com/riuvshin))
- Create test user at start of selenium tests execution [\#7965](https://github.com/eclipse/che/pull/7965) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Fix invalid API version from openshift yml [\#7913](https://github.com/eclipse/che/pull/7913) ([Themodem](https://github.com/Themodem))
- Support of headers to 'HttpJsonRequest'. Adding 'Connection: close' header while pinging workspace agent [\#7898](https://github.com/eclipse/che/pull/7898) ([ibuziuk](https://github.com/ibuziuk))
- RELEASE: Update CHANGELOG [\#7896](https://github.com/eclipse/che/pull/7896) ([riuvshin](https://github.com/riuvshin))
- CHE-5564: Fix encoding for full text search. [\#7864](https://github.com/eclipse/che/pull/7864) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Sync how CHE\_WORKSPACE\_WSAGENT\_\_JAVA\_\_OPTIONS and CHE\_WORKSPACE\_MAVEN\_\_SERVER\_\_JAVA\_\_OPTIONS looks like for end user [\#8128](https://github.com/eclipse/che/pull/8128) ([skabashnyuk](https://github.com/skabashnyuk))
- Add try/catch blocks to the selenium tests [\#8126](https://github.com/eclipse/che/pull/8126) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Fix initializing of project types with attributes inherited from its ancestors [\#8123](https://github.com/eclipse/che/pull/8123) ([azatsarynnyy](https://github.com/azatsarynnyy))
- change way how to wipe config dir to not break running che on docker [\#8121](https://github.com/eclipse/che/pull/8121) ([riuvshin](https://github.com/riuvshin))
- Selenium: Fix unexpected fails in the "refactor" package [\#8119](https://github.com/eclipse/che/pull/8119) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Increase workspace attributes values field length in database for abnormal shutdown error saving. [\#8115](https://github.com/eclipse/che/pull/8115) ([mshaposhnik](https://github.com/mshaposhnik))
- Selenium: change a locator for the Save button in the Edit machine dialog [\#8114](https://github.com/eclipse/che/pull/8114) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: changes in selenium tests for the Dashboard [\#8104](https://github.com/eclipse/che/pull/8104) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix output message in selenium tests [\#8103](https://github.com/eclipse/che/pull/8103) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Selenium: cover the Create New Workspace page by selenium test [\#8099](https://github.com/eclipse/che/pull/8099) ([SkorikSergey](https://github.com/SkorikSergey))
- Add bigger timeout to the login page  methods in the selenium tests [\#8098](https://github.com/eclipse/che/pull/8098) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: change timeout for waiting that a workspace is started [\#8096](https://github.com/eclipse/che/pull/8096) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Fix unexpected fail of CheckIntelligenceCommandFromToolbarTest selenium test [\#8093](https://github.com/eclipse/che/pull/8093) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- che-7154: Handle the workspace start/stop errors properly [\#8091](https://github.com/eclipse/che/pull/8091) ([ashumilova](https://github.com/ashumilova))
- Selenium: add changes to the unstable WorkspaceDetailsSingleMachineTest selenium test [\#8089](https://github.com/eclipse/che/pull/8089) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-7377 improve workspace config tab for UD [\#8087](https://github.com/eclipse/che/pull/8087) ([olexii4](https://github.com/olexii4))
- Selenium: remove the 'Assert.fail\(\)' from the WorkingWithNodeWsTest selenium test [\#8085](https://github.com/eclipse/che/pull/8085) ([SkorikSergey](https://github.com/SkorikSergey))
- Discontinue support of the deprecated property names [\#8080](https://github.com/eclipse/che/pull/8080) ([skabashnyuk](https://github.com/skabashnyuk))
- Add all needed classes to the org-eclipse-search from original Eclipse artifact org.eclipse.search [\#8078](https://github.com/eclipse/che/pull/8078) ([vparfonov](https://github.com/vparfonov))
-  Move image name from  location to content field in dockerimage recipes [\#8076](https://github.com/eclipse/che/pull/8076) ([mshaposhnik](https://github.com/mshaposhnik))
- CHE-8000: Fix Git commit window sizes [\#8072](https://github.com/eclipse/che/pull/8072) ([vinokurig](https://github.com/vinokurig))
- CHE-7885: Throw exception on Git Status if checkout is in progress [\#8071](https://github.com/eclipse/che/pull/8071) ([vinokurig](https://github.com/vinokurig))
- Do not print CHE CLI config message if config is skipped [\#8066](https://github.com/eclipse/che/pull/8066) ([riuvshin](https://github.com/riuvshin))
- Selenium: change check if a filename exists in the Navigate To File suggestion list [\#8064](https://github.com/eclipse/che/pull/8064) ([SkorikSergey](https://github.com/SkorikSergey))
- Add check link availability in the CheckIntelligenceCommandFromToolbarTest selenium test [\#8063](https://github.com/eclipse/che/pull/8063) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: apply try/catch block to ProjectStateAfterRenameWorkspaceTest test [\#8062](https://github.com/eclipse/che/pull/8062) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-7872: Rework Git branch dialog filter to have focus from the whole window [\#8059](https://github.com/eclipse/che/pull/8059) ([vinokurig](https://github.com/vinokurig))
- CHE-7921 fix openshift recipe parsing [\#8058](https://github.com/eclipse/che/pull/8058) ([olexii4](https://github.com/olexii4))
- Add ability to mark infrastructure-specific selenium tests [\#8057](https://github.com/eclipse/che/pull/8057) ([dmytro-ndp](https://github.com/dmytro-ndp))
- fix keycloak containerID evaluation in webdriver.sh [\#8054](https://github.com/eclipse/che/pull/8054) ([riuvshin](https://github.com/riuvshin))
- Selenium: Delete the 'Assert.fail\(\)' from the 'ProjectStateAfterRenameWorkspaceTest [\#8053](https://github.com/eclipse/che/pull/8053) ([artaleks9](https://github.com/artaleks9))
- Fix load user repo in sigle user mode [\#8052](https://github.com/eclipse/che/pull/8052) ([mshaposhnik](https://github.com/mshaposhnik))
- Selenium: open the Servers tab from a machine context menu [\#8051](https://github.com/eclipse/che/pull/8051) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: test import of a github project from the Dashboard [\#8050](https://github.com/eclipse/che/pull/8050) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: Add the 'Assert.fail\(\) to the 'CommitFilesTest' related to known issue [\#8047](https://github.com/eclipse/che/pull/8047) ([artaleks9](https://github.com/artaleks9))
- Fix codestyle [\#8046](https://github.com/eclipse/che/pull/8046) ([mshaposhnik](https://github.com/mshaposhnik))
- Selenium: apply try/catch blocks in failed selenium tests [\#8039](https://github.com/eclipse/che/pull/8039) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-6405 fix styles for small displays [\#8037](https://github.com/eclipse/che/pull/8037) ([olexii4](https://github.com/olexii4))
- Selenium: Add timeout to the 'PhpProjectDebuggingTest' related to run on the oc… [\#8034](https://github.com/eclipse/che/pull/8034) ([artaleks9](https://github.com/artaleks9))
- Add FluentWait for avoiding unexpected fails for animated web element [\#8030](https://github.com/eclipse/che/pull/8030) ([musienko-maxim](https://github.com/musienko-maxim))
- Fix oauth login to GitHub with keycloak [\#8027](https://github.com/eclipse/che/pull/8027) ([ashumilova](https://github.com/ashumilova))
- Remove extra steps in the tests from "refactor" test package and update "Refactor" page-object   [\#8026](https://github.com/eclipse/che/pull/8026) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Selenium: change the way to click the plus panel button in the Consoles page object [\#8024](https://github.com/eclipse/che/pull/8024) ([SkorikSergey](https://github.com/SkorikSergey))
- Allow overriding wsagent and maven server ram [\#8023](https://github.com/eclipse/che/pull/8023) ([skabashnyuk](https://github.com/skabashnyuk))
- CHE-7730 fix styles for wide displays [\#8018](https://github.com/eclipse/che/pull/8018) ([olexii4](https://github.com/olexii4))
- Fix indentation in docker-compose template [\#8016](https://github.com/eclipse/che/pull/8016) ([eivantsov](https://github.com/eivantsov))
- OCP deployment: more ram for keycloak and housepeeking [\#8014](https://github.com/eclipse/che/pull/8014) ([eivantsov](https://github.com/eivantsov))
- Add screening from all opened webdriver windows [\#8012](https://github.com/eclipse/che/pull/8012) ([musienko-maxim](https://github.com/musienko-maxim))
- Selenium: Change parameter in the method in the 'JavaTestPluginJunit4Test'  [\#8005](https://github.com/eclipse/che/pull/8005) ([artaleks9](https://github.com/artaleks9))
- CHE-7880: Save latest commit message before showing Git Commit dialog [\#8004](https://github.com/eclipse/che/pull/8004) ([vinokurig](https://github.com/vinokurig))
- Make it possible to update Che on OCP, including rolling update [\#8002](https://github.com/eclipse/che/pull/8002) ([eivantsov](https://github.com/eivantsov))
- Fix github-specific selenium tests after adding support of Identity brokering mechanism of Keycloak [\#7999](https://github.com/eclipse/che/pull/7999) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Improved Workspace status panel [\#7998](https://github.com/eclipse/che/pull/7998) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- Fix the css property styles in dark theme [\#7995](https://github.com/eclipse/che/pull/7995) ([ashumilova](https://github.com/ashumilova))
- Use author name instead of committer name in Git history dialog [\#7992](https://github.com/eclipse/che/pull/7992) ([vinokurig](https://github.com/vinokurig))
- Store last workspace startup or crash error status and message in workspace attributes. [\#7988](https://github.com/eclipse/che/pull/7988) ([mshaposhnik](https://github.com/mshaposhnik))
- \[cli\] stop action Use messagebus instead of json rpc bus for system calls. [\#7985](https://github.com/eclipse/che/pull/7985) ([benoitf](https://github.com/benoitf))
- CHE-6848: Navigation to file improvement: Provide filtering binary files and sorting results by extensions [\#7983](https://github.com/eclipse/che/pull/7983) ([vparfonov](https://github.com/vparfonov))
- Add try/catch blocks with known issue link to the factory tests [\#7982](https://github.com/eclipse/che/pull/7982) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Clean up after merge che6 to master [\#7979](https://github.com/eclipse/che/pull/7979) ([riuvshin](https://github.com/riuvshin))
- Add assertion with known issue in the typical unstable part of the test [\#7978](https://github.com/eclipse/che/pull/7978) ([musienko-maxim](https://github.com/musienko-maxim))
- CHE7856: Fix parsing path when getting Git Status on file creation [\#7974](https://github.com/eclipse/che/pull/7974) ([vinokurig](https://github.com/vinokurig))
- Update the images for Debian, Ubuntu and Rails runtime stacks [\#7967](https://github.com/eclipse/che/pull/7967) ([l0rd](https://github.com/l0rd))
- Add handling in the CheckMainFeatureForCSharpLanguageTest for possible failing after first initialization [\#7966](https://github.com/eclipse/che/pull/7966) ([musienko-maxim](https://github.com/musienko-maxim))
- CHE-7001: Fix Git status of untracked files in Git diff [\#7962](https://github.com/eclipse/che/pull/7962) ([vinokurig](https://github.com/vinokurig))
- Change worskpace project files storage path [\#7844](https://github.com/eclipse/che/pull/7844) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Update folder type in case of changing maven project structure [\#7812](https://github.com/eclipse/che/pull/7812) ([vzhukovskii](https://github.com/vzhukovskii))
- Keycloak identity brokering [\#7767](https://github.com/eclipse/che/pull/7767) ([mshaposhnik](https://github.com/mshaposhnik))

## [6.0.0-M3](https://github.com/eclipse/che/tree/6.0.0-M3) (2017-12-14)
[Full Changelog](https://github.com/eclipse/che/compare/5.22.0...6.0.0-M3)

**Merged pull requests:**

- Selenium: apply changes for selenium tests from Che6 branch to master [\#7870](https://github.com/eclipse/che/pull/7870) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-7407: Remove redundant file watcher initialization [\#7867](https://github.com/eclipse/che/pull/7867) ([vinokurig](https://github.com/vinokurig))

## [5.22.0](https://github.com/eclipse/che/tree/5.22.0) (2017-12-13)
[Full Changelog](https://github.com/eclipse/che/compare/5.21.1...5.22.0)

**Merged pull requests:**

- RELEASE: Set next development version [\#7848](https://github.com/eclipse/che/pull/7848) ([riuvshin](https://github.com/riuvshin))
- Adapt webdriver.sh to Multiuser Che; add ability to set rerun attempts [\#7847](https://github.com/eclipse/che/pull/7847) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Revert "Selenium: apply changes for selenium tests from Che6 branch to master" [\#7843](https://github.com/eclipse/che/pull/7843) ([SkorikSergey](https://github.com/SkorikSergey))
- Selenium: apply changes for selenium tests from Che6 branch to master [\#7830](https://github.com/eclipse/che/pull/7830) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix the OpenshiftClient connection leaks [\#7793](https://github.com/eclipse/che/pull/7793) ([davidfestal](https://github.com/davidfestal))
- Introduce wsagent ping success threshold [\#7766](https://github.com/eclipse/che/pull/7766) ([l0rd](https://github.com/l0rd))
- Give focus for widget when activate this one [\#7760](https://github.com/eclipse/che/pull/7760) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Rework selenium page objects for Dashboard [\#7757](https://github.com/eclipse/che/pull/7757) ([SkorikSergey](https://github.com/SkorikSergey))
- Remove separation of selenium tests on stable/unstable/failed [\#7749](https://github.com/eclipse/che/pull/7749) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Move clean up to the end of selenium test execution [\#7731](https://github.com/eclipse/che/pull/7731) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Set screen size in the selenium chrome node to 1920x1080 [\#7717](https://github.com/eclipse/che/pull/7717) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Test commands starting from the Processes area [\#7690](https://github.com/eclipse/che/pull/7690) ([SkorikSergey](https://github.com/SkorikSergey))
- Fixed location of centos blank stack which was previously invalid [\#7666](https://github.com/eclipse/che/pull/7666) ([JPinkney](https://github.com/JPinkney))
- Add ability to wait until selenium web element animation is ended [\#7659](https://github.com/eclipse/che/pull/7659) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Fix for part of redhat-developer/rh-che\#431 [\#7639](https://github.com/eclipse/che/pull/7639) ([JPinkney](https://github.com/JPinkney))
- Selenium: Add changes to the 'RenamePackageTest' [\#7628](https://github.com/eclipse/che/pull/7628) ([artaleks9](https://github.com/artaleks9))
- CHE-7407: Rework Git file change event detection to be depend on open… [\#7613](https://github.com/eclipse/che/pull/7613) ([vinokurig](https://github.com/vinokurig))
- Fix small UI bugs [\#7608](https://github.com/eclipse/che/pull/7608) ([olexii4](https://github.com/olexii4))
- RELEASE: Update CHANGELOG [\#7570](https://github.com/eclipse/che/pull/7570) ([riuvshin](https://github.com/riuvshin))
- Change testing of the Find Text feature presentation [\#7568](https://github.com/eclipse/che/pull/7568) ([SkorikSergey](https://github.com/SkorikSergey))
- Port from che6 Added missing lib to be able to configure LogstashEncoder on wsagent [\#7566](https://github.com/eclipse/che/pull/7566) ([skabashnyuk](https://github.com/skabashnyuk))
- Add machine token for 'Upload SSH key' request [\#7540](https://github.com/eclipse/che/pull/7540) ([RomanNikitenko](https://github.com/RomanNikitenko))
- RELEASE: Set next development version [\#7503](https://github.com/eclipse/che/pull/7503) ([riuvshin](https://github.com/riuvshin))
- Add the ability to configure logback \(MDC\) to show `identity\_id` and `X-Request-ID` in logs files when available. [\#7461](https://github.com/eclipse/che/pull/7461) ([sunix](https://github.com/sunix))
- Prevent NPE after applying the refactoring session [\#7458](https://github.com/eclipse/che/pull/7458) ([vzhukovskii](https://github.com/vzhukovskii))
- Include Organization tests into acceptance tests execution on the Multiuser Che [\#7447](https://github.com/eclipse/che/pull/7447) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Do not index files from File Index excludes [\#7096](https://github.com/eclipse/che/pull/7096) ([RomanNikitenko](https://github.com/RomanNikitenko))

## [5.21.1](https://github.com/eclipse/che/tree/5.21.1) (2017-12-07)
[Full Changelog](https://github.com/eclipse/che/compare/6.0.0-M2...5.21.1)


## [6.0.0-M2](https://github.com/eclipse/che/tree/6.0.0-M2) (2017-11-23)
[Full Changelog](https://github.com/eclipse/che/compare/5.21.0...6.0.0-M2)

## [5.21.0](https://github.com/eclipse/che/tree/5.21.0) (2017-11-22)
[Full Changelog](https://github.com/eclipse/che/compare/5.20.1...5.21.0)

**Merged pull requests:**

- RELEASE: Set next development version [\#7503](https://github.com/eclipse/che/pull/7503) ([riuvshin](https://github.com/riuvshin))
- Prevent NPE after applying the refactoring session [\#7458](https://github.com/eclipse/che/pull/7458) ([vzhukovskii](https://github.com/vzhukovskii))
- Do not index files from File Index excludes [\#7096](https://github.com/eclipse/che/pull/7096) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Remove test method from the CheckFileWatcherExcludeFeatureTest selenium test  [\#7487](https://github.com/eclipse/che/pull/7487) ([SkorikSergey](https://github.com/SkorikSergey))
- \[ WIP \] Import selenium changes from che6\(mainly in "CodenvyEditor", "CommandsExplorer"\)  [\#7484](https://github.com/eclipse/che/pull/7484) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Avoid executing chown command if the user is not a sudoer [\#7471](https://github.com/eclipse/che/pull/7471) ([l0rd](https://github.com/l0rd))
- Import selenium changes from che6 to master [\#7470](https://github.com/eclipse/che/pull/7470) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Remove unneeded let in LS csharp script [\#7457](https://github.com/eclipse/che/pull/7457) ([mmorhun](https://github.com/mmorhun))
- Fix samples.json loading [\#7452](https://github.com/eclipse/che/pull/7452) ([riuvshin](https://github.com/riuvshin))
- CHE-6855: Fix GDB regression on breakpoint stop [\#7450](https://github.com/eclipse/che/pull/7450) ([mmorhun](https://github.com/mmorhun))
- Fix top line position of editor at refreshing page [\#7443](https://github.com/eclipse/che/pull/7443) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Update version of openjdk base image to 8u131 [\#7439](https://github.com/eclipse/che/pull/7439) ([l0rd](https://github.com/l0rd))
- add bugfix versions [\#7405](https://github.com/eclipse/che/pull/7405) ([riuvshin](https://github.com/riuvshin))
- Housekeeping of selenium tests [\#7397](https://github.com/eclipse/che/pull/7397) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Rework selenium tests from organizations package [\#7389](https://github.com/eclipse/che/pull/7389) ([SkorikSergey](https://github.com/SkorikSergey))
- Fixed domain in set stack permissions while 'manageSystem' action check [\#7382](https://github.com/eclipse/che/pull/7382) ([akorneta](https://github.com/akorneta))
- Update deployment-config.yaml [\#7370](https://github.com/eclipse/che/pull/7370) ([JamesDrummond](https://github.com/JamesDrummond))
- Add method deleteMachineKey\(\) for codenvy assembly [\#7360](https://github.com/eclipse/che/pull/7360) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Rework testing of Find Text Feature results presentation [\#7355](https://github.com/eclipse/che/pull/7355) ([SkorikSergey](https://github.com/SkorikSergey))
- \[cli\] Adds a check for linuxkit in addition to moby kernel [\#7326](https://github.com/eclipse/che/pull/7326) ([benoitf](https://github.com/benoitf))
- added style for css elements for css file types [\#7320](https://github.com/eclipse/che/pull/7320) ([arunkumar413](https://github.com/arunkumar413))
- Another attempt to fix the tests that are only failing on master CI [\#7317](https://github.com/eclipse/che/pull/7317) ([davidfestal](https://github.com/davidfestal))
- Fix one test and include tests that had been left ignored [\#7316](https://github.com/eclipse/che/pull/7316) ([davidfestal](https://github.com/davidfestal))
- Fix OpenShift deployment script after new KC config maps have been added [\#7301](https://github.com/eclipse/che/pull/7301) ([l0rd](https://github.com/l0rd))
- Update RenameProjectTest selenium test [\#7291](https://github.com/eclipse/che/pull/7291) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix for replace stacks not working when agents was on multiline [\#7286](https://github.com/eclipse/che/pull/7286) ([JPinkney](https://github.com/JPinkney))
- port Fix kc db import on os  [\#7259](https://github.com/eclipse/che/pull/7259) ([riuvshin](https://github.com/riuvshin))
- If workspace base image does not have labels, skip merge of image labels [\#7252](https://github.com/eclipse/che/pull/7252) ([osallou](https://github.com/osallou))
- findResource method refactoring related to hierarchical load resource tree [\#7250](https://github.com/eclipse/che/pull/7250) ([vzhukovskii](https://github.com/vzhukovskii))
- Multi tenant workspace cleaning [\#7243](https://github.com/eclipse/che/pull/7243) ([davidfestal](https://github.com/davidfestal))
- port \#7212 to master [\#7236](https://github.com/eclipse/che/pull/7236) ([riuvshin](https://github.com/riuvshin))
- DynaModule plugin test: Avoid timestamp usage when copying dependency + sorting files issue [\#7218](https://github.com/eclipse/che/pull/7218) ([benoitf](https://github.com/benoitf))
- Fixed replace\_stacks.json after addition of dotnet-centos [\#7214](https://github.com/eclipse/che/pull/7214) ([JPinkney](https://github.com/JPinkney))
- Removed scl enable rh-nodejs dependency \(centos-nodejs\) [\#7209](https://github.com/eclipse/che/pull/7209) ([JPinkney](https://github.com/JPinkney))
- Dashboard: fixed ability to re-run of diagnostics feature [\#7197](https://github.com/eclipse/che/pull/7197) ([akurinnoy](https://github.com/akurinnoy))
- Adopt unit test to changes made in MavenMessagesHandler [\#7192](https://github.com/eclipse/che/pull/7192) ([vzhukovskii](https://github.com/vzhukovskii))
- osio-1281: OpenShift - do not set host for routes while workspace creation [\#7184](https://github.com/eclipse/che/pull/7184) ([ibuziuk](https://github.com/ibuziuk))
- Increase timeout for waiting that notification panel is closed [\#7172](https://github.com/eclipse/che/pull/7172) ([SkorikSergey](https://github.com/SkorikSergey))
- Added Traefik's docker.network label to fix multiuser single\_port [\#7170](https://github.com/eclipse/che/pull/7170) ([hickey](https://github.com/hickey))
- Don't run git selenium tests simultaneously [\#7148](https://github.com/eclipse/che/pull/7148) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Check if C\# language server client is already there before downloading it [\#7116](https://github.com/eclipse/che/pull/7116) ([l0rd](https://github.com/l0rd))
- Invoke File Watcher 'create' consumer when item is created [\#7115](https://github.com/eclipse/che/pull/7115) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Dashboard: added a new way to update factory configuration JSON [\#7107](https://github.com/eclipse/che/pull/7107) ([akurinnoy](https://github.com/akurinnoy))
- Fix Organization selenium tests [\#7100](https://github.com/eclipse/che/pull/7100) ([SkorikSergey](https://github.com/SkorikSergey))
- Create che dir when this one doesn't exist at adding to File Watcher excludes [\#7097](https://github.com/eclipse/che/pull/7097) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Don't unregister the cached resource to have consistent tree representation of files [\#7076](https://github.com/eclipse/che/pull/7076) ([vzhukovskii](https://github.com/vzhukovskii))
- Temporary disable synchronization call [\#7070](https://github.com/eclipse/che/pull/7070) ([vzhukovskii](https://github.com/vzhukovskii))
- Add support for Docker SecurityOpt \(allowing GDB Debugging on unprivileged docker containers\) [\#6856](https://github.com/eclipse/che/pull/6856) ([hkolvenbach](https://github.com/hkolvenbach))
- Adding logstash-logback dependencies to avoid classloading issue when using logstash-logback appenders [\#6539](https://github.com/eclipse/che/pull/6539) ([sunix](https://github.com/sunix))

## [5.20.1](https://github.com/eclipse/che/tree/5.20.1) (2017-11-16)
[Full Changelog](https://github.com/eclipse/che/compare/5.18.1...5.20.1)

## [5.18.1](https://github.com/eclipse/che/tree/5.18.1) (2017-11-03)
[Full Changelog](https://github.com/eclipse/che/compare/6.0.0-M1...5.18.1)

## [6.0.0-M1](https://github.com/eclipse/che/tree/6.0.0-M1) (2017-11-02)
[Full Changelog](https://github.com/eclipse/che/compare/5.20.0...6.0.0-M1)

**Merged pull requests:**

- Backport of che-dev image from che6 branch [\#7118](https://github.com/eclipse/che/pull/7118) ([skabashnyuk](https://github.com/skabashnyuk))


## [5.19.0](https://github.com/eclipse/che/tree/5.19.0) (2017-10-14)
[Full Changelog](https://github.com/eclipse/che/compare/5.18.0...5.19.0)

**Merged pull requests:**

- Rename workspace test [\#6493](https://github.com/eclipse/che/pull/6493) ([vparfonov](https://github.com/vparfonov))
- Make screenshot during each element detection [\#6492](https://github.com/eclipse/che/pull/6492) ([vparfonov](https://github.com/vparfonov))
- Adapt selenium tests according to new client [\#6471](https://github.com/eclipse/che/pull/6471) ([artaleks9](https://github.com/artaleks9))
- Do not perform chown and chmod on /projects unless a user is in sudoers [\#6416](https://github.com/eclipse/che/pull/6416) ([eivantsov](https://github.com/eivantsov))
- Update to mockito 2.10 [\#6394](https://github.com/eclipse/che/pull/6394) ([benoitf](https://github.com/benoitf))
- RELEASE: Update CHANGELOG [\#6365](https://github.com/eclipse/che/pull/6365) ([riuvshin](https://github.com/riuvshin))
- Add ability to create test workspaces for the non-default user [\#6318](https://github.com/eclipse/che/pull/6318) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Make error message clearer in the Keycloak s2i build... [\#6740](https://github.com/eclipse/che/pull/6740) ([davidfestal](https://github.com/davidfestal))
- In `deploy\_che.sh`, the keycloack route should be `https` when the che server is `https` [\#6739](https://github.com/eclipse/che/pull/6739) ([davidfestal](https://github.com/davidfestal))
- Change locators in DasboardWorkspace page object [\#6723](https://github.com/eclipse/che/pull/6723) ([SkorikSergey](https://github.com/SkorikSergey))
- Dashboard: fixed validation for recipe authoring widget. [\#6720](https://github.com/eclipse/che/pull/6720) ([akurinnoy](https://github.com/akurinnoy))
- rework selenium tests in organization package [\#6717](https://github.com/eclipse/che/pull/6717) ([Ohrimenko1988](https://github.com/Ohrimenko1988))
- Add ability to inject different webdrivers into the Entrance class [\#6714](https://github.com/eclipse/che/pull/6714) ([dmytro-ndp](https://github.com/dmytro-ndp))
- update kc image version [\#6712](https://github.com/eclipse/che/pull/6712) ([riuvshin](https://github.com/riuvshin))
- Clean up 'YamlExtensionManagerViewImpl' [\#6710](https://github.com/eclipse/che/pull/6710) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Dashboard: fixed Recent Workspaces list to show there last started workspace [\#6709](https://github.com/eclipse/che/pull/6709) ([akurinnoy](https://github.com/akurinnoy))
- Add check whether keycloak refresh token is expired or not [\#6708](https://github.com/eclipse/che/pull/6708) ([akorneta](https://github.com/akorneta))
- Add changes to one test and page object [\#6707](https://github.com/eclipse/che/pull/6707) ([artaleks9](https://github.com/artaleks9))
- Add utility class to serve request consumers [\#6704](https://github.com/eclipse/che/pull/6704) ([vzhukovskii](https://github.com/vzhukovskii))
- Fixed concurrent user registration [\#6703](https://github.com/eclipse/che/pull/6703) ([skabashnyuk](https://github.com/skabashnyuk))
- Wrong version for `che-multiuser-personal-account` [\#6697](https://github.com/eclipse/che/pull/6697) ([davidfestal](https://github.com/davidfestal))
- Fix initialization change markers render [\#6696](https://github.com/eclipse/che/pull/6696) ([RomanNikitenko](https://github.com/RomanNikitenko))
-  dashboard: fix oauth login through github in UD [\#6694](https://github.com/eclipse/che/pull/6694) ([ashumilova](https://github.com/ashumilova))
- use 9.6 tag of postgresql image instead of latest [\#6690](https://github.com/eclipse/che/pull/6690) ([riuvshin](https://github.com/riuvshin))
- Removing deprecated FileTreeWatcher [\#6688](https://github.com/eclipse/che/pull/6688) ([dkuleshov](https://github.com/dkuleshov))
- Create model interface representing file change [\#6681](https://github.com/eclipse/che/pull/6681) ([vzhukovskii](https://github.com/vzhukovskii))
- Heap on master filled with JSON-RPC message Strings [\#6676](https://github.com/eclipse/che/pull/6676) ([dkuleshov](https://github.com/dkuleshov))
- Fixed possible constraint violation with an existed organization. [\#6674](https://github.com/eclipse/che/pull/6674) ([skabashnyuk](https://github.com/skabashnyuk))
- Improved displaying of long workspace names [\#6668](https://github.com/eclipse/che/pull/6668) ([akurinnoy](https://github.com/akurinnoy))
- CHE-5340: Rework 'VcsChangeMarkerRenderFactory' initialization [\#6658](https://github.com/eclipse/che/pull/6658) ([vinokurig](https://github.com/vinokurig))
- Delete all selenium tests for Bitnami stacks [\#6652](https://github.com/eclipse/che/pull/6652) ([SkorikSergey](https://github.com/SkorikSergey))
- Fix URL with selenium test report on CI [\#6644](https://github.com/eclipse/che/pull/6644) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Don't fail if SSH agent doesn't start [\#6638](https://github.com/eclipse/che/pull/6638) ([l0rd](https://github.com/l0rd))
- Update CLI version files for future release [\#6635](https://github.com/eclipse/che/pull/6635) ([riuvshin](https://github.com/riuvshin))
- Send subscribe message when ws agent started [\#6634](https://github.com/eclipse/che/pull/6634) ([evidolob](https://github.com/evidolob))
- Fix unstable CheckBasicFunctionalityInCommandsExplorerTest selenium test [\#6632](https://github.com/eclipse/che/pull/6632) ([SkorikSergey](https://github.com/SkorikSergey))
- Send events from server to client about project's changes [\#6628](https://github.com/eclipse/che/pull/6628) ([svor](https://github.com/svor))
- Dashboard: Handle auto-scroll while creating a workspace  [\#6625](https://github.com/eclipse/che/pull/6625) ([akurinnoy](https://github.com/akurinnoy))
- Increase max number of chrome-node sessions in selenium tests [\#6623](https://github.com/eclipse/che/pull/6623) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Handle partial WebSocket messages to work with large files [\#6622](https://github.com/eclipse/che/pull/6622) ([evidolob](https://github.com/evidolob))
- Activate 'Link with editor' icon when the feature is enabled [\#6616](https://github.com/eclipse/che/pull/6616) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Language Server Protocol Rename implementation [\#6615](https://github.com/eclipse/che/pull/6615) ([evidolob](https://github.com/evidolob))
- che \#6500 - Removing optional 'che-ws-' prefix during tag creation on OpenShift [\#6604](https://github.com/eclipse/che/pull/6604) ([ibuziuk](https://github.com/ibuziuk))
- Adapt selenium tests to new Find text presentation view [\#6600](https://github.com/eclipse/che/pull/6600) ([svor](https://github.com/svor))
- Allow workspace name length up to 100 chars [\#6599](https://github.com/eclipse/che/pull/6599) ([garagatyi](https://github.com/garagatyi))
- Add capturing of a html dump after failing a test [\#6598](https://github.com/eclipse/che/pull/6598) ([musienko-maxim](https://github.com/musienko-maxim))
- Remove opacity from hex formatted colors [\#6597](https://github.com/eclipse/che/pull/6597) ([mmorhun](https://github.com/mmorhun))
-  Replace abstract method with default implementation [\#6593](https://github.com/eclipse/che/pull/6593) ([vzhukovskii](https://github.com/vzhukovskii))
- Fix top line position at restoring editors [\#6589](https://github.com/eclipse/che/pull/6589) ([RomanNikitenko](https://github.com/RomanNikitenko))
- CHE-4536: Prevent removing breakpoint annotations [\#6588](https://github.com/eclipse/che/pull/6588) ([tolusha](https://github.com/tolusha))
- Rework the 'KeepDirectoryGitImportTest' [\#6583](https://github.com/eclipse/che/pull/6583) ([artaleks9](https://github.com/artaleks9))
- CHE-6571 Fix new stack creation flow [\#6580](https://github.com/eclipse/che/pull/6580) ([olexii4](https://github.com/olexii4))
- Do not set focus on project tree when 'Link with editor' feature is applied [\#6579](https://github.com/eclipse/che/pull/6579) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Various fix for selenium tests [\#6574](https://github.com/eclipse/che/pull/6574) ([vparfonov](https://github.com/vparfonov))
- synchronize openshift deploy scripts [\#6566](https://github.com/eclipse/che/pull/6566) ([riuvshin](https://github.com/riuvshin))
- apply formatter, fix build [\#6563](https://github.com/eclipse/che/pull/6563) ([riuvshin](https://github.com/riuvshin))
- Rework tests for checking TestRunner plugin [\#6559](https://github.com/eclipse/che/pull/6559) ([musienko-maxim](https://github.com/musienko-maxim))
- Added label comment for issue and PR templates [\#6558](https://github.com/eclipse/che/pull/6558) ([bmicklea](https://github.com/bmicklea))
- Fix php debugger test [\#6556](https://github.com/eclipse/che/pull/6556) ([tolusha](https://github.com/tolusha))
- Fix name of test project in its config [\#6554](https://github.com/eclipse/che/pull/6554) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Remove hard check for the zip extension [\#6552](https://github.com/eclipse/che/pull/6552) ([vparfonov](https://github.com/vparfonov))
- Set default value of the command's goal if it doesn't exist [\#6551](https://github.com/eclipse/che/pull/6551) ([svor](https://github.com/svor))
- CHE-6024: Add selenium test for git revert action [\#6550](https://github.com/eclipse/che/pull/6550) ([tolusha](https://github.com/tolusha))
- Add ability to check swagger with several workspaces in an account [\#6548](https://github.com/eclipse/che/pull/6548) ([musienko-maxim](https://github.com/musienko-maxim))
- Update list of stable selenium tests [\#6542](https://github.com/eclipse/che/pull/6542) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Change signature by adding throws section [\#6540](https://github.com/eclipse/che/pull/6540) ([vzhukovskii](https://github.com/vzhukovskii))
- CHE-6342: Rework git status feature [\#6536](https://github.com/eclipse/che/pull/6536) ([tolusha](https://github.com/tolusha))
- Fix closing by Esc Navigate to File panel [\#6531](https://github.com/eclipse/che/pull/6531) ([vparfonov](https://github.com/vparfonov))
- Exclude test data from docker build context [\#6526](https://github.com/eclipse/che/pull/6526) ([mmorhun](https://github.com/mmorhun))
- Add pagination to the full text search results [\#6522](https://github.com/eclipse/che/pull/6522) ([svor](https://github.com/svor))
- Add timeout before double click, need to fixing several test releted to command explorer feature [\#6519](https://github.com/eclipse/che/pull/6519) ([vparfonov](https://github.com/vparfonov))
- Fix CreateAndDeleteProjectsTest flow [\#6518](https://github.com/eclipse/che/pull/6518) ([vparfonov](https://github.com/vparfonov))
- Create a selenium test for testing workspace details page [\#6516](https://github.com/eclipse/che/pull/6516) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-6469 fix remove and duplicate buttons behavior after scrolling [\#6511](https://github.com/eclipse/che/pull/6511) ([olexii4](https://github.com/olexii4))
- CHE-4167. Fix cursor position in editor after refresh IDE [\#6507](https://github.com/eclipse/che/pull/6507) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Capture screenshot when selenium test configuration method fails [\#6506](https://github.com/eclipse/che/pull/6506) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Disable scheduling of methods annotated with @ScheduleRate/@ScheduleDelay if period/delay is negative [\#6505](https://github.com/eclipse/che/pull/6505) ([sunix](https://github.com/sunix))
- Fix unstable tests from miscellaneous package [\#6503](https://github.com/eclipse/che/pull/6503) ([SkorikSergey](https://github.com/SkorikSergey))
- Remove changelog section from PR template [\#6494](https://github.com/eclipse/che/pull/6494) ([slemeur](https://github.com/slemeur))
- Update stable selenium tests suite [\#6490](https://github.com/eclipse/che/pull/6490) ([dmytro-ndp](https://github.com/dmytro-ndp))
- OpenShift Connector : Fix the issue when no exposed ports are defined in the docker image [\#6488](https://github.com/eclipse/che/pull/6488) ([benoitf](https://github.com/benoitf))
- Add more quick starts for vert.x, spring boot, and wildfly swarm [\#6484](https://github.com/eclipse/che/pull/6484) ([JPinkney](https://github.com/JPinkney))
- CHE-4952. Fix problems related to simultaneous opening files [\#6478](https://github.com/eclipse/che/pull/6478) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Fix comparing selenium tests execution results with CI [\#6477](https://github.com/eclipse/che/pull/6477) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Call sync then all project imported [\#6473](https://github.com/eclipse/che/pull/6473) ([vparfonov](https://github.com/vparfonov))
- Fix widget initialization avoid registration multiple handlers [\#6472](https://github.com/eclipse/che/pull/6472) ([vparfonov](https://github.com/vparfonov))
- Revert Git revert action [\#6470](https://github.com/eclipse/che/pull/6470) ([tolusha](https://github.com/tolusha))
- Do not store preferences when workspace has already stopped [\#6464](https://github.com/eclipse/che/pull/6464) ([vzhukovskii](https://github.com/vzhukovskii))
- Small fixes for master [\#6462](https://github.com/eclipse/che/pull/6462) ([tolusha](https://github.com/tolusha))
- Remove unnecessary tests from factory package [\#6458](https://github.com/eclipse/che/pull/6458) ([musienko-maxim](https://github.com/musienko-maxim))
- Fix the stack json link in openshift script [\#6454](https://github.com/eclipse/che/pull/6454) ([benoitf](https://github.com/benoitf))
- Rework refactoring preview test [\#6449](https://github.com/eclipse/che/pull/6449) ([musienko-maxim](https://github.com/musienko-maxim))
- Avoid NPE by checking if map are null and not only empty in OpenShift connector [\#6448](https://github.com/eclipse/che/pull/6448) ([benoitf](https://github.com/benoitf))
- Reworks CheckWsAgentAfterStopProcessTest test [\#6445](https://github.com/eclipse/che/pull/6445) ([SkorikSergey](https://github.com/SkorikSergey))
- Multi-user Eclipse Che [\#6441](https://github.com/eclipse/che/pull/6441) ([skabashnyuk](https://github.com/skabashnyuk))
- Fix formatting [\#6439](https://github.com/eclipse/che/pull/6439) ([vparfonov](https://github.com/vparfonov))
- code clean-up [\#6435](https://github.com/eclipse/che/pull/6435) ([akurinnoy](https://github.com/akurinnoy))
- Fix unstable selenium tests from dashboard package [\#6434](https://github.com/eclipse/che/pull/6434) ([SkorikSergey](https://github.com/SkorikSergey))
- Need to force update presentation to correct display node in project explorer  [\#6432](https://github.com/eclipse/che/pull/6432) ([vparfonov](https://github.com/vparfonov))
- fix unbound variable in cli tests [\#6431](https://github.com/eclipse/che/pull/6431) ([riuvshin](https://github.com/riuvshin))
- apply formatter, fix build [\#6429](https://github.com/eclipse/che/pull/6429) ([riuvshin](https://github.com/riuvshin))
- Add checking on null [\#6428](https://github.com/eclipse/che/pull/6428) ([vparfonov](https://github.com/vparfonov))
- Add notification to the event pannel if project are removed [\#6427](https://github.com/eclipse/che/pull/6427) ([vparfonov](https://github.com/vparfonov))
- CHE-5997: fix for updating node's presentation [\#6426](https://github.com/eclipse/che/pull/6426) ([svor](https://github.com/svor))
- Fix widget intialization [\#6421](https://github.com/eclipse/che/pull/6421) ([vparfonov](https://github.com/vparfonov))
- Fix logging when exception occurs on operations with workspaces' ssh … [\#6419](https://github.com/eclipse/che/pull/6419) ([sleshchenko](https://github.com/sleshchenko))
- Fix project path in some test related to Factory feature [\#6418](https://github.com/eclipse/che/pull/6418) ([vparfonov](https://github.com/vparfonov))
- Add possibility to disable DockerInstanceStopDetector [\#6415](https://github.com/eclipse/che/pull/6415) ([garagatyi](https://github.com/garagatyi))
- Reused antlr java 5 grammar from che-lib [\#6410](https://github.com/eclipse/che/pull/6410) ([skabashnyuk](https://github.com/skabashnyuk))
- CHE-4634 replace ZeroClipboard library with HTML5 clipboard APIs [\#6409](https://github.com/eclipse/che/pull/6409) ([olexii4](https://github.com/olexii4))
- Fix build with invalid import [\#6407](https://github.com/eclipse/che/pull/6407) ([benoitf](https://github.com/benoitf))
- CHE-6397: set missing environment context on machine start [\#6403](https://github.com/eclipse/che/pull/6403) ([garagatyi](https://github.com/garagatyi))
- Rework and add test for checking of Test Runner plugin  [\#6401](https://github.com/eclipse/che/pull/6401) ([musienko-maxim](https://github.com/musienko-maxim))
- Add small changes to selenium tests to according to client [\#6399](https://github.com/eclipse/che/pull/6399) ([artaleks9](https://github.com/artaleks9))
- Rework FindTextFeature test [\#6395](https://github.com/eclipse/che/pull/6395) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-5834: fix wrong behavior in "Add or Import Project" form [\#6392](https://github.com/eclipse/che/pull/6392) ([akurinnoy](https://github.com/akurinnoy))
- Move the Openshift scripts from the cli image to the init image [\#6390](https://github.com/eclipse/che/pull/6390) ([davidfestal](https://github.com/davidfestal))
- Start importing projects only then IDE fully initilized  [\#6387](https://github.com/eclipse/che/pull/6387) ([vparfonov](https://github.com/vparfonov))
- CHE-6024: Revert commit action [\#6386](https://github.com/eclipse/che/pull/6386) ([tolusha](https://github.com/tolusha))
- CHE-5729: fix the preview page of refactoring [\#6385](https://github.com/eclipse/che/pull/6385) ([svor](https://github.com/svor))
- Clean up target directory at start of selenium tests [\#6380](https://github.com/eclipse/che/pull/6380) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Allow overriding the images used by the CLI [\#6379](https://github.com/eclipse/che/pull/6379) ([davidfestal](https://github.com/davidfestal))
- Update EclipseLink to v2.7.0 [\#6377](https://github.com/eclipse/che/pull/6377) ([benoitf](https://github.com/benoitf))
- Fix format of NavigateToFile.java [\#6376](https://github.com/eclipse/che/pull/6376) ([SkorikSergey](https://github.com/SkorikSergey))
- fix docker images build [\#6372](https://github.com/eclipse/che/pull/6372) ([riuvshin](https://github.com/riuvshin))
- Integrated yaml language server [\#6371](https://github.com/eclipse/che/pull/6371) ([JPinkney](https://github.com/JPinkney))
- interrupt build scripts for Dockerfiles on failure [\#6363](https://github.com/eclipse/che/pull/6363) ([riuvshin](https://github.com/riuvshin))
- Clean up test workspaces after the selenium tests execution [\#6354](https://github.com/eclipse/che/pull/6354) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Remove unused legacy parts [\#6351](https://github.com/eclipse/che/pull/6351) ([skabashnyuk](https://github.com/skabashnyuk))
- fix che-lib build.sh if condition [\#6350](https://github.com/eclipse/che/pull/6350) ([riuvshin](https://github.com/riuvshin))
- DTO TypeScript generator: Some DTO in Che are using "arguments" and this is a reserved keyword [\#6349](https://github.com/eclipse/che/pull/6349) ([benoitf](https://github.com/benoitf))
- Fix find action selenium test [\#6340](https://github.com/eclipse/che/pull/6340) ([mmorhun](https://github.com/mmorhun))
- Add support to VS Code style snippets in code completion [\#6339](https://github.com/eclipse/che/pull/6339) ([tsmaeder](https://github.com/tsmaeder))
- Remove gitter and add public channel on mattermost [\#6322](https://github.com/eclipse/che/pull/6322) ([slemeur](https://github.com/slemeur))
- Fix locators in NavigateToFile page object [\#6266](https://github.com/eclipse/che/pull/6266) ([SkorikSergey](https://github.com/SkorikSergey))
- Implemented getVersion in OpenShiftConnector [\#6222](https://github.com/eclipse/che/pull/6222) ([JPinkney](https://github.com/JPinkney))
- Implemented top method in OpenShiftConnector [\#6221](https://github.com/eclipse/che/pull/6221) ([JPinkney](https://github.com/JPinkney))
- Added getSystemInfo into OpenShiftConnector [\#6218](https://github.com/eclipse/che/pull/6218) ([JPinkney](https://github.com/JPinkney))
- CHE-5729: adapt PHP test runner according new API [\#6201](https://github.com/eclipse/che/pull/6201) ([svor](https://github.com/svor))
- che-6024: Add 'Git revert' action [\#6108](https://github.com/eclipse/che/pull/6108) ([bdshadow](https://github.com/bdshadow))
- Add git changes markers to the editor [\#6054](https://github.com/eclipse/che/pull/6054) ([vinokurig](https://github.com/vinokurig))
- \[dashboard\] Use `open` instead of `toggle` [\#6052](https://github.com/eclipse/che/pull/6052) ([svenefftinge](https://github.com/svenefftinge))
- Remove the che-specifc variants of the Bitnami development container … [\#5888](https://github.com/eclipse/che/pull/5888) ([amrecio](https://github.com/amrecio))


## [5.18.0](https://github.com/eclipse/che/tree/5.18.0) (2017-09-20)
[Full Changelog](https://github.com/eclipse/che/compare/5.17.0...5.18.0)

**Merged pull requests:**

- Remove unused legacy parts [\#6351](https://github.com/eclipse/che/pull/6351) ([skabashnyuk](https://github.com/skabashnyuk))
- RELEASE: Set next development version [\#6345](https://github.com/eclipse/che/pull/6345) ([riuvshin](https://github.com/riuvshin))
- Fix find action selenium test [\#6340](https://github.com/eclipse/che/pull/6340) ([mmorhun](https://github.com/mmorhun))
- Adding support of applying limitranges / resourcequotas on minishift [\#6337](https://github.com/eclipse/che/pull/6337) ([ibuziuk](https://github.com/ibuziuk))
- Remove unneeded license checking excludes [\#6316](https://github.com/eclipse/che/pull/6316) ([garagatyi](https://github.com/garagatyi))
- Clean up test workspaces [\#6293](https://github.com/eclipse/che/pull/6293) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Change name of test class in the suite after renaming [\#6282](https://github.com/eclipse/che/pull/6282) ([musienko-maxim](https://github.com/musienko-maxim))
- Common fixes for master [\#6270](https://github.com/eclipse/che/pull/6270) ([musienko-maxim](https://github.com/musienko-maxim))
- CHE-6033: Fix bug when git colors are note updated after git operations [\#6262](https://github.com/eclipse/che/pull/6262) ([vinokurig](https://github.com/vinokurig))
- Fix up tests in the package 'git' [\#6257](https://github.com/eclipse/che/pull/6257) ([artaleks9](https://github.com/artaleks9))
- openshift.io-798 Checking only first 20 chars of tag in 'getImageStreamTagFromRepo' for long tags [\#6245](https://github.com/eclipse/che/pull/6245) ([ibuziuk](https://github.com/ibuziuk))
- \#5791 save user preferences when window lost focus [\#6224](https://github.com/eclipse/che/pull/6224) ([evidolob](https://github.com/evidolob))
- CODENVY-2284: Add additional logs [\#6217](https://github.com/eclipse/che/pull/6217) ([mmorhun](https://github.com/mmorhun))
- Adapt existing selenium tests that use workspace details page [\#6214](https://github.com/eclipse/che/pull/6214) ([SkorikSergey](https://github.com/SkorikSergey))
- CHE-5936 Fix build [\#6181](https://github.com/eclipse/che/pull/6181) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- \#5695 avoid leaking of double click handler [\#6168](https://github.com/eclipse/che/pull/6168) ([evidolob](https://github.com/evidolob))
- Fix the invalid null check. [\#6164](https://github.com/eclipse/che/pull/6164) ([monaka](https://github.com/monaka))
- Fix warning in pom.xml [\#6158](https://github.com/eclipse/che/pull/6158) ([vparfonov](https://github.com/vparfonov))
- \#6016 do not register highlight service if no patterns provided [\#6146](https://github.com/eclipse/che/pull/6146) ([evidolob](https://github.com/evidolob))
- Fix timeout on restoring multiple files on startup [\#6141](https://github.com/eclipse/che/pull/6141) ([tsmaeder](https://github.com/tsmaeder))
- Fix code actions [\#6113](https://github.com/eclipse/che/pull/6113) ([tsmaeder](https://github.com/tsmaeder))
- Fix workspace symbol handling [\#6112](https://github.com/eclipse/che/pull/6112) ([tsmaeder](https://github.com/tsmaeder))
- Don't wait 5 seconds for Language servers [\#6111](https://github.com/eclipse/che/pull/6111) ([tsmaeder](https://github.com/tsmaeder))
- Scripts to deploy Che on OpenShift [\#6098](https://github.com/eclipse/che/pull/6098) ([l0rd](https://github.com/l0rd))
- RELEASE: Update CHANGELOG [\#6087](https://github.com/eclipse/che/pull/6087) ([riuvshin](https://github.com/riuvshin))
- \#1796 log telemetry event [\#6079](https://github.com/eclipse/che/pull/6079) ([evidolob](https://github.com/evidolob))
- Some JSON RPC requests are not processed by RequestHandlerManage [\#5991](https://github.com/eclipse/che/pull/5991) ([dkuleshov](https://github.com/dkuleshov))
- Add ability to switch between files in Git Diff widget [\#5965](https://github.com/eclipse/che/pull/5965) ([mmorhun](https://github.com/mmorhun))
- Add implementation for 'Show message request' LS feature [\#5860](https://github.com/eclipse/che/pull/5860) ([evidolob](https://github.com/evidolob))
- Thread dump for java debugger [\#5320](https://github.com/eclipse/che/pull/5320) ([tolusha](https://github.com/tolusha))
- fix che-lib build.sh if condition [\#6350](https://github.com/eclipse/che/pull/6350) ([riuvshin](https://github.com/riuvshin))
- DTO TypeScript generator: Some DTO in Che are using "arguments" and this is a reserved keyword [\#6349](https://github.com/eclipse/che/pull/6349) ([benoitf](https://github.com/benoitf))
- Workaround for fixing freeze browser for big project [\#6341](https://github.com/eclipse/che/pull/6341) ([vparfonov](https://github.com/vparfonov))
- Add warning message when trying to get the not existing workspace [\#6290](https://github.com/eclipse/che/pull/6290) ([olexii4](https://github.com/olexii4))
- Fix and improve some actions [\#6287](https://github.com/eclipse/che/pull/6287) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- CHE-6046. Provide correct data for search results of Find text feature [\#6275](https://github.com/eclipse/che/pull/6275) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Inject unsubscribe handlers [\#6273](https://github.com/eclipse/che/pull/6273) ([vparfonov](https://github.com/vparfonov))
- Che dockerfiles: apply chmod only to folders to fool COW [\#6272](https://github.com/eclipse/che/pull/6272) ([l0rd](https://github.com/l0rd))
- CHE-6162: Fix problem project detection procedure  [\#6264](https://github.com/eclipse/che/pull/6264) ([vparfonov](https://github.com/vparfonov))
- CHE-5925: Add hotkeys to the most usable git actions [\#6247](https://github.com/eclipse/che/pull/6247) ([mmorhun](https://github.com/mmorhun))
- Added compile goal to vertx stack debug command [\#6212](https://github.com/eclipse/che/pull/6212) ([JPinkney](https://github.com/JPinkney))
- CHE-6063. Improve mechanism of handling file watcher 'MODIFIED' events [\#6209](https://github.com/eclipse/che/pull/6209) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Setup Traefik container to restart policy 'always'. [\#6207](https://github.com/eclipse/che/pull/6207) ([monaka](https://github.com/monaka))
- Backport rh-che changes to OpenShift deployment script [\#6202](https://github.com/eclipse/che/pull/6202) ([l0rd](https://github.com/l0rd))
- Modify che-server Dockerfile to run on OpenShift [\#6200](https://github.com/eclipse/che/pull/6200) ([l0rd](https://github.com/l0rd))
- CHE-6191: FIx bug when can not open project in workspace with custom … [\#6196](https://github.com/eclipse/che/pull/6196) ([vinokurig](https://github.com/vinokurig))
- CHE-5741:  Auto focus after selection terminal. [\#6192](https://github.com/eclipse/che/pull/6192) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Unconfigured as project top level folder will marked as detected project [\#6184](https://github.com/eclipse/che/pull/6184) ([vparfonov](https://github.com/vparfonov))
- Project service: Lazy init of Tika [\#6179](https://github.com/eclipse/che/pull/6179) ([benoitf](https://github.com/benoitf))
- plugin maven server: lazily init the local repository. [\#6178](https://github.com/eclipse/che/pull/6178) ([benoitf](https://github.com/benoitf))
- CHE-5936 Properly handle changing workspace [\#6176](https://github.com/eclipse/che/pull/6176) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- CHE-6114: Fix problems with project explorer performance in big projects [\#6175](https://github.com/eclipse/che/pull/6175) ([vinokurig](https://github.com/vinokurig))
- There is no Java code inside the IDE.JSP so there is no need to have all JSP stuff [\#6174](https://github.com/eclipse/che/pull/6174) ([benoitf](https://github.com/benoitf))
- CHE-5338. Clean up app state preference when workspace is removed [\#6172](https://github.com/eclipse/che/pull/6172) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Fix gulp test task execution [\#6171](https://github.com/eclipse/che/pull/6171) ([ashumilova](https://github.com/ashumilova))
- JDT core module: GWT dependency should not be there. It's running on server side. [\#6167](https://github.com/eclipse/che/pull/6167) ([benoitf](https://github.com/benoitf))
- CHE-5810: Improve client encoding for file or folder path to support special symbols [\#6166](https://github.com/eclipse/che/pull/6166) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Use concrete node version for UD Dockerfile [\#6147](https://github.com/eclipse/che/pull/6147) ([riuvshin](https://github.com/riuvshin))
- CHE-5886: Run XML test suite for TestNG [\#6145](https://github.com/eclipse/che/pull/6145) ([svor](https://github.com/svor))
- Temporary workaround limit search result to 50 file [\#6142](https://github.com/eclipse/che/pull/6142) ([vparfonov](https://github.com/vparfonov))
- Remove unsupported ant extension [\#6140](https://github.com/eclipse/che/pull/6140) ([skabashnyuk](https://github.com/skabashnyuk))
- fix cli config test [\#6137](https://github.com/eclipse/che/pull/6137) ([riuvshin](https://github.com/riuvshin))
- Fix switch statement [\#6135](https://github.com/eclipse/che/pull/6135) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Use ws-agent's Java in testing plugin [\#6132](https://github.com/eclipse/che/pull/6132) ([eivantsov](https://github.com/eivantsov))
- Docker image testing : exit if any test failed to prevent pushing images [\#6131](https://github.com/eclipse/che/pull/6131) ([riuvshin](https://github.com/riuvshin))
- CHE-5721: Importing java formatter for the project or workspace [\#6077](https://github.com/eclipse/che/pull/6077) ([svor](https://github.com/svor))
- 5485 apply workspace edit [\#5955](https://github.com/eclipse/che/pull/5955) ([tsmaeder](https://github.com/tsmaeder))
- Rework workspace detail flow [\#5451](https://github.com/eclipse/che/pull/5451) ([olexii4](https://github.com/olexii4))


## [5.17.0](https://github.com/eclipse/che/tree/5.17.0) (2017-08-23)
[Full Changelog](https://github.com/eclipse/che/compare/5.16.0...5.17.0)

**Merged pull requests:**

- RELEASE: Update CHANGELOG [\#6074](https://github.com/eclipse/che/pull/6074) ([riuvshin](https://github.com/riuvshin))
- RELEASE: Set next development version [\#6067](https://github.com/eclipse/che/pull/6067) ([riuvshin](https://github.com/riuvshin))
- CODENVY-2356: Allow exception attributes [\#6053](https://github.com/eclipse/che/pull/6053) ([mmorhun](https://github.com/mmorhun))
- Reverting \#6019: Workaround for ImageStreamTags issue on OpenShift 3.6 [\#6023](https://github.com/eclipse/che/pull/6023) ([ibuziuk](https://github.com/ibuziuk))
- \#5750 fix cursor position after completion proposal inserted [\#6020](https://github.com/eclipse/che/pull/6020) ([evidolob](https://github.com/evidolob))
- Workaround for ImageStreamTags issue on OpenShift 3.6 [\#6019](https://github.com/eclipse/che/pull/6019) ([amisevsk](https://github.com/amisevsk))
- Changing deletion order during deployment cleaup \(routes & services are going to be deleted first\) [\#6018](https://github.com/eclipse/che/pull/6018) ([ibuziuk](https://github.com/ibuziuk))
- Fix OpenShiftConnector.inspectImage\(\) to resolve issue in OS 3.6+ [\#6009](https://github.com/eclipse/che/pull/6009) ([amisevsk](https://github.com/amisevsk))
- Revert "CHE-5174 Improving search results " [\#5988](https://github.com/eclipse/che/pull/5988) ([vparfonov](https://github.com/vparfonov))
- Fix license [\#5984](https://github.com/eclipse/che/pull/5984) ([vinokurig](https://github.com/vinokurig))
- Fix typo - https://github.com/eclipse/che/issues/5980 [\#5983](https://github.com/eclipse/che/pull/5983) ([eivantsov](https://github.com/eivantsov))
- Adding assembly-ide-war `webapp` source folder as sources instead of resources to avoid duplicated files in final war [\#5979](https://github.com/eclipse/che/pull/5979) ([sunix](https://github.com/sunix))
- Adding sources maven artifact for dashboard-war [\#5971](https://github.com/eclipse/che/pull/5971) ([sunix](https://github.com/sunix))
- CHE-3415: Change 'Rebase instead of merge' checkbox title [\#5969](https://github.com/eclipse/che/pull/5969) ([vinokurig](https://github.com/vinokurig))
- Adding missing source folders to assembly-ide-war sources Maven artifact [\#5966](https://github.com/eclipse/che/pull/5966) ([sunix](https://github.com/sunix))
- Update Che Dev Dockerfile [\#5959](https://github.com/eclipse/che/pull/5959) ([JamesDrummond](https://github.com/JamesDrummond))
- Move activity components to plugin-activity [\#5896](https://github.com/eclipse/che/pull/5896) ([mkuznyetsov](https://github.com/mkuznyetsov))
- CHE-5174 Improving search results  [\#5874](https://github.com/eclipse/che/pull/5874) ([vparfonov](https://github.com/vparfonov))
- Add selenium tests [\#5759](https://github.com/eclipse/che/pull/5759) ([tolusha](https://github.com/tolusha))
- Rework import operation [\#6065](https://github.com/eclipse/che/pull/6065) ([vzhukovskii](https://github.com/vzhukovskii))
- Synchronize commands with rh-che stacks [\#6050](https://github.com/eclipse/che/pull/6050) ([benoitf](https://github.com/benoitf))
- Fixed some formatting differences [\#6044](https://github.com/eclipse/che/pull/6044) ([skabashnyuk](https://github.com/skabashnyuk))
- Cursor jumps to the top of the file  [\#6043](https://github.com/eclipse/che/pull/6043) ([dkuleshov](https://github.com/dkuleshov))
- Allow to proper set webscoket context [\#6038](https://github.com/eclipse/che/pull/6038) ([ashumilova](https://github.com/ashumilova))
- Change license headers copyright owner on remaining files [\#6036](https://github.com/eclipse/che/pull/6036) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Remove UI loader in few places not annoying user in case bad network connection [\#6035](https://github.com/eclipse/che/pull/6035) ([vparfonov](https://github.com/vparfonov))
- Change copyright owner to "Red Hat, Inc" on remaining files [\#6032](https://github.com/eclipse/che/pull/6032) ([mkuznyetsov](https://github.com/mkuznyetsov))
- CHE-6025: Fix bug when Project wizard is not closed after importing m… [\#6031](https://github.com/eclipse/che/pull/6031) ([vinokurig](https://github.com/vinokurig))
- Fix TypeScript DTO Generator for newly float type introduced [\#6029](https://github.com/eclipse/che/pull/6029) ([benoitf](https://github.com/benoitf))
- Do not scale down deployment before resource deletion. Removing watch pod logic \(seems to be also broken after 3.6 osio update\) [\#6017](https://github.com/eclipse/che/pull/6017) ([ibuziuk](https://github.com/ibuziuk))
- The project still present after deletion through terminal or project service [\#6013](https://github.com/eclipse/che/pull/6013) ([dkuleshov](https://github.com/dkuleshov))
- CHE-4509: Fix project name validator for rename action [\#6011](https://github.com/eclipse/che/pull/6011) ([bdshadow](https://github.com/bdshadow))
- CHE-5995: Fix bug with Git repository initialization [\#6010](https://github.com/eclipse/che/pull/6010) ([vinokurig](https://github.com/vinokurig))
- \#1799 implement DidChangeWatchedFiles Notification [\#6007](https://github.com/eclipse/che/pull/6007) ([evidolob](https://github.com/evidolob))
- CHE-5944. Fix editor keybindings displaying [\#6005](https://github.com/eclipse/che/pull/6005) ([RomanNikitenko](https://github.com/RomanNikitenko))
- CHE-5829. Fix non-exhaustive switch statements [\#6004](https://github.com/eclipse/che/pull/6004) ([RomanNikitenko](https://github.com/RomanNikitenko))
- CHE-5828. Remove extra expression [\#6001](https://github.com/eclipse/che/pull/6001) ([RomanNikitenko](https://github.com/RomanNikitenko))
- CHE-5881. Add ability to add a project folder to File watcher excludes [\#5998](https://github.com/eclipse/che/pull/5998) ([RomanNikitenko](https://github.com/RomanNikitenko))
- CHE-5174 Improving search results  [\#5989](https://github.com/eclipse/che/pull/5989) ([vparfonov](https://github.com/vparfonov))
- CHE-5823. Fix editor tabs displaying at refreshing page [\#5975](https://github.com/eclipse/che/pull/5975) ([RomanNikitenko](https://github.com/RomanNikitenko))
- CHE-5875: active editor when Go to line feature was accepted [\#5972](https://github.com/eclipse/che/pull/5972) ([svor](https://github.com/svor))
- CHE-5274. Do not skip setting focus on element when window is displayed [\#5968](https://github.com/eclipse/che/pull/5968) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Changed copyright owner to "Red Hat, Inc." in license headers [\#5964](https://github.com/eclipse/che/pull/5964) ([mkuznyetsov](https://github.com/mkuznyetsov))
- CHE-4783 Initial splash should be smarter [\#5961](https://github.com/eclipse/che/pull/5961) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- CHE-5737: run custom set of tests [\#5956](https://github.com/eclipse/che/pull/5956) ([svor](https://github.com/svor))
- CHE-5890: add Test group menu to the editor context menu [\#5953](https://github.com/eclipse/che/pull/5953) ([svor](https://github.com/svor))
- Rework dashboard to work through JSON RPC protocol [\#5952](https://github.com/eclipse/che/pull/5952) ([ashumilova](https://github.com/ashumilova))
- Migrate to .NET 2.0 [\#5942](https://github.com/eclipse/che/pull/5942) ([eivantsov](https://github.com/eivantsov))
- Used Google Java Codestyle [\#5851](https://github.com/eclipse/che/pull/5851) ([skabashnyuk](https://github.com/skabashnyuk))
- CHE-5792: Add ability to adjust viewing 'maven module artifact id' in preferences window [\#5849](https://github.com/eclipse/che/pull/5849) ([vinokurig](https://github.com/vinokurig))
- CHE-5335: Add Git branch/revision link to project name [\#5817](https://github.com/eclipse/che/pull/5817) ([vinokurig](https://github.com/vinokurig))
- CHE-5339: Mark with color Git changed files in project explorer [\#5722](https://github.com/eclipse/che/pull/5722) ([vinokurig](https://github.com/vinokurig))


## [5.16.0](https://github.com/eclipse/che/tree/5.16.0) (2017-08-09)
[Full Changelog](https://github.com/eclipse/che/compare/5.15.0...5.16.0)

**Merged pull requests:**

- Rework dashboard to work through JSON RPC protocol [\#5952](https://github.com/eclipse/che/pull/5952) ([ashumilova](https://github.com/ashumilova))
- RELEASE: Set next development version [\#5949](https://github.com/eclipse/che/pull/5949) ([riuvshin](https://github.com/riuvshin))
- Adding debug commands for vertx & spring-boot stacks [\#5938](https://github.com/eclipse/che/pull/5938) ([ibuziuk](https://github.com/ibuziuk))
- CHE-3221: Fix git compare on submodules. [\#5799](https://github.com/eclipse/che/pull/5799) ([mmorhun](https://github.com/mmorhun))
- Implement mechanism for providing unique ids for JSON-RPC clients [\#5775](https://github.com/eclipse/che/pull/5775) ([dkuleshov](https://github.com/dkuleshov))
- CHE-249: Setting workspace Pod terminationGracePeriodSeconds to zero [\#5773](https://github.com/eclipse/che/pull/5773) ([ibuziuk](https://github.com/ibuziuk))
- CHE-220: Improving 'removeContainer' API. Refactoring [\#5766](https://github.com/eclipse/che/pull/5766) ([ibuziuk](https://github.com/ibuziuk))
- Fix DtoServer error messages [\#5764](https://github.com/eclipse/che/pull/5764) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Small formatting fix [\#5755](https://github.com/eclipse/che/pull/5755) ([dkuleshov](https://github.com/dkuleshov))
- set actual parent version [\#5749](https://github.com/eclipse/che/pull/5749) ([riuvshin](https://github.com/riuvshin))
- RELEASE: Update CHANGELOG [\#5744](https://github.com/eclipse/che/pull/5744) ([riuvshin](https://github.com/riuvshin))
- CHE-5601: fix the bug with RAM spinner [\#5732](https://github.com/eclipse/che/pull/5732) ([akurinnoy](https://github.com/akurinnoy))
- CHE-5152: Apply pagination in Git Reset window [\#5726](https://github.com/eclipse/che/pull/5726) ([mmorhun](https://github.com/mmorhun))
- Fix LSP didChange parameters \#4978 [\#5002](https://github.com/eclipse/che/pull/5002) ([tsmaeder](https://github.com/tsmaeder))
- Update OpenJDK notification file [\#5939](https://github.com/eclipse/che/pull/5939) ([riuvshin](https://github.com/riuvshin))
- Fix an erroneous change of vertx and spring boot stacks [\#5937](https://github.com/eclipse/che/pull/5937) ([davidfestal](https://github.com/davidfestal))
- CHE-5718 Progress of the importing project is not displayed [\#5934](https://github.com/eclipse/che/pull/5934) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- CHE-5840. Do not do extra updating of editor content [\#5929](https://github.com/eclipse/che/pull/5929) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Revert Avoid NPE at using MutableProjectConfig [\#5909](https://github.com/eclipse/che/pull/5909) ([RomanNikitenko](https://github.com/RomanNikitenko))
- CHE-5334. Fix hover state [\#5899](https://github.com/eclipse/che/pull/5899) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Fixed typo in workspace list [\#5895](https://github.com/eclipse/che/pull/5895) ([hkolvenbach](https://github.com/hkolvenbach))
- CHE-5862: Set right handler on double click in Git Compare window [\#5885](https://github.com/eclipse/che/pull/5885) ([mmorhun](https://github.com/mmorhun))
- Sequential restore of the persistence components [\#5882](https://github.com/eclipse/che/pull/5882) ([vzhukovskii](https://github.com/vzhukovskii))
- Create routes in openshift with the same pattern than the urls provided by naming strategy [\#5879](https://github.com/eclipse/che/pull/5879) ([benoitf](https://github.com/benoitf))
- CHE-5725: fixes for test running [\#5877](https://github.com/eclipse/che/pull/5877) ([svor](https://github.com/svor))
- CHE-5379: fix wrong cursor placement for auto completion [\#5873](https://github.com/eclipse/che/pull/5873) ([svor](https://github.com/svor))
- Avoid NPE at using MutableProjectConfig [\#5869](https://github.com/eclipse/che/pull/5869) ([RomanNikitenko](https://github.com/RomanNikitenko))
- CHE-5415. Do not display importer in the list of import dialog if no appropriate wizard was provided [\#5868](https://github.com/eclipse/che/pull/5868) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Fix launchers to call to set\_sudo\_command [\#5866](https://github.com/eclipse/che/pull/5866) ([l0rd](https://github.com/l0rd))
- set correct license header [\#5861](https://github.com/eclipse/che/pull/5861) ([riuvshin](https://github.com/riuvshin))
- CHE-4678: Add all/local/remote filter in Git branches dialog [\#5858](https://github.com/eclipse/che/pull/5858) ([vinokurig](https://github.com/vinokurig))
- Use docker to build dashboard app. \(as alternative\) [\#5848](https://github.com/eclipse/che/pull/5848) ([benoitf](https://github.com/benoitf))
- Ceylon stack [\#5844](https://github.com/eclipse/che/pull/5844) ([davidfestal](https://github.com/davidfestal))
- CHE-5654. Activate java reconciling when classpath is changed [\#5837](https://github.com/eclipse/che/pull/5837) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Avoid using `sudo` in agent launchers when the current user is not a sudoer [\#5835](https://github.com/eclipse/che/pull/5835) ([l0rd](https://github.com/l0rd))
- Replace method implementation [\#5833](https://github.com/eclipse/che/pull/5833) ([vzhukovskii](https://github.com/vzhukovskii))
- Fix for the code validation is not available for language servers  [\#5827](https://github.com/eclipse/che/pull/5827) ([dkuleshov](https://github.com/dkuleshov))
- CHE-5645. Fix resources synchronization [\#5825](https://github.com/eclipse/che/pull/5825) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Use try-with-resources statement for reading File Watcher ignore file [\#5811](https://github.com/eclipse/che/pull/5811) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Fix spring-boot stack run command [\#5809](https://github.com/eclipse/che/pull/5809) ([l0rd](https://github.com/l0rd))
- CHE-5236 Java debugger didn't highlight line in decompiled class [\#5808](https://github.com/eclipse/che/pull/5808) ([tolusha](https://github.com/tolusha))
- CHE-5777. Fix editor initialization [\#5807](https://github.com/eclipse/che/pull/5807) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Fix construct command actions after workspace restart [\#5806](https://github.com/eclipse/che/pull/5806) ([vzhukovskii](https://github.com/vzhukovskii))
- CHE-5725: Run all java tests from the project or package [\#5804](https://github.com/eclipse/che/pull/5804) ([svor](https://github.com/svor))
- Add compile to vertx run command [\#5803](https://github.com/eclipse/che/pull/5803) ([l0rd](https://github.com/l0rd))
- CHE-5633: improve experience when adding projects to a workspace  [\#5795](https://github.com/eclipse/che/pull/5795) ([akurinnoy](https://github.com/akurinnoy))
- CHE-3415: Add ability to perform Git pull with rebase [\#5787](https://github.com/eclipse/che/pull/5787) ([vinokurig](https://github.com/vinokurig))
- CHE-5692. Fix editor errors clearing [\#5778](https://github.com/eclipse/che/pull/5778) ([RomanNikitenko](https://github.com/RomanNikitenko))
- CHE-5130 Unexpected resetting of the scroll to bottom automatically button [\#5769](https://github.com/eclipse/che/pull/5769) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- CHE-5235: Fix step into when source cannot be obtained [\#5768](https://github.com/eclipse/che/pull/5768) ([mmorhun](https://github.com/mmorhun))
- CHE-5643. Add ability to select items in the quick fix window using keyboard [\#5761](https://github.com/eclipse/che/pull/5761) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Add url encoding [\#5758](https://github.com/eclipse/che/pull/5758) ([vparfonov](https://github.com/vparfonov))
- CHE-5599: add improvements for Filters widget [\#5756](https://github.com/eclipse/che/pull/5756) ([akurinnoy](https://github.com/akurinnoy))
- CHE-5615. Fix NPE at detecting tests by java test runner [\#5748](https://github.com/eclipse/che/pull/5748) ([RomanNikitenko](https://github.com/RomanNikitenko))
- CHE-5617. Set editor as active part when this one has initialized [\#5747](https://github.com/eclipse/che/pull/5747) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Fix run command for Eclipse Vert.x stack [\#5746](https://github.com/eclipse/che/pull/5746) ([l0rd](https://github.com/l0rd))
- Deprecate WsConnectionListener [\#5740](https://github.com/eclipse/che/pull/5740) ([RomanNikitenko](https://github.com/RomanNikitenko))
- RELEASE: Set next development version [\#5734](https://github.com/eclipse/che/pull/5734) ([riuvshin](https://github.com/riuvshin))
- Adapt JUnit4 runner according new API [\#5710](https://github.com/eclipse/che/pull/5710) ([svor](https://github.com/svor))


## [5.15.0](https://github.com/eclipse/che/tree/5.15.0) (2017-07-19)
[Full Changelog](https://github.com/eclipse/che/compare/5.14.0...5.15.0)

**Merged pull requests:**

- Rework Composer plugin to avoid using Everrest based Websocket calls [\#5629](https://github.com/eclipse/che/pull/5629) ([kaloyan-raev](https://github.com/kaloyan-raev))
- C/CPP compilation error/warning messages support \#5565 [\#5604](https://github.com/eclipse/che/pull/5604) ([vrubezhny](https://github.com/vrubezhny))
- Move mvn and svn tests execution to integration profile [\#5596](https://github.com/eclipse/che/pull/5596) ([garagatyi](https://github.com/garagatyi))
- Fix dependencies [\#5590](https://github.com/eclipse/che/pull/5590) ([vparfonov](https://github.com/vparfonov))
- Try to fix occasionally failing tests on CI [\#5585](https://github.com/eclipse/che/pull/5585) ([garagatyi](https://github.com/garagatyi))
- Handle no-content response in DefaultHttpJsonRequest [\#5577](https://github.com/eclipse/che/pull/5577) ([dmytro-ndp](https://github.com/dmytro-ndp))
- Maven Server tests execution on integration phase [\#5574](https://github.com/eclipse/che/pull/5574) ([vparfonov](https://github.com/vparfonov))
- Rework Navigate to File feature to avoid using Everrest based Websocket calls [\#5561](https://github.com/eclipse/che/pull/5561) ([dkuleshov](https://github.com/dkuleshov))
- Rework Find Usages feature to avoid using Everrest based Websocket calls [\#5550](https://github.com/eclipse/che/pull/5550) ([dkuleshov](https://github.com/dkuleshov))
- Use Orion annotation model instead 'showProblems' method [\#5518](https://github.com/eclipse/che/pull/5518) ([evidolob](https://github.com/evidolob))
- Improve idling implementation [\#5512](https://github.com/eclipse/che/pull/5512) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Normalize agent names [\#5479](https://github.com/eclipse/che/pull/5479) ([vinokurig](https://github.com/vinokurig))
- Update lsp4J lib to newer version. [\#5292](https://github.com/eclipse/che/pull/5292) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Openshift connector improvements [\#5052](https://github.com/eclipse/che/pull/5052) ([sunix](https://github.com/sunix))
- Move file header under imports [\#5727](https://github.com/eclipse/che/pull/5727) ([akorneta](https://github.com/akorneta))
- Show notification when the creation of workspace failed [\#5723](https://github.com/eclipse/che/pull/5723) ([akurinnoy](https://github.com/akurinnoy))
- Refresh commands list in project's context menu in IDE [\#5717](https://github.com/eclipse/che/pull/5717) ([akurinnoy](https://github.com/akurinnoy))
- Fixed displaying of Preview URL at refreshing page [\#5709](https://github.com/eclipse/che/pull/5709) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Openshift: add mounted volume for logs [\#5708](https://github.com/eclipse/che/pull/5708) ([benoitf](https://github.com/benoitf))
- Display notifications about external delete operation in Events panel [\#5707](https://github.com/eclipse/che/pull/5707) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Auto-detect recipe format and fix Git url pattern [\#5677](https://github.com/eclipse/che/pull/5677) ([ashumilova](https://github.com/ashumilova))
- Fixed focus position at editor state restoring [\#5665](https://github.com/eclipse/che/pull/5665) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Use LSP for pom editor [\#5641](https://github.com/eclipse/che/pull/5641) ([tsmaeder](https://github.com/tsmaeder))
- Avoid using ProjectManager just for taking project root dir [\#5636](https://github.com/eclipse/che/pull/5636) ([vparfonov](https://github.com/vparfonov))
- Show 'Quick Start' tab by default and consider stacks priority order [\#5632](https://github.com/eclipse/che/pull/5632) ([ashumilova](https://github.com/ashumilova))
- Fixed using project path and fileUri [\#5625](https://github.com/eclipse/che/pull/5625) ([vparfonov](https://github.com/vparfonov))
- Fixed machine's default docker image [\#5619](https://github.com/eclipse/che/pull/5619) ([ashumilova](https://github.com/ashumilova))
- Fixed Kotlin stack and dashboard reaction on missing workspace config in stack [\#5618](https://github.com/eclipse/che/pull/5618) ([ashumilova](https://github.com/ashumilova))
- Replaced Window.open\(\) with JS native call [\#5584](https://github.com/eclipse/che/pull/5584) ([vparfonov](https://github.com/vparfonov))
- Fix possible NullPointerException  [\#5582](https://github.com/eclipse/che/pull/5582) ([vparfonov](https://github.com/vparfonov))
- Run sync container in an interactive mode [\#5576](https://github.com/eclipse/che/pull/5576) ([eivantsov](https://github.com/eivantsov))
- Save button in Workspace config tab appears only after adding second symbol to config [\#5566](https://github.com/eclipse/che/pull/5566) ([bdshadow](https://github.com/bdshadow))
- Sort imports/ fix indent in openshift connector [\#5552](https://github.com/eclipse/che/pull/5552) ([benoitf](https://github.com/benoitf))
- Change names of methods for WebSocket communication [\#5543](https://github.com/eclipse/che/pull/5543) ([svor](https://github.com/svor))
- Move binding ServerIdleDetctor to the assembly module [\#5541](https://github.com/eclipse/che/pull/5541) ([vparfonov](https://github.com/vparfonov))
- .NET C\# stacktrace support \#5489 [\#5534](https://github.com/eclipse/che/pull/5534) ([vrubezhny](https://github.com/vrubezhny))
- Fixed broken links to che-docs [\#5531](https://github.com/eclipse/che/pull/5531) ([jonahkichwacoders](https://github.com/jonahkichwacoders))
- Register refresh method for ProjectExplorer native object [\#5530](https://github.com/eclipse/che/pull/5530) ([vzhukovskii](https://github.com/vzhukovskii))
- Rework Maven plugin to avoid using Everrest Websocket [\#5527](https://github.com/eclipse/che/pull/5527) ([svor](https://github.com/svor))
- Avoid possible NPE [\#5526](https://github.com/eclipse/che/pull/5526) ([vparfonov](https://github.com/vparfonov))
- Added Kotlin runtime stack [\#5520](https://github.com/eclipse/che/pull/5520) ([eivantsov](https://github.com/eivantsov))
- Ability to handle import logs from multiple projects [\#5511](https://github.com/eclipse/che/pull/5511) ([vzhukovskii](https://github.com/vzhukovskii))
- Fixed NPE in DockerConnector [\#5510](https://github.com/eclipse/che/pull/5510) ([mmorhun](https://github.com/mmorhun))
- Fixed for DefaultOutputCustomizerTest.java - wrong API is used in place… [\#5509](https://github.com/eclipse/che/pull/5509) ([vrubezhny](https://github.com/vrubezhny))
- Fixed entrypoint to respect CHE\_DOCKER\_IP [\#5507](https://github.com/eclipse/che/pull/5507) ([eivantsov](https://github.com/eivantsov))
- Remove unnecessary stack trace [\#5506](https://github.com/eclipse/che/pull/5506) ([mmorhun](https://github.com/mmorhun))
- Fixed group by folders view in commit dialog [\#5504](https://github.com/eclipse/che/pull/5504) ([vinokurig](https://github.com/vinokurig))
- Updated Bitnami stacks to latest versions [\#5501](https://github.com/eclipse/che/pull/5501) ([amrecio](https://github.com/amrecio))
- Add repository and registry host in log on snapshot deletion failure [\#5500](https://github.com/eclipse/che/pull/5500) ([mmorhun](https://github.com/mmorhun))
- Make gwt-logger project m2e-compatible [\#5496](https://github.com/eclipse/che/pull/5496) ([tsmaeder](https://github.com/tsmaeder))
- CHE-5215. Add ability to exclude tracking files by file watcher [\#5495](https://github.com/eclipse/che/pull/5495) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Reworked importing a project while consuming Factory to avoid using Everrest based Websocket calls [\#5493](https://github.com/eclipse/che/pull/5493) ([dkuleshov](https://github.com/dkuleshov))
- Removed deprecated single descriptor and move to multi descriptors which is the replacement [\#5490](https://github.com/eclipse/che/pull/5490) ([benoitf](https://github.com/benoitf))
- Rework git client-service and other git client classes [\#5476](https://github.com/eclipse/che/pull/5476) ([vinokurig](https://github.com/vinokurig))
- New runner for TestNG tests [\#5472](https://github.com/eclipse/che/pull/5472) ([svor](https://github.com/svor))
- Let users to use .Chefile in addition to Chefile [\#5471](https://github.com/eclipse/che/pull/5471) ([benoitf](https://github.com/benoitf))
- Added new workspace creation flow [\#5447](https://github.com/eclipse/che/pull/5447) ([akurinnoy](https://github.com/akurinnoy))
- Added support for using multiple language servers to be registered for the same files \#4609 [\#5442](https://github.com/eclipse/che/pull/5442) ([tsmaeder](https://github.com/tsmaeder))
- Java stacktrace support \(From Platform to Che Workspace\) [\#5396](https://github.com/eclipse/che/pull/5396) ([vrubezhny](https://github.com/vrubezhny))
- Updated modification stamp on open and on update document. [\#5391](https://github.com/eclipse/che/pull/5391) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Added CentOS based Golang stack to default assembly [\#5282](https://github.com/eclipse/che/pull/5282) ([dharmit](https://github.com/dharmit))
- Ability to register language servers for file names instead of extensions \#5107 [\#5156](https://github.com/eclipse/che/pull/5156) ([tsmaeder](https://github.com/tsmaeder))
- Support for multiple highlights [\#5038](https://github.com/eclipse/che/pull/5038) ([tsmaeder](https://github.com/tsmaeder))
- Added CentOS based minimal stack with only git to default assembly [\#4847](https://github.com/eclipse/che/pull/4847) ([dharmit](https://github.com/dharmit))


## [5.14.0](https://github.com/eclipse/che/tree/5.14.0) (2017-06-29)
[Full Changelog](https://github.com/eclipse/che/compare/5.13.0...5.14.0)

**Merged pull requests:**

- PhpUnit testing PR  [\#5468](https://github.com/eclipse/che/pull/5468) ([vparfonov](https://github.com/vparfonov))
- Added additional logs if start from snapshot fail [\#5465](https://github.com/eclipse/che/pull/5465) ([mmorhun](https://github.com/mmorhun))
- Removed not used implementation, mark interface as deprecated [\#5448](https://github.com/eclipse/che/pull/5448) ([vparfonov](https://github.com/vparfonov))
- Added ability to perform Git push with force option [\#5444](https://github.com/eclipse/che/pull/5444) ([vinokurig](https://github.com/vinokurig))
- Added notification file for openJDK [\#5441](https://github.com/eclipse/che/pull/5441) ([riuvshin](https://github.com/riuvshin))
- [UD] Added readonly attribute for the input box widget [\#5432](https://github.com/eclipse/che/pull/5432) ([olexii4](https://github.com/olexii4))
- Mark editor state as dirty after undo/redo operations [\#5408](https://github.com/eclipse/che/pull/5408) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Added Alpine support to ls-json [\#4947](https://github.com/eclipse/che/pull/4947) ([davidwindell](https://github.com/davidwindell))
- Added Alpine support to ls-php [\#4946](https://github.com/eclipse/che/pull/4946) ([davidwindell](https://github.com/davidwindell))

## [5.13.0](https://github.com/eclipse/che/tree/5.13.0) (2017-06-21)
[Full Changelog](https://github.com/eclipse/che/compare/5.12.0...5.13.0)

**Merged pull requests:**

- Added stacks archetype [\#5417](https://github.com/eclipse/che/pull/5417) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Set correct scopes for dependencies [\#5416](https://github.com/eclipse/che/pull/5416) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Fixed bug when failed to commit renamed files [\#5394](https://github.com/eclipse/che/pull/5394) ([vinokurig](https://github.com/vinokurig))
- [UD] Changed styles for input boxes [\#5384](https://github.com/eclipse/che/pull/5384) ([olexii4](https://github.com/olexii4))
- Changed the way the invalid symbols in command are handled in the test [\#5372](https://github.com/eclipse/che/pull/5372) ([benoitf](https://github.com/benoitf))
- Enable and fix existing and add some more tests CLI tests [\#5304](https://github.com/eclipse/che/pull/5304) ([riuvshin](https://github.com/riuvshin))
- Added Git configuration agent [\#5285](https://github.com/eclipse/che/pull/5285) ([vinokurig](https://github.com/vinokurig))
- Fixed the buggy `build` command of the RH `spring-boot` stack \(https://issues.jboss.org/browse/CHE-237\) [\#5281](https://github.com/eclipse/che/pull/5281) ([davidfestal](https://github.com/davidfestal))
- Added ability to cancel rename operation by Escape button [\#5265](https://github.com/eclipse/che/pull/5265) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Updated public stacks, recipes loading policy [\#5234](https://github.com/eclipse/che/pull/5234) ([akorneta](https://github.com/akorneta))
- Updated language in exception message [\#4915](https://github.com/eclipse/che/pull/4915) ([Shan1024](https://github.com/Shan1024))
- Broadcast project import output through json rpc protocol [\#4888](https://github.com/eclipse/che/pull/4888) ([vzhukovskii](https://github.com/vzhukovskii))
- Added CentOS based nodejs4 stack to default assembly [\#4788](https://github.com/eclipse/che/pull/4788) ([dharmit](https://github.com/dharmit))

## [5.12.0](https://github.com/eclipse/che/tree/5.12.0) (2017-06-14)
[Full Changelog](https://github.com/eclipse/che/compare/5.11.2...5.12.0)

**Merged pull requests:**

- Added CentOS based Golang stack to default assembly [\#5282](https://github.com/eclipse/che/pull/5282) ([dharmit](https://github.com/dharmit))
- Avoid stack updating on several clicks on same stack item [\#5378](https://github.com/eclipse/che/pull/5378) ([ashumilova](https://github.com/ashumilova))
- Fixed sending ClientCapabilities object by removing anonymous class [\#5376](https://github.com/eclipse/che/pull/5376) ([evidolob](https://github.com/evidolob))
- Fixed build module 'agents/go-agents' for maven 3.3.3 [\#5364](https://github.com/eclipse/che/pull/5364) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Use java for maven server which ws-agent use [\#5363](https://github.com/eclipse/che/pull/5363) ([evidolob](https://github.com/evidolob))
- Fixed NPE, send JSON schemas to JSON LS [\#5343](https://github.com/eclipse/che/pull/5343) ([evidolob](https://github.com/evidolob))
- Fixed freezing of IDE in case of LS initialization timeout or failure [\#5341](https://github.com/eclipse/che/pull/5341) ([dkuleshov](https://github.com/dkuleshov))
- Make status action widget consider workspace status changes [\#5332](https://github.com/eclipse/che/pull/5332) ([ashumilova](https://github.com/ashumilova))
- Updated customizing.md [\#5328](https://github.com/eclipse/che/pull/5328) ([slemeur](https://github.com/slemeur))
- Fixed dashboard page crashes in a case with stack authoring [\#5327](https://github.com/eclipse/che/pull/5327) ([olexii4](https://github.com/olexii4))
- Updated JSON LS to VSCode 1.13.0 [\#5324](https://github.com/eclipse/che/pull/5324) ([kaloyan-raev](https://github.com/kaloyan-raev))
- Remove deprecation in GitHubClientService [\#5322](https://github.com/eclipse/che/pull/5322) ([vinokurig](https://github.com/vinokurig))
- Refactor core/rpc library so it allows to connect to jsonrpc websocket endpoint [\#5319](https://github.com/eclipse/che/pull/5319) ([evoevodin](https://github.com/evoevodin))
- Remove unnecessary gwt.xml instructions [\#5317](https://github.com/eclipse/che/pull/5317) ([eivantsov](https://github.com/eivantsov))
- Fixed che-archetype build [\#5315](https://github.com/eclipse/che/pull/5315) ([tolusha](https://github.com/tolusha))
- Added ability to stop starting workspace [\#5312](https://github.com/eclipse/che/pull/5312) ([ashumilova](https://github.com/ashumilova))
- Fixed a bug with showing commands when a workspace has started [\#5309](https://github.com/eclipse/che/pull/5309) ([svor](https://github.com/svor))
- Fixed NPE for junit and testng test actions [\#5308](https://github.com/eclipse/che/pull/5308) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Provide error message to UI [\#5302](https://github.com/eclipse/che/pull/5302) ([vzhukovskii](https://github.com/vzhukovskii))
- Fixed state for 'create workspace' button [\#5300](https://github.com/eclipse/che/pull/5300) ([olexii4](https://github.com/olexii4))
- Fixed failing tests on build [\#5291](https://github.com/eclipse/che/pull/5291) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Making 'AuthorizationCodeFlow' field from OAuthAuthenticator protected [\#5289](https://github.com/eclipse/che/pull/5289) ([ibuziuk](https://github.com/ibuziuk))
- Don't share breakpoints between workspaces [\#5288](https://github.com/eclipse/che/pull/5288) ([tolusha](https://github.com/tolusha))
- Use internal IP if specified. Else on Linux it is not matching the expecting interface [\#5275](https://github.com/eclipse/che/pull/5275) ([benoitf](https://github.com/benoitf))
- CLI fix offline command save stacks to tars [\#5269](https://github.com/eclipse/che/pull/5269) ([riuvshin](https://github.com/riuvshin))
- Uuse another implementation of the Language Server Protocol for Python [\#5267](https://github.com/eclipse/che/pull/5267) ([svor](https://github.com/svor))
- Fixed cmd download and cmd offline [\#5263](https://github.com/eclipse/che/pull/5263) ([riuvshin](https://github.com/riuvshin))
- Change checking for SSH agent readiness [\#5260](https://github.com/eclipse/che/pull/5260) ([mmorhun](https://github.com/mmorhun))
- Consider only sample name on project creation [\#5250](https://github.com/eclipse/che/pull/5250) ([ashumilova](https://github.com/ashumilova))
- Fixed dashboard factory creation [\#5249](https://github.com/eclipse/che/pull/5249) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Added real version values for the NODE default stack [\#5243](https://github.com/eclipse/che/pull/5243) ([elonmallin](https://github.com/elonmallin))
- Avoid watching stack tag changes when section is hidden [\#5238](https://github.com/eclipse/che/pull/5238) ([ashumilova](https://github.com/ashumilova))
- Use of new Traefik version \(before : RC1, now RC3\) [\#5232](https://github.com/eclipse/che/pull/5232) ([benoitf](https://github.com/benoitf))
- Update an editor tab after changing command name [\#5229](https://github.com/eclipse/che/pull/5229) ([svor](https://github.com/svor))
- Added a Stack for Java-MySql on CentOS \(based on the Openshift MySql docker image\) [\#5227](https://github.com/eclipse/che/pull/5227) ([davidfestal](https://github.com/davidfestal))
- \[go-agents\] Ged rid of core/process -\> core/rpc dependency [\#5225](https://github.com/eclipse/che/pull/5225) ([evoevodin](https://github.com/evoevodin))
- Added gwt-logger dependency to the core-ide [\#5216](https://github.com/eclipse/che/pull/5216) ([vparfonov](https://github.com/vparfonov))
- Removed usage name of a current user as a namespace [\#5207](https://github.com/eclipse/che/pull/5207) ([sleshchenko](https://github.com/sleshchenko))
- Added process exit code to MachineProcess & process\_died event [\#5205](https://github.com/eclipse/che/pull/5205) ([evoevodin](https://github.com/evoevodin))
- Removed deprecated factory methods [\#5203](https://github.com/eclipse/che/pull/5203) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Interpolate correctly resource paths in maven project inside maven server implementation [\#5179](https://github.com/eclipse/che/pull/5179) ([vzhukovskii](https://github.com/vzhukovskii))
- Added ability to turn on/off autosave mode for editor content [\#5170](https://github.com/eclipse/che/pull/5170) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Do not snapshot `/tmp` folder [\#5168](https://github.com/eclipse/che/pull/5168) ([mmorhun](https://github.com/mmorhun))
- New Git commit window [\#5081](https://github.com/eclipse/che/pull/5081) ([vinokurig](https://github.com/vinokurig))
- Rework top test menu items [\#4980](https://github.com/eclipse/che/pull/4980) ([davidfestal](https://github.com/davidfestal))
- Added ability to proper handle focus events when parts changes own focus [\#3310](https://github.com/eclipse/che/pull/3310) ([vzhukovskii](https://github.com/vzhukovskii))

## [5.11.2](https://github.com/eclipse/che/tree/5.11.2) (2017-05-29)
[Full Changelog](https://github.com/eclipse/che/compare/5.11.1...5.11.2)

**Merged pull requests:**

- Use Authorization header instead of session-access-key cookie [\#5210](https://github.com/eclipse/che/pull/5210) ([evoevodin](https://github.com/evoevodin))
- Change octocat icon color [\#5200](https://github.com/eclipse/che/pull/5200) ([tolusha](https://github.com/tolusha))
- Fixed ability start new debug session after disconnect from previous session [\#5167](https://github.com/eclipse/che/pull/5167) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Fixed workspace storage path on Docker Cloud [\#4931](https://github.com/eclipse/che/pull/4931) ([davidwindell](https://github.com/davidwindell))

## [5.11.1](https://github.com/eclipse/che/tree/5.11.1) (2017-05-26)
[Full Changelog](https://github.com/eclipse/che/compare/5.11.0...5.11.1)

**Merged pull requests:**

- Copy embedded che.properties to CHE\_LOCAL\_CONF\_DIR [\#5202](https://github.com/eclipse/che/pull/5202) ([riuvshin](https://github.com/riuvshin))
- Added python LS to python stacks [\#5197](https://github.com/eclipse/che/pull/5197) ([ashumilova](https://github.com/ashumilova))
- Fixed retrieving autosnapshot property value from boolean to string [\#5196](https://github.com/eclipse/che/pull/5196) ([ashumilova](https://github.com/ashumilova))
- Updating only parent project when changes were made in the parent pom [\#5193](https://github.com/eclipse/che/pull/5193) ([svor](https://github.com/svor))
- Switch TestDocument \(LSP\) service to the websocket JSON-RPC [\#5186](https://github.com/eclipse/che/pull/5186) ([dkuleshov](https://github.com/dkuleshov))
- Wait and check LS process [\#5176](https://github.com/eclipse/che/pull/5176) ([vparfonov](https://github.com/vparfonov))
- Added user search methods by email/name fragment [\#5051](https://github.com/eclipse/che/pull/5051) ([akorneta](https://github.com/akorneta))

## [5.11.0](https://github.com/eclipse/che/tree/5.11.0) (2017-05-24)
[Full Changelog](https://github.com/eclipse/che/compare/5.10.0...5.11.0)

**Merged pull requests:**

- Temporary disable test after pr\#5180 [\#5181](https://github.com/eclipse/che/pull/5181) ([vparfonov](https://github.com/vparfonov))
- Move exec-agent/process -\> core/process [\#5184](https://github.com/eclipse/che/pull/5184) ([evoevodin](https://github.com/evoevodin))
- Interpolate correctly resource paths in maven project inside maven server implementation [\#5180](https://github.com/eclipse/che/pull/5180) ([vzhukovskii](https://github.com/vzhukovskii))
- Added ability to interpolate target directory from maven project model [\#5173](https://github.com/eclipse/che/pull/5173) ([vzhukovskii](https://github.com/vzhukovskii))
- Enable csharp ls for dotnet stack [\#5172](https://github.com/eclipse/che/pull/5172) ([eivantsov](https://github.com/eivantsov))
- Enable text selection from command output console. [\#5171](https://github.com/eclipse/che/pull/5171) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Create PR to the owner of the origin repository [\#5158](https://github.com/eclipse/che/pull/5158) ([tolusha](https://github.com/tolusha))
- Set debug level for some messages [\#5155](https://github.com/eclipse/che/pull/5155) ([vparfonov](https://github.com/vparfonov))
- \[cli\] Use of version\_lt function instead of less\_than function [\#5141](https://github.com/eclipse/che/pull/5141) ([benoitf](https://github.com/benoitf))
- Fixed Eclipse CHE-logo. Added to the ProductInfoProvider method to get water-mark-logo. [\#5138](https://github.com/eclipse/che/pull/5138) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Fixed sort project sample by type and display name [\#5134](https://github.com/eclipse/che/pull/5134) ([ashumilova](https://github.com/ashumilova))
- Fixed a bug with command auto completion [\#5133](https://github.com/eclipse/che/pull/5133) ([svor](https://github.com/svor))
- Extend the dashboard stuff that can be re-branded [\#5123](https://github.com/eclipse/che/pull/5123) ([ashumilova](https://github.com/ashumilova))
- Analyze maven profiles [\#5122](https://github.com/eclipse/che/pull/5122) ([svor](https://github.com/svor))
- One more fix for avoid NPE id directory not exist [\#5121](https://github.com/eclipse/che/pull/5121) ([vparfonov](https://github.com/vparfonov))
- Added CSRF protection to ssh key upload forms [\#5120](https://github.com/eclipse/che/pull/5120) ([evoevodin](https://github.com/evoevodin))
- Added a path exist check before register watcher [\#5119](https://github.com/eclipse/che/pull/5119) ([vparfonov](https://github.com/vparfonov))
- Added possibility to extend che.env with addon.env if it exist [\#5118](https://github.com/eclipse/che/pull/5118) ([riuvshin](https://github.com/riuvshin))
- Enable single port exposure on Che [\#5115](https://github.com/eclipse/che/pull/5115) ([benoitf](https://github.com/benoitf))
- Apply CHE\_DOCKER\_ALWAYS\_\_PULL\_\_IMAGE to container creation [\#5112](https://github.com/eclipse/che/pull/5112) ([mmorhun](https://github.com/mmorhun))
- Gwt logger rework [\#5109](https://github.com/eclipse/che/pull/5109) ([vparfonov](https://github.com/vparfonov))
- Fixed create factory button state for UD [\#5104](https://github.com/eclipse/che/pull/5104) ([olexii4](https://github.com/olexii4))
- Fixed CHE custom properties usage [\#5103](https://github.com/eclipse/che/pull/5103) ([riuvshin](https://github.com/riuvshin))
- Replace md5 calculation for avoid problem with big files [\#5090](https://github.com/eclipse/che/pull/5090) ([vparfonov](https://github.com/vparfonov))
- Fixed clean up map after widget deletion from ProcessPanel [\#5087](https://github.com/eclipse/che/pull/5087) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Fixed user namespace usage on workspace creation [\#5085](https://github.com/eclipse/che/pull/5085) ([ashumilova](https://github.com/ashumilova))
- Fixed items bulk selection and filtration [\#5083](https://github.com/eclipse/che/pull/5083) ([akurinnoy](https://github.com/akurinnoy))
- Enable UseStringDeduplication java flag for WS agent [\#5074](https://github.com/eclipse/che/pull/5074) ([mshaposhnik](https://github.com/mshaposhnik))
- Improved editor behavior for design a new factory from a template [\#5073](https://github.com/eclipse/che/pull/5073) ([olexii4](https://github.com/olexii4))
- Refine terminal related UI [\#5070](https://github.com/eclipse/che/pull/5070) ([vzhukovskii](https://github.com/vzhukovskii))
- Disable this test that is not working on jenkins CI [\#5069](https://github.com/eclipse/che/pull/5069) ([benoitf](https://github.com/benoitf))
- Fixed catching exception in case invalid POM to prevent fail start workspace [\#5066](https://github.com/eclipse/che/pull/5066) ([vparfonov](https://github.com/vparfonov))
- Revert "Fix catching exception in case invalid POM to prevent fail start workspace" [\#5065](https://github.com/eclipse/che/pull/5065) ([vparfonov](https://github.com/vparfonov))
- Fixed resize terminal tab on the remote server [\#5063](https://github.com/eclipse/che/pull/5063) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Added default values for new branding links [\#5062](https://github.com/eclipse/che/pull/5062) ([olexii4](https://github.com/olexii4))
- Fixed authoring a custom stack from compose file [\#5050](https://github.com/eclipse/che/pull/5050) ([akurinnoy](https://github.com/akurinnoy))
- Fixed CLI startup output for Windows; [\#5045](https://github.com/eclipse/che/pull/5045) ([mshaposhnik](https://github.com/mshaposhnik))
- Updated open in editor files after re-creation [\#5044](https://github.com/eclipse/che/pull/5044) ([mmorhun](https://github.com/mmorhun))
- Fixed receiving file tracking operation calls from client at refactoring [\#5041](https://github.com/eclipse/che/pull/5041) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Fixed ssh agent for CentOS [\#5036](https://github.com/eclipse/che/pull/5036) ([eivantsov](https://github.com/eivantsov))
- Do not display external operation event for opened files at remove resource [\#5016](https://github.com/eclipse/che/pull/5016) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Fixed catching exception in case invalid POM to prevent fail start workspace  [\#5015](https://github.com/eclipse/che/pull/5015) ([vparfonov](https://github.com/vparfonov))
- Fixed Eclipse CHE logo visibility in the EditorPartStack for GoogleChrome [\#5014](https://github.com/eclipse/che/pull/5014) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Restore filter order [\#5009](https://github.com/eclipse/che/pull/5009) ([mshaposhnik](https://github.com/mshaposhnik))
- Unification of JSON RPC codebase [\#5005](https://github.com/eclipse/che/pull/5005) ([dkuleshov](https://github.com/dkuleshov))
- Fixed bugs related to processing of read-only files [\#5003](https://github.com/eclipse/che/pull/5003) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Allow docker node throw environment exception on WS bind [\#4984](https://github.com/eclipse/che/pull/4984) ([garagatyi](https://github.com/garagatyi))
- Revamped workspace's name validation [\#4950](https://github.com/eclipse/che/pull/4950) ([akurinnoy](https://github.com/akurinnoy))
- Introduce a template-based custom docker server evaluation strategy [\#4928](https://github.com/eclipse/che/pull/4928) ([benoitf](https://github.com/benoitf))
- Show Find Project Symbol only if capability exist [\#4925](https://github.com/eclipse/che/pull/4925) ([vparfonov](https://github.com/vparfonov))
- Add paging objects [\#4923](https://github.com/eclipse/che/pull/4923) ([olexii4](https://github.com/olexii4))
- Extract Che specific servlet binding to separate class [\#4873](https://github.com/eclipse/che/pull/4873) ([skabashnyuk](https://github.com/skabashnyuk))

## [5.10.0](https://github.com/eclipse/che/tree/5.10.0) (2017-05-10)
[Full Changelog](https://github.com/eclipse/che/compare/5.9.0...5.10.0)

**Pull requests merged:**
- Change doc's links. [5033](https://github.com/eclipse/che/pull/5033)
- Apply possibility copy and paste in the terminal by "Ctrl + C" and "Ctrl + V". Combination "Ctrl + C" works to copy only in case if you selected some text in the terminal, otherwise it sends stop signal for current running process in the terminal. [5012](https://github.com/eclipse/che/pull/5012)
- Add stack description into ready-to-go widgets. [5010](https://github.com/eclipse/che/pull/5010)
- [UD] Fixed the select dropbox options to fit menu width. [4983](https://github.com/eclipse/che/pull/4983)
- [UD] truncated long stack description in Stack library by adding '...'[4982](https://github.com/eclipse/che/pull/4982)
- Fix a problem with saving commands [4955](https://github.com/eclipse/che/pull/4955)
- Add possibility to access external resources in docker image build phase of workspace start if Che is deployed in environment behind the proxy. [4948](https://github.com/eclipse/che/pull/4948)
- [UD] fixed text overlapping on Configure Actions on Factory details page.[4944](https://github.com/eclipse/che/pull/4944)
- Remove redundant action for creating js file [4943](https://github.com/eclipse/che/pull/4943)
- Improve error logging on ws agent start. [4937](https://github.com/eclipse/che/pull/4937)
- Make copy file operation more informative. [4926](https://github.com/eclipse/che/pull/4926)
- Handle file remove operation in recent item list. [4924](https://github.com/eclipse/che/pull/4924)
- Close the editor if the file was removed after external operation. [4911](https://github.com/eclipse/che/pull/4911)
- Removed generating of outdated analitycs rel for factories. [4909](https://github.com/eclipse/che/pull/4909)
- Prevent duplicating project in application context after rename operation [4889](https://github.com/eclipse/che/pull/4889)

## [5.9.0](https://github.com/eclipse/che/tree/5.9.0) (2017-04-26)
[Full Changelog](https://github.com/eclipse/che/compare/5.8.0...5.9.0)

**Pull requests merged:**
- fix problem with permissions in /projects [4904](https://github.com/eclipse/che/pull/4904)
- Added ability to set namespace caption, empty message, function for retrieving organization additional info. [4895](https://github.com/eclipse/che/pull/4895)
- [UD] fixed bug when templates list was not shown for existing workspace. [4893](https://github.com/eclipse/che/pull/4893)
- [UD] updated restriction in UD for port range to be 0-65535.[4892](https://github.com/eclipse/che/pull/4892)
- [UD] fixed "Close" icon on "Remove machine" popup.[4890](https://github.com/eclipse/che/pull/4890)
- [UD] changed wrong button text on "Edit the command" popup.[4887](https://github.com/eclipse/che/pull/4887)
- Fixed dockerfile parser in order to correctly parse instructions which contain line breaks and ampersands.[4881](https://github.com/eclipse/che/pull/4881)
- Correctly detect installed java version [4870](https://github.com/eclipse/che/pull/4870)
- Moves che-plugin-machine-ext-client to IDE core. [4861](https://github.com/eclipse/che/pull/4861)
- Do not use debug log level as default when master debug mode is enabled. [4860](https://github.com/eclipse/che/pull/4860)
- Fixed path for aspnet-web-simple project to be the same as project name. [4859](https://github.com/eclipse/che/pull/4859)
- Moved publishing before account removed cascade event to manager instead of entity listener. [4856](https://github.com/eclipse/che/pull/4856)
- Fixes problems running exec-agent. [4845](https://github.com/eclipse/che/pull/4845)
- Improved logging for an agent that fails to start. [4834](https://github.com/eclipse/che/pull/4834)
- Fix a bug with restoring dimensions when refreshing the browser. [4829](https://github.com/eclipse/che/pull/4829)
- Fix docker output in case IDE initiate start workspace [4821](https://github.com/eclipse/che/pull/4821)
- Tomcat upgraded to 8.5.11 [4817](https://github.com/eclipse/che/pull/4817)
- [4802](https://github.com/eclipse/che/pull/4802)
- Show and hide dashboard navigation bar by IDE [4790](https://github.com/eclipse/che/pull/4790)
- Preview image files in dedicated browser tab [4782](https://github.com/eclipse/che/pull/4782)
- Language Server Protocol support ported to Eclipse LSP4J. [4765](https://github.com/eclipse/che/pull/4765)
- Introduced two maven modules for ws-agent minimum set of components that need to start workspace agent [4578](https://github.com/eclipse/che/pull/4578)
- Add WildFly Swarm stack to default assembly. [4544](https://github.com/eclipse/che/pull/4544)

## [5.8.0](https://github.com/eclipse/che/tree/5.8.0) (2017-04-13)
[Full Changelog](https://github.com/eclipse/che/compare/5.7.0...5.8.0)

**Pull requests merged:**
- Fix workspace master message routing via json rpc transport. [4798](https://github.com/eclipse/che/pull/4798)
- Fixed disappearing Duplicate/Remove Command buttons when width of the Commands Explorer is too small [4784](https://github.com/eclipse/che/pull/4784)
- Fixed restoring Commands Explorer active state on refreshing IDE [4773](https://github.com/eclipse/che/pull/4773)
- None [4767](https://github.com/eclipse/che/pull/4767)
- Removed outline from the Stop/Rerun buttons on the Commands toolbar [4766](https://github.com/eclipse/che/pull/4766)
- Fixed bug with opening/closing Processes dropdown list when Stop/Rerun button has been clicked [4764](https://github.com/eclipse/che/pull/4764)
- Fix maven build execution that kills Eclipse IDE when building Che [4762](https://github.com/eclipse/che/pull/4762)
- Fixed loading IDE when project has not valid JSON of some command [4755](https://github.com/eclipse/che/pull/4755)
- fix dependency version [4754](https://github.com/eclipse/che/pull/4754)
- `Preview` in context menu is not visible for non-html items. [4753](https://github.com/eclipse/che/pull/4753)
- Fix Maven dependency manangement: Use ${che.version} instead of ${project.version} to allow projects with different version to use Che dependencies.[4752](https://github.com/eclipse/che/pull/4752)
- code clean up after previous merge [4746](https://github.com/eclipse/che/pull/4746)
- Fixes several bugs related to _Execute Command_ buttons on _Commands_ toolbar [4745](https://github.com/eclipse/che/pull/4745)
- Added ability to delete workspace snapshots from Docker Hub. [4744](https://github.com/eclipse/che/pull/4744)
- Replaced IDE client message bus based services to JSON RPC based for the debugger functionality[4739](https://github.com/eclipse/che/pull/4739)
- Added new indexes to DB for faster searches and deletes. [4730](https://github.com/eclipse/che/pull/4730)
- Move CheConnectionClosedInformer to the ide-app module [4726](https://github.com/eclipse/che/pull/4726)
- Improved name generation for duplicate stack. [4722](https://github.com/eclipse/che/pull/4722)
- [UD] fixed bugs in CheHttpBackend[4716](https://github.com/eclipse/che/pull/4716)
- Fixed SSH agent launch error when host security prevents a user from seeing container root's processes. [4708](https://github.com/eclipse/che/pull/4708)
- Fixed NPE in file watcher service that appeared to happen in some rare cases [4691](https://github.com/eclipse/che/pull/4691)
- Replaced IDE client message bus based services to JSON RPC based [4621](https://github.com/eclipse/che/pull/4621)
- Java Testing support Bug fixes and Enhancements [4481](https://github.com/eclipse/che/pull/4481)
- Added support for Language Server Protocol codeAction request. [4345](https://github.com/eclipse/che/pull/4345)

## [5.7.0](https://github.com/eclipse/che/tree/5.7.0) (2017-04-06)
[Full Changelog](https://github.com/eclipse/che/compare/5.6.0...5.7.0)

**Pull requests merged:**
- fix release failure [4729](https://github.com/eclipse/che/pull/4729)
- Add node modules to the gitignore [4727](https://github.com/eclipse/che/pull/4727)
- Added factory images used in links, Pull Requests etc [4725](https://github.com/eclipse/che/pull/4725)
- Fix agents installation scripts in case neither of curl/wget is installed in machine. [4723](https://github.com/eclipse/che/pull/4723)
- Change link to docs in product [4717](https://github.com/eclipse/che/pull/4717)
- Fixing tests after changing Url generation logic [4709](https://github.com/eclipse/che/pull/4709)
- Added possibility to show/hide info panel in text editors. [4707](https://github.com/eclipse/che/pull/4707)
- Using '-' instead of '.' for generating OpenShift route Urls [4705](https://github.com/eclipse/che/pull/4705)
- Fix possible NPE if ProductInfoDataProvider not provide logo [4703](https://github.com/eclipse/che/pull/4703)
- Fixed appearance of the commands toolbar and command editor for the light theme [4700](https://github.com/eclipse/che/pull/4700)
- Fix few warn during GWT compilation [4697](https://github.com/eclipse/che/pull/4697)
- [UD] reworked fetch current user to return promise on error and handle 304 status properly. [4695](https://github.com/eclipse/che/pull/4695)
- Methods related to factory button functionality in FactoryService become deprecated [4694](https://github.com/eclipse/che/pull/4694)
- Suppress exception traces on start of workspace were sudo is forbidden for user in dev-machine. [4693](https://github.com/eclipse/che/pull/4693)
- Make che-plugin-product-info optional for IDE [4682](https://github.com/eclipse/che/pull/4682)
- Fix a problem with getting subpackages for java projects [4681](https://github.com/eclipse/che/pull/4681)
- Fixed bug with displaying command's name in Processes list when text is too long [4680](https://github.com/eclipse/che/pull/4680)
- Fix php56 name [4676](https://github.com/eclipse/che/pull/4676)
- Adding property to set workspaces memory request on OpenShift [4671](https://github.com/eclipse/che/pull/4671)
- Add Nullable parameter to che.docker.ip.external in OpenShiftConnector [4662](https://github.com/eclipse/che/pull/4662)
- CHE-158 Adding TLS support for Workspace routes [4660](https://github.com/eclipse/che/pull/4660)
- Makes it possible to move packages [4659](https://github.com/eclipse/che/pull/4659)
- Now all command goals names must be unique ignoring string case considerations. [4656](https://github.com/eclipse/che/pull/4656)
- CHE-4619; Move factory functionality into core [4655](https://github.com/eclipse/che/pull/4655)
- #4306 fix NPE in case of invalid java FQN [4654](https://github.com/eclipse/che/pull/4654)
- Sets CHE_WORKSPACE_ID and CHE_MACHINE_NAME env variables in all machines started by Che [4649](https://github.com/eclipse/che/pull/4649)
- CHE-4586: Add pip3 check fro python language server [4648](https://github.com/eclipse/che/pull/4648)
- Allowed to use single hyphen in the middle of account name. [4643](https://github.com/eclipse/che/pull/4643)
- Docker client throws specific exception instead of general in case exec is not found on exec start request. [4620](https://github.com/eclipse/che/pull/4620)
- CHE-3844: Show 'Add terminal button' in the machine nodes when Workspace is running [4618](https://github.com/eclipse/che/pull/4618)
- #4554 fix Class not found exception in maven server [4613](https://github.com/eclipse/che/pull/4613)
- Remove opacity style for emptyEditorsPanel logo div. [4612](https://github.com/eclipse/che/pull/4612)
- An option to configure `Soft Wrap` is placed to `Profile > Preferences > Editor`. [4580](https://github.com/eclipse/che/pull/4580)
- Added alias `index.docker.io` for docker hub. [4572](https://github.com/eclipse/che/pull/4572)
- [UD] changed namespace toggle button to dropbox, fixed error on workspace creation with non-existing namespace provided. [4570](https://github.com/eclipse/che/pull/4570)
- Add support for resource requests/limits when running on Openshift [4564](https://github.com/eclipse/che/pull/4564)
- Replace mysql with eclipse/mysql image [4451](https://github.com/eclipse/che/pull/4451)
- Update terminal xterm.js to the version 2.4.0. Move terminal client to the che-lib. [4449](https://github.com/eclipse/che/pull/4449)
- Adds Factories which automate workspace provisioning. [4413](https://github.com/eclipse/che/pull/4413)
- [cli] Add new 'archetype' command for generating, building and running custom assemblies [4179](https://github.com/eclipse/che/pull/4179)
- Allow to use wget instead of only curl for installing ws agent or terminal agent [4029](https://github.com/eclipse/che/pull/4029)

## [5.6.0](https://github.com/eclipse/che/tree/5.6.0) (2017-03-30)
[Full Changelog](https://github.com/eclipse/che/compare/5.5.0...5.6.0)

**Pull requests merged:**
The follow are changelogs for eclipse/che:
- Active left part (Project Explorer, Commands Explorer) remains the same after restarting a workspace. [4638](https://github.com/eclipse/che/pull/4638)
- Add php5.6 stack [4633](https://github.com/eclipse/che/pull/4633)
- Allow developers to use words ```instance``` and ```config``` as package names [4632](https://github.com/eclipse/che/pull/4632)
- Intelligent commands UX and UI improvements: [4611](https://github.com/eclipse/che/pull/4611)
- [UD] Fixed the project creation when reusing the same project template several times which was erasing source data during import. [4610](https://github.com/eclipse/che/pull/4610)
- Correct check folder name in create folder operation [4607](https://github.com/eclipse/che/pull/4607)
- Add attribute for UI element to make life of QA more easy [4601](https://github.com/eclipse/che/pull/4601)
- Fix typo in the stack.json [4599](https://github.com/eclipse/che/pull/4599)
- Add missing filter bindings [4598](https://github.com/eclipse/che/pull/4598)
- Fix close editor by middle button [4597](https://github.com/eclipse/che/pull/4597)
- Add goals to commands provided with default stacks [4589](https://github.com/eclipse/che/pull/4589)
- Move golang agents sources to satisfy golang best practices [4588](https://github.com/eclipse/che/pull/4588)
- Show error message about trying to access not registered method via JSON RPC [4587](https://github.com/eclipse/che/pull/4587)
- Fixed a problem with creation the workspace [4585](https://github.com/eclipse/che/pull/4585)
- Avoid NPE if UI element not attached to the parent [4579](https://github.com/eclipse/che/pull/4579)
- Added macros for retrieving file base name [4574](https://github.com/eclipse/che/pull/4574)
- Check if endpoint already subscribed on file modification event on server-side [4571](https://github.com/eclipse/che/pull/4571)
- Fix dockerImageConfig is null (since v1.5 of OpenShift API) [4569](https://github.com/eclipse/che/pull/4569)
- Setting rwx permissions for all on /data/ in case it's not mounted [4563](https://github.com/eclipse/che/pull/4563)
- Remove dashabord from che-parent submodules to avoid building it [4562](https://github.com/eclipse/che/pull/4562)
- Fix stack description [4561](https://github.com/eclipse/che/pull/4561)
- Various fixes to the PR panel [4556](https://github.com/eclipse/che/pull/4556)
- Provide error messages in create folder or file operation [4549](https://github.com/eclipse/che/pull/4549)
- Use new `.factory.dockerfile` and `.factory.properties` for repo URL based factories. [4548](https://github.com/eclipse/che/pull/4548)
- Find an alternative to subPath in volumeMount [4545](https://github.com/eclipse/che/pull/4545)
- Moved Orion code to Che core. Old Orion plugin `che-plugin-orion-editor` will be removed in 5.8. [4539](https://github.com/eclipse/che/pull/4539)
- Notifies user that connection to server has been lost [4535](https://github.com/eclipse/che/pull/4535)
- [UD] fixed bug in parsing provided environment variables in dockerfile [4534](https://github.com/eclipse/che/pull/4534)
- Synchronizes project configuration with file system before loading project's nodes in the project explorer. [4530](https://github.com/eclipse/che/pull/4530)
- Change parent node for terminal node [4528](https://github.com/eclipse/che/pull/4528)
- Update Docker Compose tests to fix test failure [4525](https://github.com/eclipse/che/pull/4525)
- Factory name made mandatory on database level [4521](https://github.com/eclipse/che/pull/4521)
- Use correct localization constant [4520](https://github.com/eclipse/che/pull/4520)
- Fix GDB debug configuration removal [4513](https://github.com/eclipse/che/pull/4513)
- Optimize load resources operations [4505](https://github.com/eclipse/che/pull/4505)
- [UD] Avoid any IDE iframe script execution, when not loaded yet and source changes. [4504](https://github.com/eclipse/che/pull/4504)
- Update versions of OpenShift connector projects [4495](https://github.com/eclipse/che/pull/4495)
- Add default implemnattion of authentication asking dialog [4490](https://github.com/eclipse/che/pull/4490)
- Implement correctly 'AnnotationModelImpl.getAnnotationIterator' [4489](https://github.com/eclipse/che/pull/4489)
- Separated terminal and exec agents. [4486](https://github.com/eclipse/che/pull/4486)
- Moved `plugin-ssh-key` from `plugins` to `wsagent` packages. [4485](https://github.com/eclipse/che/pull/4485)
- Removed outdated policies.match parameter; [4480](https://github.com/eclipse/che/pull/4480)
- not required [4478](https://github.com/eclipse/che/pull/4478)
- [cli] Fix for restart failure [4475](https://github.com/eclipse/che/pull/4475)
- Modifications to the shell scripts that bootstrap the servers [4472](https://github.com/eclipse/che/pull/4472)
- Fix typo [4468](https://github.com/eclipse/che/pull/4468)
- cli sync : add option to allow /dev/fuse usage on ubuntu [4467](https://github.com/eclipse/che/pull/4467)
- [cli] If ssl is in use, propagate the property to utilities images [4465](https://github.com/eclipse/che/pull/4465)
- [UD] fixed bug when team administrator was not able to select workspaces which are not shared with him. [4463](https://github.com/eclipse/che/pull/4463)
- Removed deprecated RemotePreferenceDao. [4455](https://github.com/eclipse/che/pull/4455)
- Remove gwt dependency in server side war packaging [4454](https://github.com/eclipse/che/pull/4454)
- [diagnostic]: Use machine token when interacting with wsagent [4450](https://github.com/eclipse/che/pull/4450)
- Reduced build output in "che-core-commons-scheduler" and "plugin-svn" by ommiting debug info logging [4443](https://github.com/eclipse/che/pull/4443)
- [UD] updated list of countries. [4441](https://github.com/eclipse/che/pull/4441)
- Set Github token through workspace master Rest API. Added a force activation property variable to register Github Oauth provider even without client id/secret [4438](https://github.com/eclipse/che/pull/4438)
- Synchronize projects in the workspace with projects on file system. [4433](https://github.com/eclipse/che/pull/4433)
- Adds the Spring Boot stack to the default Che assembly. [4426](https://github.com/eclipse/che/pull/4426)
- Prevent multiple event subscription for single file [4420](https://github.com/eclipse/che/pull/4420)
- Reduce CPU usage when running on OpenShift [4411](https://github.com/eclipse/che/pull/4411)
- Fix missing parts and wrong ENV names [4409](https://github.com/eclipse/che/pull/4409)
- VFS components are now considered deprecated and will be replaced by standard JDK routines. [4400](https://github.com/eclipse/che/pull/4400)
- Introduced Intelligent Commands functionality. [4389](https://github.com/eclipse/che/pull/4389)
- Refactoring: moved SshServiceClient class from wsmaster war to wsagent war [4386](https://github.com/eclipse/che/pull/4386)
- [UD] fixed bug when default template is not selected in samples list. [4384](https://github.com/eclipse/che/pull/4384)

## [5.5.0](https://github.com/eclipse/che/tree/5.5.0) (2017-03-15)
[Full Changelog](https://github.com/eclipse/che/compare/5.4.1...5.5.0)

**Pull requests merged:**
The follow are changelogs for eclipse/che:
- Fix the aliases to use for the che cli image (for now alias was using the same name) [4436](https://github.com/eclipse/che/pull/4436)
- Avoid possible NullPointerException [4422](https://github.com/eclipse/che/pull/4422)
- Fix bug when workspace folder is not deleted after deleting workspace in IDE on Windows OS. [4418](https://github.com/eclipse/che/pull/4418)
- Improved java source name validator in create dialog window [4412](https://github.com/eclipse/che/pull/4412)
- Set correct default hot key scheme. Don't use deprecated method. [4402](https://github.com/eclipse/che/pull/4402)
- New Eclipse based Key Schema [4394](https://github.com/eclipse/che/pull/4394)
- Trigger file saving operation on editor closing only when file has changes [4393](https://github.com/eclipse/che/pull/4393)
- Add missing pom dependencies that were producing a build failure [4391](https://github.com/eclipse/che/pull/4391)
- Revert CHE-120 Workspace creation as non-privileged container. [4390](https://github.com/eclipse/che/pull/4390)
- [cli] Give containers used in preflight tests unique name [4378](https://github.com/eclipse/che/pull/4378)
- Use dynamic persistence.xml generator in tests [4374](https://github.com/eclipse/che/pull/4374)
- Perspectives are shown in 'Window' menu if their number is more than one If a Che assembly includes 1+ perspectives they are now listed in the IDE's Window menu. [4369](https://github.com/eclipse/che/pull/4369)
- Previous recursive file watcher implementation is replaced by tree walk based one [4368](https://github.com/eclipse/che/pull/4368)
- [UD] fixed bug when "Save" and "Cancel" buttons were visible for untouched workspace in Workspace details. [UD] fixed bug when list of samples was empty for custom stack in Create workspace flow. [4367](https://github.com/eclipse/che/pull/4367)
- Add version for angular-aria dependency in dashboard. [4365](https://github.com/eclipse/che/pull/4365)
- Update CentOS Dockerfile to avoid permissions issues [4354](https://github.com/eclipse/che/pull/4354)
- Fixed issue with an 'Unable to initialize IDE' error when loading the Web IDE. [4352](https://github.com/eclipse/che/pull/4352)
- Che server and workpaces exposed on the same single TCP port [4351](https://github.com/eclipse/che/pull/4351)
- Add back in check for `--user` on command line [4350](https://github.com/eclipse/che/pull/4350)
- CHE-120 Workspace creation as non-privileged container [4349](https://github.com/eclipse/che/pull/4349)
- Removes an error when adding a new perspective. [4348](https://github.com/eclipse/che/pull/4348)
- Edd style for the editor tooltips [4346](https://github.com/eclipse/che/pull/4346)
- Refactor golang agents for re-usage of components for creation of other agents. [4344](https://github.com/eclipse/che/pull/4344)
- [cli] Apply custom image names for Che and associated CLI images [4336](https://github.com/eclipse/che/pull/4336)
- Improve behavior of SSH installation script on unknown Linux stacks [4334](https://github.com/eclipse/che/pull/4334)
- allow using args for start command in cmd_upgrade [4332](https://github.com/eclipse/che/pull/4332)
- The Machine API has been removed in this release. [4331](https://github.com/eclipse/che/pull/4331)
- Handle relative path to source folder at managing maven project classpath [4329](https://github.com/eclipse/che/pull/4329)
- Explicit snapshot creation becomes an internal approach. Recover from snapshot dialog is removed from IDE. Workspace REST API methods related to snapshots are deprecated. [4328](https://github.com/eclipse/che/pull/4328)
- [cli] Add check to ensure `:/data` can execute files written to it from a container [cli] Add `--follow` parameter to start command to follow logs while booting [4326](https://github.com/eclipse/che/pull/4326)
- Disable creating a snapshot in case if workspace agent lost connection. [4325](https://github.com/eclipse/che/pull/4325)
- Updated commands definition to be properly displayed in new command editor [4324](https://github.com/eclipse/che/pull/4324)
- Remove obsolete files Ssh.gwt.xml [4322](https://github.com/eclipse/che/pull/4322)
- Removes gwt-test-util redundant dependency [4320](https://github.com/eclipse/che/pull/4320)
- Add command goals to all templates provided by default with Che [4319](https://github.com/eclipse/che/pull/4319)
- Implement getContainerLogs method in OpenShiftConnector [4309](https://github.com/eclipse/che/pull/4309)
- Use Persistent Volumes Claims when creating workspaces [4308](https://github.com/eclipse/che/pull/4308)
- Add support for exec operations when running Che on OpenShift. [4305](https://github.com/eclipse/che/pull/4305)
- [UD] fixed bug when default project template is not selected in templates list. [4304](https://github.com/eclipse/che/pull/4304)
- JUnit testing support Bug fixes and Enhancements Provided a new ` Tests` text console view. Fixed problems encountered when trying to run tests that: Require write access in the current directory. Use the thread context class-loader during test execution. Reduced the JUnit test execution time by removing an unnecessary step. [4303](https://github.com/eclipse/che/pull/4303)
- Adds `ssh` protocol into configuration of the ssh agent. [4302](https://github.com/eclipse/che/pull/4302)
- Added ability to generate gwt.xml from included gwt modules in classpath [4298](https://github.com/eclipse/che/pull/4298)
- Add `che.workspace.auto_start=` property to set whether URL acceptance auto-starts a workspace [4287](https://github.com/eclipse/che/pull/4287)
- Added possibility to insert new lines to 'message' text area in Git commit window by pressing ENTER key [4280](https://github.com/eclipse/che/pull/4280)
- Remove deprecation related to PromiseHelper [4278](https://github.com/eclipse/che/pull/4278)
- Disable delete projects button when workspace is not running [4189](https://github.com/eclipse/che/pull/4189)
- Added optional dependencies to Bitnami stacks. [4116](https://github.com/eclipse/che/pull/4116)
- Removed Machine client side API (was deprecated in 5.2). [3963](https://github.com/eclipse/che/pull/3963)
- Show server's address along with URL. [3866](https://github.com/eclipse/che/pull/3866)
- BugFix: Fix throwing exception on Git commit, if working directory is clean or nothing added to commit. [3833](https://github.com/eclipse/che/pull/3833)

## [5.4.1](https://github.com/eclipse/che/tree/5.4.1) (2017-03-06)
[Full Changelog](https://github.com/eclipse/che/compare/5.4.0...5.4.1)

**Pull requests merged:**
The follow are changelogs for eclipse/che:
- Improved package name validator in create package dialog window [4271](https://github.com/eclipse/che/pull/4271)

## [5.4.0](https://github.com/eclipse/che/tree/5.4.0) (2017-03-01)
[Full Changelog](https://github.com/eclipse/che/compare/5.3.1...5.4.0)

**Pull requests merged:**
The follow are changelogs for eclipse/che:
- fix env property name [4293](https://github.com/eclipse/che/pull/4293)
- remove duplicate entries in no_proxy because it may cause issues [4285](https://github.com/eclipse/che/pull/4285)
- Use HTTPS instead of HTTP in web links for documentation and internal URLs. [4276](https://github.com/eclipse/che/pull/4276)
- Fix situations where node.js debugger doesn't stop and can become frozen. [4263](https://github.com/eclipse/che/pull/4263)
- Added fetch workspaces by namespace, read state of application notifications, section injection in workspace details. [4262](https://github.com/eclipse/che/pull/4262)
- [UD] added custom filter which will be used for "Get more RAM" widget on billing page. [4261](https://github.com/eclipse/che/pull/4261)
- chefile: Switch from WSMaster Machine API to Workspace Exec Agent [4253](https://github.com/eclipse/che/pull/4253)
- Add on dashboard possibility to stop workspace while it is being started. Improve machine runtime popups for dashboard hide recipe location if it isn't url Fixed sorting rules for recent workspaces [4246](https://github.com/eclipse/che/pull/4246)
- Fix building the tree for packages in Move Refactoring window [4245](https://github.com/eclipse/che/pull/4245)
- [cli] Add `--skip:config` option to start, restart, and config commands [4244](https://github.com/eclipse/che/pull/4244)
- Enable to bootstrap Che on OpenShift without mounting the Docker Socket [4241](https://github.com/eclipse/che/pull/4241)
- Fix ProcessesPanelPresenterTest. Clean up rubbish. [4237](https://github.com/eclipse/che/pull/4237)
- Add terminal debugId. [4235](https://github.com/eclipse/che/pull/4235)
- UD add directives for custom input types for numbers and city names; UD add city name validation directive; [4233](https://github.com/eclipse/che/pull/4233)
- Added new utility methods for handling pagination of objects. [4232](https://github.com/eclipse/che/pull/4232)
- Fix issue where it was lose track of running workspace in OpenShift. [4230](https://github.com/eclipse/che/pull/4230)
- [UD] fixed bugs when modifying machine definitions for custom stacks. [UD] machine details uses available space more efficiently [4224](https://github.com/eclipse/che/pull/4224)
- Replace getNetworks() docker API call when running on OpenShift. [4219](https://github.com/eclipse/che/pull/4219)
- Bugfix: workspace attributes were ignored, when creating workspace. [4215](https://github.com/eclipse/che/pull/4215)
- Removed deprecated classes in the texteditor package. [4213](https://github.com/eclipse/che/pull/4213)
- Add search algorithm for host ip with fedora enp* network interfaces [4210](https://github.com/eclipse/che/pull/4210)
- OpenShift connector uses filesystem tokens to authenticate with OpenShift API server [4209](https://github.com/eclipse/che/pull/4209)
- Add a diagnostic page to the dashboard that can check workspace requirements. [4207](https://github.com/eclipse/che/pull/4207)
- Allow to use auto scroll on data provider that are arrays [4204](https://github.com/eclipse/che/pull/4204)
- Doesn't perform DeleteResourceAction into partStack which doesn't support resource selection. [4199](https://github.com/eclipse/che/pull/4199)
- Update currently selected resource in case if the last one was updated programmatically from the code [4194](https://github.com/eclipse/che/pull/4194)
- Fixed rendering of some stack icons on the Dashboard. [4193](https://github.com/eclipse/che/pull/4193)
- Fixed bug in`Git`->`Add To Index` menu command that was not adding deleted files to index. [4187](https://github.com/eclipse/che/pull/4187)
- [cli] Simplify execution of initialization methods [cli] Add diff for repo mode [cli] Add checks for all curl commands and ensure '--skip:network' applied [4175](https://github.com/eclipse/che/pull/4175)
- Upgrade Orion editor to latest version [4165](https://github.com/eclipse/che/pull/4165)
- Use HTTPS instead of HTTP in web links for documentation and internal URLs. [4086](https://github.com/eclipse/che/pull/4086)
- Trigger file saving operation on editor closing only when file has changes [4077](https://github.com/eclipse/che/pull/4077)
- Add `--user uid:gid` and `-e CHE_USER=uid:gid` option to CLI to override user identity of Che container [4050](https://github.com/eclipse/che/pull/4050)
- Internal refactoring: move account out of user entity Allow personal account to be optional Add missed indexes for type field of account and foreign key to account id in workspace table. [3823](https://github.com/eclipse/che/pull/3823)

The follow are changelogs for eclipse/che-dockerfiles:
- Added php-xml and php-mbstring packages to get tutorial to work https://eclipse.org/che/docs/tutorials/php/index.html .  [66](https://github.com/eclipse/che-dockerfiles/pull/66)


## [5.3.1](https://github.com/eclipse/che/tree/5.3.1) (2017-02-21)
[Full Changelog](https://github.com/eclipse/che/compare/5.3.0...5.3.1)

**Pull requests merged:**
The follow are changelogs for eclipse/che:
- Remove readme.io references and replace with internal documentation link. [1794](https://github.com/eclipse/che/pull/1794)
- Add option to unison to handle Windows FAT filesystems. [4182](https://github.com/eclipse/che/pull/4182)
- Remove duplicated code from cli [4172](https://github.com/eclipse/che/pull/4172)
- Add go to the `PATH` of `eclipse/che-dev` docker image [4169](https://github.com/eclipse/che/pull/4169)
- Update references to hold documentation site [4166](https://github.com/eclipse/che/pull/4166)

## [5.3.0](https://github.com/eclipse/che/tree/5.3.0) (2017-02-17)
[Full Changelog](https://github.com/eclipse/che/compare/5.2.2...5.3.0)

**Pull requests merged:**
- fix cli test [4164](https://github.com/eclipse/che/pull/4164)
- Workspace _updated_ attribute is updated before real stop is called [4158](https://github.com/eclipse/che/pull/4158)
- [cli] default debug port is 8000 when user do not specify it [4157](https://github.com/eclipse/che/pull/4157)
- Prevent external event for another widgets on key DELETE for terminal UI. [4156](https://github.com/eclipse/che/pull/4156)
- update docker hub url in cli tests [4155](https://github.com/eclipse/che/pull/4155)
- Fix machine stop in case docker container was stopped or killed not by Codenvy. [4154](https://github.com/eclipse/che/pull/4154)
- Reuse `$SHELL_INTERPRETER` as shell interpreter for exec-agent [4148](https://github.com/eclipse/che/pull/4148)
- Fix page crashes in dashboard when choosing stack types and during project deletion. [4140](https://github.com/eclipse/che/pull/4140)
- Added option to override the `JAVA_OPTIONS` variable from the `che.env` config file. [4137](https://github.com/eclipse/che/pull/4137)
- Fixed CLI to cleanup volumes after container stopped. [4134](https://github.com/eclipse/che/pull/4134)
- Add possibility to set custom DNS resolvers for workspace **(master too)** container runtimes. [4129](https://github.com/eclipse/che/pull/4129)
- Restore backward compliance broken on workspace keys by https://github.com/eclipse/che/pull/4073 [4123](https://github.com/eclipse/che/pull/4123)
- Fix a bug where workspace folder was present after workpsace deletion [4122](https://github.com/eclipse/che/pull/4122)
- Inject `MAVEN_OPTS` environment variable into dev-machine [4119](https://github.com/eclipse/che/pull/4119)
- Reworked workspace key to new format where namespace can contain / symbols. [4115](https://github.com/eclipse/che/pull/4115)
- Make command-line `CHE_HOST` or `CHE_PORT` override `che.env` values. [4114](https://github.com/eclipse/che/pull/4114)
- Move popup from Quick documentation in the right place[4088](https://github.com/eclipse/che/pull/4088)
- Use the official OpenJDK image. [4087](https://github.com/eclipse/che/pull/4087)
- Improved OpenShift connector independence from DockerConnector [4085](https://github.com/eclipse/che/pull/4085)
- [cli] Prevent overwriting variables with recursive `cmd_lifecycle` statement [4083](https://github.com/eclipse/che/pull/4083)
- Removed unused transitive dependency for GWT code in `che-plugin-docker-client`. [4079](https://github.com/eclipse/che/pull/4079)
- Reworked workspace key to new format where namespace can contain `/` symbols. [4073](https://github.com/eclipse/che/pull/4073)
- remove CLI scripts mount in dev mode [4069](https://github.com/eclipse/che/pull/4069)
- Fixing failed tests [4065](https://github.com/eclipse/che/pull/4065)
- Improves UX of graceful shutdown message. [4064](https://github.com/eclipse/che/pull/4064)
- [cli] graceful stop work with any remote system state [4063](https://github.com/eclipse/che/pull/4063)
- Fix bad locale in CentOS based image [4056](https://github.com/eclipse/che/pull/4056)
- Prevent potential `NullPointerException` during string comparison. [4054](https://github.com/eclipse/che/pull/4054)
- Show workspace ssh key in ssh panel 'Connect via SSH'[4053](https://github.com/eclipse/che/pull/4053)
- Added OpenShiftConnector OAuth token support. [4049](https://github.com/eclipse/che/pull/4049)
- Add awk function to do numerical comparisons in CLI [4046](https://github.com/eclipse/che/pull/4046)
- Don't show double error notification when workspace starting is failed.[4045](https://github.com/eclipse/che/pull/4045)
- [cli] only gives -it docker run option if it was given from the command line [4037](https://github.com/eclipse/che/pull/4037)
- Reverts eclipse/che#4028 [4035](https://github.com/eclipse/che/pull/4035)
- Add awk function to do numerical comparisons in CLI but reverted by PR #4035. [4028](https://github.com/eclipse/che/pull/4028)
- Allow to start exec-agent/terminal agent on alpine image (base image without glibc) [4027](https://github.com/eclipse/che/pull/4027)
- Publish tracking events during system graceful stop [4023](https://github.com/eclipse/che/pull/4023)
- Fixed bug with environment variables parsing in dockerfile in UD[4016](https://github.com/eclipse/che/pull/4016)
- Fix issues with compiling GWT on Windows. [4011](https://github.com/eclipse/che/pull/4011)
- CLI - if `:/repo` mounted, check `CHE_BASE_API_VERSION` in repo to match version in image [4006](https://github.com/eclipse/che/pull/4006)
- Exclude `assembly/assembly-main/src/assembly/bin/` source folder from gitignore [4003](https://github.com/eclipse/che/pull/4003)
- - verbose output in background cli sync job when `--unison-verbose` flag is enabled [4001](https://github.com/eclipse/che/pull/4001)
- Decoupling of testing framework core API from Java specific testing frameworks implementation. ### Release Notes: N/A refactoring of existing code. ### Docs PR: None : same behavior than before [3999](https://github.com/eclipse/che/pull/3999)
- Use `/dockerfiles` path inside CLI container for launch [3991](https://github.com/eclipse/che/pull/3991)
- Errors that might happen on application server stopping, will be logged. [3990](https://github.com/eclipse/che/pull/3990)
- Upgraded GWT to version 2.8 including new `guava` and `lib-gwt-svg`. [3984](https://github.com/eclipse/che/pull/3984)
- Move all JS files of Orion from plugin-orion to the che-lib repository [3979](https://github.com/eclipse/che/pull/3979)
- Add output of failed agent into tomcat logs. [3961](https://github.com/eclipse/che/pull/3961)
- Implement OpenShiftConnector `pull`, `tag`, and `inspectImage` through [3956](https://github.com/eclipse/che/pull/3956)
- Bug fix for Starting workspace on openshift 1.4.1 `servicePort.setProtocol(protocol.toUpperCase());` [3954](https://github.com/eclipse/che/pull/3954)
- SSH machine types are moved to a separate plugin to decouple them from other types. [3946](https://github.com/eclipse/che/pull/3946)
- Integrate xterm.js (version 2.2.3) widget instead of xterm. [3943](https://github.com/eclipse/che/pull/3943)
- `org.eclipse.che.ide.api.keybinding.KeyBindingAgent#getEclipse` has been deprecated: use `KeyBindingAgent#getActive()` or `KeyBindingAgent#getScheme(String)` if you want to access a Scheme [3857](https://github.com/eclipse/che/pull/3857)
- Clarifies workspace state when IDE is loading while a workspace is being snapshotted. [3851](https://github.com/eclipse/che/pull/3851)
- Adds the Eclipse Vert.x stack to the default Che assembly. [3843](https://github.com/eclipse/che/pull/3843)
- Git history panel changed to a window to enable visualization of commit changes. [3799](https://github.com/eclipse/che/pull/3799)
- Git push authorization error message describes possible reasons [3781](https://github.com/eclipse/che/pull/3781)
- rename docker image eclipse/che-cli to eclipse/che (and add alias to previous name eclipse/che-cli) [3692](https://github.com/eclipse/che/pull/3692)
- Replicates changes done under issue #1947 and contained within PR #3032 including websocket and json rpc services modification but excluding exec agent client adaptation itself. [3627](https://github.com/eclipse/che/pull/3627)

## [5.2.2](https://github.com/eclipse/che/tree/5.2.2) (2017-02-04)
[Full Changelog](https://github.com/eclipse/che/compare/5.2.1..5.2.2)

**Pull requests merged:**
- Change command how to install openJDK on Debian [4017](https://github.com/eclipse/che/pull/4017)

## [5.2.1](https://github.com/eclipse/che/tree/5.2.1) (2017-02-03)
[Full Changelog](https://github.com/eclipse/che/compare/5.2.0...5.2.1)

**Pull requests merged:**
- Fixes workspace with project creation bug on user dashboard, ram indicator, stacks and samples relations. [4004](https://github.com/eclipse/che/pull/4004)

## [5.2.0](https://github.com/eclipse/che/tree/5.2.0) (2017-02-01)
[Full Changelog](https://github.com/eclipse/che/compare/5.1.2...5.2.0)

**Pull requests merged:**

- cli/ docker helper function : does not return false when container is not found [3992](https://github.com/eclipse/che/pull/3992)
- [cli] Fix restart command options on stop action [3986](https://github.com/eclipse/che/pull/3986)
- - Fix custom tag name, defined in dashboard components, for select stack widget. [3985](https://github.com/eclipse/che/pull/3985)
- Remove default--pretty option in docker che-ip unit tests [3983](https://github.com/eclipse/che/pull/3983)
- Add graceful stop (disable with --force) in CLI [3968](https://github.com/eclipse/che/pull/3968)
- Machine API has been deprecated in this release. [3966](https://github.com/eclipse/che/pull/3966)
- Native scripts like cli.sh, che.sh, etc have been removed [3960](https://github.com/eclipse/che/pull/3960)
- Rewrite che-ip utility and add unit tests for all known use cases (OS/Docker install). [3952](https://github.com/eclipse/che/pull/3952)
- Adds pretty formatting in bats cli tests image and add bats-assert helper functions [3951](https://github.com/eclipse/che/pull/3951)
- Introducing properties for OpenShift liveness probe initial delay / timeout [3950](https://github.com/eclipse/che/pull/3950)
- Adding stub implementation of Container API for OpenShiftConnector. Minor Refactoring. [3945](https://github.com/eclipse/che/pull/3945)
- Add `CHE_CONTAINER=` option to set explicit container name with CLI [3940](https://github.com/eclipse/che/pull/3940)
- Fixed agents installation behind the proxy [3927](https://github.com/eclipse/che/pull/3927)
- Che logs should go in /logs folder. server log was not present. [3926](https://github.com/eclipse/che/pull/3926)
- Package assembly-ide-war as classes artifact [3924](https://github.com/eclipse/che/pull/3924)
- Fixed regression of stack import and stack authoring in the Select Stack widget. [3922](https://github.com/eclipse/che/pull/3922)
- Input-boxes with 'required' attribute are marked with asterisk. [3919](https://github.com/eclipse/che/pull/3919)
- Add system service that allows to prepare system to shutdown [3917](https://github.com/eclipse/che/pull/3917)
- Do not write default values into the initial Chefile file when using chedir [3916](https://github.com/eclipse/che/pull/3916)
- Remove unused dependecies [3912](https://github.com/eclipse/che/pull/3912)
- Rework Project Service links injector [3911](https://github.com/eclipse/che/pull/3911)
- Add support of docker compose file in Chefile [3908](https://github.com/eclipse/che/pull/3908)
- Remove native launch of cli [3904](https://github.com/eclipse/che/pull/3904)
- `--unison-verbose` flag for sync command [3900](https://github.com/eclipse/che/pull/3900)
- Moved CLI functional tests from base directory to cli directory [3899](https://github.com/eclipse/che/pull/3899)
- Fix bug with infinite expectation during project import in case with running workspace. [3898](https://github.com/eclipse/che/pull/3898)
- Remove not needed classes. Web.xml cleanup [3897](https://github.com/eclipse/che/pull/3897)
- Don't sort node interceptors at initialization state [3895](https://github.com/eclipse/che/pull/3895)
- Adds CPU limits to Docker build process executions so they don't starve an entire node. [3893](https://github.com/eclipse/che/pull/3893)
- Fixed links pointing to stack documentation [3881](https://github.com/eclipse/che/pull/3881)
- Handle dockerfile content in Chefile as raw string [3875](https://github.com/eclipse/che/pull/3875)
- Change default workspace idle timeout to 4 hours [3874](https://github.com/eclipse/che/pull/3874)
- Added basic CLI 'start' functional tests [3870](https://github.com/eclipse/che/pull/3870)
- Change AGENT_EXTERNAL_PORT to real ephemeral port [3867](https://github.com/eclipse/che/pull/3867)
- Improve output of `info` command [3862](https://github.com/eclipse/che/pull/3862)
- Workaround illegal response from docker [3854](https://github.com/eclipse/che/pull/3854)
- Remove inmemory DAO implementations [3852](https://github.com/eclipse/che/pull/3852)
- Fix bug which prevents to show workspace-details page. [3850](https://github.com/eclipse/che/pull/3850)
- Add missing scope for servlet-api dependency [3841](https://github.com/eclipse/che/pull/3841)
- Update PR template with new PR policy items [3839](https://github.com/eclipse/che/pull/3839)
- Decouple different agents on different maven modules [3830](https://github.com/eclipse/che/pull/3830)
- Npm is now installing dependencies [3829](https://github.com/eclipse/che/pull/3829)
- Simplify Dashboard build by relying on NPM run-script [3828](https://github.com/eclipse/che/pull/3828)
- Switch to CLI to launch CHE inside chedir instead of the Che launcher [3826](https://github.com/eclipse/che/pull/3826)
- Fix pressing Enter key on a node inside FindUsage widget [3821](https://github.com/eclipse/che/pull/3821)
- Update style for popups. [3818](https://github.com/eclipse/che/pull/3818)
- Rework EnvironmentContext#getSubject method to not return null subject [3813](https://github.com/eclipse/che/pull/3813)
- Fix docker machines addresses setting [3812](https://github.com/eclipse/che/pull/3812)
- Improve find and navigate to file capabilities in IDE [3806](https://github.com/eclipse/che/pull/3806)
- Fixes display URL error when not initialized [3800](https://github.com/eclipse/che/pull/3800)
- Add `OpenShiftConnector` to support `io.fabric8` API for container management. [3798](https://github.com/eclipse/che/pull/3798)
- Change data type of project attribute values from VARCHAR(255) to TEXT [3789](https://github.com/eclipse/che/pull/3789)
- Remove Eclipse Che Launcher: it has been supersede by new Docker CLI [3787](https://github.com/eclipse/che/pull/3787)
- Holds node interceptors in set instead of list to avoid duplicating [3786](https://github.com/eclipse/che/pull/3786)
- Remove native launch scripts of Eclipse Che (replaced now by Docker CLI) [3780](https://github.com/eclipse/che/pull/3780)
- Rename exec-agent directory to exec [3775](https://github.com/eclipse/che/pull/3775)
- Add filters for force or disable caching on the given resources paths. [3771](https://github.com/eclipse/che/pull/3771)
- Removes redundant in-memory JSON trees for faster DTO parsing performance. [3103] (https://github.com/eclipse/che/pull/3103)
- Add commands to workspace when importing project samples [2976](https://github.com/eclipse/che/pull/2976)

## [5.1.2](https://github.com/eclipse/che/tree/5.1.2) (2017-01-24)
[Full Changelog](https://github.com/eclipse/che/compare/5.1.1...5.1.2)

**Issues with no labels:**

- Can't create an old version of che [\#3868](https://github.com/eclipse/che/issues/3868)
- CHE CLI - nightly - errors - opensuse [\#3855](https://github.com/eclipse/che/issues/3855)
- The Che server is unable to ping your workspace.  [\#3849](https://github.com/eclipse/che/issues/3849)
- New ideas of Features [\#3845](https://github.com/eclipse/che/issues/3845)
- Browser can't access workspace: "client has aborted connection" [\#3842](https://github.com/eclipse/che/issues/3842)
- Some factories do not work on the getting-started page [\#3836](https://github.com/eclipse/che/issues/3836)
- Workspace container exposed to IP 0.0.0.0 instead of CHE\_HOST [\#3831](https://github.com/eclipse/che/issues/3831)
- Creating new workspace does not work\(regression\) [\#3822](https://github.com/eclipse/che/issues/3822)
- Release CHE 5.1.1 [\#3808](https://github.com/eclipse/che/issues/3808)
- Remove Local dao implementations [\#3776](https://github.com/eclipse/che/issues/3776)
- Update Wiki for PR Policy [\#3773](https://github.com/eclipse/che/issues/3773)
- Fix losing selected text in the new terminal ui. [\#3757](https://github.com/eclipse/che/issues/3757)
- Support: Help Getting Che Master & Agent To Connect [\#3737](https://github.com/eclipse/che/issues/3737)
- Cannot connect workspace over ssh with putty [\#3687](https://github.com/eclipse/che/issues/3687)
- Cannot access Workspace from different PC over LAN  [\#3657](https://github.com/eclipse/che/issues/3657)
- anyone who can tell me where's  the source code of che-terminal-server [\#3587](https://github.com/eclipse/che/issues/3587)
- Workspace doesn't startup [\#3543](https://github.com/eclipse/che/issues/3543)
- about exception -org.eclipse.jdt.internal.core.Openable [\#3516](https://github.com/eclipse/che/issues/3516)
- Terminal enhancement by using xterm.js [\#3513](https://github.com/eclipse/che/issues/3513)
- persistent URLs [\#3512](https://github.com/eclipse/che/issues/3512)
- Avoid caching problem in http resources [\#3492](https://github.com/eclipse/che/issues/3492)
- Create new docs repo [\#3488](https://github.com/eclipse/che/issues/3488)
- Inject panel in editor at runtime ? [\#3475](https://github.com/eclipse/che/issues/3475)
- 404 error opening my workspace. [\#3418](https://github.com/eclipse/che/issues/3418)
- how do I add local \(proprietary\) tools to Eclipse Che server installed locally? [\#3377](https://github.com/eclipse/che/issues/3377)
- failed to inject orion editor [\#3355](https://github.com/eclipse/che/issues/3355)
- Enhancements for workspace create REST service to support additional parameters [\#3283](https://github.com/eclipse/che/issues/3283)
- Can't create a workspace or anything for that matter with latest eclipse che [\#3268](https://github.com/eclipse/che/issues/3268)
- Not able to load eclipse che Java console app  [\#3219](https://github.com/eclipse/che/issues/3219)
- Need to access eclipse che url\(http://ip-address/dashboard\) from jquery [\#3208](https://github.com/eclipse/che/issues/3208)
- Update codemirror version to 5.19.0 [\#3141](https://github.com/eclipse/che/issues/3141)
- where is documentation of class ProposalApplyResult? [\#3138](https://github.com/eclipse/che/issues/3138)
- Add iPad Support [\#3116](https://github.com/eclipse/che/issues/3116)
- Developing with libgdx in che [\#3041](https://github.com/eclipse/che/issues/3041)
- OpenShift API implementation [\#3031](https://github.com/eclipse/che/issues/3031)
- Error creating new project [\#2902](https://github.com/eclipse/che/issues/2902)
- import from Google Cloud VCS [\#2842](https://github.com/eclipse/che/issues/2842)
- "OOM of process" in container [\#2788](https://github.com/eclipse/che/issues/2788)
- Install che behind specific Port range to communicate [\#2751](https://github.com/eclipse/che/issues/2751)
- Unable to access Artik IDE at the URL \(Unauthorized message on the browser\) [\#1892](https://github.com/eclipse/che/issues/1892)
- Release CHE 5.1.2 [\#3872](https://github.com/eclipse/che/issues/3872)

**Pull requests merged:**

- CLI - Fix error with version check on nightly [\#3848](https://github.com/eclipse/che/pull/3848) ([TylerJewell](https://github.com/TylerJewell))
- Fixed validator of raw workspace configuration [\#3838](https://github.com/eclipse/che/pull/3838) ([olexii4](https://github.com/olexii4))
- \[cli\] Version command fix, add :/assembly mount option [\#3835](https://github.com/eclipse/che/pull/3835) ([TylerJewell](https://github.com/TylerJewell))
- New tests for CLI, refactoring of CLI scripts, fix destroy cmd [\#3700](https://github.com/eclipse/che/pull/3700) ([mlabuda](https://github.com/mlabuda))

## [5.1.1](https://github.com/eclipse/che/tree/5.1.1) (2017-01-20)
[Full Changelog](https://github.com/eclipse/che/compare/5.1.0...5.1.1)

**Issues with no labels:**

- Image eclipse/che not Removed with CLI RMI  [\#3820](https://github.com/eclipse/che/issues/3820)
- Need to document the process of deployment Che on OpenShift  [\#3817](https://github.com/eclipse/che/issues/3817)
- assembly-ide-war build Error on enabling sample-plugin-nativeaccess [\#3810](https://github.com/eclipse/che/issues/3810)
- the commands from samples.json don't appear [\#3794](https://github.com/eclipse/che/issues/3794)
- Executing commands on Target through Eclipse che [\#3624](https://github.com/eclipse/che/issues/3624)
- Using Eclipse Che for developing apps on Raspberry pi [\#3273](https://github.com/eclipse/che/issues/3273)

## [5.1.0](https://github.com/eclipse/che/tree/5.1.0) (2017-01-18)
[Full Changelog](https://github.com/eclipse/che/compare/5.0.1...5.1.0)

**Issues with no labels:**

- no\_proxy is not applied when using samples.json [\#3790](https://github.com/eclipse/che/issues/3790)
- unexpected grouping of create new project menu items [\#3759](https://github.com/eclipse/che/issues/3759)
- getting Che to execute an imported Node.js hello world [\#3755](https://github.com/eclipse/che/issues/3755)
- The language server cannot finish of initializing [\#3744](https://github.com/eclipse/che/issues/3744)
- Provide ability to cancel workspace start [\#3742](https://github.com/eclipse/che/issues/3742)
- All bitnami stacks do not work [\#3740](https://github.com/eclipse/che/issues/3740)
- The 'Navigate To File' works incorrectly \(regression\) [\#3739](https://github.com/eclipse/che/issues/3739)
- Unable to mount volume to workspace - CHE-WORKSPACE-VOLUME [\#3738](https://github.com/eclipse/che/issues/3738)
- Che server is unable to ping your workspace [\#3736](https://github.com/eclipse/che/issues/3736)
- Passing CHE\_PORT env var to docker "che start" results in unreachable server [\#3729](https://github.com/eclipse/che/issues/3729)
- UTILITY\_IMAGE\_CHEIP: unbound variable [\#3716](https://github.com/eclipse/che/issues/3716)
- Boot2Docker - eclipse/che  - Are you trying to connect to a TLS-enabled daemon without TLS [\#3713](https://github.com/eclipse/che/issues/3713)
- Improve build xterm js using gulp tasks [\#3527](https://github.com/eclipse/che/issues/3527)
-  Improve xterm.js css styles to nice view. [\#3526](https://github.com/eclipse/che/issues/3526)
- Reorganize Che repository to simplify location of agent storage [\#3437](https://github.com/eclipse/che/issues/3437)
- Eclipse Che no longer responding, message "Updating File" [\#3396](https://github.com/eclipse/che/issues/3396)
- Issues with documentation popup for LSP code completion [\#3218](https://github.com/eclipse/che/issues/3218)
- Provide better alignements in the Process panel [\#2859](https://github.com/eclipse/che/issues/2859)
- Advanced stack configuration form [\#2316](https://github.com/eclipse/che/issues/2316)
- 5.1.0 Milestone Overview [\#3972](https://github.com/eclipse/che/issues/3972)
- Release CHE 5.1.0 [\#3807](https://github.com/eclipse/che/issues/3807)
- Unexpected error when import project in the IDE [\#3766](https://github.com/eclipse/che/issues/3766)
- Workspace created by compose recipe url does not start \(regression\) [\#3765](https://github.com/eclipse/che/issues/3765)
- Avoid jumping selection in the file tree after selecting files [\#3762](https://github.com/eclipse/che/issues/3762)
- cli nightly does not work on different OS or storage drivers [\#3684](https://github.com/eclipse/che/issues/3684)
- CLI must check if all containers started properly [\#3655](https://github.com/eclipse/che/issues/3655)
- Remove Machine Perspective [\#3619](https://github.com/eclipse/che/issues/3619)
- Java Debugger server side test [\#3617](https://github.com/eclipse/che/issues/3617)
- Display system servers as well in the list of servers [\#3615](https://github.com/eclipse/che/issues/3615)
- Unexpected losing of  ocus in the terminal after minimize/maximize operations [\#3578](https://github.com/eclipse/che/issues/3578)
- Wiped issue [\#3550](https://github.com/eclipse/che/issues/3550)
- Make it possible to restart WS in IDE if previous start failed [\#3548](https://github.com/eclipse/che/issues/3548)
- Delete docs folder [\#3511](https://github.com/eclipse/che/issues/3511)
- Can't stop exec agent process after refresh page [\#3464](https://github.com/eclipse/che/issues/3464)
- Implement ability to perform cascade operation on event [\#3399](https://github.com/eclipse/che/issues/3399)
- Remove org.eclipse.che.ide.api.resources.VirtualFile\#getMediaType deprecated method [\#3321](https://github.com/eclipse/che/issues/3321)
- The context menu for Git in Project Explorer is invalid [\#3271](https://github.com/eclipse/che/issues/3271)
- Add method for getting project [\#3243](https://github.com/eclipse/che/issues/3243)
- Change signature of the org.eclipse.che.ide.api.resources.Resource\#getParent [\#3242](https://github.com/eclipse/che/issues/3242)
- Add utility methods for casting resources to their particular types [\#3239](https://github.com/eclipse/che/issues/3239)
- Toolbar is empty after restart workspace \(regression\) [\#3234](https://github.com/eclipse/che/issues/3234)
- When user click exit button terminal process will not be killed if terminal has child processes. [\#3216](https://github.com/eclipse/che/issues/3216)
- Import and configure batch of projects on stack testing [\#3209](https://github.com/eclipse/che/issues/3209)
- Stop workspace w/o snapshot on deletion [\#3159](https://github.com/eclipse/che/issues/3159)
- Add restart button the the Workspace Agent Not Responding popup [\#3155](https://github.com/eclipse/che/issues/3155)
- Improve buttons on the part toolbar [\#3152](https://github.com/eclipse/che/issues/3152)
- Add Sourcegraph Python Language Server to Che [\#3120](https://github.com/eclipse/che/issues/3120)
- Reduce amount of calls on get workspaces API call  [\#3082](https://github.com/eclipse/che/issues/3082)
- Update / clean up snapshots on environments configuration update [\#3017](https://github.com/eclipse/che/issues/3017)
- Incremental search doesn't work? [\#2992](https://github.com/eclipse/che/issues/2992)
- Failed to restart workspace with renamed environment [\#2528](https://github.com/eclipse/che/issues/2528)
- Add source section to advanced stack page  [\#2514](https://github.com/eclipse/che/issues/2514)
- Commands in the output console are duplicated. [\#2382](https://github.com/eclipse/che/issues/2382)
- Import zip project from dropbox works wrong [\#2349](https://github.com/eclipse/che/issues/2349)
- Che server should connect to ws-agent on internal URL [\#2030](https://github.com/eclipse/che/issues/2030)
- Viewing or editing a file containing line 'exit' kills the terminal [\#1979](https://github.com/eclipse/che/issues/1979)

**Pull requests merged:**

- RELEASE: set tags for release [\#3796](https://github.com/eclipse/che/pull/3796) ([riuvshin](https://github.com/riuvshin))
- CODENVY-1544: workaround zero-length ws agent archive in snapshots [\#3793](https://github.com/eclipse/che/pull/3793) ([garagatyi](https://github.com/garagatyi))
- Fix NPE introduced by \#3701 [\#3769](https://github.com/eclipse/che/pull/3769) ([evoevodin](https://github.com/evoevodin))
- Skip failed project resolving in case if the last one is empty [\#3767](https://github.com/eclipse/che/pull/3767) ([vzhukovskii](https://github.com/vzhukovskii))
- Avoid tree jump during file selection [\#3763](https://github.com/eclipse/che/pull/3763) ([vzhukovskii](https://github.com/vzhukovskii))
- Fix \#3686 : Property around external docker has been changed in a refactoring [\#3753](https://github.com/eclipse/che/pull/3753) ([benoitf](https://github.com/benoitf))
- Update CUSTOMIZING.md [\#3752](https://github.com/eclipse/che/pull/3752) ([JamesDrummond](https://github.com/JamesDrummond))
- Fix bug in CLI Output if user has overridden CHE\_HOST [\#3749](https://github.com/eclipse/che/pull/3749) ([TylerJewell](https://github.com/TylerJewell))
- \[cli\] Fix init command [\#3747](https://github.com/eclipse/che/pull/3747) ([benoitf](https://github.com/benoitf))
- CHE-3740; fix debian scipts java install [\#3745](https://github.com/eclipse/che/pull/3745) ([mshaposhnik](https://github.com/mshaposhnik))
- Fixes mapping of custom port with CHE\_PORT [\#3734](https://github.com/eclipse/che/pull/3734) ([TylerJewell](https://github.com/TylerJewell))
- Update cli-functions.sh [\#3732](https://github.com/eclipse/che/pull/3732) ([riuvshin](https://github.com/riuvshin))
- \[cli\] Fix \#3655 : Check docker-compose file validity, result of docker-compose up and containers [\#3731](https://github.com/eclipse/che/pull/3731) ([benoitf](https://github.com/benoitf))
- allow skip backup on upgrade [\#3728](https://github.com/eclipse/che/pull/3728) ([riuvshin](https://github.com/riuvshin))
- Update exec-agent accordingly to its move to new path [\#3727](https://github.com/eclipse/che/pull/3727) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Composer project generation [\#3726](https://github.com/eclipse/che/pull/3726) ([vparfonov](https://github.com/vparfonov))
- add 5.0.1 version [\#3725](https://github.com/eclipse/che/pull/3725) ([riuvshin](https://github.com/riuvshin))
- Remove deprecated method getMediaType [\#3724](https://github.com/eclipse/che/pull/3724) ([vzhukovskii](https://github.com/vzhukovskii))
- Add missed test resources [\#3719](https://github.com/eclipse/che/pull/3719) ([tolusha](https://github.com/tolusha))
- CODENVY-1506 Rework workspace manager methods to optionally return runtime info [\#3714](https://github.com/eclipse/che/pull/3714) ([mkuznyetsov](https://github.com/mkuznyetsov))
- JavaDebugger server side tests [\#3705](https://github.com/eclipse/che/pull/3705) ([tolusha](https://github.com/tolusha))
- Update dto-pom.xml [\#3702](https://github.com/eclipse/che/pull/3702) ([riuvshin](https://github.com/riuvshin))
- Implement workspace start cancellation [\#3701](https://github.com/eclipse/che/pull/3701) ([evoevodin](https://github.com/evoevodin))
- CHE-2859 Provide better alignements in the Process panel [\#3699](https://github.com/eclipse/che/pull/3699) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- CHE-3548: add ability to press start button to restart WS if previous start failed [\#3698](https://github.com/eclipse/che/pull/3698) ([svor](https://github.com/svor))
- revert back pulling CLI if local image older than 24h [\#3695](https://github.com/eclipse/che/pull/3695) ([riuvshin](https://github.com/riuvshin))
- CHE-3120: Add Sourcegraph Python Language Server to Che [\#3693](https://github.com/eclipse/che/pull/3693) ([vparfonov](https://github.com/vparfonov))
- SAAS-101 : Allow cli inheritance without dockerfiles manifests [\#3691](https://github.com/eclipse/che/pull/3691) ([benoitf](https://github.com/benoitf))
- Remove machine perspective [\#3689](https://github.com/eclipse/che/pull/3689) ([dkuleshov](https://github.com/dkuleshov))
- revert cli nightly image check [\#3688](https://github.com/eclipse/che/pull/3688) ([riuvshin](https://github.com/riuvshin))
- Change signature of getParent to return actual parent instead of Optional [\#3681](https://github.com/eclipse/che/pull/3681) ([vzhukovskii](https://github.com/vzhukovskii))
- INFRA-41; Migrate OracleJDK to OpenJDK installing in custom images [\#3680](https://github.com/eclipse/che/pull/3680) ([mshaposhnik](https://github.com/mshaposhnik))
- CHE-3271: Fix Git commit when the source of the project is selected in project explorer [\#3679](https://github.com/eclipse/che/pull/3679) ([vinokurig](https://github.com/vinokurig))
- CODENVY-1150: Refactor docker hosts evaluation [\#3677](https://github.com/eclipse/che/pull/3677) ([garagatyi](https://github.com/garagatyi))
- CODENVY-1403: Disable rsync agents on UI [\#3676](https://github.com/eclipse/che/pull/3676) ([mmorhun](https://github.com/mmorhun))
- Reorganize resource api related to obtain bound project [\#3669](https://github.com/eclipse/che/pull/3669) ([vzhukovskii](https://github.com/vzhukovskii))
- Use getConfig\(\) instead of null while creating machine metadata [\#3662](https://github.com/eclipse/che/pull/3662) ([evoevodin](https://github.com/evoevodin))
- Revert WorkspaceService\#getByNamespace functionality [\#3661](https://github.com/eclipse/che/pull/3661) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Base URL to the master will be provided by AppContext  [\#3658](https://github.com/eclipse/che/pull/3658) ([vparfonov](https://github.com/vparfonov))
- CHE-3578: set focus on terminal after resizing [\#3654](https://github.com/eclipse/che/pull/3654) ([svor](https://github.com/svor))
- Add utility methods to cast resource to its particular type [\#3653](https://github.com/eclipse/che/pull/3653) ([vzhukovskii](https://github.com/vzhukovskii))
- Add ability to reload page after lose connection with ws agent [\#3651](https://github.com/eclipse/che/pull/3651) ([vzhukovskii](https://github.com/vzhukovskii))
- Move agents in agents module [\#3647](https://github.com/eclipse/che/pull/3647) ([mkuznyetsov](https://github.com/mkuznyetsov))
- CHE-3615: display system servers in the list of servers [\#3636](https://github.com/eclipse/che/pull/3636) ([akurinnoy](https://github.com/akurinnoy))
- fix che docs version [\#3633](https://github.com/eclipse/che/pull/3633) ([riuvshin](https://github.com/riuvshin))
- CHE-2894 Processes panel should be opened maximized [\#3631](https://github.com/eclipse/che/pull/3631) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- Exclude generated files from license check [\#3623](https://github.com/eclipse/che/pull/3623) ([ashumilova](https://github.com/ashumilova))
- Fix SQL license exclusion filter [\#3622](https://github.com/eclipse/che/pull/3622) ([mkuznyetsov](https://github.com/mkuznyetsov))
- CHE-3271: Add more Git actions to context menu [\#3618](https://github.com/eclipse/che/pull/3618) ([vinokurig](https://github.com/vinokurig))
- CHE-3464: fix a problem with stopping the process [\#3613](https://github.com/eclipse/che/pull/3613) ([svor](https://github.com/svor))
- Revert license for SQL scripts [\#3610](https://github.com/eclipse/che/pull/3610) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Set correct language attribute to Python 3 sample [\#3598](https://github.com/eclipse/che/pull/3598) ([mkuznyetsov](https://github.com/mkuznyetsov))
- CHE-3589 Clean-up Plugin SVN encryption related code [\#3592](https://github.com/eclipse/che/pull/3592) ([mkuznyetsov](https://github.com/mkuznyetsov))
- CHE-3152 Improve buttons on the part toolbar [\#3590](https://github.com/eclipse/che/pull/3590) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- Remove docs which are now located at che-docs. [\#3580](https://github.com/eclipse/che/pull/3580) ([JamesDrummond](https://github.com/JamesDrummond))
- Refactor workspace infrastructure provisioning [\#3577](https://github.com/eclipse/che/pull/3577) ([garagatyi](https://github.com/garagatyi))
- CHE-1038: make Navigate To File feature not case-sensitive [\#3573](https://github.com/eclipse/che/pull/3573) ([svor](https://github.com/svor))
- Load instance runtime information on machine start [\#3561](https://github.com/eclipse/che/pull/3561) ([evoevodin](https://github.com/evoevodin))
- Do not fetch runtimes when getting list of all workspaces [\#3557](https://github.com/eclipse/che/pull/3557) ([mkuznyetsov](https://github.com/mkuznyetsov))
- CHE-1979: Fix closing terminal widget on typing "exit" or when user kills terminal process [\#3554](https://github.com/eclipse/che/pull/3554) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- Loads a new git history page when user scrolled list to the very bottom [\#3553](https://github.com/eclipse/che/pull/3553) ([tolusha](https://github.com/tolusha))
- CHE-2528: Start workspace after renaming of environment [\#3521](https://github.com/eclipse/che/pull/3521) ([mmorhun](https://github.com/mmorhun))
- CHE-2514 add import stack popup [\#3518](https://github.com/eclipse/che/pull/3518) ([olexii4](https://github.com/olexii4))
- CHE-3209 add import and configure batch of projects on stack testing [\#3445](https://github.com/eclipse/che/pull/3445) ([olexii4](https://github.com/olexii4))
- CODENVY-937: stop buttons behavior based on auto-snapshot settings [\#3419](https://github.com/eclipse/che/pull/3419) ([ashumilova](https://github.com/ashumilova))
- Add manually publishing cascade events in implementation of DAOs instead of using EntityListeners [\#3342](https://github.com/eclipse/che/pull/3342) ([sleshchenko](https://github.com/sleshchenko))
- Refactor DockerInstanceRuntimeInfo\#getServers\(\) \(\#2030\) [\#3282](https://github.com/eclipse/che/pull/3282) ([amisevsk](https://github.com/amisevsk))

## [5.0.1](https://github.com/eclipse/che/tree/5.0.1) (2017-01-12)
[Full Changelog](https://github.com/eclipse/che/compare/5.0.0...5.0.1)

**Issues with no labels:**

- Problem importing OpenShift Git project in Eclipse Che on Codenvy [\#3696](https://github.com/eclipse/che/issues/3696)
- enviromental variables are not inherited in the web ide [\#3665](https://github.com/eclipse/che/issues/3665)
- Confusing help on CLI for 'sync' command [\#3650](https://github.com/eclipse/che/issues/3650)
- Problem in folder \(Package\) with name "api"  [\#3644](https://github.com/eclipse/che/issues/3644)
- I can not open eclipse-che [\#3643](https://github.com/eclipse/che/issues/3643)
- \[Docs\] Intelij development setup section missing in help [\#3642](https://github.com/eclipse/che/issues/3642)
- license headers are missing [\#3608](https://github.com/eclipse/che/issues/3608)
- CLI does not use a local che assembly [\#3599](https://github.com/eclipse/che/issues/3599)
- CLI download error. [\#3596](https://github.com/eclipse/che/issues/3596)
- Workspace Agent Not responding [\#3595](https://github.com/eclipse/che/issues/3595)
- Remove SVN encryption related code [\#3589](https://github.com/eclipse/che/issues/3589)
- Can we deploy a custom war file into tomcat which is in che container [\#3588](https://github.com/eclipse/che/issues/3588)
- Integration  xterm.js to GWT code. [\#3525](https://github.com/eclipse/che/issues/3525)
- Eclipse-che docs typo on Logical Architecture Section [\#3440](https://github.com/eclipse/che/issues/3440)
- Memory settings on workspaces and VMs [\#3401](https://github.com/eclipse/che/issues/3401)
- wsmaster/che-core-api-workspace sometimes fails to compile [\#3337](https://github.com/eclipse/che/issues/3337)
- Processes panel should be opened maximized [\#2894](https://github.com/eclipse/che/issues/2894)
- console-python3-simple has strange attribute [\#2792](https://github.com/eclipse/che/issues/2792)
- Rename Che Docker Images [\#2737](https://github.com/eclipse/che/issues/2737)
- release che 5.0.1 [\#3706](https://github.com/eclipse/che/issues/3706)
- Breakpoints disappear when nodejs debugger is resumed [\#3675](https://github.com/eclipse/che/issues/3675)
- make it possible to configure logback smtp host and port [\#3670](https://github.com/eclipse/che/issues/3670)
- CLI upgrade command does not work [\#3668](https://github.com/eclipse/che/issues/3668)
- Improve error message when starting nightly from a latest configuration [\#3664](https://github.com/eclipse/che/issues/3664)
- NodeJS Hello World Broke [\#3660](https://github.com/eclipse/che/issues/3660)
- Alter Chedir Syntax [\#3645](https://github.com/eclipse/che/issues/3645)
- Prevent Che start if 'nightly' or 'latest' images are not current. [\#3640](https://github.com/eclipse/che/issues/3640)
- File watcher works incorrectly \(regression\) [\#3537](https://github.com/eclipse/che/issues/3537)

**Pull requests merged:**

- fix che-ip [\#3690](https://github.com/eclipse/che/pull/3690) ([riuvshin](https://github.com/riuvshin))
- fix cli tty issue [\#3683](https://github.com/eclipse/che/pull/3683) ([riuvshin](https://github.com/riuvshin))
- Fix \#3668: Fix upgrade cli method [\#3682](https://github.com/eclipse/che/pull/3682) ([benoitf](https://github.com/benoitf))
- Update default\_node\_content [\#3678](https://github.com/eclipse/che/pull/3678) ([JamesDrummond](https://github.com/JamesDrummond))
- CLI improvements for handling of nightly images [\#3671](https://github.com/eclipse/che/pull/3671) ([TylerJewell](https://github.com/TylerJewell))
- CHE-3537: don't show notification after deleting files internally [\#3652](https://github.com/eclipse/che/pull/3652) ([dkuleshov](https://github.com/dkuleshov))
- Che CLI Refactoring [\#3646](https://github.com/eclipse/che/pull/3646) ([TylerJewell](https://github.com/TylerJewell))

## [5.0.0](https://github.com/eclipse/che/tree/5.0.0) (2017-01-06)
[Full Changelog](https://github.com/eclipse/che/compare/5.0.0-M9...5.0.0)

**Issues with no labels:**

- Che issue starting debugger. [\#3604](https://github.com/eclipse/che/issues/3604)
- Error: Fail launching agent SSH [\#3603](https://github.com/eclipse/che/issues/3603)
- eclipse/che-ip returns 2 IP addresses as CHE\_HOST [\#3564](https://github.com/eclipse/che/issues/3564)
- docker fails when starting a workspace [\#3552](https://github.com/eclipse/che/issues/3552)
- Add tests written section in PR template [\#3547](https://github.com/eclipse/che/issues/3547)
- Make CLI show che-server start logs in dev mode  [\#3546](https://github.com/eclipse/che/issues/3546)
- Debug Che binaries within che-server without mounting /repo [\#3542](https://github.com/eclipse/che/issues/3542)
- Unsupported OAuth provider github for Ready-To-Run project [\#3523](https://github.com/eclipse/che/issues/3523)
- Investigate correct working xtermjs with requirejs [\#3517](https://github.com/eclipse/che/issues/3517)
- Dashboard "Create Workspace" button creates new project, not workspace [\#3515](https://github.com/eclipse/che/issues/3515)
- Workspace storage location not inherited from server container [\#3514](https://github.com/eclipse/che/issues/3514)
- Build che docs. [\#3487](https://github.com/eclipse/che/issues/3487)
- Create repo to store large files such doc images. [\#3483](https://github.com/eclipse/che/issues/3483)
- Duplicate entry in project explorer after import [\#3463](https://github.com/eclipse/che/issues/3463)
- changing recipe location causes an error [\#3447](https://github.com/eclipse/che/issues/3447)
- Unable to create workspace on start [\#3417](https://github.com/eclipse/che/issues/3417)
- How to configure SSL che terminal ? [\#3132](https://github.com/eclipse/che/issues/3132)
- Project import gets org.eclipse.jdt.core.JavaModelException [\#2866](https://github.com/eclipse/che/issues/2866)
- Make alternative to CHE\_LOCAL\_BINARY [\#2778](https://github.com/eclipse/che/issues/2778)
- The pop up dialog about "Success created workspace "overlay the open button on dashboard [\#2690](https://github.com/eclipse/che/issues/2690)
- We have an empty  name and email fields in .git/config file after import an existing project [\#2682](https://github.com/eclipse/che/issues/2682)
- GDB Debugger: Workspace IDE freeze when debugging noexit program [\#2508](https://github.com/eclipse/che/issues/2508)
- Documentation for PHP Debugging [\#3594](https://github.com/eclipse/che/issues/3594)
- Release and ship CHE 5.0.0 [\#3593](https://github.com/eclipse/che/issues/3593)
- Fix package/deploy issue of docs. [\#3563](https://github.com/eclipse/che/issues/3563)
- Privileged mode does not work [\#3549](https://github.com/eclipse/che/issues/3549)
- Not all files are deleted from editor after deleting parent folder\(regression\) [\#3536](https://github.com/eclipse/che/issues/3536)
- File unexpectedly disappears from editor after rename \(regression\) [\#3535](https://github.com/eclipse/che/issues/3535)
- Content of file is not update after git checkout \(regression\) [\#3532](https://github.com/eclipse/che/issues/3532)
- Change access to docs from dashboard [\#3524](https://github.com/eclipse/che/issues/3524)
- Docs maven build [\#3510](https://github.com/eclipse/che/issues/3510)
- The editor is empty after restart workspace\(regression\) [\#3499](https://github.com/eclipse/che/issues/3499)
- Unexpected notification 'Running tests' after call 'Navigate to File'  [\#3478](https://github.com/eclipse/che/issues/3478)
- Unexpected appearance of empty split panel after first starting of workspace [\#3460](https://github.com/eclipse/che/issues/3460)
- Add Servers section to machine details [\#3456](https://github.com/eclipse/che/issues/3456)
- Clarify how Che uses private docker registry for snapshots [\#3442](https://github.com/eclipse/che/issues/3442)
- We have red output after launching tomcat for the Spring project [\#3439](https://github.com/eclipse/che/issues/3439)
- After applying new exec agent some commands may be invalid [\#3438](https://github.com/eclipse/che/issues/3438)
- Any command is not performed in the not dev-machine \(regression\) [\#3435](https://github.com/eclipse/che/issues/3435)
- The command line is empty into console after run \(regression\) [\#3434](https://github.com/eclipse/che/issues/3434)
- Preview URL is lost after refresh page\(regression\)  [\#3433](https://github.com/eclipse/che/issues/3433)
- Cannot open package in a particular project [\#3426](https://github.com/eclipse/che/issues/3426)
- Update CI Systems [\#3423](https://github.com/eclipse/che/issues/3423)
- Revamp Che docs for 5 [\#3406](https://github.com/eclipse/che/issues/3406)
- CLI Docker Daemon Check [\#3384](https://github.com/eclipse/che/issues/3384)
- Impossible to delete existing workspace [\#3372](https://github.com/eclipse/che/issues/3372)
- Can't select text in the terminal panel [\#3370](https://github.com/eclipse/che/issues/3370)
- Git history panel is not opened \(regression\) [\#3369](https://github.com/eclipse/che/issues/3369)
- Can't connect to Che server with debug session  [\#3367](https://github.com/eclipse/che/issues/3367)
- Sometimes workspace fails to start or projects are failed to initialize [\#3363](https://github.com/eclipse/che/issues/3363)
- Git History blocks with large projects [\#3353](https://github.com/eclipse/che/issues/3353)
- Che does not start after toggling dev mode on / off from CLI [\#3351](https://github.com/eclipse/che/issues/3351)
- CHE\_HOST variable is not working as expected [\#3350](https://github.com/eclipse/che/issues/3350)
- Che container creates folders with projects in /data on host machine [\#3324](https://github.com/eclipse/che/issues/3324)
- Configure Master & Agent JVMs to Inherit Proxy Settings [\#3319](https://github.com/eclipse/che/issues/3319)
- Workspace RUNNING status event is not published after SNAPSHOTTING status [\#3314](https://github.com/eclipse/che/issues/3314)
- Can't resize process window when there is download file in chrome browser [\#3298](https://github.com/eclipse/che/issues/3298)
- Make process of snapshot removal asynchronous. [\#3258](https://github.com/eclipse/che/issues/3258)
- Display version number in dashboard [\#3257](https://github.com/eclipse/che/issues/3257)
- Mark org.eclipse.che.ide.api.resources.VirtualFile\#getMediaType as deprecated [\#3235](https://github.com/eclipse/che/issues/3235)
- Remove deprecated org.eclipse.che.ide.api.resources.VirtualFile\#getPath [\#3233](https://github.com/eclipse/che/issues/3233)
- Open of new terminal doesn't show processes tab [\#3223](https://github.com/eclipse/che/issues/3223)
- Open create workspace failed. [\#3183](https://github.com/eclipse/che/issues/3183)
- HotKeys hints for import/create projects does not appear in browser under anonim mode [\#3167](https://github.com/eclipse/che/issues/3167)
- Che version should be visible on the user dashboard [\#3154](https://github.com/eclipse/che/issues/3154)
- Cannot select an item in the terminal [\#3140](https://github.com/eclipse/che/issues/3140)
- After reset or shut down computer CHE networks still exist. [\#3135](https://github.com/eclipse/che/issues/3135)
- Project can't be created without Z option [\#3129](https://github.com/eclipse/che/issues/3129)
- Issues with Language Servers [\#3127](https://github.com/eclipse/che/issues/3127)
- Maven dependency resolver continues to run after workspace is stopped [\#3121](https://github.com/eclipse/che/issues/3121)
- Add Sourcegraph TypeScript Language Server to the Che  [\#3119](https://github.com/eclipse/che/issues/3119)
- Access to workspace freezes when loading moderately big maven project [\#3115](https://github.com/eclipse/che/issues/3115)
- Websocket connection fails on workspace  [\#3109](https://github.com/eclipse/che/issues/3109)
- 5.0.0 Milestone Overview [\#3093](https://github.com/eclipse/che/issues/3093)
- machine.getOwner\(\) should return userId and not namespace [\#3042](https://github.com/eclipse/che/issues/3042)
- Eclipse Che CLI Refactoring + Improvements [\#2977](https://github.com/eclipse/che/issues/2977)
- Use base images from eclipse DockerHub organization [\#2942](https://github.com/eclipse/che/issues/2942)
- Better handle "Process Panel" when commands are long [\#2911](https://github.com/eclipse/che/issues/2911)
- Improve "Recent Workspaces" behaviors [\#2908](https://github.com/eclipse/che/issues/2908)
- Wrong hover tooltip behavior [\#2846](https://github.com/eclipse/che/issues/2846)
- The newly created worksapce is not removed on Dashboard [\#2819](https://github.com/eclipse/che/issues/2819)
- Language Server formatting options are hardcoded [\#2728](https://github.com/eclipse/che/issues/2728)
- IDE is trying to get projects while the workspace is not started [\#2629](https://github.com/eclipse/che/issues/2629)
- Project import/creation performance issues [\#2602](https://github.com/eclipse/che/issues/2602)
- Notification pop up message 'Workspace is starting' is duplicated [\#2573](https://github.com/eclipse/che/issues/2573)
- Separate commands execution API from main API [\#1946](https://github.com/eclipse/che/issues/1946)
- Execute commands directly on machine [\#1944](https://github.com/eclipse/che/issues/1944)
- Language Server Protocol: ShowMessage Notification feature [\#1793](https://github.com/eclipse/che/issues/1793)

**Pull requests merged:**

- Avoid NPE in runtime after stopping the workspace [\#3626](https://github.com/eclipse/che/pull/3626) ([vzhukovskii](https://github.com/vzhukovskii))
- Fixed launcher bats tests and minor refactoring of launcher scripts [\#3586](https://github.com/eclipse/che/pull/3586) ([mlabuda](https://github.com/mlabuda))
- Exclude IP addresses from aliased interfaces [\#3582](https://github.com/eclipse/che/pull/3582) ([TylerJewell](https://github.com/TylerJewell))
- CLI - Separate debugging apart from local repo [\#3581](https://github.com/eclipse/che/pull/3581) ([TylerJewell](https://github.com/TylerJewell))
- CHE-3456: add Servers section to machine details [\#3575](https://github.com/eclipse/che/pull/3575) ([akurinnoy](https://github.com/akurinnoy))
- Open docs in new window [\#3560](https://github.com/eclipse/che/pull/3560) ([akurinnoy](https://github.com/akurinnoy))
- fix workspace startup fail on mac [\#3558](https://github.com/eclipse/che/pull/3558) ([riuvshin](https://github.com/riuvshin))
- Minor dockerfiles fixes [\#3555](https://github.com/eclipse/che/pull/3555) ([l0rd](https://github.com/l0rd))
- CHE-3524: change access to docs from dashboard [\#3528](https://github.com/eclipse/che/pull/3528) ([akurinnoy](https://github.com/akurinnoy))
- Temporary remove loader from get tree method [\#3520](https://github.com/eclipse/che/pull/3520) ([vzhukovskii](https://github.com/vzhukovskii))
- Move centos containers pipeline file do dockerfiles folder [\#3509](https://github.com/eclipse/che/pull/3509) ([l0rd](https://github.com/l0rd))
- CODENVY-1224 Make snapshot images use tag field [\#3491](https://github.com/eclipse/che/pull/3491) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Added {% include base.html %} to all markdown.  [\#3490](https://github.com/eclipse/che/pull/3490) ([JamesDrummond](https://github.com/JamesDrummond))
- Improve Che's documentation around configuring Docker [\#3472](https://github.com/eclipse/che/pull/3472) ([TylerJewell](https://github.com/TylerJewell))
- CHE-3438: Reuse shell interpreter passed to command line to start terminal [\#3458](https://github.com/eclipse/che/pull/3458) ([tolusha](https://github.com/tolusha))
- \#2866 fix importing maven project with relative path in modules [\#3457](https://github.com/eclipse/che/pull/3457) ([evidolob](https://github.com/evidolob))
- CODENVY-1337 Logs of workspace containers and agents are not shown when WS starts in IDE [\#3450](https://github.com/eclipse/che/pull/3450) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- Fix disappeared preview url and command line text [\#3449](https://github.com/eclipse/che/pull/3449) ([vzhukovskii](https://github.com/vzhukovskii))
- Revised docker image referenced name from `codenvy/` to `eclipse/` for stacks [\#3448](https://github.com/eclipse/che/pull/3448) ([JamesDrummond](https://github.com/JamesDrummond))
- \[cli\] When starting docker containers, adds the CHE\_\* env variables [\#3446](https://github.com/eclipse/che/pull/3446) ([benoitf](https://github.com/benoitf))
- Add images of docs/ folder using git-lfs [\#3443](https://github.com/eclipse/che/pull/3443) ([benoitf](https://github.com/benoitf))
- Fix documentation typo at Logical Architecture session [\#3441](https://github.com/eclipse/che/pull/3441) ([Fabs](https://github.com/Fabs))
- Fix group id is too big issues [\#3425](https://github.com/eclipse/che/pull/3425) ([vazexqi](https://github.com/vazexqi))
- Improve CLI Boot Speed [\#3424](https://github.com/eclipse/che/pull/3424) ([TylerJewell](https://github.com/TylerJewell))
- CHE-3369 Git history panel is not opened [\#3414](https://github.com/eclipse/che/pull/3414) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- Use of Chefile in new cli : new 'dir' command [\#3413](https://github.com/eclipse/che/pull/3413) ([benoitf](https://github.com/benoitf))
- Add handlers for websocket connection error and closed [\#3410](https://github.com/eclipse/che/pull/3410) ([ashumilova](https://github.com/ashumilova))
- Added documentation.  [\#3407](https://github.com/eclipse/che/pull/3407) ([JamesDrummond](https://github.com/JamesDrummond))
- \[cli\] Compare date but by having a delta of 1hour [\#3404](https://github.com/eclipse/che/pull/3404) ([benoitf](https://github.com/benoitf))
- Update Bitnami stacks to latest minideb version [\#3402](https://github.com/eclipse/che/pull/3402) ([amrecio](https://github.com/amrecio))
- \[dockerfiles\] Fix scripts to be compliant with sh \(and not only bash\) [\#3397](https://github.com/eclipse/che/pull/3397) ([benoitf](https://github.com/benoitf))
- CLI Improvements [\#3394](https://github.com/eclipse/che/pull/3394) ([TylerJewell](https://github.com/TylerJewell))
- CHE-3257: display version number in CHE dashboard from API request [\#3379](https://github.com/eclipse/che/pull/3379) ([ashumilova](https://github.com/ashumilova))
- Pass options and attributes from template model to CreateProjectHandler [\#3375](https://github.com/eclipse/che/pull/3375) ([kaloyan-raev](https://github.com/kaloyan-raev))
- \[cli\] Fix for sync, test, action and ssh commands [\#3373](https://github.com/eclipse/che/pull/3373) ([benoitf](https://github.com/benoitf))
- \[cli\] in development mode, enable debug mode \(it will start Tomcat with jpda\) [\#3371](https://github.com/eclipse/che/pull/3371) ([benoitf](https://github.com/benoitf))
- Machine.getOwner should provide userId and not namespace [\#3366](https://github.com/eclipse/che/pull/3366) ([benoitf](https://github.com/benoitf))
- CHE-3257: display version number in CHE dashboard [\#3365](https://github.com/eclipse/che/pull/3365) ([ashumilova](https://github.com/ashumilova))
- CLI Fixes - Proxy, Native Mode [\#3360](https://github.com/eclipse/che/pull/3360) ([TylerJewell](https://github.com/TylerJewell))
- Cli fixes [\#3357](https://github.com/eclipse/che/pull/3357) ([benoitf](https://github.com/benoitf))
- \[dockerfiles/lib\] Always use -U to be sure to have the latest changes [\#3349](https://github.com/eclipse/che/pull/3349) ([benoitf](https://github.com/benoitf))
- Che 3135: Clean up abandoned docker networks created by CHE [\#3348](https://github.com/eclipse/che/pull/3348) ([mmorhun](https://github.com/mmorhun))
- Fix typescript dto plugin generation [\#3347](https://github.com/eclipse/che/pull/3347) ([benoitf](https://github.com/benoitf))
- CODENVY-1178: Add oAuth1 authentication [\#3329](https://github.com/eclipse/che/pull/3329) ([vinokurig](https://github.com/vinokurig))
- Remove deprecated getPath method and use getLocation instead [\#3322](https://github.com/eclipse/che/pull/3322) ([vzhukovskii](https://github.com/vzhukovskii))
- Deprecate getMediaType method as we don't use media type for any purpose [\#3320](https://github.com/eclipse/che/pull/3320) ([vzhukovskii](https://github.com/vzhukovskii))
- CHE-2977 "move the core Che Dockerfiles and Dockerfile.centos into /dockerfiles/che [\#3318](https://github.com/eclipse/che/pull/3318) ([benoitf](https://github.com/benoitf))
- Che CLI Improvements [\#3301](https://github.com/eclipse/che/pull/3301) ([TylerJewell](https://github.com/TylerJewell))
- Remove redundant info log call [\#3296](https://github.com/eclipse/che/pull/3296) ([vzhukovskii](https://github.com/vzhukovskii))
- CHE-3175: close all editors on WS stop event [\#3291](https://github.com/eclipse/che/pull/3291) ([vparfonov](https://github.com/vparfonov))
- CHE-2908 improve filter for recent workspaces [\#3286](https://github.com/eclipse/che/pull/3286) ([olexii4](https://github.com/olexii4))
- \#2353 fix style to prevent line wrap in terminal [\#3284](https://github.com/eclipse/che/pull/3284) ([evidolob](https://github.com/evidolob))
- CHE-3199: add cpu limits configuration [\#3278](https://github.com/eclipse/che/pull/3278) ([garagatyi](https://github.com/garagatyi))
- Add "Run/Debug PHP script" commands to the PHP and Zend stacks [\#3277](https://github.com/eclipse/che/pull/3277) ([kaloyan-raev](https://github.com/kaloyan-raev))
- ARTIK-146. Add ability to suspend gdb debugger session and breakpoints … [\#3274](https://github.com/eclipse/che/pull/3274) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Make ProjectManager a non-final class [\#3267](https://github.com/eclipse/che/pull/3267) ([tareqhs](https://github.com/tareqhs))
- CHE-3264 - Starting the che server as an user [\#3265](https://github.com/eclipse/che/pull/3265) ([snjeza](https://github.com/snjeza))
- Add ability to reveal resource via native js api call [\#3263](https://github.com/eclipse/che/pull/3263) ([vzhukovskii](https://github.com/vzhukovskii))
- warning: \[MissingOverride\] clone overrides method in Object; expected @Override [\#3261](https://github.com/eclipse/che/pull/3261) ([vzhukovskii](https://github.com/vzhukovskii))
- Dockerfiles directory rename [\#3255](https://github.com/eclipse/che/pull/3255) ([benoitf](https://github.com/benoitf))
- \#2676 use theme color for editor meta tag style [\#3254](https://github.com/eclipse/che/pull/3254) ([evidolob](https://github.com/evidolob))
- \[cli\] add all CHE\_ properties to che.env file at first [\#3246](https://github.com/eclipse/che/pull/3246) ([benoitf](https://github.com/benoitf))
- CHE-3044 Remove temporary workspaces on server shutdown [\#3245](https://github.com/eclipse/che/pull/3245) ([mshaposhnik](https://github.com/mshaposhnik))
- Create ws agent component to initialize resource manager [\#3232](https://github.com/eclipse/che/pull/3232) ([vzhukovskii](https://github.com/vzhukovskii))
- Move eclipse/che-dockerfiles che-\* images to this repository in /dockerfiles [\#3228](https://github.com/eclipse/che/pull/3228) ([benoitf](https://github.com/benoitf))
- Zend Debugger for PHP [\#3202](https://github.com/eclipse/che/pull/3202) ([tolusha](https://github.com/tolusha))
- fix demo-components [\#3191](https://github.com/eclipse/che/pull/3191) ([akurinnoy](https://github.com/akurinnoy))
- CHE-3183: avoid using includes function [\#3188](https://github.com/eclipse/che/pull/3188) ([ashumilova](https://github.com/ashumilova))
- fix workspace-edit-mode-overlay z-index [\#3176](https://github.com/eclipse/che/pull/3176) ([akurinnoy](https://github.com/akurinnoy))
- Define tests phase for dashboard and skip condition [\#3169](https://github.com/eclipse/che/pull/3169) ([ashumilova](https://github.com/ashumilova))
- CHE-2819: fix ability to remove the newly created workspace. [\#3165](https://github.com/eclipse/che/pull/3165) ([akurinnoy](https://github.com/akurinnoy))
- Improve message about unreachable workspace [\#3156](https://github.com/eclipse/che/pull/3156) ([vzhukovskii](https://github.com/vzhukovskii))
- CHE-2463 Improve Panels behaviors in IDE [\#3151](https://github.com/eclipse/che/pull/3151) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- CHE-3129 - Project can't be created without Z option [\#3130](https://github.com/eclipse/che/pull/3130) ([snjeza](https://github.com/snjeza))
- Issue 1793: Language Server Protocol: ShowMessage Notification feature [\#3124](https://github.com/eclipse/che/pull/3124) ([xcoulon](https://github.com/xcoulon))
- \#2972 add empty state widgets for project and editor panels [\#3102](https://github.com/eclipse/che/pull/3102) ([evidolob](https://github.com/evidolob))
- CHE-2816: Fix search text in PHP, HTML and other files  [\#3087](https://github.com/eclipse/che/pull/3087) ([vparfonov](https://github.com/vparfonov))
- CHE-3011. Fix CentOS and RHEL 6 issues [\#3070](https://github.com/eclipse/che/pull/3070) ([eivantsov](https://github.com/eivantsov))
- \#3030 add editor context menu [\#3066](https://github.com/eclipse/che/pull/3066) ([evidolob](https://github.com/evidolob))
- Rework database schema loading [\#3063](https://github.com/eclipse/che/pull/3063) ([evoevodin](https://github.com/evoevodin))
- Fix for using the official mysql image in composite stacks [\#3049](https://github.com/eclipse/che/pull/3049) ([kaloyan-raev](https://github.com/kaloyan-raev))
- CHE-2934: Add 'Link With Editor' action to the Project Explorer [\#3026](https://github.com/eclipse/che/pull/3026) ([svor](https://github.com/svor))
- Improve default services start strategy. [\#3006](https://github.com/eclipse/che/pull/3006) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- CHE-1661: Fix deletion of ssh key by name with slash [\#3000](https://github.com/eclipse/che/pull/3000) ([vinokurig](https://github.com/vinokurig))
- Update the name, descriptions of agents [\#2994](https://github.com/eclipse/che/pull/2994) ([benoitf](https://github.com/benoitf))
- Introduced PlatformIO stack with couple of samples [\#2887](https://github.com/eclipse/che/pull/2887) ([skabashnyuk](https://github.com/skabashnyuk))
- \#2459 store and restore IDE state: opened files, opened part and their size [\#2880](https://github.com/eclipse/che/pull/2880) ([evidolob](https://github.com/evidolob))
- Get projects after workspace has been already initialized [\#2867](https://github.com/eclipse/che/pull/2867) ([vzhukovskii](https://github.com/vzhukovskii))
- CHE-2816. Correctly applying exclude filters at indexing files [\#2857](https://github.com/eclipse/che/pull/2857) ([RomanNikitenko](https://github.com/RomanNikitenko))
- Render hover messages according to LSP specification [\#2856](https://github.com/eclipse/che/pull/2856) ([kaloyan-raev](https://github.com/kaloyan-raev))
- Replace Crane with felixfbecker PHP Language Server [\#2830](https://github.com/eclipse/che/pull/2830) ([kaloyan-raev](https://github.com/kaloyan-raev))
- Make arduino files looks like C++ files [\#2772](https://github.com/eclipse/che/pull/2772) ([skabashnyuk](https://github.com/skabashnyuk))
- CHE-2456: Svn switch action [\#2758](https://github.com/eclipse/che/pull/2758) ([tolusha](https://github.com/tolusha))
- Fixes \#2437: Apply multi-edit formatting without messing up the document [\#2719](https://github.com/eclipse/che/pull/2719) ([kaloyan-raev](https://github.com/kaloyan-raev))
- Add some files generated by m2e to .gitignore [\#2705](https://github.com/eclipse/che/pull/2705) ([kaloyan-raev](https://github.com/kaloyan-raev))
- CHE-1756 Add ability to download workspace starting outputs from IDE loader [\#2686](https://github.com/eclipse/che/pull/2686) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- Remove workspace name from model [\#2652](https://github.com/eclipse/che/pull/2652) ([evoevodin](https://github.com/evoevodin))
- CHE-2214 NodeJs Debugger [\#2625](https://github.com/eclipse/che/pull/2625) ([tolusha](https://github.com/tolusha))
- Auto create files with hello world content when creating C, C++, and P… [\#2600](https://github.com/eclipse/che/pull/2600) ([eivantsov](https://github.com/eivantsov))
- Fix the parent pom version [\#2564](https://github.com/eclipse/che/pull/2564) ([benoitf](https://github.com/benoitf))
- CHE-1761 Improve wizard to restart workspace [\#2542](https://github.com/eclipse/che/pull/2542) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- InitializeParams should include an empty ClientCapabilities [\#2466](https://github.com/eclipse/che/pull/2466) ([kaloyan-raev](https://github.com/kaloyan-raev))
- CHE-1857: add ability to rename projects [\#2436](https://github.com/eclipse/che/pull/2436) ([svor](https://github.com/svor))
- Updating dashboard README.MD [\#2420](https://github.com/eclipse/che/pull/2420) ([ibuziuk](https://github.com/ibuziuk))
- CHE-2344: Fixes repetitive saving snapshot of workspace [\#2413](https://github.com/eclipse/che/pull/2413) ([garagatyi](https://github.com/garagatyi))
- Syntax coloration to machine outputs [\#2407](https://github.com/eclipse/che/pull/2407) ([vzhukovskii](https://github.com/vzhukovskii))
- CHE-1758 Display loading steps when booting ws from IDE [\#2352](https://github.com/eclipse/che/pull/2352) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- CHE-1900: Update editor to Orion 12 [\#2351](https://github.com/eclipse/che/pull/2351) ([azatsarynnyy](https://github.com/azatsarynnyy))
- CHE-2336: add an action for downloading all projects from the ws [\#2347](https://github.com/eclipse/che/pull/2347) ([svor](https://github.com/svor))
- CHE-2324: Avoid duplicate call new terminal for dev machine [\#2341](https://github.com/eclipse/che/pull/2341) ([vparfonov](https://github.com/vparfonov))
- change basic measurement unit for RAM after model changed [\#2340](https://github.com/eclipse/che/pull/2340) ([olexii4](https://github.com/olexii4))
- Fix a bug with "Find Action" window [\#2334](https://github.com/eclipse/che/pull/2334) ([svor](https://github.com/svor))
- Provide protocol into server based macro [\#2296](https://github.com/eclipse/che/pull/2296) ([vzhukovskii](https://github.com/vzhukovskii))
- Register macro to provide workspace name [\#2294](https://github.com/eclipse/che/pull/2294) ([vzhukovskii](https://github.com/vzhukovskii))
- Enable syntax highlighting for \*.phtml files [\#2263](https://github.com/eclipse/che/pull/2263) ([mniewrzal](https://github.com/mniewrzal))
- CODENVY-106: remove related widgets when the machine was destroyed [\#2250](https://github.com/eclipse/che/pull/2250) ([svor](https://github.com/svor))
- CHE-1485 allow special characters in file names and folder names + fix an encoding issue [\#2176](https://github.com/eclipse/che/pull/2176) ([Leward](https://github.com/Leward))
- Basic PHP plugin [\#2160](https://github.com/eclipse/che/pull/2160) ([kaloyan-raev](https://github.com/kaloyan-raev))
- Add support for Git Log API. [\#2046](https://github.com/eclipse/che/pull/2046) ([ShimonBenYair](https://github.com/ShimonBenYair))
- Allow character based key bindings  [\#1571](https://github.com/eclipse/che/pull/1571) ([AlexTugarev](https://github.com/AlexTugarev))

## [5.0.0-M9](https://github.com/eclipse/che/tree/5.0.0-M9) (2016-12-22)
[Full Changelog](https://github.com/eclipse/che/compare/5.0.0-M8...5.0.0-M9)

**Issues with no labels:**

- What's the proper way for a workspace `dev-machine` to connect to the docker daemon? [\#3462](https://github.com/eclipse/che/issues/3462)
- "Reading Project Structure" popup long and painful [\#3444](https://github.com/eclipse/che/issues/3444)
- Configuration reset always [\#3422](https://github.com/eclipse/che/issues/3422)
- "group id ... is too big" on exec-agent module on Mac [\#3378](https://github.com/eclipse/che/issues/3378)
- Permission denied for che-websocket-terminal after building Che on Windows [\#3374](https://github.com/eclipse/che/issues/3374)
- Workspace doesn't start on Che running on Amazon EC2 instance using remote browser [\#3361](https://github.com/eclipse/che/issues/3361)
- Workspaces disappear from interface after a stop/crash  [\#3352](https://github.com/eclipse/che/issues/3352)
- server and clent interaction [\#3346](https://github.com/eclipse/che/issues/3346)
- sample-json-plugin doesn't appear in IDE [\#3338](https://github.com/eclipse/che/issues/3338)
- Unable to Build Che [\#3333](https://github.com/eclipse/che/issues/3333)
- Not able to create project [\#3332](https://github.com/eclipse/che/issues/3332)
- artik-ide start and ERROR !!! Error - Docker not installed properly issue [\#3328](https://github.com/eclipse/che/issues/3328)
- how to resume installation after crash [\#3326](https://github.com/eclipse/che/issues/3326)
- Docker CLI Usage Message [\#3316](https://github.com/eclipse/che/issues/3316)
- Workspace agent stopped event doesn't fire when workspace is stopping [\#3313](https://github.com/eclipse/che/issues/3313)
- dashboard fails to compile [\#3312](https://github.com/eclipse/che/issues/3312)
- Eclipse Che extension doesn't get loaded using Docker for Mac [\#3302](https://github.com/eclipse/che/issues/3302)
- Sorry to bother, but I really need help to solve the network problem. [\#3299](https://github.com/eclipse/che/issues/3299)
- Getting Started CHE CLI: che.sh fails to download cli.sh [\#3266](https://github.com/eclipse/che/issues/3266)
- Starting the che server as an user \(implementing the CHE\_USER property\) [\#3264](https://github.com/eclipse/che/issues/3264)
- Extend the Che CLI with http proxy parameters [\#3259](https://github.com/eclipse/che/issues/3259)
- Scroll to botton on Organize imports [\#3220](https://github.com/eclipse/che/issues/3220)
- Investigate usage  xterm.js instead of  old and unsupported  term.js [\#3210](https://github.com/eclipse/che/issues/3210)
- Add configuration of CPU limits in docker machines [\#3199](https://github.com/eclipse/che/issues/3199)
- Properly maximize console and terminal tabs [\#3177](https://github.com/eclipse/che/issues/3177)
- Perform migration of same domain recipe links to the relative form. [\#3004](https://github.com/eclipse/che/issues/3004)
- CHEDIR broken. [\#2925](https://github.com/eclipse/che/issues/2925)
- Wrong message when connection with workspace agent is broken [\#2860](https://github.com/eclipse/che/issues/2860)
- Openshift Plugin Update [\#2834](https://github.com/eclipse/che/issues/2834)
- Usability improvements to che-server container model [\#2755](https://github.com/eclipse/che/issues/2755)
- Rework agents launching SPI [\#2626](https://github.com/eclipse/che/issues/2626)
- Use `volumes-from` when starting a workspace [\#2598](https://github.com/eclipse/che/issues/2598)
- Improve Panels behaviors in IDE [\#2463](https://github.com/eclipse/che/issues/2463)
- Confused behavior when switching to Events area [\#2042](https://github.com/eclipse/che/issues/2042)
- Rework clients to use new command API of new exec agent [\#1947](https://github.com/eclipse/che/issues/1947)
- Adapt clients to use machine API deployed on a separate instance \(remote to the main API\) [\#1945](https://github.com/eclipse/che/issues/1945)
- Create Exec agent [\#1943](https://github.com/eclipse/che/issues/1943)
- Docker launcher related improvements [\#1697](https://github.com/eclipse/che/issues/1697)

## [5.0.0-M8](https://github.com/eclipse/che/tree/5.0.0-M8) (2016-12-07)
[Full Changelog](https://github.com/eclipse/che/compare/5.0.0-M7-artik...5.0.0-M8)

**Issues with no labels:**

- maven-server-impl test fails [\#3295](https://github.com/eclipse/che/issues/3295)
- Fail launching agent Terminal [\#3275](https://github.com/eclipse/che/issues/3275)
- Docs reference image eclipse/che-file which doesn't exist [\#3269](https://github.com/eclipse/che/issues/3269)
- Upload a new version of the PHP Language Server [\#3227](https://github.com/eclipse/che/issues/3227)
- che-sample-plugin-json-ide fails to compile [\#3222](https://github.com/eclipse/che/issues/3222)
- Add Clojure Support [\#3217](https://github.com/eclipse/che/issues/3217)
- Is there any possibility from which we can by pass username and password in eclipse che url? [\#3215](https://github.com/eclipse/che/issues/3215)
- Why is there connections between port 4411 and the host where the web browser is opened?  [\#3211](https://github.com/eclipse/che/issues/3211)
- Test CPU limits with docker and swarm [\#3198](https://github.com/eclipse/che/issues/3198)
- No refresh in project explorer [\#3195](https://github.com/eclipse/che/issues/3195)
- Upload files into workspace? [\#3194](https://github.com/eclipse/che/issues/3194)
- \[Q\] Issue w/ ws-agent creation when creating project. [\#3190](https://github.com/eclipse/che/issues/3190)
- wsagent 4818 Exception sending context initialized event [\#3184](https://github.com/eclipse/che/issues/3184)
- Failed to change port \(regression\) [\#3179](https://github.com/eclipse/che/issues/3179)
- bazel causes workspace agent to stop responding [\#3178](https://github.com/eclipse/che/issues/3178)
- Is there any way in ehich we can install eclipse che on any virtual machine [\#3172](https://github.com/eclipse/che/issues/3172)
- Can CheConf16 recording play? [\#3148](https://github.com/eclipse/che/issues/3148)
- Moderator as a Contributor [\#3147](https://github.com/eclipse/che/issues/3147)
- Need end point to load project from github branch [\#3134](https://github.com/eclipse/che/issues/3134)
- Fail to start workspace agent  [\#3128](https://github.com/eclipse/che/issues/3128)
- Endpoint for create and delete branch in eclipseche--\>git--\>branches [\#3126](https://github.com/eclipse/che/issues/3126)
- Need to push changes to github branch [\#3122](https://github.com/eclipse/che/issues/3122)
- Failed to inject orion editor [\#3118](https://github.com/eclipse/che/issues/3118)
- Cannot create any project in the IDE [\#3114](https://github.com/eclipse/che/issues/3114)
- Does Iresource Model supported in Che? How to achieve Iresource features ? [\#3099](https://github.com/eclipse/che/issues/3099)
- Not able to load eclipse che workspace url in iframe [\#3072](https://github.com/eclipse/che/issues/3072)
- File Sync agent is disabled by default [\#3071](https://github.com/eclipse/che/issues/3071)
- How to run java project in eclipse che [\#3067](https://github.com/eclipse/che/issues/3067)
- Set uncaught exception handler for executors [\#3065](https://github.com/eclipse/che/issues/3065)
- Invalid docker ip address when running by cli [\#3060](https://github.com/eclipse/che/issues/3060)
- Cannot start Eclipse Che using command line tool [\#3058](https://github.com/eclipse/che/issues/3058)
- Are workspaces persistent? [\#3057](https://github.com/eclipse/che/issues/3057)
- Estimate effort to support pull request panel operations with BitBucket \(public and private\) [\#3052](https://github.com/eclipse/che/issues/3052)
- proxying and port exposure.. [\#3037](https://github.com/eclipse/che/issues/3037)
- Add contextual menu associated to right-click action in the editor [\#3030](https://github.com/eclipse/che/issues/3030)
- Wordpress issue www-data:www-data [\#3018](https://github.com/eclipse/che/issues/3018)
- Possibility to develop android with gradle [\#3008](https://github.com/eclipse/che/issues/3008)
- Need to update github url in remotes using swagger [\#2973](https://github.com/eclipse/che/issues/2973)
- Manage empty states in IDE [\#2972](https://github.com/eclipse/che/issues/2972)
- Fail to build che dashboard module using Docker [\#2963](https://github.com/eclipse/che/issues/2963)
- How to change location in origin\(Git--\>Remotes--\>origin\) using curl [\#2951](https://github.com/eclipse/che/issues/2951)
- Can not close Events panel [\#2923](https://github.com/eclipse/che/issues/2923)
- Adding a new project template to custom stack [\#2879](https://github.com/eclipse/che/issues/2879)
- Let users configure the "Z" flag when mouting a volume [\#2874](https://github.com/eclipse/che/issues/2874)
- Wrong behavior of 'get\(\)' method in 'JGitConfigImpl' [\#2870](https://github.com/eclipse/che/issues/2870)
- Cannot build on windows "npm" command not found [\#2858](https://github.com/eclipse/che/issues/2858)
- Overwriting of name of workspace on creation with auto generated value [\#2855](https://github.com/eclipse/che/issues/2855)
- Cordova/Phonegap stacks, templates, and commands [\#2845](https://github.com/eclipse/che/issues/2845)
- maven command does not work [\#2841](https://github.com/eclipse/che/issues/2841)
- Wizard plugin not working [\#2810](https://github.com/eclipse/che/issues/2810)
- Specifying local docker image in stacks.json [\#2806](https://github.com/eclipse/che/issues/2806)
- Compile error  [\#2797](https://github.com/eclipse/che/issues/2797)
- CHE using Docker on Mac with Chrome: Can't load project types: Error at Object.window.IDE.eventHandlers.initializationFailed  [\#2782](https://github.com/eclipse/che/issues/2782)
- Handle DOCKER\_HOST better [\#2754](https://github.com/eclipse/che/issues/2754)
- Local IDE Mount with docker hangs [\#2742](https://github.com/eclipse/che/issues/2742)
- Documentation for Using Che as an IDE - Intellisense [\#2720](https://github.com/eclipse/che/issues/2720)
- Documentation for Workspace Administration - Workspace Agents [\#2718](https://github.com/eclipse/che/issues/2718)
- Documentation for Workspace Administration - Runtime Machines [\#2716](https://github.com/eclipse/che/issues/2716)
- Documentation for Workspace Administration - Runtime Recipes [\#2688](https://github.com/eclipse/che/issues/2688)
- yellow on white hard to read [\#2676](https://github.com/eclipse/che/issues/2676)
- Investigate how to add possibility to limit CPU consumption by containers. [\#2630](https://github.com/eclipse/che/issues/2630)
- Consider Adding Default Profiles for Maven Build [\#2594](https://github.com/eclipse/che/issues/2594)
- How to authenticate against bitbucket? [\#2581](https://github.com/eclipse/che/issues/2581)
- Cannot Paste commands in Command Definition Window [\#2579](https://github.com/eclipse/che/issues/2579)
- Problems with Eclipse Che build. [\#2576](https://github.com/eclipse/che/issues/2576)
- Port Eclipse Che for POWER \(ppc64le\) [\#2510](https://github.com/eclipse/che/issues/2510)
- How would I preview a typical LAMP project? [\#2497](https://github.com/eclipse/che/issues/2497)
- Highlight issue with custom editor and multiple extension file [\#2488](https://github.com/eclipse/che/issues/2488)
- Problem using Bridge Mode for Server and Workspace Containers \(can't use --net=host\) [\#2450](https://github.com/eclipse/che/issues/2450)
- CLI - che mount Fails [\#2442](https://github.com/eclipse/che/issues/2442)
- dotnet workspace can't create donet/c\# project [\#2374](https://github.com/eclipse/che/issues/2374)
- Cannot paste \(Ctrl+V\) into Text Area widget [\#2329](https://github.com/eclipse/che/issues/2329)
- Request: for better UI on IDE especially for terminal  [\#2231](https://github.com/eclipse/che/issues/2231)
- How to integrate Eclipse Che with Perforce or GitSwarm. [\#2201](https://github.com/eclipse/che/issues/2201)
- Preparing a Workspace with a Maven Project [\#2191](https://github.com/eclipse/che/issues/2191)
- Malformed Host Header error on Che startup [\#2124](https://github.com/eclipse/che/issues/2124)
- Orion editor - Highlight issue [\#2078](https://github.com/eclipse/che/issues/2078)
- Improve configurability for third party tools [\#1894](https://github.com/eclipse/che/issues/1894)
- Add third dependency SmartGWT to the che [\#1886](https://github.com/eclipse/che/issues/1886)
- State of the multi-module project is not restored [\#1782](https://github.com/eclipse/che/issues/1782)
- Running workspace results in IOException: Docker image build failed [\#1766](https://github.com/eclipse/che/issues/1766)
- Release and ship CHE 5.0.0-M8 [\#3307](https://github.com/eclipse/che/issues/3307)
- Create GET method to return snapshot configuration [\#3287](https://github.com/eclipse/che/issues/3287)
- Not able to run che with cli [\#3276](https://github.com/eclipse/che/issues/3276)
- Eclipse Che CLI Refactoring + Improvements : phase 1 [\#3229](https://github.com/eclipse/che/issues/3229)
- Import project from dashboard does not work [\#3226](https://github.com/eclipse/che/issues/3226)
- Apaide? Should maybe be Apache? [\#3205](https://github.com/eclipse/che/issues/3205)
- "Restoring project structure..." loader doesn't hide in the workspace without projects. [\#3181](https://github.com/eclipse/che/issues/3181)
- The editor has wrong behavior after restart workspace [\#3175](https://github.com/eclipse/che/issues/3175)
- Workspace does not start from 'Bitnami Codeigniter' stack on dashboard [\#3173](https://github.com/eclipse/che/issues/3173)
- org.eclipse.che.ws-agent should check java version before starting [\#3137](https://github.com/eclipse/che/issues/3137)
- 5.0.0-M8 Milestone Overview [\#3094](https://github.com/eclipse/che/issues/3094)
- Cannot start workspace [\#3062](https://github.com/eclipse/che/issues/3062)
- Remove temporary workspaces on server shutdown [\#3044](https://github.com/eclipse/che/issues/3044)
- Create and edit workspace using raw config [\#3025](https://github.com/eclipse/che/issues/3025)
- The expanded project is collapsed when workspace is restarted \(regression\) [\#3021](https://github.com/eclipse/che/issues/3021)
- Unexpected enabling of the button create workspace [\#3019](https://github.com/eclipse/che/issues/3019)
- Cannot start a workspace from centos:6.6 [\#3011](https://github.com/eclipse/che/issues/3011)
- Cascade deletion of projects with the same storage fails [\#2993](https://github.com/eclipse/che/issues/2993)
- Adding ssh key by OAuth GitHub form does not work [\#2988](https://github.com/eclipse/che/issues/2988)
- REST method for batch creating Projects suitable for both import and generate  [\#2937](https://github.com/eclipse/che/issues/2937)
- Switching editor tabs should move the highlight in the project explorer [\#2934](https://github.com/eclipse/che/issues/2934)
- Docker networks are not deleted when the corresponding workspace is stopped [\#2930](https://github.com/eclipse/che/issues/2930)
- Git history area is not restored after refresh page \(regression\) [\#2924](https://github.com/eclipse/che/issues/2924)
- Use OpenJDK in che-server CentOS Dockerfile [\#2916](https://github.com/eclipse/che/issues/2916)
- can not clone from IP adress in the URL [\#2915](https://github.com/eclipse/che/issues/2915)
- Updating .NET Core Template and Maintainer [\#2862](https://github.com/eclipse/che/issues/2862)
- Find in path does not work [\#2816](https://github.com/eclipse/che/issues/2816)
- Performance issues with code completion [\#2815](https://github.com/eclipse/che/issues/2815)
- Unexpected loss of focus on the project \(regression\) [\#2795](https://github.com/eclipse/che/issues/2795)
- Use relative link to recipe in workspace environment if possible  [\#2769](https://github.com/eclipse/che/issues/2769)
- Implement schema initialization/migration components [\#2768](https://github.com/eclipse/che/issues/2768)
- Unexpected notification about updating a file after refactoring operation \(regression\) [\#2745](https://github.com/eclipse/che/issues/2745)
- Add possibility expand of nodes for a project in the Project tree [\#2724](https://github.com/eclipse/che/issues/2724)
- C\# icon has word "c\#" which makes it seem like a duplicate [\#2614](https://github.com/eclipse/che/issues/2614)
- Improved behavior when selecting stack [\#2568](https://github.com/eclipse/che/issues/2568)
- Rename .codenvy --\> .che [\#2550](https://github.com/eclipse/che/issues/2550)
- Manage stack testing [\#2520](https://github.com/eclipse/che/issues/2520)
- Creating a workspace from definition file doesn't work [\#2489](https://github.com/eclipse/che/issues/2489)
- After adding new subfolder the parent node does not open [\#2439](https://github.com/eclipse/che/issues/2439)
- Wrong synchronization of content in editor after split [\#2391](https://github.com/eclipse/che/issues/2391)
- Not all editor tabs are closed after stopping workspace \(regression\) [\#2372](https://github.com/eclipse/che/issues/2372)
- Java package collapses in explorer after some file move operations \(regression\) [\#2367](https://github.com/eclipse/che/issues/2367)
- command instruction not supported in compose file [\#2365](https://github.com/eclipse/che/issues/2365)
- Chefile Phase 2 [\#2266](https://github.com/eclipse/che/issues/2266)
- Wrong behavior when refactor rename package [\#1776](https://github.com/eclipse/che/issues/1776)
- Unable to remove SSH key when including invalid characters [\#1661](https://github.com/eclipse/che/issues/1661)
- Terminal doesn't recieve Alt Gr characters [\#671](https://github.com/eclipse/che/issues/671)

**Pull requests merged:**

- RELEASE: set tag versions [\#3306](https://github.com/eclipse/che/pull/3306) ([riuvshin](https://github.com/riuvshin))
- Start eclipse/che-server docker image as root by default [\#3297](https://github.com/eclipse/che/pull/3297) ([benoitf](https://github.com/benoitf))
- fix typo [\#3285](https://github.com/eclipse/che/pull/3285) ([akurinnoy](https://github.com/akurinnoy))
- Send LineConsumerFactory to ProjectManager, improve RequestDispatcher  [\#3240](https://github.com/eclipse/che/pull/3240) ([gazarenkov](https://github.com/gazarenkov))
- Fix ssh client calls for UD and CLI [\#3238](https://github.com/eclipse/che/pull/3238) ([benoitf](https://github.com/benoitf))
- Save state of expanded containers when refactoring operations are performed [\#3231](https://github.com/eclipse/che/pull/3231) ([vzhukovskii](https://github.com/vzhukovskii))
- Fix import projects by URL, from GitHub [\#3225](https://github.com/eclipse/che/pull/3225) ([ashumilova](https://github.com/ashumilova))
- CHE-3175: close all editors on WS stop event [\#3193](https://github.com/eclipse/che/pull/3193) ([vparfonov](https://github.com/vparfonov))
- Set tooltip with refresh description to the correct button [\#3189](https://github.com/eclipse/che/pull/3189) ([vzhukovskii](https://github.com/vzhukovskii))
- Unexpected loss of focus on the project [\#3170](https://github.com/eclipse/che/pull/3170) ([vzhukovskii](https://github.com/vzhukovskii))
- Correct handling parent element during creating new resource [\#3166](https://github.com/eclipse/che/pull/3166) ([vzhukovskii](https://github.com/vzhukovskii))
- Add ability to auto select first node when tree becomes visible and it has at least one node [\#3163](https://github.com/eclipse/che/pull/3163) ([vzhukovskii](https://github.com/vzhukovskii))
- Fix $CHE\_DOCKER\_MACHINE\_HOST\_EXTERNAL variable in docker.sh [\#3158](https://github.com/eclipse/che/pull/3158) ([l0rd](https://github.com/l0rd))
- Performance improvements and other fixes in code completion [\#3146](https://github.com/eclipse/che/pull/3146) ([kaloyan-raev](https://github.com/kaloyan-raev))
- CODENVY-593: fix workspace stopping [\#3133](https://github.com/eclipse/che/pull/3133) ([garagatyi](https://github.com/garagatyi))
- Issue 3029 - Add a 'warning' state for the notifications [\#3113](https://github.com/eclipse/che/pull/3113) ([xcoulon](https://github.com/xcoulon))
- fix position for toolbar buttons [\#3097](https://github.com/eclipse/che/pull/3097) ([olexii4](https://github.com/olexii4))
- CHE-2157: preparation for merge https://github.com/eclipse/che/pull/2157 [\#3095](https://github.com/eclipse/che/pull/3095) ([vparfonov](https://github.com/vparfonov))
- debugger improvement [\#3090](https://github.com/eclipse/che/pull/3090) ([olexii4](https://github.com/olexii4))
- Calculate common path for several paths [\#3089](https://github.com/eclipse/che/pull/3089) ([vzhukovskii](https://github.com/vzhukovskii))
- Add hotkey for expand/collapse project tree [\#3083](https://github.com/eclipse/che/pull/3083) ([vzhukovskii](https://github.com/vzhukovskii))
- Introduced after user remove event [\#3056](https://github.com/eclipse/che/pull/3056) ([skabashnyuk](https://github.com/skabashnyuk))
- Update Bitnami stacks to latest versions [\#3051](https://github.com/eclipse/che/pull/3051) ([amrecio](https://github.com/amrecio))
- CHE-2520: add stack testing widget [\#3050](https://github.com/eclipse/che/pull/3050) ([olexii4](https://github.com/olexii4))
- Improve workspace creating flow [\#3028](https://github.com/eclipse/che/pull/3028) ([akurinnoy](https://github.com/akurinnoy))
- Make it possible to use relative links to recipe in workspace environment [\#3002](https://github.com/eclipse/che/pull/3002) ([mshaposhnik](https://github.com/mshaposhnik))
- CODENVY-1076: Fix URL provided by Project API [\#2989](https://github.com/eclipse/che/pull/2989) ([vparfonov](https://github.com/vparfonov))
- CHE-2874 Let users configure the 'Z' flag when mouting a volume [\#2921](https://github.com/eclipse/che/pull/2921) ([snjeza](https://github.com/snjeza))
- che\#2550: replaced .codenvy folder to .che [\#2919](https://github.com/eclipse/che/pull/2919) ([vparfonov](https://github.com/vparfonov))
- CHE-2365: Add deserializer for 'command' field ComposeServiceImpl. [\#2807](https://github.com/eclipse/che/pull/2807) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- CODENVY-587: Handle closed consumers in composite line comsumer [\#2549](https://github.com/eclipse/che/pull/2549) ([mmorhun](https://github.com/mmorhun))

## [5.0.0-M7-artik](https://github.com/eclipse/che/tree/5.0.0-M7-artik) (2016-11-11)
[Full Changelog](https://github.com/eclipse/che/compare/5.0.0-M7...5.0.0-M7-artik)

**Issues with no labels:**

- Endpoint for removing origin in eclipse che [\#3047](https://github.com/eclipse/che/issues/3047)
- Dockerfile for the codenvy/mysql image? [\#2991](https://github.com/eclipse/che/issues/2991)

## [5.0.0-M7](https://github.com/eclipse/che/tree/5.0.0-M7) (2016-11-10)
[Full Changelog](https://github.com/eclipse/che/compare/5.0.0-M6...5.0.0-M7)

**Issues with no labels:**

- Wrong tooltip in  Project Explorer [\#3040](https://github.com/eclipse/che/issues/3040)
- The button "save" and "cancel" in Debug Configuration window always in disabled status. [\#3039](https://github.com/eclipse/che/issues/3039)
- Customizing dashboard [\#3016](https://github.com/eclipse/che/issues/3016)
- Command Editor - Ability to get list of macros [\#2998](https://github.com/eclipse/che/issues/2998)
- Eclipse Che install is a disaster [\#2965](https://github.com/eclipse/che/issues/2965)
- Feature Request : Environmental Variables in main project / app container. [\#2954](https://github.com/eclipse/che/issues/2954)
- Error starting workspace [\#2952](https://github.com/eclipse/che/issues/2952)
- Cannot create a workspace on codenvy-stg.com host from dashboard [\#2948](https://github.com/eclipse/che/issues/2948)
- WS Fails Creation - Zombie Docker Networks [\#2945](https://github.com/eclipse/che/issues/2945)
- Che launcher is not working if CHE\_VERSION is not set to 'nightly' [\#2943](https://github.com/eclipse/che/issues/2943)
- Processes panel's size is not restored after refresh page [\#2926](https://github.com/eclipse/che/issues/2926)
- This Linux user is not in 'docker' group [\#2922](https://github.com/eclipse/che/issues/2922)
- Small question: what is inside eclipse/che:latest - where to find the dockerfile? [\#2917](https://github.com/eclipse/che/issues/2917)
- On Mac, Running che command throws error `/usr/local/bin/che: line 165: init\_global\_variables: command not found` [\#2890](https://github.com/eclipse/che/issues/2890)
- Unable to connect to Analytics host on install.codenevycorp.com [\#2889](https://github.com/eclipse/che/issues/2889)
- Project is still displayed after deleting on dashboard \(regression\) [\#2878](https://github.com/eclipse/che/issues/2878)
- SVN UI - Commands Run via Java Implementation [\#2863](https://github.com/eclipse/che/issues/2863)
- Add ability to add and remove machines to workspace environment [\#2825](https://github.com/eclipse/che/issues/2825)
- Sometimes, commands are not added correctly on workspace creation from stack [\#2680](https://github.com/eclipse/che/issues/2680)
- Could not load \[org.h2.mvstore.MV Store$2\] [\#2663](https://github.com/eclipse/che/issues/2663)
- Status of workspace displayed incorrectly on the navbar panel after creating snapshot [\#2622](https://github.com/eclipse/che/issues/2622)
- json structure to create dot net project in eclipse che workspace [\#2493](https://github.com/eclipse/che/issues/2493)
- IDE should remember previous state of project tree, files open, panels open, terminals open [\#2459](https://github.com/eclipse/che/issues/2459)
- UD not updated properly when ws stopped under certain conditions [\#2457](https://github.com/eclipse/che/issues/2457)
- Configuring of named variable with underscore in name doesn't work if it was set using environment variables [\#2454](https://github.com/eclipse/che/issues/2454)
- Show/Hide Hidden Files feature works wrong [\#2415](https://github.com/eclipse/che/issues/2415)
- Provide automation for Json Rpc request/response processing [\#2147](https://github.com/eclipse/che/issues/2147)
- Simplify usage of Json Rpc related components [\#2145](https://github.com/eclipse/che/issues/2145)
- Wrong behaviour of modal windows if workspace start fails [\#2089](https://github.com/eclipse/che/issues/2089)
- The sub-modules are not configured as project after recursive import [\#2056](https://github.com/eclipse/che/issues/2056)
- Properly handle situations when a ws agent is killed by OOM [\#1988](https://github.com/eclipse/che/issues/1988)
- Ws-agent has stopped in some case [\#1817](https://github.com/eclipse/che/issues/1817)
- Workspace creation/edit view recasting and extending with new item [\#1767](https://github.com/eclipse/che/issues/1767)
- Release and ship Che 5.0.0-M7 [\#3043](https://github.com/eclipse/che/issues/3043)
- Windows boot2docker fails starting new che-server under certain conditions [\#3024](https://github.com/eclipse/che/issues/3024)
- Wrong behavior of panel 'Processes' after refresh \(regression\) [\#3001](https://github.com/eclipse/che/issues/3001)
- A lot of space is used for empty panel [\#2987](https://github.com/eclipse/che/issues/2987)
- Predefined commands do not appear in the command widget \(regression\) [\#2984](https://github.com/eclipse/che/issues/2984)
- Terminal is not available after restart workspace \(regression\) [\#2983](https://github.com/eclipse/che/issues/2983)
- Multi-Machine Workspace creation [\#2979](https://github.com/eclipse/che/issues/2979)
- Cannot save previewURL into a command \(regression\) [\#2966](https://github.com/eclipse/che/issues/2966)
-  OAuth protocol from github does not work [\#2944](https://github.com/eclipse/che/issues/2944)
- fix usage of CHE\_DATA in Che Server [\#2941](https://github.com/eclipse/che/issues/2941)
- 5.0.0-M7 Milestone Plan [\#2935](https://github.com/eclipse/che/issues/2935)
- Detect and stop/remove Machines not counted by API \(regression\) [\#2927](https://github.com/eclipse/che/issues/2927)
- Incorrect alignements in Stack screen [\#2893](https://github.com/eclipse/che/issues/2893)
- The number of machines is not correctly displayed in the tree if you add workspace using URL [\#2892](https://github.com/eclipse/che/issues/2892)
- Latest X\>5 che-pullrequests-build failed due to git tests [\#2888](https://github.com/eclipse/che/issues/2888)
- Samples configuration improvements [\#2883](https://github.com/eclipse/che/issues/2883)
- File watchers don't always work as expected [\#2876](https://github.com/eclipse/che/issues/2876)
- Add servers to Agent description and propagate them to Workspace Runtime [\#2832](https://github.com/eclipse/che/issues/2832)
- Make agents list fit the styles of other lists in machine's section [\#2824](https://github.com/eclipse/che/issues/2824)
- "No workspace selected. Unable to open IDE" displayed while opening the IDE [\#2820](https://github.com/eclipse/che/issues/2820)
- Che launcher: not clear error message [\#2777](https://github.com/eclipse/che/issues/2777)
- Wrong behavior with stack bulk operation [\#2727](https://github.com/eclipse/che/issues/2727)
- Improve selected state in textfield for dark theme [\#2689](https://github.com/eclipse/che/issues/2689)
- Compose Syntax Links Not Working. [\#2687](https://github.com/eclipse/che/issues/2687)
- Remove UD notification when workspace is created [\#2627](https://github.com/eclipse/che/issues/2627)
- Array format unsupported for environment in compose file [\#2624](https://github.com/eclipse/che/issues/2624)
- Display raw JSON configuration of the stack [\#2519](https://github.com/eclipse/che/issues/2519)
- Add ability to define stack's components [\#2517](https://github.com/eclipse/che/issues/2517)
- Add ability to set stack's category \(advanced, general\) [\#2516](https://github.com/eclipse/che/issues/2516)
- Add ability to configure machines inside stack definition [\#2515](https://github.com/eclipse/che/issues/2515)
- User Workspace SSH Improvements [\#2059](https://github.com/eclipse/che/issues/2059)
- Simplify names of che.properties to be user friendly [\#2015](https://github.com/eclipse/che/issues/2015)
- Remove workspace id from websocket connection path to master [\#1787](https://github.com/eclipse/che/issues/1787)

**Pull requests merged:**

- Change ssh text displayed in the IDE [\#3045](https://github.com/eclipse/che/pull/3045) ([benoitf](https://github.com/benoitf))
- CODENVY-804 : Use of userManager to get the userId \(when injecting ssh keys\) [\#3036](https://github.com/eclipse/che/pull/3036) ([benoitf](https://github.com/benoitf))
- cli: che ssh and che mount commands [\#3033](https://github.com/eclipse/che/pull/3033) ([benoitf](https://github.com/benoitf))
- Revert changes after \#2867 [\#3015](https://github.com/eclipse/che/pull/3015) ([vzhukovskii](https://github.com/vzhukovskii))
- CHE-2979: fix display machines name in RAM widget [\#3009](https://github.com/eclipse/che/pull/3009) ([ashumilova](https://github.com/ashumilova))
- Contribute PatternFly starter template [\#2990](https://github.com/eclipse/che/pull/2990) ([dgutride](https://github.com/dgutride))
- CHE-2059 Add ssh view for workspace in UD [\#2980](https://github.com/eclipse/che/pull/2980) ([benoitf](https://github.com/benoitf))
- CHE-2059 Add unison agent for che-mount utility [\#2978](https://github.com/eclipse/che/pull/2978) ([benoitf](https://github.com/benoitf))
- Fix links for websockets [\#2964](https://github.com/eclipse/che/pull/2964) ([benoitf](https://github.com/benoitf))
- CHE-2820: Don't show "No workpsace selected" message when IDE is loading [\#2957](https://github.com/eclipse/che/pull/2957) ([akurinnoy](https://github.com/akurinnoy))
- CHE-2824: fix agents list [\#2956](https://github.com/eclipse/che/pull/2956) ([akurinnoy](https://github.com/akurinnoy))
- CHE-2059 : Each time a workspace is created, register/associate ssh key [\#2949](https://github.com/eclipse/che/pull/2949) ([benoitf](https://github.com/benoitf))
- CODENVY-1007: add erb extension support as ruby template [\#2947](https://github.com/eclipse/che/pull/2947) ([ashumilova](https://github.com/ashumilova))
- Resolve project type after adding all commands [\#2928](https://github.com/eclipse/che/pull/2928) ([kaloyan-raev](https://github.com/kaloyan-raev))
- Introduces changes needed to be used by teams in codenvy [\#2918](https://github.com/eclipse/che/pull/2918) ([ashumilova](https://github.com/ashumilova))
- \#2059 SSH improvement : whenever as a user I open up the SSH panel, i… [\#2903](https://github.com/eclipse/che/pull/2903) ([benoitf](https://github.com/benoitf))
- Suppress talkative log output [\#2896](https://github.com/eclipse/che/pull/2896) ([skabashnyuk](https://github.com/skabashnyuk))
- Add SNAPSHOTTING status tracking and remove obvious notifications [\#2875](https://github.com/eclipse/che/pull/2875) ([ashumilova](https://github.com/ashumilova))
- CHE-2654: Changing Agent REST API \(adding 'id' and 'description' fiel… [\#2861](https://github.com/eclipse/che/pull/2861) ([ibuziuk](https://github.com/ibuziuk))
- Upgrade gulp-stylus version [\#2814](https://github.com/eclipse/che/pull/2814) ([akervern](https://github.com/akervern))
- Simplify Tomcat che.sh bootsrap script [\#2786](https://github.com/eclipse/che/pull/2786) ([TylerJewell](https://github.com/TylerJewell))
- Fixes \#2728: Respect user settings when sending formatting options to LS [\#2735](https://github.com/eclipse/che/pull/2735) ([kaloyan-raev](https://github.com/kaloyan-raev))
- Add ability to configure machines inside stack definition \[CHE-2515\] [\#2734](https://github.com/eclipse/che/pull/2734) ([olexii4](https://github.com/olexii4))
- CHE-2015 Rename configuration properties [\#2707](https://github.com/eclipse/che/pull/2707) ([mkuznyetsov](https://github.com/mkuznyetsov))
- CHE-2454: add replacing of double underscores [\#2664](https://github.com/eclipse/che/pull/2664) ([garagatyi](https://github.com/garagatyi))

## [5.0.0-M6](https://github.com/eclipse/che/tree/5.0.0-M6) (2016-10-26)
[Full Changelog](https://github.com/eclipse/che/compare/5.0.0-M5...5.0.0-M6)

**Issues with no labels:**

- che.sh + docker: IPs and ws-agent timeouts [\#2864](https://github.com/eclipse/che/issues/2864)
- Where to specify credentials for subversion [\#2852](https://github.com/eclipse/che/issues/2852)
- The eclipse che can't start a workspace [\#2851](https://github.com/eclipse/che/issues/2851)
- The eclipse che can't start a workspace [\#2849](https://github.com/eclipse/che/issues/2849)
- There is no modelling tool on Eclipse Che [\#2844](https://github.com/eclipse/che/issues/2844)
- Error while creating java project [\#2839](https://github.com/eclipse/che/issues/2839)
- Documentation Feedback [\#2828](https://github.com/eclipse/che/issues/2828)
- How To Start many che instances on same machine [\#2821](https://github.com/eclipse/che/issues/2821)
- Service owned by current user [\#2818](https://github.com/eclipse/che/issues/2818)
- Maven modules not recognized [\#2805](https://github.com/eclipse/che/issues/2805)
- Che Mount - Accept Unison Profiles [\#2791](https://github.com/eclipse/che/issues/2791)
- Github oauth uploaded ssh key worked, terminal not using it [\#2789](https://github.com/eclipse/che/issues/2789)
- Hello World Extension Not Working [\#2784](https://github.com/eclipse/che/issues/2784)
- Command editor should allow multi-line commands to be typed without using && [\#2780](https://github.com/eclipse/che/issues/2780)
- Docker Launcher: Versions and Nightly Builds doesn't work [\#2776](https://github.com/eclipse/che/issues/2776)
- Error "Certificates are required for https connection" in Eclipse Che  [\#2774](https://github.com/eclipse/che/issues/2774)
- Commands don't work in workspaces which were created from Bitnami stack \[Regression\] [\#2764](https://github.com/eclipse/che/issues/2764)
- Documentation - Adding Terms to Glossary [\#2762](https://github.com/eclipse/che/issues/2762)
- Creating a new machine in the machine perspective doesn't appear in project perspective \(regression\) [\#2759](https://github.com/eclipse/che/issues/2759)
- Special characters not working in workspace terminal [\#2752](https://github.com/eclipse/che/issues/2752)
- Persisting workspaces on Dockerized Che [\#2741](https://github.com/eclipse/che/issues/2741)
- Build assembly-ide-war failed on Window7 [\#2739](https://github.com/eclipse/che/issues/2739)
- Documentation - Che Compose build.context for Private Repo [\#2738](https://github.com/eclipse/che/issues/2738)
- How to configure Che when workspaces + browser are on different networks [\#2736](https://github.com/eclipse/che/issues/2736)
- File is opening with error [\#2729](https://github.com/eclipse/che/issues/2729)
- Language Server integration should respect empty LS capabilities  [\#2695](https://github.com/eclipse/che/issues/2695)
- Add the way to figure out that workspace is currently snapshotting [\#2683](https://github.com/eclipse/che/issues/2683)
- Ubuntu 16.04 unable to install Eclipse [\#2621](https://github.com/eclipse/che/issues/2621)
- Unexpected rewriting content of stack after renaming [\#2603](https://github.com/eclipse/che/issues/2603)
- Eclipse Che Extension : Sample hello-world extension project Run issue  [\#2583](https://github.com/eclipse/che/issues/2583)
- Question: Running Che on Mesos [\#2536](https://github.com/eclipse/che/issues/2536)
- Docker Store - Common Vulnerabilities and Exposures\(Docker Image\) [\#2534](https://github.com/eclipse/che/issues/2534)
- Wrong behavior after delete project on dashboard [\#2527](https://github.com/eclipse/che/issues/2527)
- Data type mismatch in JpaUserDao\#getAll\(\) method [\#2524](https://github.com/eclipse/che/issues/2524)
- Iterative improvements to simplify usage of che in che scenarios [\#2116](https://github.com/eclipse/che/issues/2116)
- Study Initial schema generation and how to make changes in model after migration to single database [\#2110](https://github.com/eclipse/che/issues/2110)
- Wrong behavior while creating project from maven archetype [\#2098](https://github.com/eclipse/che/issues/2098)
- Wrong behavior after rename not java files [\#1821](https://github.com/eclipse/che/issues/1821)
- Release and ship Che 5.0.0-M6 [\#2891](https://github.com/eclipse/che/issues/2891)
- Some commands that have worked through bash shell, can work wrong \(regression\) [\#2811](https://github.com/eclipse/che/issues/2811)
- Unexpected error message 'Machine id' not found after refreshing a browser \(regression\) [\#2794](https://github.com/eclipse/che/issues/2794)
- Amount of machines is not correctly displayed in process tree \[Regression\] [\#2775](https://github.com/eclipse/che/issues/2775)
- 5.0.0-M6 Milestone Plan [\#2740](https://github.com/eclipse/che/issues/2740)
- Implement args syntax of build section in compose environment [\#2661](https://github.com/eclipse/che/issues/2661)
- Documentation for Workspace Administration - Intro [\#2659](https://github.com/eclipse/che/issues/2659)
- Leak of open file descriptors [\#2633](https://github.com/eclipse/che/issues/2633)
- Docker Store - Common Vulnerabilities and Exposures\(Che's Binary\)  [\#2533](https://github.com/eclipse/che/issues/2533)
- Do not try to connect to terminal if terminal agent not found in machine config [\#2472](https://github.com/eclipse/che/issues/2472)
- Send schema associations to JSON language server [\#2471](https://github.com/eclipse/che/issues/2471)
- Dev agent is not deployed to all machines [\#2467](https://github.com/eclipse/che/issues/2467)
- svn switch missing from svn menu [\#2456](https://github.com/eclipse/che/issues/2456)
- Stop workspaces before user removal [\#2438](https://github.com/eclipse/che/issues/2438)
- Projects are not removed after deleting a workspace [\#2435](https://github.com/eclipse/che/issues/2435)
- Notify a user when he loses connection with Workspace Agent [\#2369](https://github.com/eclipse/che/issues/2369)
- Wrong behavior after run command 'Delete' in Subversion plugin [\#2350](https://github.com/eclipse/che/issues/2350)
- Improved tabbed editor design [\#1841](https://github.com/eclipse/che/issues/1841)
- Make workspace creation and edit screens identical [\#1769](https://github.com/eclipse/che/issues/1769)
- Update JsonExampleEditorProvider Code Example [\#1622](https://github.com/eclipse/che/issues/1622)
- Closing the ws-machine SSH console produce zombies [\#1518](https://github.com/eclipse/che/issues/1518)
- Maven pom.xml and project configuration are not synced [\#942](https://github.com/eclipse/che/issues/942)

**Pull requests merged:**

- CHE-2848: Removing "skip-validate-sources" from "fast" maven profile [\#2853](https://github.com/eclipse/che/pull/2853) ([ibuziuk](https://github.com/ibuziuk))
- CHE-2811 Launch all user commands by using bash if shell is not defined. [\#2838](https://github.com/eclipse/che/pull/2838) ([benoitf](https://github.com/benoitf))
- Fix git config test failure [\#2836](https://github.com/eclipse/che/pull/2836) ([amisevsk](https://github.com/amisevsk))
- Add sample actions plugin contributed by EclipseSource [\#2799](https://github.com/eclipse/che/pull/2799) ([mathansen](https://github.com/mathansen))
- CLI - Add support for unison profiles [\#2790](https://github.com/eclipse/che/pull/2790) ([TylerJewell](https://github.com/TylerJewell))
- Annotation used is not the expected one [\#2757](https://github.com/eclipse/che/pull/2757) ([benoitf](https://github.com/benoitf))
- CODENVY-933: remove snapshot stuff from dashboard [\#2756](https://github.com/eclipse/che/pull/2756) ([ashumilova](https://github.com/ashumilova))
- Fix macro [\#2750](https://github.com/eclipse/che/pull/2750) ([azatsarynnyy](https://github.com/azatsarynnyy))
- Add build args support in compose files \(CHE-2661\) [\#2749](https://github.com/eclipse/che/pull/2749) ([l0rd](https://github.com/l0rd))
- CODENVY-931: add snapshot creating state to workspace status [\#2747](https://github.com/eclipse/che/pull/2747) ([ashumilova](https://github.com/ashumilova))
- Adding 'fast' profile for building Che faster by skipping unit tests,… [\#2733](https://github.com/eclipse/che/pull/2733) ([ibuziuk](https://github.com/ibuziuk))
- Client command framework improvements [\#2730](https://github.com/eclipse/che/pull/2730) ([azatsarynnyy](https://github.com/azatsarynnyy))
- CLI: Add new command - ws - for listing & logs of workspaces [\#2717](https://github.com/eclipse/che/pull/2717) ([TylerJewell](https://github.com/TylerJewell))
- CHE-1769: make workspace creation and edit screen identical. [\#2706](https://github.com/eclipse/che/pull/2706) ([akurinnoy](https://github.com/akurinnoy))
- Allow to use bare "alpine" image [\#2691](https://github.com/eclipse/che/pull/2691) ([benoitf](https://github.com/benoitf))
- Build che server Docker image with CentOS base image [\#2643](https://github.com/eclipse/che/pull/2643) ([dharmit](https://github.com/dharmit))
- Enable PHP and JSON LS agents for all PHP stacks [\#2639](https://github.com/eclipse/che/pull/2639) ([kaloyan-raev](https://github.com/kaloyan-raev))
- CHE-2435: Add component for clean up workspace folder after remove workspace. [\#2544](https://github.com/eclipse/che/pull/2544) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- CHE-2369: add a mechanism which checks state of the ws agent [\#2530](https://github.com/eclipse/che/pull/2530) ([svor](https://github.com/svor))
- Fix \#2471: Send json/schemaAssociations notification [\#2474](https://github.com/eclipse/che/pull/2474) ([kaloyan-raev](https://github.com/kaloyan-raev))
- CHE-1841. Improve tabbed editor design [\#2400](https://github.com/eclipse/che/pull/2400) ([RomanNikitenko](https://github.com/RomanNikitenko))

## [5.0.0-M5](https://github.com/eclipse/che/tree/5.0.0-M5) (2016-10-07)
[Full Changelog](https://github.com/eclipse/che/compare/5.0.0-M4...5.0.0-M5)

**Issues with no labels:**

- can not find or open /mnt/che/lib/ws-agent.zip [\#2701](https://github.com/eclipse/che/issues/2701)
- Support remote Docker by IP [\#2693](https://github.com/eclipse/che/issues/2693)
- \[Q\] Why two versions of che.sh available? [\#2675](https://github.com/eclipse/che/issues/2675)
- Default Stacks Do Not Reference Minimal Base Images. [\#2671](https://github.com/eclipse/che/issues/2671)
- Code completion for PHP [\#2666](https://github.com/eclipse/che/issues/2666)
- Import an existing workspace [\#2660](https://github.com/eclipse/che/issues/2660)
- Recently created workspaces are lost when machine is drastically closed [\#2655](https://github.com/eclipse/che/issues/2655)
- Not possible to input '{' in the editor [\#2649](https://github.com/eclipse/che/issues/2649)
- Cover by selenium test GWT SDM for Che [\#2635](https://github.com/eclipse/che/issues/2635)
- Eclipse Che on Windows 8.1 [\#2620](https://github.com/eclipse/che/issues/2620)
- Editor does not filter code completion proposals from language server [\#2592](https://github.com/eclipse/che/issues/2592)
- Workspace creation error: 404 No such file or directory [\#2565](https://github.com/eclipse/che/issues/2565)
- Language server module refactoring [\#2552](https://github.com/eclipse/che/issues/2552)
- Rename of workspace prevent its start [\#2538](https://github.com/eclipse/che/issues/2538)
- Formatting the whole document makes a big mess [\#2437](https://github.com/eclipse/che/issues/2437)
- Remove WorkspaceHooks interface [\#1939](https://github.com/eclipse/che/issues/1939)
- Simplify transition between dashboard and IDE [\#1743](https://github.com/eclipse/che/issues/1743)
- Release and ship Che 5.0.0-M5 [\#2731](https://github.com/eclipse/che/issues/2731)
- Terminal wasn't opened after restart workspace \(regression\) [\#2702](https://github.com/eclipse/che/issues/2702)
- Remote build context in compose file fails when using a git repo rather than a direct link to a Dockerfile [\#2684](https://github.com/eclipse/che/issues/2684)
- Updated getting started for Java/Maven [\#2674](https://github.com/eclipse/che/issues/2674)
- Updated introduction for Che docs [\#2673](https://github.com/eclipse/che/issues/2673)
- Workspace configurations are not saved on Che server restart. [\#2670](https://github.com/eclipse/che/issues/2670)
- Documentation for Workspace Administration - Runtime Stacks [\#2662](https://github.com/eclipse/che/issues/2662)
- Git checkout with start point is not working [\#2618](https://github.com/eclipse/che/issues/2618)
- Building and skipping tests with default maven goal is failing [\#2610](https://github.com/eclipse/che/issues/2610)
- Running npm commands freeze the IDE [\#2608](https://github.com/eclipse/che/issues/2608)
- After trying to delete predefined stack - message is not clear [\#2593](https://github.com/eclipse/che/issues/2593)
- Add Doc About Workspace Sharing [\#2557](https://github.com/eclipse/che/issues/2557)
- Workspace "learn more" link in UD is wrong [\#2551](https://github.com/eclipse/che/issues/2551)
- Add ability to list/edit stack's tags  [\#2518](https://github.com/eclipse/che/issues/2518)
- Improve error handling when read a container logs [\#2498](https://github.com/eclipse/che/issues/2498)
- "undefined" workspace name in modal dialog in case of error of starting workspace in Dashboard [\#2492](https://github.com/eclipse/che/issues/2492)
- Add editing mode in workspace view [\#2478](https://github.com/eclipse/che/issues/2478)
- Workspace name and RAM not respected when importing from workspace definition file [\#2477](https://github.com/eclipse/che/issues/2477)
- Servers in machine config are not applied to runtime after workspace restart [\#2470](https://github.com/eclipse/che/issues/2470)
- Typo in name validation error message [\#2455](https://github.com/eclipse/che/issues/2455)
- Move 'Git' and 'Subversion' menus to the left [\#2447](https://github.com/eclipse/che/issues/2447)
- 5.0.0-M5 Milestone Plan [\#2359](https://github.com/eclipse/che/issues/2359)
- Make username validation to use account name validation [\#2343](https://github.com/eclipse/che/issues/2343)
- Enhance GDB debugger to work with node.js [\#2214](https://github.com/eclipse/che/issues/2214)
- Validate received Stacks [\#2055](https://github.com/eclipse/che/issues/2055)
- Recursive ssh import does not work [\#2045](https://github.com/eclipse/che/issues/2045)
- Do not use machine API for machine handling [\#1929](https://github.com/eclipse/che/issues/1929)
- Rename project doesn't work [\#1857](https://github.com/eclipse/che/issues/1857)
- Add ability to download workspace starting outputs from IDE loader [\#1756](https://github.com/eclipse/che/issues/1756)
- Create a Che-specific loader to replace the vertical bars [\#1754](https://github.com/eclipse/che/issues/1754)
- When browser is resized, the content of the IDE terminal is missing partly [\#642](https://github.com/eclipse/che/issues/642)

**Pull requests merged:**

- Fix default PHP content [\#2721](https://github.com/eclipse/che/pull/2721) ([kaloyan-raev](https://github.com/kaloyan-raev))
- Fix integration tests when uid/gid already exists in docker image for maven typescript generator [\#2711](https://github.com/eclipse/che/pull/2711) ([benoitf](https://github.com/benoitf))
- Add default content for PHP project [\#2710](https://github.com/eclipse/che/pull/2710) ([vparfonov](https://github.com/vparfonov))
- Add new example plugins provided by EclipseSource [\#2704](https://github.com/eclipse/che/pull/2704) ([ashumilova](https://github.com/ashumilova))
- Zend stack and project sample [\#2700](https://github.com/eclipse/che/pull/2700) ([kaloyan-raev](https://github.com/kaloyan-raev))
- Adding Node.js info to the 'Requirements' section of the README.MD [\#2699](https://github.com/eclipse/che/pull/2699) ([ibuziuk](https://github.com/ibuziuk))
- Allow to use -Dmaven.test.skip=true [\#2696](https://github.com/eclipse/che/pull/2696) ([benoitf](https://github.com/benoitf))
- CHE-2593: disable stack deletion if current user is not creator [\#2678](https://github.com/eclipse/che/pull/2678) ([ashumilova](https://github.com/ashumilova))
- CHE-2518: add ability to add/remove stack's tags [\#2668](https://github.com/eclipse/che/pull/2668) ([olexii4](https://github.com/olexii4))
- Adds Chefile mapping so we can have syntax highlighting [\#2657](https://github.com/eclipse/che/pull/2657) ([benoitf](https://github.com/benoitf))
- Fix \#2649 : Allow on Mac to use alt + 5 which is for example used to type { [\#2656](https://github.com/eclipse/che/pull/2656) ([benoitf](https://github.com/benoitf))
- Fix grammar and typo errors [\#2653](https://github.com/eclipse/che/pull/2653) ([ashumilova](https://github.com/ashumilova))
- CHE-2492: fix undefined in error message [\#2648](https://github.com/eclipse/che/pull/2648) ([olexii4](https://github.com/olexii4))
- CODENVY-846: add che-in-che stack only for che assembly [\#2638](https://github.com/eclipse/che/pull/2638) ([ashumilova](https://github.com/ashumilova))
- Improvements on DTO Typescript generator [\#2637](https://github.com/eclipse/che/pull/2637) ([benoitf](https://github.com/benoitf))
- Fix NPE in tests [\#2623](https://github.com/eclipse/che/pull/2623) ([garagatyi](https://github.com/garagatyi))
- CHE-2618 Fix checkout with start point [\#2619](https://github.com/eclipse/che/pull/2619) ([mkuznyetsov](https://github.com/mkuznyetsov))
- CHE-2477 and CHE-2551 [\#2605](https://github.com/eclipse/che/pull/2605) ([ashumilova](https://github.com/ashumilova))
- CHE-1754: improve ide loader [\#2589](https://github.com/eclipse/che/pull/2589) ([olexii4](https://github.com/olexii4))
- improve IDE iframe injection [\#2578](https://github.com/eclipse/che/pull/2578) ([olexii4](https://github.com/olexii4))
- Expose getCurrentBranch\(\) method on git connection + rework gitvalueProviderFactory [\#2569](https://github.com/eclipse/che/pull/2569) ([benoitf](https://github.com/benoitf))
- CHE-2478: add editing mode in workspace view [\#2537](https://github.com/eclipse/che/pull/2537) ([akurinnoy](https://github.com/akurinnoy))
- CHE-2498: Improve error handling when read a container logs [\#2499](https://github.com/eclipse/che/pull/2499) ([mmorhun](https://github.com/mmorhun))
- Add property machine.docker.local\_node\_host.external [\#2402](https://github.com/eclipse/che/pull/2402) ([l0rd](https://github.com/l0rd))

## [5.0.0-M4](https://github.com/eclipse/che/tree/5.0.0-M4) (2016-09-29)
[Full Changelog](https://github.com/eclipse/che/compare/5.0.0-M3...5.0.0-M4)

**Issues with no labels:**

- Cover by selenium tests the Bitnamy stacks from dashboars [\#2636](https://github.com/eclipse/che/issues/2636)
- Editor right click context menu. [\#2634](https://github.com/eclipse/che/issues/2634)
- TODO [\#2586](https://github.com/eclipse/che/issues/2586)
- Console doesn't want to be maximized when IDE is opened in frame [\#2540](https://github.com/eclipse/che/issues/2540)
- Java errors - RHEL 7.2 Maipo  [\#2486](https://github.com/eclipse/che/issues/2486)
- Simplify Stack management and authoring [\#2205](https://github.com/eclipse/che/issues/2205)
- Language Server Protocol: Signature Help feature [\#1801](https://github.com/eclipse/che/issues/1801)
- Loading flow when loading IDE is flickering [\#1752](https://github.com/eclipse/che/issues/1752)
- 5.0.0-M4 Milestone Plan [\#2615](https://github.com/eclipse/che/issues/2615)
- Change JPA mapping for TEXT fields [\#2609](https://github.com/eclipse/che/issues/2609)
- Release and ship Che 5.0.0-M4 [\#2588](https://github.com/eclipse/che/issues/2588)
- CLI Environment Variables [\#2560](https://github.com/eclipse/che/issues/2560)

## [5.0.0-M3](https://github.com/eclipse/che/tree/5.0.0-M3) (2016-09-26)
[Full Changelog](https://github.com/eclipse/che/compare/5.0.0-M2...5.0.0-M3)

**Issues with no labels:**

- Running the docker launcher with MACHINE\_WS\_AGENT\_MAX\_START\_TIME\_MS has no effect [\#2584](https://github.com/eclipse/che/issues/2584)
- How to specify port for previewing Meteor projects [\#2580](https://github.com/eclipse/che/issues/2580)
- Question: Using a Docker insecure registry [\#2563](https://github.com/eclipse/che/issues/2563)
- Create Docker Image to Get CLI [\#2559](https://github.com/eclipse/che/issues/2559)
- Remove Docker Server Mac and Windows Docs [\#2556](https://github.com/eclipse/che/issues/2556)
- Link to 4.7 Release Notes on homepage broken [\#2513](https://github.com/eclipse/che/issues/2513)
- Select and Copy output of Terminal panel [\#2512](https://github.com/eclipse/che/issues/2512)
- Values from che.properties are not injected to Workspace, using Eclipse Che 4.7.2  [\#2511](https://github.com/eclipse/che/issues/2511)
- Code Assistant and Code Validation don't work for C\#  [\#2509](https://github.com/eclipse/che/issues/2509)
- Incorrect url is being used when pulling from private registry \(v5 M1\) [\#2495](https://github.com/eclipse/che/issues/2495)
- Prompt is blinking [\#2342](https://github.com/eclipse/che/issues/2342)
- Wrong behavior 'Close other' feature from context menu for tabs in the editor [\#1968](https://github.com/eclipse/che/issues/1968)
- Language Server Protocol: Refactor Symbol navigation UI [\#1809](https://github.com/eclipse/che/issues/1809)
- Language Server Protocol: Hover feature [\#1800](https://github.com/eclipse/che/issues/1800)
- Language Server Protocol: Implement client part for "Go To Symbol" feature [\#1791](https://github.com/eclipse/che/issues/1791)
- Language Server Protocol: Respect Language Server capabilities on IDE client [\#1789](https://github.com/eclipse/che/issues/1789)
- Language Server Protocol: Implement document formatting [\#1788](https://github.com/eclipse/che/issues/1788)
- The packages are collapsed after refactoring move  [\#1775](https://github.com/eclipse/che/issues/1775)
- Improve wizard to restart workspace [\#1761](https://github.com/eclipse/che/issues/1761)
- Improve loader when snapshotting [\#1760](https://github.com/eclipse/che/issues/1760)
- 5.0.0-M3 Milestone Overview [\#2641](https://github.com/eclipse/che/issues/2641)
- Documentation for preview HTML. [\#2597](https://github.com/eclipse/che/issues/2597)
- Documentation for Mounting [\#2596](https://github.com/eclipse/che/issues/2596)
- The editor hangs if a initializing server is not launched [\#2574](https://github.com/eclipse/che/issues/2574)
- Remove duplicated dependency [\#2547](https://github.com/eclipse/che/issues/2547)
- Item 'Clear list' was present earlier but it's absent now [\#2521](https://github.com/eclipse/che/issues/2521)
- Use tag instead of snapshot of the io.typefox.lsapi project [\#2506](https://github.com/eclipse/che/issues/2506)
- Can't start workspace if it contains projects after it's stopped  [\#2500](https://github.com/eclipse/che/issues/2500)
- Impossible to change RAM when compose stack is selected [\#2494](https://github.com/eclipse/che/issues/2494)
- Remove autostart LS agents [\#2484](https://github.com/eclipse/che/issues/2484)
- ch.sh wrong permissions [\#2468](https://github.com/eclipse/che/issues/2468)
- Workspace environment page enhancement [\#2451](https://github.com/eclipse/che/issues/2451)
- CLI - che start is not selinux aware [\#2441](https://github.com/eclipse/che/issues/2441)
- Cannot start a workspace with alpine base image [\#2424](https://github.com/eclipse/che/issues/2424)
- Fix project creation page issues on dashboard [\#2416](https://github.com/eclipse/che/issues/2416)
- volumes\_from does not work [\#2366](https://github.com/eclipse/che/issues/2366)
- After invoking of some command in the IDE terminal - view may be broken [\#2353](https://github.com/eclipse/che/issues/2353)
- Gray out menus until the workspace is not loaded or stopped [\#2286](https://github.com/eclipse/che/issues/2286)
- Merge model changes to JPA branch [\#2280](https://github.com/eclipse/che/issues/2280)
- Merge LSP branch to the master  [\#2279](https://github.com/eclipse/che/issues/2279)
- Proper C\# support for Che [\#2274](https://github.com/eclipse/che/issues/2274)
- Add utils to parse environment recipe format [\#2213](https://github.com/eclipse/che/issues/2213)
- Provide simple create/edit page for a Stack [\#2207](https://github.com/eclipse/che/issues/2207)
- Add Stacks page under Che's Dashboard [\#2206](https://github.com/eclipse/che/issues/2206)
- Soften lines/separator for dark theme [\#2142](https://github.com/eclipse/che/issues/2142)
- User password stores/updates without encoding [\#2136](https://github.com/eclipse/che/issues/2136)
- Migrate local json-based storage to jpa [\#2016](https://github.com/eclipse/che/issues/2016)
- Implement Account API [\#1989](https://github.com/eclipse/che/issues/1989)
- Don't store account name as Workspace\#namespace [\#1950](https://github.com/eclipse/che/issues/1950)
- Unexpected reloading the factories page after selecting [\#1922](https://github.com/eclipse/che/issues/1922)
- Allow for changes to workspace RAM to existing workspace [\#1918](https://github.com/eclipse/che/issues/1918)
- Update editor to Orion 12 [\#1900](https://github.com/eclipse/che/issues/1900)
- Create/Use TCK for UserDao [\#1847](https://github.com/eclipse/che/issues/1847)
- UserService structural refactoring [\#1846](https://github.com/eclipse/che/issues/1846)
- RecipeDao implementation on JPA [\#1815](https://github.com/eclipse/che/issues/1815)
- Implementation of workspace service storage on JPA [\#1813](https://github.com/eclipse/che/issues/1813)
- FactoryService structural refactoring [\#1812](https://github.com/eclipse/che/issues/1812)
- Implement UserDao based on JPA [\#1811](https://github.com/eclipse/che/issues/1811)
- Create JPA based SshDao implementation [\#1810](https://github.com/eclipse/che/issues/1810)
- Add c\# project type [\#1808](https://github.com/eclipse/che/issues/1808)
- Integrate JPA components/tools with Che Infrastructure [\#1807](https://github.com/eclipse/che/issues/1807)
- Investigate strategies for removing cascading entities [\#1803](https://github.com/eclipse/che/issues/1803)
- SnapshotDao implementation on JPA [\#1797](https://github.com/eclipse/che/issues/1797)
- StackDao implementation on JPA [\#1795](https://github.com/eclipse/che/issues/1795)
- Add section in workspace to handle the agents [\#1774](https://github.com/eclipse/che/issues/1774)
- Add Environment variables in the workspace configuration [\#1772](https://github.com/eclipse/che/issues/1772)
- Add Ports section in the workspace configuration [\#1771](https://github.com/eclipse/che/issues/1771)
- Add syntax coloration to machine outputs when starting a workspace [\#1755](https://github.com/eclipse/che/issues/1755)

**Pull requests merged:**

- Publish StackPersistedEvent after stack is persisted [\#2582](https://github.com/eclipse/che/pull/2582) ([evoevodin](https://github.com/evoevodin))
- CHE-1774: Adding "Agents" section to the "Runtime" tab [\#2577](https://github.com/eclipse/che/pull/2577) ([ibuziuk](https://github.com/ibuziuk))
- Fixes space issue with profile variables [\#2575](https://github.com/eclipse/che/pull/2575) ([TylerJewell](https://github.com/TylerJewell))
- CODENVY-2142 fix dashboard dropdown menu [\#2572](https://github.com/eclipse/che/pull/2572) ([olexii4](https://github.com/olexii4))
- Fix editing machine's RAM on workspace creation [\#2570](https://github.com/eclipse/che/pull/2570) ([ashumilova](https://github.com/ashumilova))
- CHE-2142 improve dark theme styles for lines and separators [\#2555](https://github.com/eclipse/che/pull/2555) ([olexii4](https://github.com/olexii4))
- Add testing stack for Langage Server agents [\#2541](https://github.com/eclipse/che/pull/2541) ([slemeur](https://github.com/slemeur))
- CLI: Use new che-mount & adds mechanism for CLI to update itself to new versions [\#2535](https://github.com/eclipse/che/pull/2535) ([TylerJewell](https://github.com/TylerJewell))
- CHE-2521: improve clear recent list action [\#2531](https://github.com/eclipse/che/pull/2531) ([olexii4](https://github.com/olexii4))
- CODENVY-502: introduce application notifications and container for them [\#2529](https://github.com/eclipse/che/pull/2529) ([ashumilova](https://github.com/ashumilova))
- Che CLI: added some parameters to execute che-mount [\#2523](https://github.com/eclipse/che/pull/2523) ([l0rd](https://github.com/l0rd))
- CHE-1900: Update editor to Orion 12 [\#2522](https://github.com/eclipse/che/pull/2522) ([azatsarynnyy](https://github.com/azatsarynnyy))
- CHE-2494: show RAM widget when compose stack is selected [\#2504](https://github.com/eclipse/che/pull/2504) ([akurinnoy](https://github.com/akurinnoy))
- Provide Maven plugin for generating TypeScript DTO objects based on Java DTO [\#2490](https://github.com/eclipse/che/pull/2490) ([benoitf](https://github.com/benoitf))
- CHE-2206: add stacks list, edit and creation [\#2465](https://github.com/eclipse/che/pull/2465) ([ashumilova](https://github.com/ashumilova))
- CHE-2286: disable menu items until the workspace is not running [\#2464](https://github.com/eclipse/che/pull/2464) ([olexii4](https://github.com/olexii4))
- Add .che to gitignore [\#2462](https://github.com/eclipse/che/pull/2462) ([benoitf](https://github.com/benoitf))
- Support for Language Server Protocol [\#2452](https://github.com/eclipse/che/pull/2452) ([tolusha](https://github.com/tolusha))
- CHE-2416: improve workspace-select-stack widget for UD [\#2432](https://github.com/eclipse/che/pull/2432) ([olexii4](https://github.com/olexii4))
- Set CLI home directory to be ${CHE\_MINI\_PRODUCT\_NAME} [\#2410](https://github.com/eclipse/che/pull/2410) ([TylerJewell](https://github.com/TylerJewell))
- CHE-1771: Add Runtime page to Workspace details [\#2371](https://github.com/eclipse/che/pull/2371) ([akurinnoy](https://github.com/akurinnoy))
- Add support of BasicAuthentication Authentication to Git [\#1940](https://github.com/eclipse/che/pull/1940) ([i053322](https://github.com/i053322))
- Use of TypeScript instead of ES6 [\#1587](https://github.com/eclipse/che/pull/1587) ([benoitf](https://github.com/benoitf))
- Add parameters for auto-snapshot and auto-restore of the workspace state [\#1281](https://github.com/eclipse/che/pull/1281) ([akorneta](https://github.com/akorneta))

## [5.0.0-M2](https://github.com/eclipse/che/tree/5.0.0-M2) (2016-09-20)
[Full Changelog](https://github.com/eclipse/che/compare/5.0.0-M1...5.0.0-M2)

**Issues with no labels:**

- RAM widget disappers when select Java-MySQL stack [\#2480](https://github.com/eclipse/che/issues/2480)
- CLI: Run Che specify CHE\_HOST\_IP [\#2476](https://github.com/eclipse/che/issues/2476)
- consume eclipse che api from jquery/c\# [\#2475](https://github.com/eclipse/che/issues/2475)
- Having to go through a series of steps before Eclipse Che starts. [\#2449](https://github.com/eclipse/che/issues/2449)
- How to run a Che farm behind an nginx router [\#2383](https://github.com/eclipse/che/issues/2383)
- Stop VM running che after idle/inactivity for long time [\#2362](https://github.com/eclipse/che/issues/2362)
- Init git repository at workspace level [\#2357](https://github.com/eclipse/che/issues/2357)
- Unable to select text on terminal window [\#2320](https://github.com/eclipse/che/issues/2320)
- Fix tag on default template "web-javaee-jaxrs" [\#2290](https://github.com/eclipse/che/issues/2290)
- Add ability to support specific docker registries for saving snapshots [\#2273](https://github.com/eclipse/che/issues/2273)
- Adapt JPA branch with changes in Workspace model [\#2215](https://github.com/eclipse/che/issues/2215)
- Implement post-flight check requirements into the codenvy/che-test image [\#2127](https://github.com/eclipse/che/issues/2127)
- Adapt ARTIK IDE to use Che Docker Launcher [\#2117](https://github.com/eclipse/che/issues/2117)
- Eclipse che not working in clients machine [\#2062](https://github.com/eclipse/che/issues/2062)
- Tab styling on operations perspective [\#2035](https://github.com/eclipse/che/issues/2035)
- Create a mechanism to configure Che with configs from different sources [\#2014](https://github.com/eclipse/che/issues/2014)
- Che build in the root directory fails on a clean check-out [\#1858](https://github.com/eclipse/che/issues/1858)
- Bower dependencies causing Che build to fail [\#1827](https://github.com/eclipse/che/issues/1827)
- JPA Dao implementation [\#1790](https://github.com/eclipse/che/issues/1790)
- Add Device logging for Artik [\#1777](https://github.com/eclipse/che/issues/1777)
- Errors in workspace after checking out \(missing jdt dependencies\) [\#1740](https://github.com/eclipse/che/issues/1740)
- Support for WTP server launching [\#1676](https://github.com/eclipse/che/issues/1676)
- Question about google super dev. [\#1640](https://github.com/eclipse/che/issues/1640)
- Timeline for multi-cursor visuals? [\#1618](https://github.com/eclipse/che/issues/1618)
- Add README for each plugin [\#1567](https://github.com/eclipse/che/issues/1567)
- How can I make my project type  extension  to extends MAVEN project type ?? [\#1535](https://github.com/eclipse/che/issues/1535)
- non workspace machines don't have project code [\#1533](https://github.com/eclipse/che/issues/1533)
- ability to use docker-compose.yml instead of docker file for dev environments [\#1527](https://github.com/eclipse/che/issues/1527)
- How about supporting Mercurial as a version control tool ? [\#1436](https://github.com/eclipse/che/issues/1436)
- \[languageserver\] Push notification to client on new language server [\#1427](https://github.com/eclipse/che/issues/1427)
- \[languageserver\] Ensure order of events [\#1426](https://github.com/eclipse/che/issues/1426)
- \[languageserver\] Support incremental updates [\#1425](https://github.com/eclipse/che/issues/1425)
- \[languageserver\] Find Reference [\#1421](https://github.com/eclipse/che/issues/1421)
- How to extend a new project type that contains a new perspective [\#1404](https://github.com/eclipse/che/issues/1404)
- 5.0.0-M2 Milestone Overview [\#2640](https://github.com/eclipse/che/issues/2640)
- Java Refactoring Rename feature broken after merging  VFS Events and Split Editor features [\#2168](https://github.com/eclipse/che/issues/2168)

**Pull requests merged:**

- Fix LanguageServerException message for CSharp LS [\#2532](https://github.com/eclipse/che/pull/2532) ([xcoulon](https://github.com/xcoulon))
- CHE-781: use 1Gb RAM for db machine and remove ssh agent from it [\#2505](https://github.com/eclipse/che/pull/2505) ([ashumilova](https://github.com/ashumilova))

## [5.0.0-M1](https://github.com/eclipse/che/tree/5.0.0-M1) (2016-09-14)
[Full Changelog](https://github.com/eclipse/che/compare/4.7.2...5.0.0-M1)

**Issues with no labels:**

- Command for opening a file [\#2412](https://github.com/eclipse/che/issues/2412)
- Custom extension not visible on IDE 4.7.2 [\#2411](https://github.com/eclipse/che/issues/2411)
- GitLab docs update [\#2405](https://github.com/eclipse/che/issues/2405)
- Added documentation for GitLab oAuth [\#2404](https://github.com/eclipse/che/issues/2404)
- Add authentication for accessing workspace in private cloud [\#2390](https://github.com/eclipse/che/issues/2390)
- Help needed to make custom che.properties work on boot2docker-hyperV in windows 10 [\#2384](https://github.com/eclipse/che/issues/2384)
- Not able to import projects from my Github account though can see the projects listed.  [\#2360](https://github.com/eclipse/che/issues/2360)
- Close editor when file is deleted [\#2328](https://github.com/eclipse/che/issues/2328)
- How integrate eclipse Che with AD and LDAP [\#2302](https://github.com/eclipse/che/issues/2302)
- Support for private docker registries withotut authentication? [\#2188](https://github.com/eclipse/che/issues/2188)
- Can't load project types outside localhost [\#2058](https://github.com/eclipse/che/issues/2058)
- Configure locale in a docker container [\#1856](https://github.com/eclipse/che/issues/1856)
- Environment Provider and Agent SPI [\#1829](https://github.com/eclipse/che/issues/1829)
- Docker Launcher: Websockets are unable to comunicate with the wsagent when the server and the browser run on different networks [\#1644](https://github.com/eclipse/che/issues/1644)
- Broken link on dashboard page to custom stacks documentation [\#2440](https://github.com/eclipse/che/issues/2440)
- Release and ship Che 5.0.0-M1 [\#2433](https://github.com/eclipse/che/issues/2433)
- NullPointer when starting a multi machine workspace [\#2426](https://github.com/eclipse/che/issues/2426)
- Ways to mount folder inside host machine to auxiliary machine [\#2425](https://github.com/eclipse/che/issues/2425)
- Workspaces that have been created before merge of the agents feature do not start [\#2385](https://github.com/eclipse/che/issues/2385)
- Download project as Zip does not work [\#2377](https://github.com/eclipse/che/issues/2377)
- There is no content of recipe into 'Operation Perspective' [\#2373](https://github.com/eclipse/che/issues/2373)
- Document model changes introduced in \#1818  [\#2363](https://github.com/eclipse/che/issues/2363)
- Snapshoting of machines failed if snapshot made second time for given machine [\#2344](https://github.com/eclipse/che/issues/2344)
- Cannot launch a workspace after creation [\#2331](https://github.com/eclipse/che/issues/2331)
- che.sh root script is not sh compliant [\#2303](https://github.com/eclipse/che/issues/2303)
- Creating new machine does not work [\#2300](https://github.com/eclipse/che/issues/2300)
- che.sh does not run [\#2295](https://github.com/eclipse/che/issues/2295)
- Node console template not showing up [\#2291](https://github.com/eclipse/che/issues/2291)
- Adopt agents to new environment model [\#2285](https://github.com/eclipse/che/issues/2285)
- Redrawing dashboard page when no workspaces [\#2275](https://github.com/eclipse/che/issues/2275)
- Make Che with debug flag use default log level instead of debug log level [\#2272](https://github.com/eclipse/che/issues/2272)
- 5.0.0-M1 Milestone Plan [\#2267](https://github.com/eclipse/che/issues/2267)
- Avoid using deprecated KeyboardEvent.keyIdentifier [\#2209](https://github.com/eclipse/che/issues/2209)
- Make default workspace RAM setting to 2GB [\#2204](https://github.com/eclipse/che/issues/2204)
- Copy/Paste doesn't work in the Terminal \(Firefox\) [\#2178](https://github.com/eclipse/che/issues/2178)
- Pack ssh agent [\#2156](https://github.com/eclipse/che/issues/2156)
- Test agents over different containers [\#2138](https://github.com/eclipse/che/issues/2138)
- Continuously upload new agent binaries to Codenvy Update Server [\#2137](https://github.com/eclipse/che/issues/2137)
- Change type of pointed messages from ERROR to WARNING [\#2135](https://github.com/eclipse/che/issues/2135)
- Pack terminal agent [\#2074](https://github.com/eclipse/che/issues/2074)
- Package dev agent [\#2073](https://github.com/eclipse/che/issues/2073)
- Implement and pack Language Server Agents [\#2032](https://github.com/eclipse/che/issues/2032)
- Implement Agent API [\#2008](https://github.com/eclipse/che/issues/2008)
- Specify how to name, package and run Agent [\#2005](https://github.com/eclipse/che/issues/2005)
- NPE after deleting multi-module project [\#1985](https://github.com/eclipse/che/issues/1985)
- Git checkout operation notification [\#1912](https://github.com/eclipse/che/issues/1912)
- File explorer real time content update [\#1911](https://github.com/eclipse/che/issues/1911)
- File editor real time content update [\#1910](https://github.com/eclipse/che/issues/1910)
- Add ability to preview an HTML file into another browser window [\#1883](https://github.com/eclipse/che/issues/1883)
- Add ability to install Orion plugins inside the Che editor [\#1878](https://github.com/eclipse/che/issues/1878)
- Detector of VFS high level events related to client side state [\#1832](https://github.com/eclipse/che/issues/1832)
- Client-side service to track client state [\#1830](https://github.com/eclipse/che/issues/1830)
- IDE \(client\) - workspace agent \(server\) event transport service [\#1824](https://github.com/eclipse/che/issues/1824)
- Machine Agent specification and implementation [\#1823](https://github.com/eclipse/che/issues/1823)
- Change Workspace environment model [\#1818](https://github.com/eclipse/che/issues/1818)
- Remove the current workspace runtime loader [\#1759](https://github.com/eclipse/che/issues/1759)
- Display loading steps when booting ws from IDE [\#1758](https://github.com/eclipse/che/issues/1758)
- Provide more space to the console when the workspace is booting [\#1757](https://github.com/eclipse/che/issues/1757)
- Is there a plan to support multiple extra column mapping in new workspace container creation? [\#1244](https://github.com/eclipse/che/issues/1244)

**Pull requests merged:**

- Remove duplicated lines in pom.xml [\#2479](https://github.com/eclipse/che/pull/2479) ([benoitf](https://github.com/benoitf))
- CHE-2440: fix custom stack documentation link and stack format toggle [\#2443](https://github.com/eclipse/che/pull/2443) ([ashumilova](https://github.com/ashumilova))
- CHE-2425: Ways to mount folder inside host machine to auxiliary machine [\#2427](https://github.com/eclipse/che/pull/2427) ([tolusha](https://github.com/tolusha))
- Fix NPE after deleting multi-module project [\#2419](https://github.com/eclipse/che/pull/2419) ([azatsarynnyy](https://github.com/azatsarynnyy))
- improve workspace RAM settings for add project flow [\#2403](https://github.com/eclipse/che/pull/2403) ([olexii4](https://github.com/olexii4))
- Add ability to preview an HTML file into another browser window [\#2378](https://github.com/eclipse/che/pull/2378) ([azatsarynnyy](https://github.com/azatsarynnyy))
- Remove unused code [\#2370](https://github.com/eclipse/che/pull/2370) ([azatsarynnyy](https://github.com/azatsarynnyy))
- Fix double output, workspace list, RAM displaying, add recipe format [\#2348](https://github.com/eclipse/che/pull/2348) ([ashumilova](https://github.com/ashumilova))
- Avoid using deprecated 'keyIdentifier' property of 'KeyboardEvent' [\#2318](https://github.com/eclipse/che/pull/2318) ([azatsarynnyy](https://github.com/azatsarynnyy))
- fixup to che.sh [\#2306](https://github.com/eclipse/che/pull/2306) ([TylerJewell](https://github.com/TylerJewell))
- Add Bitnami stacks and blank project for use with the generators [\#2301](https://github.com/eclipse/che/pull/2301) ([amrecio](https://github.com/amrecio))
- Add support for Che in Che with a Chefile [\#2289](https://github.com/eclipse/che/pull/2289) ([benoitf](https://github.com/benoitf))
- backport PR2264 into CHE-1818 branch [\#2288](https://github.com/eclipse/che/pull/2288) ([benoitf](https://github.com/benoitf))
- Fix redirection to creation page - removed flicking [\#2276](https://github.com/eclipse/che/pull/2276) ([ashumilova](https://github.com/ashumilova))
- CLI: Fix Mac tmp dir access [\#2269](https://github.com/eclipse/che/pull/2269) ([TylerJewell](https://github.com/TylerJewell))
- Allow mounting of multiple volumes to mount properties [\#2264](https://github.com/eclipse/che/pull/2264) ([benoitf](https://github.com/benoitf))
- Add possibility to install Orion plugins for the CHE editor [\#2262](https://github.com/eclipse/che/pull/2262) ([azatsarynnyy](https://github.com/azatsarynnyy))
- Mechanism to configure Che with configs from different sources [\#2175](https://github.com/eclipse/che/pull/2175) ([andrew00x](https://github.com/andrew00x))

## [4.7.2](https://github.com/eclipse/che/tree/4.7.2) (2016-09-09)
[Full Changelog](https://github.com/eclipse/che/compare/4.7.1...4.7.2)

**Issues with no labels:**

- Building of 4.7.1 tag fails on IDE Stack: "Missing header in: che-core-ide-stacks/src/main/resources/images/type-bitnami.svg" [\#2389](https://github.com/eclipse/che/issues/2389)
- Am I using che-install-plugin correctly? I can't make the JSON plugin works [\#2330](https://github.com/eclipse/che/issues/2330)
- 4.7.2 Milestone Plan [\#2401](https://github.com/eclipse/che/issues/2401)
- The box 'boxcutter/centos72-docker' could not be found [\#2379](https://github.com/eclipse/che/issues/2379)

**Pull requests merged:**

- Update Vagrantfile to use base centos72 image [\#2388](https://github.com/eclipse/che/pull/2388) ([TylerJewell](https://github.com/TylerJewell))

## [4.7.1](https://github.com/eclipse/che/tree/4.7.1) (2016-09-08)
[Full Changelog](https://github.com/eclipse/che/compare/4.8.0-artik...4.7.1)

**Issues with no labels:**

- Can't load project [\#2361](https://github.com/eclipse/che/issues/2361)
- Workspace - "Download as Zip..." action should download all projects in the workspace [\#2336](https://github.com/eclipse/che/issues/2336)
- mvn clean install build is failure  [\#2335](https://github.com/eclipse/che/issues/2335)
- The size of workspase is not correctly displayed on the dashboard. [\#2333](https://github.com/eclipse/che/issues/2333)
- Che server and workspace machines on separate nodes [\#2327](https://github.com/eclipse/che/issues/2327)
- from 4.7.0 become 4.6.2  [\#2326](https://github.com/eclipse/che/issues/2326)
- Trying to build Eclipse Che 4.8.x on Ubuntu, I got exception "java.net.SocketException: Broken pipe" [\#2323](https://github.com/eclipse/che/issues/2323)
- "cannot enable tty mode on non tty input" on Eclipse Che version 4.7.0 [\#2321](https://github.com/eclipse/che/issues/2321)
- Running che as a server on Mac with odd behavior [\#2313](https://github.com/eclipse/che/issues/2313)
- How to config mirror for maven? cant run vi in che container [\#2309](https://github.com/eclipse/che/issues/2309)
- What should I do to support hundreds of workspace working properly at the same time. [\#2297](https://github.com/eclipse/che/issues/2297)
- Grammar for PHP tag doesn't support all cases [\#2283](https://github.com/eclipse/che/issues/2283)
- I built Eclipse Che 4.8.0, but I get "LOADING: Error while Booting developer machine" when I try to run a Workspace [\#2271](https://github.com/eclipse/che/issues/2271)
- chrome developer tools network show ”Provisional headers are shown“ [\#2270](https://github.com/eclipse/che/issues/2270)
- somtimes pop dialog cant copy and paste [\#2258](https://github.com/eclipse/che/issues/2258)
- Issue with Git Committing in 4.5.1 [\#2101](https://github.com/eclipse/che/issues/2101)
- No index.html when creating a java-swing workspace with mentioned stack [\#2021](https://github.com/eclipse/che/issues/2021)
- Restore state of project feature - does not apply to a maven multimodule projects [\#1920](https://github.com/eclipse/che/issues/1920)
- Make Che with multi-machine environments backward compatible [\#1820](https://github.com/eclipse/che/issues/1820)
- Add enhancements for working with files not added as projects [\#1580](https://github.com/eclipse/che/issues/1580)
- 4.7.1 Milestone Plan [\#2354](https://github.com/eclipse/che/issues/2354)
- Release and ship Che 4.7.1 [\#2337](https://github.com/eclipse/che/issues/2337)
- Machine tab does not have full output of the workspace boot [\#2325](https://github.com/eclipse/che/issues/2325)
- Two terminal tabs appearing when workspace first loads [\#2324](https://github.com/eclipse/che/issues/2324)
- Connection failed with terminal [\#2322](https://github.com/eclipse/che/issues/2322)
- ${workspace.name} macro should be include in gin configuration [\#2293](https://github.com/eclipse/che/issues/2293)
- ${server.\<name\>} macro should provide full information about server [\#2292](https://github.com/eclipse/che/issues/2292)
- 'che-ip' tool returns an error in case when there is no 'ethn' interface [\#2284](https://github.com/eclipse/che/issues/2284)
- Remote Che: terminal unavailable [\#2281](https://github.com/eclipse/che/issues/2281)
- After creation a new workspace the ssh button in the processes widget is absent [\#2278](https://github.com/eclipse/che/issues/2278)
- Unexpected appearance of the second terminal after refresh [\#2249](https://github.com/eclipse/che/issues/2249)

**Pull requests merged:**

- Allow Che CLI to run in directory w/o write permissions [\#2358](https://github.com/eclipse/che/pull/2358) ([TylerJewell](https://github.com/TylerJewell))
- Separate CHE\_VERSION from CHE\_UTILITY\_VERSION [\#2307](https://github.com/eclipse/che/pull/2307) ([TylerJewell](https://github.com/TylerJewell))

## [4.8.0-artik](https://github.com/eclipse/che/tree/4.8.0-artik) (2016-08-31)
[Full Changelog](https://github.com/eclipse/che/compare/4.7.0...4.8.0-artik)

**Issues with no labels:**

- After stopping workspace the restart widget does not appear [\#2268](https://github.com/eclipse/che/issues/2268)
- Trying to build and run Eclipse Che 4.6.x, I get java.lang.NoClassDefFoundError: org/objectweb/asm/MethodVisitor [\#2259](https://github.com/eclipse/che/issues/2259)
- Cannot use github without oauth [\#2253](https://github.com/eclipse/che/issues/2253)
- Build Che Using Docker - npm error [\#2247](https://github.com/eclipse/che/issues/2247)
- Unable to import GitSwarm Projects [\#2244](https://github.com/eclipse/che/issues/2244)
- Cannot close tabs into a single pane  [\#2223](https://github.com/eclipse/che/issues/2223)
- Cannot close the last pane [\#2221](https://github.com/eclipse/che/issues/2221)

## [4.7.0](https://github.com/eclipse/che/tree/4.7.0) (2016-08-29)
[Full Changelog](https://github.com/eclipse/che/compare/4.7.0-RC1...4.7.0)

**Issues with no labels:**

- IDE can't build and run project [\#2238](https://github.com/eclipse/che/issues/2238)
- Add macros for host [\#2230](https://github.com/eclipse/che/issues/2230)
- Incomprehensible behavior for creation a factory from dashboard [\#2229](https://github.com/eclipse/che/issues/2229)
- Folder/File disappeared after rename [\#2227](https://github.com/eclipse/che/issues/2227)
- In company's network,workspace open error,and can't create project [\#2226](https://github.com/eclipse/che/issues/2226)
- The just created new splitted pane for a terminal is empty [\#2222](https://github.com/eclipse/che/issues/2222)
- Ability to create a workspace from any repository hosting provider [\#2202](https://github.com/eclipse/che/issues/2202)
- Is there a way to run 4.7 until it officially comes out? [\#2199](https://github.com/eclipse/che/issues/2199)
- Error of automatic update of IM CLI: 'Could not generate DH keypair' [\#2195](https://github.com/eclipse/che/issues/2195)
- Unable to start my workspace "You can configure machine.ws\_agent.max\_start\_time\_ms in Che properties to increase the timeout" [\#2192](https://github.com/eclipse/che/issues/2192)
- Eclipse che up freezing [\#2189](https://github.com/eclipse/che/issues/2189)
- CHE\_SERVER\_CONTAINER\_NAME doesn't have any effect. [\#2187](https://github.com/eclipse/che/issues/2187)
- Where can I find che.properties file and export workspace snapshot? [\#2186](https://github.com/eclipse/che/issues/2186)
- Links on hwo to extend Che on website are outdated [\#2184](https://github.com/eclipse/che/issues/2184)
- Jade/Coffeescript/SASS support? [\#2180](https://github.com/eclipse/che/issues/2180)
- HTTPS Support? [\#2174](https://github.com/eclipse/che/issues/2174)
- Unable to create project eventhough workspace created.  [\#2173](https://github.com/eclipse/che/issues/2173)
- Workspaces don't persist between docker service restarts [\#2172](https://github.com/eclipse/che/issues/2172)
- Enable node.js debugging via GDB [\#2171](https://github.com/eclipse/che/issues/2171)
- I don't think APIs in swagger related to projects are working correctly. [\#2166](https://github.com/eclipse/che/issues/2166)
- What's the differnce between eclipse/che and codenvy/che dockerhub repos? [\#2164](https://github.com/eclipse/che/issues/2164)
- setup nightly QA for new dockerized CHE [\#2161](https://github.com/eclipse/che/issues/2161)
- Blank Workspace Won't Start with Obscure Error [\#2149](https://github.com/eclipse/che/issues/2149)
- Refresh in Project Explorer does not work [\#2141](https://github.com/eclipse/che/issues/2141)
- Can not do CLI mount  [\#2123](https://github.com/eclipse/che/issues/2123)
- Wokspaces are not loaded when che starts as a container [\#2122](https://github.com/eclipse/che/issues/2122)
- Docker out of docker [\#2086](https://github.com/eclipse/che/issues/2086)
- Issue building Che with custom plugin - Project extension doesn t appear [\#2077](https://github.com/eclipse/che/issues/2077)
- Add Native Scripts to Launch All Che Commands [\#1969](https://github.com/eclipse/che/issues/1969)
- Docker Launcher - wrong hostname output when running in a VM [\#1925](https://github.com/eclipse/che/issues/1925)
- Che launches a new browser window when changing left-side navigation options [\#1923](https://github.com/eclipse/che/issues/1923)
- Move "Subversion" menu after to "Git" in project's explorer right-click menu [\#1884](https://github.com/eclipse/che/issues/1884)
- Separate environment runtime management from workspace runtime management [\#1864](https://github.com/eclipse/che/issues/1864)
- Wrong symbols in the message console after git merge [\#1859](https://github.com/eclipse/che/issues/1859)
- Rework the grids and lists views in the user dashboard [\#1762](https://github.com/eclipse/che/issues/1762)
- Will the plugin-datasource coming back to the Che future version? [\#1724](https://github.com/eclipse/che/issues/1724)
- Re-creating a project with the same name as a deleted one in same workspace fails on Codenvy [\#1637](https://github.com/eclipse/che/issues/1637)
- How to restrict the number of workspaces that can be created? Or enable only one workspace running at the same time  [\#1557](https://github.com/eclipse/che/issues/1557)
- Please add Clojure support to Eclipse Che [\#1484](https://github.com/eclipse/che/issues/1484)
- Release and ship Che 4.7.0 [\#2265](https://github.com/eclipse/che/issues/2265)
- Sometimes the IDE view may be broken [\#2260](https://github.com/eclipse/che/issues/2260)
- che.sh trying to run 'docker.exe' on OSX [\#2248](https://github.com/eclipse/che/issues/2248)
- Eclipse CHE is up on vagrant but not available on the browser [\#2235](https://github.com/eclipse/che/issues/2235)
- Modify Error Message When Trying to Run Che Server Twice [\#2233](https://github.com/eclipse/che/issues/2233)
- Wrong icon for unknown filetype in editor [\#2183](https://github.com/eclipse/che/issues/2183)
- Revamp list's header [\#2179](https://github.com/eclipse/che/issues/2179)
- How do I make eclipse che instance persist across host reboots [\#2170](https://github.com/eclipse/che/issues/2170)
- Simplify boxes' design for Dashboard page [\#2158](https://github.com/eclipse/che/issues/2158)
- Dashboard's New Project wizard fails if workspace source type is 'location' [\#2134](https://github.com/eclipse/che/issues/2134)
- \[dashboard\] Move project repository info from separate tab [\#2129](https://github.com/eclipse/che/issues/2129)
- Error when running Che using CLI utility [\#2128](https://github.com/eclipse/che/issues/2128)
- Che launcher debug prints wrong port / hostname for running server if variables change [\#2102](https://github.com/eclipse/che/issues/2102)
- Registry disappears from admin section [\#2082](https://github.com/eclipse/che/issues/2082)
- che-launcher based provisioning with Vagrant doesn't restart the server [\#2066](https://github.com/eclipse/che/issues/2066)
- che-launcher self-destruct causes error [\#2065](https://github.com/eclipse/che/issues/2065)
- Remove native git implementation [\#2033](https://github.com/eclipse/che/issues/2033)
- Che Milestone 4.7.0 [\#2029](https://github.com/eclipse/che/issues/2029)
- Convert Vagrantfile to use Che Launcher syntax [\#2026](https://github.com/eclipse/che/issues/2026)
- Incorrect factory validation behavior when field value matches default for its type [\#2022](https://github.com/eclipse/che/issues/2022)
- Project is not accessible in Dashboard [\#2020](https://github.com/eclipse/che/issues/2020)
- Apply the new component to docker registries list [\#2010](https://github.com/eclipse/che/issues/2010)
- Sometimes the org.eclipse.che.api.project.server.Project Service Test fails during build of the CHE [\#2006](https://github.com/eclipse/che/issues/2006)
- Wrong behavior of targets widget [\#2002](https://github.com/eclipse/che/issues/2002)
- On workspace start error, "Start Workspace" dialog covers error dialog [\#1987](https://github.com/eclipse/che/issues/1987)
- Classpath not resolved when it's in a Maven container [\#1964](https://github.com/eclipse/che/issues/1964)
- Docker Che launcher doesn't show progress on pull of new che-server image [\#1942](https://github.com/eclipse/che/issues/1942)
- Wrong behavior after starting workspace from snapshot  [\#1933](https://github.com/eclipse/che/issues/1933)
- Add support for chefile configuration [\#1895](https://github.com/eclipse/che/issues/1895)
- Improved tabbed terminals design [\#1888](https://github.com/eclipse/che/issues/1888)
- Update plugin sample  [\#1882](https://github.com/eclipse/che/issues/1882)
- Path in the 'Parent' field  presents incorrectly on the 'Project Configuration' window  [\#1868](https://github.com/eclipse/che/issues/1868)
- The whole git changed list opens if git compare called from file context menu [\#1866](https://github.com/eclipse/che/issues/1866)
- After select an item in the Git compare widget the Compare button is disabled [\#1865](https://github.com/eclipse/che/issues/1865)
- Name of workspace is displayed incorrectly in the header. [\#1848](https://github.com/eclipse/che/issues/1848)
- Adapt Editor agent to manage multi parts [\#1840](https://github.com/eclipse/che/issues/1840)
- Correct processing some operations for editor [\#1839](https://github.com/eclipse/che/issues/1839)
- Sync content of the file for all opened tabs of this file [\#1838](https://github.com/eclipse/che/issues/1838)
- Split view for editor [\#1837](https://github.com/eclipse/che/issues/1837)
- Apply the new grid component to workspace projects list [\#1780](https://github.com/eclipse/che/issues/1780)
- Apply the new grid component to users list and workspace members list [\#1779](https://github.com/eclipse/che/issues/1779)
- New layout for forms in UD [\#1770](https://github.com/eclipse/che/issues/1770)
- Add "+" button next to "Recent workspaces" [\#1768](https://github.com/eclipse/che/issues/1768)
- Handle workspace list hover and click states for list views in dashboard [\#1765](https://github.com/eclipse/che/issues/1765)
- Add actions for workspace item in workspace list for dashboard [\#1764](https://github.com/eclipse/che/issues/1764)
- Create grids common components [\#1763](https://github.com/eclipse/che/issues/1763)
- placeholder for preview URL [\#1591](https://github.com/eclipse/che/issues/1591)
- Macro for selected files in the project explorer [\#953](https://github.com/eclipse/che/issues/953)

**Pull requests merged:**

- Restore PR \#1528 fix that has been lost with TypeScript changes [\#2554](https://github.com/eclipse/che/pull/2554) ([benoitf](https://github.com/benoitf))
- CLI Fixup [\#2252](https://github.com/eclipse/che/pull/2252) ([TylerJewell](https://github.com/TylerJewell))
- Update dashboard view [\#2245](https://github.com/eclipse/che/pull/2245) ([akurinnoy](https://github.com/akurinnoy))
- Fix Processes panel behavior [\#2240](https://github.com/eclipse/che/pull/2240) ([azatsarynnyy](https://github.com/azatsarynnyy))
- Let Che CLI compile Che [\#2239](https://github.com/eclipse/che/pull/2239) ([TylerJewell](https://github.com/TylerJewell))
- Deactivation of che-long-touch behaviour in navbar [\#2237](https://github.com/eclipse/che/pull/2237) ([slemeur](https://github.com/slemeur))
- Update Vagrantfile [\#2236](https://github.com/eclipse/che/pull/2236) ([TylerJewell](https://github.com/TylerJewell))
- \#953: Extend macro list [\#2232](https://github.com/eclipse/che/pull/2232) ([vzhukovskii](https://github.com/vzhukovskii))
- Fix errors in che-in-che stack [\#2225](https://github.com/eclipse/che/pull/2225) ([TylerJewell](https://github.com/TylerJewell))
- Changes to support move to che-dockerfiles repository [\#2220](https://github.com/eclipse/che/pull/2220) ([TylerJewell](https://github.com/TylerJewell))
- CHE-2158: simplify boxes' design for Dashboard page [\#2219](https://github.com/eclipse/che/pull/2219) ([akurinnoy](https://github.com/akurinnoy))
- CHE-2134  improve create project flow [\#2217](https://github.com/eclipse/che/pull/2217) ([olexii4](https://github.com/olexii4))
- Fix invalid syntax in dashboard imports [\#2216](https://github.com/eclipse/che/pull/2216) ([benoitf](https://github.com/benoitf))
- Che script improvements [\#2211](https://github.com/eclipse/che/pull/2211) ([TylerJewell](https://github.com/TylerJewell))
- CHE-2179: add description widget [\#2210](https://github.com/eclipse/che/pull/2210) ([ashumilova](https://github.com/ashumilova))
- Fix che-in-che stack [\#2208](https://github.com/eclipse/che/pull/2208) ([mkuznyetsov](https://github.com/mkuznyetsov))
- Add che product name to CLI & launcher [\#2203](https://github.com/eclipse/che/pull/2203) ([TylerJewell](https://github.com/TylerJewell))
- \#2183 Wrong icon for unknown filetype in editor [\#2196](https://github.com/eclipse/che/pull/2196) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- CHE-2129: \[dashboard\] move project repository info from separate tab [\#2190](https://github.com/eclipse/che/pull/2190) ([akurinnoy](https://github.com/akurinnoy))
- CODENVY-562: Clean up container if it failed to start [\#2165](https://github.com/eclipse/che/pull/2165) ([mmorhun](https://github.com/mmorhun))
- CHE-1848: name of workspace is displayed correctly [\#2146](https://github.com/eclipse/che/pull/2146) ([akurinnoy](https://github.com/akurinnoy))
- \#1868: Display correct path during converting folder into project [\#2140](https://github.com/eclipse/che/pull/2140) ([vzhukovskii](https://github.com/vzhukovskii))
- Changes to support che-in-che [\#2119](https://github.com/eclipse/che/pull/2119) ([TylerJewell](https://github.com/TylerJewell))
- CHE-1866: Fix wrong viewing of git compare [\#2106](https://github.com/eclipse/che/pull/2106) ([vinokurig](https://github.com/vinokurig))
- Optimize che-launcher for perf [\#2105](https://github.com/eclipse/che/pull/2105) ([TylerJewell](https://github.com/TylerJewell))
- CHE-1770: New layout for forms in UD [\#2061](https://github.com/eclipse/che/pull/2061) ([akurinnoy](https://github.com/akurinnoy))
- CHE-2020: Fix passing project name on project creation from wizard [\#2051](https://github.com/eclipse/che/pull/2051) ([ashumilova](https://github.com/ashumilova))
- \#1895 codenvy/che-file improvements [\#2048](https://github.com/eclipse/che/pull/2048) ([benoitf](https://github.com/benoitf))
- codenvy-447: Remove containers in case failed to create docker instance. [\#2007](https://github.com/eclipse/che/pull/2007) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))
- CHE-2002 fix wrong workspace ID for SSH target [\#2003](https://github.com/eclipse/che/pull/2003) ([olexii4](https://github.com/olexii4))
- CHE-1491: add "+" button next to "Recent workspaces" [\#1816](https://github.com/eclipse/che/pull/1816) ([akurinnoy](https://github.com/akurinnoy))
- CODENVY-707: fix bug with several IDE on page [\#1746](https://github.com/eclipse/che/pull/1746) ([akurinnoy](https://github.com/akurinnoy))
- \[WIP\] CHE-1369: rework UD to listen environment channels [\#1648](https://github.com/eclipse/che/pull/1648) ([ashumilova](https://github.com/ashumilova))

## [4.7.0-RC1](https://github.com/eclipse/che/tree/4.7.0-RC1) (2016-08-16)
[Full Changelog](https://github.com/eclipse/che/compare/4.7.0-artik...4.7.0-RC1)

## [4.7.0-artik](https://github.com/eclipse/che/tree/4.7.0-artik) (2016-08-15)
[Full Changelog](https://github.com/eclipse/che/compare/4.6.2...4.7.0-artik)

**Issues with no labels:**

- Eclipse che doesn't read the workspaces created when executed as a container [\#2120](https://github.com/eclipse/che/issues/2120)
- Signer information does not match \(version 4.6.2\) [\#2113](https://github.com/eclipse/che/issues/2113)
- Problem authenticating on github [\#2104](https://github.com/eclipse/che/issues/2104)
- Compiling Che fails [\#2093](https://github.com/eclipse/che/issues/2093)
- SSH machine is displayed as RUNNING after creating it with wrong credentials [\#2090](https://github.com/eclipse/che/issues/2090)
- Make che-launcher inject all CHE\_\* environment variables into che-server [\#2013](https://github.com/eclipse/che/issues/2013)
- Remove some editor api interfaces and clases and simplify editor initialization process [\#1913](https://github.com/eclipse/che/issues/1913)
- Can't find REST API about auth. [\#1592](https://github.com/eclipse/che/issues/1592)

## [4.6.2](https://github.com/eclipse/che/tree/4.6.2) (2016-08-11)
[Full Changelog](https://github.com/eclipse/che/compare/4.6.1...4.6.2)

**Issues with no labels:**

- How do I write a custom recipe that uses scripts? [\#2084](https://github.com/eclipse/che/issues/2084)
- unzip:  cannot find or open /mnt/che/ws-agent.zip, /mnt/che/ws-agent.zip.zip or /mnt/che/ws-agent.zip.ZIP. [\#2081](https://github.com/eclipse/che/issues/2081)
- How to debug che source code in windows? [\#2070](https://github.com/eclipse/che/issues/2070)
- Question: WEB UI Authentication [\#2028](https://github.com/eclipse/che/issues/2028)
- Sparse checkout broken [\#2019](https://github.com/eclipse/che/issues/2019)
- Cannot wget/curl/git/apt-get to internet from within docker container [\#2001](https://github.com/eclipse/che/issues/2001)
- Issue on Eclipse Che using vagrant behind firewall [\#1897](https://github.com/eclipse/che/issues/1897)

## [4.6.1](https://github.com/eclipse/che/tree/4.6.1) (2016-08-04)
[Full Changelog](https://github.com/eclipse/che/compare/4.6.0...4.6.1)

**Issues with no labels:**

- Could not start workspace \<wokespace-id\> Reason: Timeout reached [\#2039](https://github.com/eclipse/che/issues/2039)
- Javascript errors while building from source [\#1984](https://github.com/eclipse/che/issues/1984)
- Preview URL for android workspaces not include for Eclipse Che version 4.5.1 [\#1908](https://github.com/eclipse/che/issues/1908)

## [4.6.0](https://github.com/eclipse/che/tree/4.6.0) (2016-08-01)
[Full Changelog](https://github.com/eclipse/che/compare/4.5.1...4.6.0)

**Issues with no labels:**

- "Edit Commands..." for java seems don't work [\#1996](https://github.com/eclipse/che/issues/1996)
- Check if workspace backup performed on docker service restart or stop [\#1972](https://github.com/eclipse/che/issues/1972)
- Publish port exposed by workspace at a particular port  [\#1971](https://github.com/eclipse/che/issues/1971)
- Deprecate CurrentProjectChangedEvent and his handler [\#1961](https://github.com/eclipse/che/issues/1961)
- Add custom user agent header into JGit  [\#1935](https://github.com/eclipse/che/issues/1935)
- Make ability to show notifications from dashboard when IDE iframe is showed [\#1915](https://github.com/eclipse/che/issues/1915)
- Is it possible way to debug Che Server? [\#1880](https://github.com/eclipse/che/issues/1880)
- How should I debug the Eclipse Che core? [\#1876](https://github.com/eclipse/che/issues/1876)
- Use local image before registry [\#1845](https://github.com/eclipse/che/issues/1845)
- Certificates are required for https connection [\#1792](https://github.com/eclipse/che/issues/1792)
- How to solve cross domain problem when deploy docker on seperate node [\#1781](https://github.com/eclipse/che/issues/1781)
- Find way to distinguish between Docker for Mac and Windows [\#1744](https://github.com/eclipse/che/issues/1744)
- CORS restrictions in Workspace Agent [\#1735](https://github.com/eclipse/che/issues/1735)
- Cannot start a new workspace [\#1686](https://github.com/eclipse/che/issues/1686)
- Che doesn't use the configured DNS server [\#1684](https://github.com/eclipse/che/issues/1684)
- Error response from daemon: client is newer than server \(client API version: 1.23, server API version: 1.22\) [\#1636](https://github.com/eclipse/che/issues/1636)
- insufficient memory [\#1631](https://github.com/eclipse/che/issues/1631)
- Bluetooth over USB on OSX 10.11.4 - VirtualBox Settings [\#1611](https://github.com/eclipse/che/issues/1611)
- Intellisense not work [\#1610](https://github.com/eclipse/che/issues/1610)
- org.eclipse.che.ide.websocket.WebSocketException: WebSocket is not opened. [\#1604](https://github.com/eclipse/che/issues/1604)
- How to restore workspaces when restarting Che? [\#1561](https://github.com/eclipse/che/issues/1561)
- \[languageserver\] Rename Refactoring [\#1424](https://github.com/eclipse/che/issues/1424)
- \[languageserver\] Goto Definition [\#1423](https://github.com/eclipse/che/issues/1423)
- \[languageserver\] hover provider [\#1422](https://github.com/eclipse/che/issues/1422)
- Callbacks send to WsAgentStateController\#getMessageBus ignored [\#1413](https://github.com/eclipse/che/issues/1413)
- Release and ship Che 4.6.0 [\#2012](https://github.com/eclipse/che/issues/2012)
- Not able to run Che as a Docker Container on OSX [\#1976](https://github.com/eclipse/che/issues/1976)
- Machine recipe not editable [\#1967](https://github.com/eclipse/che/issues/1967)
- Parameterized Vagrantfile: Make Virtualbox Machine name configurable [\#1965](https://github.com/eclipse/che/issues/1965)
- Add instructions in new Che launcher how to get Che server logs [\#1951](https://github.com/eclipse/che/issues/1951)
- Stop of Che container in new Che launcher is broken [\#1949](https://github.com/eclipse/che/issues/1949)
- Unable to copy public key from SSH prefs [\#1938](https://github.com/eclipse/che/issues/1938)
- Elements stops responding after clicking outside submenu in Firefox [\#1928](https://github.com/eclipse/che/issues/1928)
- Che Docker Launcher - Fails to Recognize Valid Server Boot [\#1924](https://github.com/eclipse/che/issues/1924)
- When restarting a workspace, open project tree re-appears as closed. [\#1919](https://github.com/eclipse/che/issues/1919)
- IDE resources caching from UD is broken [\#1909](https://github.com/eclipse/che/issues/1909)
- Cannot export a workspace from the Dashboard [\#1903](https://github.com/eclipse/che/issues/1903)
- Unexpected  errors in the browser console  after restarting a workspace [\#1902](https://github.com/eclipse/che/issues/1902)
- Copy and paste not working in the terminal [\#1899](https://github.com/eclipse/che/issues/1899)
- Cloning a VSTS repo feature does not work [\#1893](https://github.com/eclipse/che/issues/1893)
- Move che-plugin-java-jdt-core-repack module to che-lib [\#1887](https://github.com/eclipse/che/issues/1887)
- Milestone Summary 4.6.0 [\#1870](https://github.com/eclipse/che/issues/1870)
- If use the dashboard for import project from zip archive, the root folder of the archive don't skip [\#1852](https://github.com/eclipse/che/issues/1852)
- Opened files list in the editor area does not work properly [\#1850](https://github.com/eclipse/che/issues/1850)
- Che ignores user response when asks whether it should restore workspace or not [\#1849](https://github.com/eclipse/che/issues/1849)
- Change value of "java.output.folder" attribute [\#1843](https://github.com/eclipse/che/issues/1843)
- Add CI mechanisms for new Che Docker images [\#1842](https://github.com/eclipse/che/issues/1842)
- After closing the Project wizard widget by ESC select path form still opened [\#1825](https://github.com/eclipse/che/issues/1825)
- Delete multi-module projects in some case holding failure [\#1819](https://github.com/eclipse/che/issues/1819)
- Wrong behavior after configure folder with name 'java' as source  [\#1814](https://github.com/eclipse/che/issues/1814)
- Tree of 'changes to be performed' in the refactoring 'Rename' window does not work correctly [\#1786](https://github.com/eclipse/che/issues/1786)
- Preview URL may be lost after refreshing page [\#1785](https://github.com/eclipse/che/issues/1785)
- Automatically open the IDE after creating a project [\#1753](https://github.com/eclipse/che/issues/1753)

**Pull requests merged:**

- WIP: Add Native .bat and .sh scripts for Eclipse Che [\#2000](https://github.com/eclipse/che/pull/2000) ([TylerJewell](https://github.com/TylerJewell))
- \#1919: Save application state to the user profile correctly [\#1994](https://github.com/eclipse/che/pull/1994) ([vzhukovskii](https://github.com/vzhukovskii))
- Parameterize Vagrantfile: Make Virtualbox Machine name configurable [\#1966](https://github.com/eclipse/che/pull/1966) ([zenobios](https://github.com/zenobios))
- Add additional DEBUG info to che-launcher [\#1957](https://github.com/eclipse/che/pull/1957) ([TylerJewell](https://github.com/TylerJewell))
- Launcher: stop che-server cleanly \(fix \#1949\) [\#1956](https://github.com/eclipse/che/pull/1956) ([l0rd](https://github.com/l0rd))
- \#1814: Synchronize project instead of parent directory [\#1954](https://github.com/eclipse/che/pull/1954) ([vzhukovskii](https://github.com/vzhukovskii))
- fix dropdown-menu freezing [\#1948](https://github.com/eclipse/che/pull/1948) ([akurinnoy](https://github.com/akurinnoy))
- CHE-1797: Add JPA based SnapshotDao implementation [\#1937](https://github.com/eclipse/che/pull/1937) ([evoevodin](https://github.com/evoevodin))
- CHE-1935; add custom User-Agent header value for JGit; [\#1936](https://github.com/eclipse/che/pull/1936) ([mshaposhnik](https://github.com/mshaposhnik))
- \#1899: Add ability to copy and paste text in terminal view [\#1932](https://github.com/eclipse/che/pull/1932) ([vzhukovskii](https://github.com/vzhukovskii))
- Update IDE resource path after changes for namespace handling \(Fix \#1909\) [\#1931](https://github.com/eclipse/che/pull/1931) ([benoitf](https://github.com/benoitf))
- CHE-1785: save preview URL for the command [\#1930](https://github.com/eclipse/che/pull/1930) ([svor](https://github.com/svor))
- Allow to continue to start the script even if there is a chown failure [\#1917](https://github.com/eclipse/che/pull/1917) ([benoitf](https://github.com/benoitf))
- CHE-1825: fix problem with the window selection [\#1916](https://github.com/eclipse/che/pull/1916) ([svor](https://github.com/svor))
- \[Replaces \#1885\] Launcher: fixed Path problems, splitted in 3 files and added tests [\#1914](https://github.com/eclipse/che/pull/1914) ([l0rd](https://github.com/l0rd))
- CHE-1849: Modify start workspace by ID API method [\#1907](https://github.com/eclipse/che/pull/1907) ([vinokurig](https://github.com/vinokurig))
- \#1903: fix export a workspace from the Dashboard [\#1906](https://github.com/eclipse/che/pull/1906) ([akurinnoy](https://github.com/akurinnoy))
- CHE-1893; fix authorization flow during clone from private repo [\#1905](https://github.com/eclipse/che/pull/1905) ([mshaposhnik](https://github.com/mshaposhnik))
- CHE-1361 Artik: Resources monitor \(CPU, memory and storage\) [\#1904](https://github.com/eclipse/che/pull/1904) ([vitaliy-guliy](https://github.com/vitaliy-guliy))
- CHE-1843: change value of "java.output.folder" attribute [\#1901](https://github.com/eclipse/che/pull/1901) ([svor](https://github.com/svor))
- Launcher: fixed Path problems, splitted in 3 files and added tests [\#1898](https://github.com/eclipse/che/pull/1898) ([l0rd](https://github.com/l0rd))
- Fix the ENV about configuration folder to set when using docker image [\#1896](https://github.com/eclipse/che/pull/1896) ([benoitf](https://github.com/benoitf))
- Add docker image to grab the ip used by docker [\#1891](https://github.com/eclipse/che/pull/1891) ([benoitf](https://github.com/benoitf))
- che-launcher infer Che version and self destruct itself [\#1881](https://github.com/eclipse/che/pull/1881) ([l0rd](https://github.com/l0rd))
- CHE-1535: Reveal resources after move and copy operation [\#1877](https://github.com/eclipse/che/pull/1877) ([vzhukovskii](https://github.com/vzhukovskii))
- CHE-1819: fix NPE when unresolved project is deleted [\#1874](https://github.com/eclipse/che/pull/1874) ([svor](https://github.com/svor))
- Type fox issue 1413 [\#1873](https://github.com/eclipse/che/pull/1873) ([vparfonov](https://github.com/vparfonov))
- Add new parameters to build docker image method [\#1872](https://github.com/eclipse/che/pull/1872) ([mmorhun](https://github.com/mmorhun))
- \#1850: Remove closed file from the editor's popup list [\#1867](https://github.com/eclipse/che/pull/1867) ([vzhukovskii](https://github.com/vzhukovskii))
- CHE-1492: automatically open the IDE after creating a project [\#1863](https://github.com/eclipse/che/pull/1863) ([akurinnoy](https://github.com/akurinnoy))
- Downgrade docker installed in Che image [\#1833](https://github.com/eclipse/che/pull/1833) ([l0rd](https://github.com/l0rd))
- CHE-1504: \[dashboard\] fix bug in project template selection [\#1737](https://github.com/eclipse/che/pull/1737) ([akurinnoy](https://github.com/akurinnoy))
- Fix new alpine based Dockerfile for Boot2Docker [\#1723](https://github.com/eclipse/che/pull/1723) ([l0rd](https://github.com/l0rd))
- Use a docker launcher image to simplify start/stop/update/restart commands [\#1683](https://github.com/eclipse/che/pull/1683) ([l0rd](https://github.com/l0rd))
- CODENVY-651 Save machine config with 'dev' instead of 'isDev' field [\#1679](https://github.com/eclipse/che/pull/1679) ([mkuznyetsov](https://github.com/mkuznyetsov))
- CHE-1248 remove workspace information from EnvironmentContext [\#1658](https://github.com/eclipse/che/pull/1658) ([mshaposhnik](https://github.com/mshaposhnik))
- Update according to changes in everrest [\#1625](https://github.com/eclipse/che/pull/1625) ([mkuznyetsov](https://github.com/mkuznyetsov))

## [4.5.1](https://github.com/eclipse/che/tree/4.5.1) (2016-07-19)
[Full Changelog](https://github.com/eclipse/che/compare/4.5.0...4.5.1)

**Issues with no labels:**

- Create component to send heartbeat information from docker based Che [\#1835](https://github.com/eclipse/che/issues/1835)
- Can't authenticate on github [\#1694](https://github.com/eclipse/che/issues/1694)
- Cannot start workspace by using dashboard [\#1834](https://github.com/eclipse/che/issues/1834)

## [4.5.0](https://github.com/eclipse/che/tree/4.5.0) (2016-07-18)
[Full Changelog](https://github.com/eclipse/che/compare/4.4.2-artik...4.5.0)

**Issues with no labels:**

- The flow when loading IDE is flickering and ugly [\#1745](https://github.com/eclipse/che/issues/1745)
- \[dashboard\] Rework the grids and related behavior [\#1742](https://github.com/eclipse/che/issues/1742)
- Workspace should update project by path instead by name [\#1741](https://github.com/eclipse/che/issues/1741)
- \[Q\] Exposed ports in Dockerfile [\#1719](https://github.com/eclipse/che/issues/1719)
- Can't have multiple instances of Che container connected to same GitHub account [\#1716](https://github.com/eclipse/che/issues/1716)
- Docker for Windows Beta does not write workspaces and storage files to mounted drives [\#1711](https://github.com/eclipse/che/issues/1711)
- Anyone know why my che cannot find Virtual Box even though VBOX\_MSI\_INSTALL\_PATH is set in environment variable [\#1710](https://github.com/eclipse/che/issues/1710)
- Che nightly won't start on Docker for Mac [\#1708](https://github.com/eclipse/che/issues/1708)
- Che shows the incorrect view aftering rebuild /dashboard [\#1700](https://github.com/eclipse/che/issues/1700)
- Shared workspaces [\#1371](https://github.com/eclipse/che/issues/1371)

**Pull requests merged:**

- codenvy/che-file docker improvement [\#2037](https://github.com/eclipse/che/pull/2037) ([benoitf](https://github.com/benoitf))
- Bunch of changes for allowing to build on CI with Docker/Linux [\#2017](https://github.com/eclipse/che/pull/2017) ([benoitf](https://github.com/benoitf))
- fix dependency [\#1844](https://github.com/eclipse/che/pull/1844) ([akurinnoy](https://github.com/akurinnoy))
- CHE-1347: fix import project on dashboard from zip archive [\#1738](https://github.com/eclipse/che/pull/1738) ([akurinnoy](https://github.com/akurinnoy))
- CHE-1298; remove war name from url schema [\#1572](https://github.com/eclipse/che/pull/1572) ([mshaposhnik](https://github.com/mshaposhnik))
- CHE-394: Add ability to specify branch when cloning from GitHub [\#1430](https://github.com/eclipse/che/pull/1430) ([vinokurig](https://github.com/vinokurig))
- CHE-1208: add an ability to configure several source folders [\#1419](https://github.com/eclipse/che/pull/1419) ([svor](https://github.com/svor))
- CHE-1159: Add to Jgit implementation ability to view cloning process [\#1394](https://github.com/eclipse/che/pull/1394) ([vinokurig](https://github.com/vinokurig))

## [4.4.2-artik](https://github.com/eclipse/che/tree/4.4.2-artik) (2016-07-12)
[Full Changelog](https://github.com/eclipse/che/compare/4.4.2...4.4.2-artik)

**Issues with no labels:**

- oAuth settings in che.properties not getting picked up [\#1696](https://github.com/eclipse/che/issues/1696)
- Run on docker for windows [\#1695](https://github.com/eclipse/che/issues/1695)
- Error when starting workspace [\#1681](https://github.com/eclipse/che/issues/1681)
- Unable to open newly created workspaces [\#1666](https://github.com/eclipse/che/issues/1666)
- Unable to run the latest version assembly successfully [\#1665](https://github.com/eclipse/che/issues/1665)
- 404 error on creating workspace container. [\#1635](https://github.com/eclipse/che/issues/1635)
- Create a Deb/Rpm package to facilitate installation and configuration out of the box [\#1620](https://github.com/eclipse/che/issues/1620)
- Google Eclipse Plugin - is or will there be a GWT plugin for Che ? [\#1617](https://github.com/eclipse/che/issues/1617)
- Example showing syntax highlighting [\#1608](https://github.com/eclipse/che/issues/1608)
- Cant run "Che run" on hyper-V \(not using docker for windows, due windows 10 build\) [\#1593](https://github.com/eclipse/che/issues/1593)
- \[Codeenvy\] CORs issue [\#1481](https://github.com/eclipse/che/issues/1481)
- \[Codenvy\] New Project stuck at "Starting workspace runtime" [\#1480](https://github.com/eclipse/che/issues/1480)
- Workspace import/export [\#1468](https://github.com/eclipse/che/issues/1468)
- How to create and register a custom viewpart in Che workspace? [\#1446](https://github.com/eclipse/che/issues/1446)
- How to add a new view? [\#1433](https://github.com/eclipse/che/issues/1433)

## [4.4.2](https://github.com/eclipse/che/tree/4.4.2) (2016-07-06)
[Full Changelog](https://github.com/eclipse/che/compare/4.4.1...4.4.2)

## [4.4.1](https://github.com/eclipse/che/tree/4.4.1) (2016-07-05)
[Full Changelog](https://github.com/eclipse/che/compare/4.4.0...4.4.1)

**Issues with no labels:**

- Autocomplete for python? [\#1642](https://github.com/eclipse/che/issues/1642)
- Client has aborted connection. Response writing omitted. [\#1638](https://github.com/eclipse/che/issues/1638)
- run che on eclipse with tomcat [\#1630](https://github.com/eclipse/che/issues/1630)
- Ports not exposed when using Docker for Mac [\#1629](https://github.com/eclipse/che/issues/1629)
- Could not start workspace wksp-JavaEE. Reason: Error response from docker API, status: 404, message: Container command '/bin/sh' not found or does not exist. [\#1621](https://github.com/eclipse/che/issues/1621)
-  Can't create machine from snapshot. [\#1612](https://github.com/eclipse/che/issues/1612)
- download size [\#1602](https://github.com/eclipse/che/issues/1602)
- I want set a login [\#1601](https://github.com/eclipse/che/issues/1601)
- Failed build from source \(mvn clean install\) with devnation branch  [\#1598](https://github.com/eclipse/che/issues/1598)
- can not load openshift oauth [\#1597](https://github.com/eclipse/che/issues/1597)
- Not able to open Workspace in Chrome. Stuck in Loading.  [\#1596](https://github.com/eclipse/che/issues/1596)
- unzip:  cannot find or open /mnt/che/ws-agent.zip, /mnt/che/ws-agent.zip.zip or /mnt/che/ws-agent.zip.ZIP. [\#1595](https://github.com/eclipse/che/issues/1595)
- Create Workspace Dialog [\#1517](https://github.com/eclipse/che/issues/1517)

## [4.4.0](https://github.com/eclipse/che/tree/4.4.0) (2016-06-28)
[Full Changelog](https://github.com/eclipse/che/compare/4.3.5...4.4.0)

**Issues with no labels:**

- Is there a factory file? [\#1590](https://github.com/eclipse/che/issues/1590)

**Pull requests merged:**

- CHE-1314 Add loader during workspace snapshotting process [\#1503](https://github.com/eclipse/che/pull/1503) ([mkuznyetsov](https://github.com/mkuznyetsov))
- CHE-1142: \[dashboard\] improve project creation popup [\#1461](https://github.com/eclipse/che/pull/1461) ([akurinnoy](https://github.com/akurinnoy))
- CHE-1136. Show workspace start logs when workspace is in STARTING state [\#1355](https://github.com/eclipse/che/pull/1355) ([RomanNikitenko](https://github.com/RomanNikitenko))
- CHE-167: Improve java debugger for opening java files from external project modules. [\#1300](https://github.com/eclipse/che/pull/1300) ([AndrienkoAleksandr](https://github.com/AndrienkoAleksandr))

## [4.3.5](https://github.com/eclipse/che/tree/4.3.5) (2016-06-24)
[Full Changelog](https://github.com/eclipse/che/compare/4.3.4...4.3.5)

**Issues with no labels:**

- add shortcut for Quick Fix to editor [\#1570](https://github.com/eclipse/che/issues/1570)
- Cannot connect Agent when creating workspace: cannot find or open /mnt/che/ws-agent.zip [\#1554](https://github.com/eclipse/che/issues/1554)
- Document/support private SSH key [\#1540](https://github.com/eclipse/che/issues/1540)

## [4.3.4](https://github.com/eclipse/che/tree/4.3.4) (2016-06-22)
[Full Changelog](https://github.com/eclipse/che/compare/4.3.3...4.3.4)

**Issues with no labels:**

- Parameterize the Che Vagrantfile [\#1531](https://github.com/eclipse/che/issues/1531)
- Client has aborted connection. Response writing omitted.Help!  [\#1530](https://github.com/eclipse/che/issues/1530)

## [4.3.3](https://github.com/eclipse/che/tree/4.3.3) (2016-06-17)
[Full Changelog](https://github.com/eclipse/che/compare/4.3.2...4.3.3)

**Issues with no labels:**

- Codenvy beta installs the entire OS after container stopped, causing huge startup delays [\#1516](https://github.com/eclipse/che/issues/1516)
- Can't start machine ws-machine because machine recipe downloading failed. [\#1504](https://github.com/eclipse/che/issues/1504)

## [4.3.2](https://github.com/eclipse/che/tree/4.3.2) (2016-06-14)
[Full Changelog](https://github.com/eclipse/che/compare/4.3.1...4.3.2)

## [4.3.1](https://github.com/eclipse/che/tree/4.3.1) (2016-06-14)
[Full Changelog](https://github.com/eclipse/che/compare/4.3.0...4.3.1)

## [4.3.0](https://github.com/eclipse/che/tree/4.3.0) (2016-06-13)
[Full Changelog](https://github.com/eclipse/che/compare/4.3.0-RC1...4.3.0)

**Issues with no labels:**

- The latest code Compiling GWT Application failed [\#1485](https://github.com/eclipse/che/issues/1485)
- Is there any tutorial to introduce how to deploy Che in a farm to keep every user has their own Che instance [\#1475](https://github.com/eclipse/che/issues/1475)
- Github [\#1470](https://github.com/eclipse/che/issues/1470)
- Workspace ram [\#1469](https://github.com/eclipse/che/issues/1469)
- Browser JS error when starting agent [\#1462](https://github.com/eclipse/che/issues/1462)
- Question: port range to open in amazon instance [\#1457](https://github.com/eclipse/che/issues/1457)
- Terminal error on workspace creation [\#1445](https://github.com/eclipse/che/issues/1445)
- Commands not loading from new workspace. [\#1428](https://github.com/eclipse/che/issues/1428)

**Pull requests merged:**

- CODENVY-608: Close output consumer on destroy machine [\#1466](https://github.com/eclipse/che/pull/1466) ([vinokurig](https://github.com/vinokurig))
- CODENVY-595: add possibility to adjust machine swap size [\#1458](https://github.com/eclipse/che/pull/1458) ([riuvshin](https://github.com/riuvshin))
- Fix docker image reference parsing by DockerImageIdentifierParser [\#1420](https://github.com/eclipse/che/pull/1420) ([garagatyi](https://github.com/garagatyi))
- CHE-1196: Artik: Debugger hangs when debugging binaries using Artik SDK [\#1418](https://github.com/eclipse/che/pull/1418) ([tolusha](https://github.com/tolusha))
- CODENVY-566 make workspace export working again [\#1417](https://github.com/eclipse/che/pull/1417) ([benoitf](https://github.com/benoitf))
- CHE-1275: Add api endpoint into each non dev machine environment [\#1415](https://github.com/eclipse/che/pull/1415) ([akorneta](https://github.com/akorneta))
- CHE-1233: fix wrong behavior for ready-to-go-stacks selector [\#1411](https://github.com/eclipse/che/pull/1411) ([olexii4](https://github.com/olexii4))
- CODENVY-27; adapt machine sevice to workspace sharing [\#1409](https://github.com/eclipse/che/pull/1409) ([mshaposhnik](https://github.com/mshaposhnik))
- CHE-1231. Show/hide error messages after updating pom.xml [\#1398](https://github.com/eclipse/che/pull/1398) ([RomanNikitenko](https://github.com/RomanNikitenko))
- CODENVY-480 Remove user's roles [\#1336](https://github.com/eclipse/che/pull/1336) ([sleshchenko](https://github.com/sleshchenko))

## [4.3.0-RC1](https://github.com/eclipse/che/tree/4.3.0-RC1) (2016-06-04)
[Full Changelog](https://github.com/eclipse/che/compare/4.2.3...4.3.0-RC1)

**Issues with no labels:**

- AMI for che? [\#1416](https://github.com/eclipse/che/issues/1416)
- Stuck at 'Starting workspace agent' when Che server, Docker and browser are on the same machine [\#1412](https://github.com/eclipse/che/issues/1412)
- Workspace Not Loaded On Che Start [\#1410](https://github.com/eclipse/che/issues/1410)
- VPN + eclipse che :  workspace agent unable to ping the Che server [\#1408](https://github.com/eclipse/che/issues/1408)
- Artik IDE not reuseable [\#1381](https://github.com/eclipse/che/issues/1381)

## [4.2.3](https://github.com/eclipse/che/tree/4.2.3) (2016-05-25)
[Full Changelog](https://github.com/eclipse/che/compare/4.2.2...4.2.3)

## [4.2.2](https://github.com/eclipse/che/tree/4.2.2) (2016-05-12)
[Full Changelog](https://github.com/eclipse/che/compare/4.2.1...4.2.2)

## [4.2.1](https://github.com/eclipse/che/tree/4.2.1) (2016-04-27)
[Full Changelog](https://github.com/eclipse/che/compare/4.2.0...4.2.1)

## [4.2.0](https://github.com/eclipse/che/tree/4.2.0) (2016-04-25)
[Full Changelog](https://github.com/eclipse/che/compare/4.1.1...4.2.0)

## [4.1.1](https://github.com/eclipse/che/tree/4.1.1) (2016-04-15)
[Full Changelog](https://github.com/eclipse/che/compare/4.1.0...4.1.1)

## [4.1.0](https://github.com/eclipse/che/tree/4.1.0) (2016-04-08)
[Full Changelog](https://github.com/eclipse/che/compare/4.0.1...4.1.0)

## [4.0.1](https://github.com/eclipse/che/tree/4.0.1) (2016-03-29)
[Full Changelog](https://github.com/eclipse/che/compare/4.0.0...4.0.1)

## [4.0.0](https://github.com/eclipse/che/tree/4.0.0) (2016-03-29)
[Full Changelog](https://github.com/eclipse/che/compare/4.0.0-RC14...4.0.0)

## [4.0.0-RC14](https://github.com/eclipse/che/tree/4.0.0-RC14) (2016-03-23)
[Full Changelog](https://github.com/eclipse/che/compare/4.0.0-RC13...4.0.0-RC14)

## [4.0.0-RC13](https://github.com/eclipse/che/tree/4.0.0-RC13) (2016-03-09)
[Full Changelog](https://github.com/eclipse/che/compare/4.0.0-RC12...4.0.0-RC13)

## [4.0.0-RC12](https://github.com/eclipse/che/tree/4.0.0-RC12) (2016-03-06)
[Full Changelog](https://github.com/eclipse/che/compare/4.0.0-RC11...4.0.0-RC12)

## [4.0.0-RC11](https://github.com/eclipse/che/tree/4.0.0-RC11) (2016-03-03)
[Full Changelog](https://github.com/eclipse/che/compare/4.0.0-RC10...4.0.0-RC11)

## [4.0.0-RC10](https://github.com/eclipse/che/tree/4.0.0-RC10) (2016-03-02)
[Full Changelog](https://github.com/eclipse/che/compare/4.0.0-RC9...4.0.0-RC10)

## [4.0.0-RC9](https://github.com/eclipse/che/tree/4.0.0-RC9) (2016-03-01)
[Full Changelog](https://github.com/eclipse/che/compare/4.0.0-RC8...4.0.0-RC9)

## [4.0.0-RC8](https://github.com/eclipse/che/tree/4.0.0-RC8) (2016-02-28)
[Full Changelog](https://github.com/eclipse/che/compare/4.0.0-RC7...4.0.0-RC8)

## [4.0.0-RC7](https://github.com/eclipse/che/tree/4.0.0-RC7) (2016-02-25)
[Full Changelog](https://github.com/eclipse/che/compare/4.0.0-RC6...4.0.0-RC7)

## [4.0.0-RC6](https://github.com/eclipse/che/tree/4.0.0-RC6) (2016-02-20)
[Full Changelog](https://github.com/eclipse/che/compare/4.0.0-RC5...4.0.0-RC6)

## [4.0.0-RC5](https://github.com/eclipse/che/tree/4.0.0-RC5) (2016-02-18)
[Full Changelog](https://github.com/eclipse/che/compare/4.0.0-RC4...4.0.0-RC5)

## [4.0.0-RC4](https://github.com/eclipse/che/tree/4.0.0-RC4) (2016-02-15)


\* *This Change Log was automatically generated by [github_changelog_generator](https://github.com/skywinder/Github-Changelog-Generator)*
