# Eclipse Che - Eclipse Next-Generation IDE
[![Eclipse License](https://img.shields.io/badge/license-Eclipse-brightgreen.svg)](https://github.com/codenvy/che/blob/master/LICENSE)
[![Build Status](https://ci.codenvycorp.com/buildStatus/icon?job=che-master-ci)](https://ci.codenvycorp.com/job/che-master-ci)
<a href="https://sonarcloud.io/dashboard?id=org.eclipse.che%3Ache-parent%3Amaster">
<img src="https://sonarcloud.io/images/project_badges/sonarcloud-black.svg" width="94" height="20" href="" />
</a>


https://www.eclipse.org/che/. Next-generation Eclipse platform, developer workspace server and cloud IDE. Che is focused on container-native development. It defines workspaces that include their dependencies including embedded containerized runtimes, a web IDE, and project code. This makes workspaces distributed, collaborative, and portable to run anywhere on a desktop or a server ... [Read More](https://www.eclipse.org/che/features/)

![Eclipse Che](https://www.eclipse.org/che/images/hero-technology-v2@2x.png "Eclipse Che")

### Getting Started
You can run Che in the public cloud, a private cloud, or install it on any OS. Che has been tested on Ubuntu, Linux, MacOS and Windows. The [step by step guide](https://eclipse.org/che/getting-started/) will get you going along with [our docs](https://www.eclipse.org/che/docs/).

The `che` repository is where we do development and there are many ways you can participate, for example:

- [Submit bugs and feature requests](https://github.com/eclipse/che/issues) and help us verify them
- Review [source code changes](https://github.com/eclipse/che/pulls)
- [Improve docs](https://github.com/codenvy/che-docs)

### Customizing
There are many ways to customize Che out-of-the-box including [stacks, templates, commands, IDE extensions, server-side extensions plugins, assemblies, RESTful APIs, and editors](https://github.com/eclipse/che/blob/master/CUSTOMIZING.md). 

### Contributing
If you are interested in fixing issues and contributing directly to the code base, please see [How to Contribute](https://github.com/eclipse/che/wiki/How-To-Contribute). It covers:
- [Submitting bugs](https://github.com/eclipse/che/wiki/Submitting-Bugs-and-Suggestions)
- [Development workflow](https://github.com/eclipse/che/wiki/Development-Workflow)
- [Coding guidelines](https://github.com/eclipse/che/wiki/Coding-Guidelines)
- [Contributor license agreement](https://github.com/eclipse/che/wiki/Contributor-License-Agreement)

### Ecosystem
The next generation of Eclipse Che is going to be built from multiple components and plugins (learn more in [the roadmap](https://github.com/eclipse/che/wiki/Roadmap) on the wiki). This list provides links to those components and plugins.

| Project        | Description  |
| ----------- |-----|
| [Theia-IDE](https://github.com/theia-ide/theia) | Theia IDE integrated in Che.  |
| [GitHub Plugin](https://github.com/eclipse/che-theia-github-plugin) | GitHub VCS support.  |
| [Java Plugin](https://github.com/eclipse/che-theia-java-plugin) | Java language support. |
| [SSH Plugin](https://github.com/eclipse/che-theia-ssh-plugin) | SSH public/private key pairs management. |
| [Terminal Plugin](https://github.com/eclipse/che-theia-terminal-plugin) | Terminal plugin. |
| [Machines Plugin](https://github.com/eclipse/che-theia-machines-plugin)| Workspace's containers controller plugin. |
| [Hosted plugin manager](https://github.com/eclipse/che-theia-hosted-plugin-manager-extension)| IDE hosting handler for url changing and port forwarding. |

### Feedback
* **Support:** You can ask questions, report bugs, and request features using [GitHub issues](https://github.com/eclipse/che/issues).
* **Public Chat:** Join the public [eclipse-che](https://mattermost.eclipse.org/eclipse/channels/eclipse-che) Mattermost channel to discuss with community and contributors.
* **Roadmap:** We maintain [the roadmap](https://github.com/eclipse/che/wiki/Roadmap) on the wiki. 
* **Weekly Meetings:** Join us in our [Che community meeting](https://github.com/eclipse/che/wiki/Che-Dev-Meetings) every second monday.

### License
Che is open sourced under the Eclipse Public License 2.0.

### Roadmap and Community Meetings
We publish the [Che roadmap](https://github.com/eclipse/che/wiki/Roadmap) in the open and welcome anyone to join our [community meetings](https://github.com/eclipse/che/wiki/Che-Dev-Meetings). We love to hear from users and developers!
