/*
 * Copyright (c) 2012-2018 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
package org.eclipse.che.ide.api.editor.texteditor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import org.eclipse.che.ide.api.editor.EditorWithErrors;
import org.eclipse.che.ide.api.editor.codeassist.CompletionsSource;
import org.eclipse.che.ide.api.editor.keymap.Keymap;
import org.eclipse.che.ide.api.editor.text.TextPosition;

/**
 * View interface for the text editors components.
 *
 * @author "Mickaël Leduque"
 */
public interface TextEditorPartView extends RequiresResize, IsWidget, HasNotificationPanel {

  /**
   * Invoke the code complete dialog.
   *
   * @param editorWidget the editor widget
   * @param completionsSource the completion source
   */
  void showCompletionProposals(EditorWidget editorWidget, CompletionsSource completionsSource);

  /**
   * Invoke the code complete dialog with default completion.
   *
   * @param editorWidget the editor widget
   */
  void showCompletionProposals(EditorWidget editorWidget);

  /**
   * Sets the view delegate.
   *
   * @param delegate the delegate
   */
  void setDelegate(Delegate delegate);

  /**
   * Sets the editor widget.
   *
   * @param editorWidget the widget
   */
  void setEditorWidget(EditorWidget editorWidget);

  /**
   * Display a placeholder in place of the editor widget.
   *
   * @param placeHolder the widget to display
   */
  void showPlaceHolder(Widget placeHolder);

  /**
   * Sets whether the info panel is visible.
   *
   * @param visible {@code true} to show the info panel, {@code false} to hide it
   */
  void setInfoPanelVisible(boolean visible);

  /**
   * Sets the initial state of the info panel.
   *
   * @param mode the file mode
   * @param keymap the current keymap
   * @param lineCount the number of lines
   * @param tabSize the tab size in this editor
   */
  void initInfoPanel(String mode, Keymap keymap, int lineCount, int tabSize);

  /**
   * Update the location displayed in the info panel.
   *
   * @param position the new position
   */
  void updateInfoPanelPosition(TextPosition position);

  /**
   * Update the values in the info panel for when the editor is not focused (i.e. show line count
   * and not char part).
   *
   * @param lineCount the number of lines in the file
   */
  void updateInfoPanelUnfocused(int lineCount);

  /** Delegate interface for this view. */
  interface Delegate extends EditorWithErrors, RequiresResize {
    /** Reaction on loss of focus. */
    void editorLostFocus();

    /** Reaction when the editor gains focus. */
    void editorGotFocus();

    /** Reaction when the cursor position changes. */
    void editorCursorPositionChanged();
  }
}
