/*
 * Copyright (c) 2012-2018 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
package org.eclipse.che.ide.api.project.type;

import java.util.List;
import org.eclipse.che.api.project.shared.dto.ProjectTypeDto;
import org.eclipse.che.commons.annotation.Nullable;

/** Registry of project types. */
public interface ProjectTypeRegistry {

  List<ProjectTypeDto> getProjectTypes();

  @Nullable
  ProjectTypeDto getProjectType(String id);
}
