/*
 * Copyright (c) 2012-2018 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
package org.eclipse.che.ide.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import org.eclipse.che.ide.bootstrap.IdeBootstrap;
import org.eclipse.che.ide.client.inject.IDEInjector;

/** The EntryPoint of the IDE application */
public class IDE implements EntryPoint {
  /** This is the entry point method. */
  @Override
  public void onModuleLoad() {
    IDEInjector injector = GWT.create(IDEInjector.class);
    @SuppressWarnings("unused")
    IdeBootstrap bootstrap = injector.getIdeBootstrap();
  }
}
