/*
 * Copyright (c) 2012-2018 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
package org.eclipse.che.ide.statepersistance;

import com.google.gwt.inject.client.AbstractGinModule;
import com.google.gwt.inject.client.multibindings.GinMultibinder;
import org.eclipse.che.ide.api.statepersistance.AppStateServiceClient;
import org.eclipse.che.ide.api.statepersistance.StateComponent;
import org.eclipse.che.ide.editor.EditorAgentImpl;
import org.eclipse.che.ide.part.explorer.project.ProjectExplorerStateComponent;
import org.eclipse.che.ide.workspace.WorkspacePresenter;

/** GIN module for configuring Persistence API components. */
public class PersistenceApiModule extends AbstractGinModule {

  @Override
  protected void configure() {
    bind(AppStateTracker.class).asEagerSingleton();
    bind(AppStateManager.class).asEagerSingleton();
    bind(AppStateServiceClient.class).to(AppStateServiceClientImpl.class);

    GinMultibinder<StateComponent> stateComponents =
        GinMultibinder.newSetBinder(binder(), StateComponent.class);
    stateComponents.addBinding().to(WorkspacePresenter.class);
    stateComponents.addBinding().to(EditorAgentImpl.class);
    stateComponents.addBinding().to(ProjectExplorerStateComponent.class);
  }
}
