/*
 * Copyright (c) 2012-2018 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
package org.eclipse.che.api.git;

/** @author <a href="mailto:evoevodin@codenvy.com">Eugene Voevodin</a> */
public class UserCredential {

  public static final UserCredential EMPTY_CREDENTIALS = new UserCredential("", "", "");
  private final String userName;
  private final String password;
  private final String providerId;

  public UserCredential(String userName, String password, String providerId) {
    this.userName = userName;
    this.password = password;
    this.providerId = providerId;
  }

  public String getUserName() {
    return userName;
  }

  public String getPassword() {
    return password;
  }

  public String getProviderId() {
    return providerId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    UserCredential that = (UserCredential) o;

    if (password != null ? !password.equals(that.password) : that.password != null) return false;
    if (providerId != null ? !providerId.equals(that.providerId) : that.providerId != null)
      return false;
    if (userName != null ? !userName.equals(that.userName) : that.userName != null) return false;

    return true;
  }

  @Override
  public int hashCode() {
    int result = userName != null ? userName.hashCode() : 0;
    result = 31 * result + (password != null ? password.hashCode() : 0);
    result = 31 * result + (providerId != null ? providerId.hashCode() : 0);
    return result;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("UserCredential{");
    sb.append("userName='").append(userName).append('\'');
    sb.append(", password='").append(password).append('\'');
    sb.append(", providerId='").append(providerId).append('\'');
    sb.append('}');
    return sb.toString();
  }
}
