(*  Title:      PSL/SeLFiE/SeLFiE.thy
 *  Author:     Yutaka Nagashima, Czech Technical University in Prague, the University of Innsbruck
 *
 * Examples about rev and itrev were originally developed by Tobias Nipkow and Gerwin Klein
 * as Isabelle theory files accompanying their book "Concrete Semantics".
 *
 * The PDF file of the book and the original Isabelle theory files are available
 * at the following website:
 *   http://concrete-semantics.org/index.html
 *
 * MeLoId: Machine Learning Induction for Isabelle/HOL, and
 * LiFtEr: Logical Feature Extractor.
 * SeLFiE: Semantic Logical Feature Extractor.
 *)
theory SeLFiE
  imports "Pure"
  keywords "assert_SeLFiE_true"          :: diag
  and      "assert_SeLFiE_false"         :: diag
  and      "smart_induct"                :: diag
  and      "sem_ind"                     :: diag
  and      "all_induction_heuristic"     :: diag
  and      "all_generalization_heuristic":: diag
begin

(* pre-processing *)
ML_file "Definition_Pattern.ML"
ML_file "Util.ML"
ML_file "Unique_Node.ML"
ML_file "Unique_Node_Test.ML"
ML_file "Path_Table_And_Print_Table.ML"
ML_file "Term_Table.ML"
(* This Term_Table_Test works only in the interactive mode.
ML_file "Term_Table_Test.ML"
*)

ML_file "Dynamic_Induct.ML"

ML_file "Eval_Bool.ML"
ML_file "Eval_Number.ML"
ML_file "Eval_Node.ML"
ML_file "Eval_Unode.ML"
ML_file "Eval_Print.ML"

ML_file "Path_To_Unode.ML"  (*The bifurcation of "inner" and "outer" starts here.*)
ML_file "Print_To_Paths.ML"

ML\<open> structure Print_To_Inner_Paths = from_Path_Table_and_Path_To_Unode_to_Print_To_Paths(Inner_Path_Table): PRINT_TO_PATHS; \<close>
ML\<open> structure Print_To_Outer_Paths = from_Path_Table_and_Path_To_Unode_to_Print_To_Paths(Outer_Path_Table): PRINT_TO_PATHS; \<close>

ML_file "Eval_Path.ML"
ML_file "Eval_Parameter.ML"
ML_file "Eval_Parameter_With_Bool.ML"
ML_file "Quantifier_Domain.ML"
ML_file "Eval_Unary.ML"
ML_file "Eval_Multi_Arity.ML"
ML_file "Eval_Variable.ML"
ML_file "Eval_Surface.ML"
ML_file "Eval_Syntactic_Sugar.ML"

ML_file "Smart_Construction.ML"
ML_file "Screening.ML"

ML_file "Parser_Combinator.ML"
ML_file "Apply_SeLFiE.ML"
ML_file "Assertion_Test.ML"
ML_file "Assertion_Induction.ML"
ML_file "Assertion_Generalization.ML"

ML\<open> Apply_SeLFiE.activate (); \<close>

(* test *)
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "heuristic_1"                                                                                                                        ) (Assertion_Test.heuristic_1                                                                                                                        , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "heuristic_2"                                                                                                                        ) (Assertion_Test.heuristic_2                                                                                                                        , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "heuristic_3"                                                                                                                        ) (Assertion_Test.heuristic_3                                                                                                                        , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "heuristic_4"                                                                                                                        ) (Assertion_Test.heuristic_4                                                                                                                        , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "heuristic_5"                                                                                                                        ) (Assertion_Test.heuristic_5                                                                                                                        , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "heuristic_6"                                                                                                                        ) (Assertion_Test.heuristic_6                                                                                                                        , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "heuristic_7"                                                                                                                        ) (Assertion_Test.heuristic_7                                                                                                                        , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "heuristic_8"                                                                                                                        ) (Assertion_Test.heuristic_8                                                                                                                        , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "heuristic_9"                                                                                                                        ) (Assertion_Test.heuristic_9                                                                                                                        , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "heuristic_10"                                                                                                                       ) (Assertion_Test.heuristic_10                                                                                                                       , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "heuristic_11"                                                                                                                       ) (Assertion_Test.heuristic_11                                                                                                                       , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "heuristic_12"                                                                                                                       ) (Assertion_Test.heuristic_12                                                                                                                       , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "heuristic_13"                                                                                                                       ) (Assertion_Test.heuristic_13                                                                                                                       , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "heuristic_14"                                                                                                                       ) (Assertion_Test.heuristic_14                                                                                                                       , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "lifter_1"     (*not good enough for smart_induction_2*)                                                                             ) (Assertion_Test.lifter_1                                                                                                                           , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "lifter_1b"    (*not good enough for smart_induction_2*)                                                                             ) (Assertion_Test.lifter_1b                                                                                                                          , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "lifter_2"                                                                                                                           ) (Assertion_Test.lifter_2                                                                                                                           , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "lifter_3"                                                                                                                           ) (Assertion_Test.lifter_3                                                                                                                           , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "lifter_4"     (*not good enough for smart_induction_2 because it is based solely on pattern-matching on the LHS*)                   ) (Assertion_Test.lifter_4                                                                                                                           , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "lifter_9"                                                                                                                           ) (Assertion_Test.lifter_9                                                                                                                           , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "lifter_13"    (*may be harmful: no arbitrary is at the same relative location as induction in terms of a function. See sorted_wrt_dist_take_drop in Nearest_Neighbors.thy, for example.*)) (Assertion_Test.lifter_13                                                                     , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "lifter_14"    (*obsolete because of smart construction*)                                                                            ) (Assertion_Test.lifter_14                                                                                                                          , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "test_dive_in"                                                                                                                       ) (Assertion_Test.test_dive_in                                                                                                                       , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "print_all_outer_prints"                                                                                                             ) (Assertion_Test.print_all_outer_prints                                                                                                             , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "print_all_inner_prints"                                                                                                             ) (Assertion_Test.print_all_inner_prints                                                                                                             , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "print_all_unodes"                                                                                                                   ) (Assertion_Test.print_all_unodes                                                                                                                   , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "print_outer_path_root"                                                                                                              ) (Assertion_Test.print_outer_path_root                                                                                                              , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "print_inner_roots"                                                                                                                  ) (Assertion_Test.print_inner_roots                                                                                                                  , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "print_all_inner_lhss"                                                                                                               ) (Assertion_Test.print_all_inner_lhss                                                                                                               , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "print_fst_params_of_fun_const"                                                                                                      ) (Assertion_Test.print_fst_params_of_fun_const                                                                                                      , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "test_is_a_meta_premise"                                                                                                             ) (Assertion_Test.test_is_a_meta_premise                                                                                                             , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "test_is_a_meta_conclusion"                                                                                                          ) (Assertion_Test.test_is_a_meta_conclusion                                                                                                          , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "test_is_a_meta_premise_or_below"                                                                                                    ) (Assertion_Test.test_is_a_meta_premise_or_below                                                                                                    , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "test_is_a_meta_conclusion_or_below"                                                                                                 ) (Assertion_Test.test_is_a_meta_conclusion_or_below                                                                                                 , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "test_is_more_than"                                                                                                                  ) (Assertion_Test.test_is_more_than                                                                                                                  , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "for_all_arbs_there_should_be_a_change_simplified_for_presentation"                                                                  ) (Assertion_Test.for_all_arbs_there_should_be_a_change_simplified_for_presentation                                                                  , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "test_Is_If_Then_Else"                                                                                                               ) (Assertion_Test.test_Is_If_Then_Else                                                                                                               , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "test_Is_Subprint_Of_true"                                                                                                           ) (Assertion_Test.test_Is_Subprint_Of_true                                                                                                           , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "test_Is_Subprint_Of_false"                                                                                                          ) (Assertion_Test.test_Is_Subprint_Of_false                                                                                                          , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "test_Is_Case_Distinct_Of_Trm_With_A_Case"                                                                                           ) (Assertion_Test.test_Is_Case_Distinct_Of_Trm_With_A_Case                                                                                           , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "test_Is_Let_X_Be_Y_In_X"                                                                                                            ) (Assertion_Test.test_Is_Let_X_Be_Y_In_X                                                                                                            , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,(*no good*)"structural_induction_on_nt_arg_of_inductively_defined_constant_in_the_concl_of_meta_imp_if_nth_arg_shrinks_in_def_of_constant_outer") (Assertion_Test.structural_induction_on_nt_arg_of_inductively_defined_constant_in_the_concl_of_meta_imp_if_nth_arg_shrinks_in_def_of_constant_outer, 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic,           "generalize_all_free_var_not_inducted_on" (*bad*)                                                                                    ) (Assertion_Test.generalize_all_free_var_not_inducted_on                                                                                            , 1.0) \<close>


(* induct *)
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "lifter2_improved"                                                                                                                   ) (Assertion_Induct.lifter2_improved                                                                                                                     , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "lifter_3_improved"                                                                                                                  ) (Assertion_Induct.lifter_3_improved                                                                                                                    , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "lifter_5"     (*may be obsolete due to smart_construction, may be harmful for lacking generalization *)                             ) (Assertion_Induct.lifter_5                                                                                                                             , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "lifter_7"                                                                                                                           ) (Assertion_Induct.lifter_7                                                                                                                             , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "lifter_8"                                                                                                                           ) (Assertion_Induct.lifter_8                                                                                                                             , 5.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "lifter_9_improved"                                                                                                                  ) (Assertion_Induct.lifter_9_improved                                                                                                                    , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "lifter_11"    (*may be harmful*)                                                                                                    ) (Assertion_Induct.lifter_11                                                                                                                            , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "lifter_15"    (*TODO: test the heuristic*)                                                                                          ) (Assertion_Induct.lifter_15                                                                                                                            , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "lifter_20"    (*rule inversion on a function in a premise*)(*TODO: test*)                                                           ) (Assertion_Induct.lifter_20                                                                                                                            , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "is_defined_recursively_on_nth"                                                                                                      ) (Assertion_Induct.is_defined_recursively_on_nth_outer                                                                                                  , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "if_part_of_lhs_n_part_of_rhs_of_eq_is_induct_then_induct_on_part_of_lhs"                                                            ) (Assertion_Induct.if_part_of_lhs_n_part_of_rhs_of_eq_is_induct_then_induct_on_part_of_lhs                                                              , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "outer_induct_on_arg_of_set_member_n_set_outer"                                                                                      ) (Assertion_Induct.outer_induct_on_arg_of_set_member_n_set_outer                                                                                        , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "induct_on_arg_of_set_member_n_set_syntax_only"                                                                                      ) (Assertion_Induct.induct_on_arg_of_set_member_n_set_syntax_only                                                                                        , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "induct_on_2nd_arg_of_map_outer"                                                                                                     ) (Assertion_Induct.induct_on_2nd_arg_of_map_outer                                                                                                       , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "structural_induction_on_an_arg_of_inductive_defined_constant_in_the_concl_of_meta_imp"                                              ) (Assertion_Induct.structural_induction_on_an_arg_of_inductive_defined_constant_in_the_concl_of_meta_imp                                                , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "rule_inversion_using_the_deepest_const"                                                                                             ) (Assertion_Induct.rule_inversion_using_the_deepest_const                                                                                               , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "complex_lhs_causes_functional_induction_outer"                                                                                      ) (Assertion_Induct.complex_lhs_causes_functional_induction_outer                                                                                        , 2.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "is_defined_recursively_on_nth_n_mth_by_two_funs"                                                                                    ) (Assertion_Induct.is_defined_recursively_on_nth_n_mth_by_two_funs                                                                                      , 2.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "if_part_of_lhs_n_part_of_rhs_of_eq_is_induct_rule_then_induct_rule_on_part_of_lhs"                                                  ) (Assertion_Induct.if_part_of_lhs_n_part_of_rhs_of_eq_is_induct_rule_then_induct_rule_on_part_of_lhs                                                    , 2.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "all_ind_should_be_atom"                                                                                                             ) (Assertion_Induct.all_ind_should_be_atom                                                                                                               , 2.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "if_rule_induct_using_const_defined_with_inductive_set_in_snd_argument_of_membership_then_induct_on_var_in_fst_argument_of_membership") (Assertion_Induct.if_rule_induct_using_const_defined_with_inductive_set_in_snd_argument_of_membership_then_induct_on_var_in_fst_argument_of_membership, 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "if_defined_with_inductive_set_in_meta_premise_then_set_induction"                                                                   ) (Assertion_Induct.if_defined_with_inductive_set_in_meta_premise_then_set_induction                                                                     , 10.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "trancl_induct"                                                                                                                      ) (Assertion_Induct.trancl_induct                                                                                                                        , 7.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "tranclp_induct"                                                                                                                     ) (Assertion_Induct.tranclp_induct                                                                                                                       , 7.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "rtrancl_induct"                                                                                                                     ) (Assertion_Induct.rtrancl_induct                                                                                                                       , 7.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "rtranclp_induct"                                                                                                                    ) (Assertion_Induct.rtranclp_induct                                                                                                                      , 7.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "trancl_induct2"                                                                                                                     ) (Assertion_Induct.trancl_induct2                                                                                                                       , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "tranclp_induct2"                                                                                                                    ) (Assertion_Induct.tranclp_induct2                                                                                                                      , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "rtrancl_induct2"                                                                                                                    ) (Assertion_Induct.rtrancl_induct2                                                                                                                      , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "rtranclp_induct2"                                                                                                                   ) (Assertion_Induct.rtranclp_induct2                                                                                                                     , 1.0) \<close>
(* Somehow this assertion does not work well when tested against listsetI_nth in Rep_Fin_Groups.thy *)
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "if_two_occs_of_length_or_size_in_assum_or_chained_fact_then_list_induct2"                                                           ) (Assertion_Induct.if_two_occs_of_length_or_size_in_assum_or_chained_fact_then_list_induct2                                                             , 4.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "rule_is_list_induct2'"                                                                                                              ) (Assertion_Induct.rule_is_list_induct2'                                                                                                                , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "if_list_all2_then_list_all2_induct"                                                                                                 ) (Assertion_Induct.if_list_all2_then_list_all2_induct                                                                                                   , 4.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "if_list_induct2'_then_two_induct_terms"                                                                                             ) (Assertion_Induct.if_list_induct2'_then_two_induct_terms                                                                                               , 3.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "if_not_equal_in_premise_or_chained_then_rev_nonempty_induct"                                                                        ) (Assertion_Induct.if_not_equal_in_premise_or_chained_then_rev_nonempty_induct                                                                          , 3.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "if_less_eq_in_premise_or_chained_but_not_nonempty_induct_then_inc_induct"                                                           ) (Assertion_Induct.if_less_eq_in_premise_or_chained_but_not_nonempty_induct_then_inc_induct                                                             , 5.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Induction_Heuristic,      "if_less_or_less_eq_in_premise_or_chained_but_not_nonempty_induct_then_less_induct"                                                  ) (Assertion_Induct.if_less_or_less_eq_in_premise_or_chained_but_not_nonempty_induct_then_less_induct                                                    , 4.0) \<close>

(* generalization *)
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Generalization_Heuristic, "lifter_6"                                                                                                                           ) (Assertion_Generalization.lifter_6                                                                                                                         , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Generalization_Heuristic, "lifter_10"                                                                                                                          ) (Assertion_Generalization.lifter_10                                                                                                                        , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Generalization_Heuristic, "lifter_12"                                                                                                                          ) (Assertion_Generalization.lifter_12                                                                                                                        , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Generalization_Heuristic, "generalize_arguments_used_in_recursion"                                                                                             ) (Assertion_Generalization.generalize_arguments_used_in_recursion                                                                                           , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Generalization_Heuristic, "for_all_arbs_there_should_be_a_change"                                                                                              ) (Assertion_Generalization.for_all_arbs_there_should_be_a_change                                                                                            , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Generalization_Heuristic, "ind_on_lhs_of_eq_then_arb_on_rhs_of_eq"                                                                                             ) (Assertion_Generalization.ind_on_lhs_of_eq_then_arb_on_rhs_of_eq                                                                                           , 1.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Generalization_Heuristic, "if_rule_induction_then_no_generalization"                                                                                           ) (Assertion_Generalization.if_rule_induction_then_no_generalization                                                                                         , 0.0) \<close>
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Generalization_Heuristic, "no_arb_has_occ_as_argument_of_all_occ_of_functional_induction"                                                                      ) (Assertion_Generalization.no_arb_has_occ_as_argument_of_all_occ_of_functional_induction                                                                    , 3.0) \<close>
(*good but expensive
setup\<open> Apply_SeLFiE.update_assert (Apply_SeLFiE.Test_Heuristic (*Generalization_Heuristic but expensive*) , "generalize_arguments_used_in_recursion_deep"                                                      ) (SeLFiE_Assertion.generalize_arguments_used_in_recursion_deep                                                                                          , 3.0) \<close>*)

end