(* Property from Case-Analysis for Rippling and Inductive Proof, 
   Moa Johansson, Lucas Dixon and Alan Bundy, ITP 2010. 
   This Isabelle theory is produced using the TIP tool offered at the following website: 
     https://github.com/tip-org/tools 
   This file was originally provided as part of TIP benchmark at the following website:
     https://github.com/tip-org/benchmarks 
   Yutaka Nagashima at CIIRC, CTU changed the TIP output theory file slightly 
   to make it compatible with Isabelle2017.
   Some proofs were added by Yutaka Nagashima.*)
theory TIP_prop_19
  imports "../../Test_Base"
begin

datatype 'a list = nil2 | cons2 "'a" "'a list"

datatype Nat = Z | S "Nat"

fun len :: "'a list => Nat" where
  "len (nil2) = Z"
| "len (cons2 y xs) = S (len xs)"

fun drop :: "Nat => 'a list => 'a list" where
  "drop (Z) y = y"
| "drop (S z) (nil2) = nil2"
| "drop (S z) (cons2 x2 x3) = drop z x3"

fun t2 :: "Nat => Nat => Nat" where
  "t2 (Z) y = Z"
| "t2 (S z) (Z) = S z"
| "t2 (S z) (S x2) = t2 z x2"

theorem property0 :
  "((len (drop n xs)) = (t2 (len xs) n))"
  apply(induct xs arbitrary:n)(*This "arbitrary:n" is mandatory.*)
   apply clarsimp(*This clarsimp is optional.*)
   apply(induct_tac n)(*"induct_tac" instead of "induct" because of "\<And>n"*)
    apply fastforce+
  apply clarsimp(*This clarsimp is optional.*)
  apply(induct_tac n)(*"induct_tac" instead of "induct" because of "\<And>n"*)
   apply fastforce+
  done

(*It is also a valid choice to start with induction on n.*)
theorem property0' :
  "((len (drop n xs)) = (t2 (len xs) n))"
  apply(induct n arbitrary:xs)(*This "arbitrary:xs" is mandatory.*)
   apply clarsimp(*This clarsimp is optional.*)
   apply(induct_tac xs)(*"induct_tac" instead of "induct" because of "\<And>n"*)
    apply fastforce+
  apply(induct_tac xs)(*"induct_tac" instead of "induct" because of "\<And>n"*)
   apply fastforce+
  done

end